/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.base.Parameter;
import com.fr.base.TableData;
import com.fr.data.core.DataCoreXmlUtils;
import com.fr.data.impl.DecoratedDataModel;
import com.fr.data.impl.NameTableData;
import com.fr.general.data.Condition;
import com.fr.general.data.DataModel;
import com.fr.script.Calculator;
import com.fr.stable.ArrayUtils;
import com.fr.stable.ParameterProvider;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;
import java.util.Arrays;

public class DecoratedTableData
implements TableData {
    private String[] relatedTableDataNames;
    private Condition condition;

    public String[] getRelatedTableDataNames() {
        return this.relatedTableDataNames;
    }

    public void setRelatedTableDataNames(String[] stringArray) {
        this.relatedTableDataNames = stringArray;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public DataModel createDataModel(Calculator calculator) {
        DataModel[] dataModelArray = new DataModel[ArrayUtils.getLength(this.relatedTableDataNames)];
        for (int i2 = 0; i2 < dataModelArray.length; ++i2) {
            dataModelArray[i2] = new NameTableData(this.relatedTableDataNames[i2]).createDataModel(calculator);
        }
        return new DecoratedDataModel(dataModelArray, this.relatedTableDataNames, this.condition, calculator);
    }

    public DataModel createDataModel(Calculator calculator, String string) {
        return this.createDataModel(calculator);
    }

    public DataModel createDataModel(Calculator calculator, int n2) {
        return this.createDataModel(calculator);
    }

    public Parameter[] getParameters(Calculator calculator) {
        ArrayList<ParameterProvider> arrayList = new ArrayList<ParameterProvider>();
        if (this.relatedTableDataNames != null) {
            for (int i2 = 0; i2 < this.relatedTableDataNames.length; ++i2) {
                arrayList.addAll(Arrays.asList(new NameTableData(this.relatedTableDataNames[i2]).getParameters(calculator)));
            }
        }
        if (this.condition != null) {
            String[] stringArray = this.condition.getDependence();
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                arrayList.add(new Parameter(stringArray[i3]));
            }
        }
        return arrayList.toArray(new Parameter[0]);
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        int n2 = ArrayUtils.getLength(this.relatedTableDataNames);
        for (int i2 = 0; i2 < n2; ++i2) {
            xMLPrintWriter.startTAG("TDName").textNode(this.relatedTableDataNames[i2]).end();
        }
        DataCoreXmlUtils.writeXMLCondition(xMLPrintWriter, this.condition);
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string;
            String string2 = xMLableReader.getTagName();
            if ("TDName".equals(string2) && StringUtils.isNotBlank(string = xMLableReader.getElementValue())) {
                this.relatedTableDataNames = (String[])ArrayUtils.add(this.relatedTableDataNames, string);
            } else if ("Condition".equals(string2)) {
                this.condition = DataCoreXmlUtils.readCondition(xMLableReader);
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        DecoratedTableData decoratedTableData = (DecoratedTableData)super.clone();
        if (this.relatedTableDataNames != null) {
            decoratedTableData.relatedTableDataNames = (String[])ArrayUtils.clone(this.relatedTableDataNames);
        }
        if (this.condition != null) {
            decoratedTableData.condition = (Condition)this.condition.clone();
        }
        return decoratedTableData;
    }
}

