/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.dao;

import com.fr.data.core.db.dml.Table;
import com.fr.data.dao.DAOUtils;
import com.fr.data.dao.DataInitJob;
import com.fr.data.dao.FieldColumnMapper;
import com.fr.data.dao.UniqueKey;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import java.util.ArrayList;

public class ObjectTableMapper
implements Cloneable {
    public static final String PREFIX_NAME = "FR_T_";
    protected Table table;
    protected FieldColumnMapper[] fieldMappers;
    protected Class clazz;
    protected String[][] uniqueColumns;
    protected DataInitJob job = null;
    protected boolean checkTable = true;
    protected int checkTableExistLevel = 1;

    public ObjectTableMapper() {
    }

    public ObjectTableMapper(Table table, FieldColumnMapper[] fieldColumnMapperArray, String[][] stringArray) {
        this(null, table, fieldColumnMapperArray, stringArray, null);
    }

    public ObjectTableMapper(Class clazz, FieldColumnMapper[] fieldColumnMapperArray) {
        this(clazz, fieldColumnMapperArray, (String[][])null);
    }

    public ObjectTableMapper(Class clazz, FieldColumnMapper[] fieldColumnMapperArray, String[][] stringArray) {
        this(clazz, fieldColumnMapperArray, stringArray, null);
    }

    public ObjectTableMapper(Class clazz, FieldColumnMapper[] fieldColumnMapperArray, String[][] stringArray, DataInitJob dataInitJob) {
        this(clazz, new Table(PREFIX_NAME + DAOUtils.getClassNameWithOutPath(clazz)), fieldColumnMapperArray, stringArray, dataInitJob);
    }

    public ObjectTableMapper(Table table, Class clazz, FieldColumnMapper[] fieldColumnMapperArray, String[][] stringArray, DataInitJob dataInitJob) {
        this(clazz, table, fieldColumnMapperArray, stringArray, dataInitJob);
    }

    public ObjectTableMapper(Class clazz, Table table, FieldColumnMapper[] fieldColumnMapperArray) {
        this(clazz, table, fieldColumnMapperArray, (String[][])null, null);
    }

    public ObjectTableMapper(Class clazz, Table table, FieldColumnMapper[] fieldColumnMapperArray, String[][] stringArray, DataInitJob dataInitJob) {
        this.setObjectClass(clazz);
        this.setTable(table);
        this.setFieldColumnMappers(fieldColumnMapperArray);
        this.uniqueColumns = stringArray;
        this.job = dataInitJob;
    }

    public ObjectTableMapper(Class clazz, Table table, FieldColumnMapper[] fieldColumnMapperArray, int n2) {
        this(clazz, table, fieldColumnMapperArray, (String[][])null, null);
        this.checkTableExistLevel = n2;
    }

    public ObjectTableMapper(Class clazz, FieldColumnMapper[] fieldColumnMapperArray, String[][] stringArray, int n2) {
        this(clazz, fieldColumnMapperArray, stringArray, null);
        this.checkTableExistLevel = n2;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public Table getTable() {
        return this.table;
    }

    public void setFieldColumnMappers(FieldColumnMapper[] fieldColumnMapperArray) {
        this.fieldMappers = fieldColumnMapperArray;
    }

    public FieldColumnMapper[] getFieldColumnMappers() {
        return this.fieldMappers;
    }

    public void setObjectClass(Class clazz) {
        this.clazz = clazz;
    }

    public Class getObjectClass() {
        return this.clazz;
    }

    public int getFieldColumnMapperCount() {
        return this.fieldMappers.length;
    }

    public DataInitJob getDataInitJob() {
        return this.job;
    }

    public FieldColumnMapper getPrimaryKey() {
        for (int i2 = 0; i2 < this.fieldMappers.length; ++i2) {
            if (!this.fieldMappers[i2].isPrimaryKey()) continue;
            return this.fieldMappers[i2];
        }
        return null;
    }

    public UniqueKey[] getUniqueKeys() {
        if (this.uniqueColumns == null) {
            return null;
        }
        ArrayList<UniqueKey> arrayList = new ArrayList<UniqueKey>();
        for (int i2 = 0; i2 < this.uniqueColumns.length; ++i2) {
            String[] stringArray = this.uniqueColumns[i2];
            if (stringArray == null) continue;
            UniqueKey uniqueKey = new UniqueKey();
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                FieldColumnMapper fieldColumnMapper = this.findFCMapperByColumnName(stringArray[i3]);
                uniqueKey.addColumn(fieldColumnMapper.createTableColumn());
            }
            arrayList.add(uniqueKey);
        }
        return arrayList.toArray(new UniqueKey[arrayList.size()]);
    }

    public FieldColumnMapper findFCMapperByColumnName(String string) {
        if (string == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.fieldMappers.length; ++i2) {
            if (!ComparatorUtils.equals(string, this.fieldMappers[i2].getColumnName())) continue;
            return this.fieldMappers[i2];
        }
        return null;
    }

    public FieldColumnMapper findFCMapperByFieldName(String string) {
        if (string == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.fieldMappers.length; ++i2) {
            if (!ComparatorUtils.equals(string, this.fieldMappers[i2].getFieldName())) continue;
            return this.fieldMappers[i2];
        }
        return null;
    }

    public String findColumnNameByFieldName(String string) {
        FieldColumnMapper fieldColumnMapper = this.findFCMapperByFieldName(string);
        return fieldColumnMapper == null ? null : fieldColumnMapper.getColumnName();
    }

    public boolean shouleCheckTable() {
        return this.checkTable;
    }

    public ObjectTableMapper applyNoCheckTableObjectCase() {
        try {
            ObjectTableMapper objectTableMapper = (ObjectTableMapper)this.clone();
            objectTableMapper.checkTable = false;
            return objectTableMapper;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            FRLogger.getLogger().error(cloneNotSupportedException.getMessage(), cloneNotSupportedException);
            return null;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

