/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.dao;

import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dml.DML;
import com.fr.data.core.db.dml.Delete;
import com.fr.data.core.db.dml.Insert;
import com.fr.data.core.db.dml.Select;
import com.fr.data.core.db.dml.Update;
import com.fr.data.dao.ResultSetExtractor;
import com.fr.data.dao.StatementCallback;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class JdbcOperator {
    public static void execute(Connection connection, final String string) throws Exception {
        JdbcOperator.execute(connection, new StatementCallback(){

            public Object doInStatement(Statement statement) throws Exception {
                statement.execute(string);
                return null;
            }
        });
    }

    public static Object query(Connection connection, final String string, final ResultSetExtractor resultSetExtractor) throws Exception {
        return JdbcOperator.execute(connection, new StatementCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doInStatement(Statement statement) throws Exception {
                Object object;
                ResultSet resultSet = null;
                try {
                    ResultSet resultSet2 = resultSet = statement.executeQuery(string);
                    object = resultSetExtractor.extractData(resultSet2);
                }
                catch (Throwable throwable) {
                    DBUtils.closeResultSet(resultSet);
                    throw throwable;
                }
                DBUtils.closeResultSet(resultSet);
                return object;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object execute(Connection connection, StatementCallback statementCallback) throws Exception {
        if (connection == null) {
            throw new RuntimeException("No Connection!");
        }
        Statement statement = null;
        try {
            Statement statement2 = statement = connection.createStatement();
            Object object = statementCallback.doInStatement(statement2);
            return object;
        }
        finally {
            DBUtils.closeStatement(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object executeQuery(Connection connection, Dialect dialect, Select select, ResultSetExtractor resultSetExtractor) throws Exception {
        Object object;
        if (connection == null || dialect == null) {
            throw new RuntimeException("No Connection or dialect!");
        }
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        try {
            select = (Select)select.applyDialect(dialect);
            preparedStatement = select.createPreparedStatement(connection);
            resultSet = preparedStatement.executeQuery();
            object = resultSetExtractor.extractData(resultSet);
        }
        catch (Throwable throwable) {
            DBUtils.closeResultSet(resultSet);
            DBUtils.closeStatement(preparedStatement);
            throw throwable;
        }
        DBUtils.closeResultSet(resultSet);
        DBUtils.closeStatement(preparedStatement);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Serializable execute(Connection connection, Dialect dialect, Insert insert, boolean bl) throws Exception {
        PreparedStatement preparedStatement;
        PreparedStatement preparedStatement2 = null;
        ResultSet resultSet = null;
        try {
            insert = (Insert)insert.applyDialect(dialect);
            preparedStatement2 = insert.createPreparedStatement(connection);
            if (preparedStatement2 == null) {
                throw new RuntimeException("Can not create statement from connection!");
            }
            preparedStatement2.executeUpdate();
            Object object = null;
            if (bl) {
                preparedStatement = null;
                try {
                    String string = dialect.getIdentitySelectString(insert.getTable().getName(), "id", -5);
                    preparedStatement = connection.prepareStatement(string);
                    resultSet = preparedStatement.executeQuery();
                    object = JdbcOperator.getIdentifier(resultSet, Long.class);
                }
                catch (Throwable throwable) {
                    DBUtils.closeStatement(preparedStatement);
                    throw throwable;
                }
                DBUtils.closeStatement(preparedStatement);
            }
            preparedStatement = object;
        }
        catch (Throwable throwable) {
            DBUtils.closeStatement(preparedStatement2);
            throw throwable;
        }
        DBUtils.closeStatement(preparedStatement2);
        return preparedStatement;
    }

    public static void execute(Connection connection, Dialect dialect, DML dML) throws Exception {
        JdbcOperator.execute(connection, dialect, dML, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int execute(Connection connection, Dialect dialect, DML dML, boolean bl) throws Exception {
        PreparedStatement preparedStatement;
        block4: {
            int n2;
            preparedStatement = null;
            try {
                dML = dML.applyDialect(dialect);
                preparedStatement = dML.createPreparedStatement(connection);
                if (preparedStatement == null) {
                    throw new RuntimeException("Can not create statement from connection!");
                }
                if (!bl) break block4;
                n2 = preparedStatement.executeUpdate();
            }
            catch (Throwable throwable) {
                DBUtils.closeStatement(preparedStatement);
                throw throwable;
            }
            DBUtils.closeStatement(preparedStatement);
            return n2;
        }
        preparedStatement.execute();
        int n3 = -1;
        DBUtils.closeStatement(preparedStatement);
        return n3;
    }

    public static int executeDelete(Connection connection, Dialect dialect, Delete delete) throws Exception {
        return JdbcOperator.execute(connection, dialect, delete, true);
    }

    public static int executeUpdate(Connection connection, Dialect dialect, Update update) throws Exception {
        return JdbcOperator.execute(connection, dialect, update, true);
    }

    private static Serializable getIdentifier(ResultSet resultSet, Class clazz) throws SQLException {
        if (!resultSet.next()) {
            throw new RuntimeException("No Idetity");
        }
        if (clazz == Long.class) {
            return new Long(resultSet.getLong(1));
        }
        if (clazz == Integer.class) {
            return new Integer(resultSet.getInt(1));
        }
        if (clazz == Short.class) {
            return new Short(resultSet.getShort(1));
        }
        if (clazz == String.class) {
            return resultSet.getString(1);
        }
        throw new RuntimeException("this id generator generates long, integer, short or string");
    }
}

