/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.dao;

import com.fr.data.dao.DAOSession;
import com.fr.data.dao.RelationFCMapper;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class DAOHashSet {
    private Set set = null;
    private DAOSession session;
    private RelationFCMapper relationMapper;
    private Class objClazz;
    private Object objId;

    public DAOHashSet(DAOSession dAOSession, RelationFCMapper relationFCMapper, Class clazz, Object object) {
        this.session = dAOSession;
        this.relationMapper = relationFCMapper;
        this.objClazz = clazz;
        this.objId = object;
    }

    private void init() throws Exception {
        this.init(false);
    }

    private void init(boolean bl) throws Exception {
        if (this.set == null) {
            this.load(bl);
        }
    }

    private void load(boolean bl) throws Exception {
        this.set = this.session.listSetByRelationField(this.objClazz, this.objId, this.relationMapper, bl);
    }

    public synchronized void reset() {
        if (this.set != null) {
            this.set.clear();
            this.set = null;
        }
    }

    public synchronized boolean add(Object object) throws Exception {
        if (this.set == null) {
            this.session.addRelation(object, this.objClazz, this.objId, this.relationMapper);
            return true;
        }
        boolean bl = this.set.contains(object);
        if (!bl) {
            this.session.addRelation(object, this.objClazz, this.objId, this.relationMapper);
            return this.set.add(object);
        }
        return false;
    }

    public synchronized boolean addAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public synchronized void clear() throws Exception {
        this.session.deleteAllRelation(this.objClazz, this.objId, this.relationMapper);
        if (this.set == null) {
            this.set = new HashSet();
        }
        this.set.clear();
    }

    public synchronized boolean contains(Object object) throws Exception {
        this.init();
        return this.set.contains(object);
    }

    public synchronized boolean containsAll(Collection collection) throws Exception {
        this.init();
        return this.set.containsAll(collection);
    }

    public synchronized boolean isEmpty() throws Exception {
        this.init();
        return this.set.isEmpty();
    }

    public synchronized Iterator iterator() throws Exception {
        return this.iterator(false);
    }

    public synchronized Iterator iterator(boolean bl) throws Exception {
        this.init(bl);
        return this.set.iterator();
    }

    public synchronized boolean remove(Object object) throws Exception {
        if (this.set == null) {
            this.session.removeRelation(object, this.objClazz, this.objId, this.relationMapper);
            return true;
        }
        boolean bl = this.set.contains(object);
        if (!bl) {
            this.session.removeRelation(object, this.objClazz, this.objId, this.relationMapper);
            return this.set.remove(object);
        }
        return false;
    }

    public synchronized boolean removeAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public synchronized boolean retainAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public synchronized int size() throws Exception {
        this.init();
        return this.set.size();
    }

    public synchronized Object[] toArray() throws Exception {
        this.init();
        return this.set.toArray();
    }

    public synchronized Object[] toArray(Object[] objectArray) throws Exception {
        this.init();
        return this.set.toArray(objectArray);
    }

    public Set toSet() throws Exception {
        this.init();
        return this.set;
    }

    public Set toSet(boolean bl) throws Exception {
        this.init(bl);
        return this.set;
    }
}

