/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core.db.dml;

import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.core.db.dml.DML;
import com.fr.data.core.db.dml.Table;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public abstract class AbstractDML
implements DML,
Cloneable {
    private Table table;
    protected Dialect dialect;

    protected AbstractDML(Table table, Dialect dialect) {
        this.setTable(table);
        this.dialect = dialect == null ? DialectFactory.getDefaultDialect() : dialect;
    }

    public DML applyDialect(Dialect dialect) {
        AbstractDML abstractDML = null;
        try {
            abstractDML = (AbstractDML)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
        if (dialect != null) {
            abstractDML.dialect = dialect;
        }
        return abstractDML;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public Table getTable() {
        return this.table;
    }

    public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
        if (!this.validate(connection)) {
            return null;
        }
        return this.createPreparedStatementByValidatedParameters(connection);
    }

    protected boolean validate(Connection connection) {
        return connection != null && this.table != null;
    }

    protected abstract PreparedStatement createPreparedStatementByValidatedParameters(Connection var1) throws SQLException;
}

