/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core.db.dialect;

import com.fr.base.StoreProcedureParameter;
import com.fr.data.DataUtils;
import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.AbstractDialect;
import com.fr.data.core.db.dialect.TypeUtils;
import com.fr.data.core.db.dml.Table;
import com.fr.data.impl.Connection;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MySQLDialect
extends AbstractDialect {
    private static Map yearDataMap = new HashMap();
    private static final int DEFAULT_HASH_VALUE = 37;
    private static final int LIMITED_STRING_LENGTH = 20;
    private static final String DEFAULT_INCREMENT_EM = "auto_increment";

    public MySQLDialect() {
        this.left_quote = "`";
        this.right_quote = "`";
    }

    public int getFetchSize() {
        return Integer.MIN_VALUE;
    }

    public String columnType2SQL(int n2, String string) {
        switch (n2) {
            case -2: {
                return "TINYBLOB";
            }
            case 2004: {
                return "MEDIUMBLOB";
            }
            case -4: {
                return "LONGBLOB";
            }
            case 2005: {
                return "longtext";
            }
            case 4: {
                return "int";
            }
            case -1: {
                return "longtext";
            }
            case 1: {
                return "varchar(" + string + ")";
            }
            case 12: {
                return "varchar(" + string + ")";
            }
            case -3: {
                return "varbinary(" + string + ")";
            }
            case 3: {
                return "decimal(" + string + ")";
            }
            case 2: {
                return "numeric(" + string + ")";
            }
            case 7: {
                return "FLOAT";
            }
            case -5: {
                return "BIGINT(" + string + ")";
            }
            case 5: {
                return "SMALLINT(" + string + ")";
            }
            case -7: {
                return "VARCHAR(1)";
            }
        }
        return TypeUtils.getTypeName(n2);
    }

    public String createSequence(java.sql.Connection connection, String string, String string2, String string3) {
        return new StringBuffer().append(string3).append(' ').append(DEFAULT_INCREMENT_EM).toString();
    }

    public String getIdentitySelectString() {
        return "select last_insert_id()";
    }

    public String getLimitString(String string, int n2, int n3) {
        return new StringBuffer(string.length() + 20).append(string).append(" limit " + n2 + ", " + n3).toString();
    }

    public boolean isYearData(java.sql.Connection connection, int n2, Table table, String string) {
        if (n2 != 91) {
            return false;
        }
        CTC cTC = new CTC(connection, table, string);
        if (yearDataMap.get(cTC) == null) {
            boolean bl = this.isYear(connection, table, string);
            yearDataMap.put(cTC, bl);
            return bl;
        }
        return (Boolean)yearDataMap.get(cTC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isYear(java.sql.Connection connection, Table table, String string) {
        String string2 = "select " + string + " from " + table.toString();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(string2);
            ResultSet resultSet = preparedStatement.executeQuery();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            if (resultSetMetaData.getColumnTypeName(1).equalsIgnoreCase("YEAR")) {
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException sQLException) {
            FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
            try {
                preparedStatement.close();
            }
            catch (SQLException sQLException2) {
                FRLogger.getLogger().error(sQLException2.getMessage(), sQLException2);
            }
        }
        finally {
            try {
                preparedStatement.close();
            }
            catch (SQLException sQLException) {
                FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
            }
        }
        return false;
    }

    public String quartzDelegateClass() {
        return "com.fr.third.org.quartz.impl.jdbcjobstore.MSSQLDelegate";
    }

    public String defaultValidationQuery(java.sql.Connection connection) {
        return "select 1";
    }

    public boolean supportsCascadeDelete() {
        return false;
    }

    public String buildForeignKeyString(String string, String[] stringArray, String string2, String[] stringArray2, boolean bl) {
        String string3 = StringUtils.join(", ", stringArray);
        return new StringBuffer(30).append(" add index ").append(string).append(" (").append(string3).append("), add constraint ").append(string).append(" foreign key (").append(string3).append(") references ").append(string2).append(" (").append(StringUtils.join(", ", stringArray2)).append(')').toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoreProcedureParameter[] getStoreProcedureDeclarationParameters(java.sql.Connection connection, String string, String string2) {
        ArrayList arrayList;
        block6: {
            arrayList = new ArrayList();
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                String string3 = connection.getMetaData().getURL();
                string3 = string3.substring(string3.lastIndexOf("/") == -1 ? 0 : string3.lastIndexOf("/") + 1, string3.length());
                if (string3.indexOf("?") >= 0) {
                    string3 = string3.substring(0, string3.indexOf("?"));
                }
                String string4 = this.getProcedureParametersSql(string3 + "`" + string);
                statement = connection.createStatement();
                resultSet = statement.executeQuery(string4);
                this.addPara2ListFromResultset(arrayList, resultSet);
                DBUtils.closeResultSet(resultSet);
            }
            catch (SQLException sQLException) {
                FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
                break block6;
            }
            finally {
                DBUtils.closeResultSet(resultSet);
                DBUtils.closeStatement(statement);
            }
            DBUtils.closeStatement(statement);
        }
        return arrayList.toArray(new StoreProcedureParameter[arrayList.size()]);
    }

    private void addPara2ListFromResultset(List list, ResultSet resultSet) {
        try {
            while (resultSet.next()) {
                Blob blob = resultSet.getBlob("param_list");
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(blob.getBinaryStream()));
                List list2 = this.getParaFromBufferReader(bufferedReader);
                if (list2.isEmpty()) continue;
                String[] stringArray = new String[list2.size()];
                for (int i2 = 0; i2 < list2.size(); ++i2) {
                    String string = (String)list2.get(i2);
                    stringArray[i2] = string.endsWith(",") ? string.substring(0, string.length() - 1) : string;
                }
                list.addAll(this.parameterToList(stringArray));
            }
        }
        catch (SQLException sQLException) {
            FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
        }
    }

    private List getParaFromBufferReader(BufferedReader bufferedReader) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string = "";
            while ((string = bufferedReader.readLine()) != null) {
                if (StringUtils.isBlank(string)) continue;
                String[] stringArray = string.split(",");
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    String string2 = stringArray[i2];
                    if (StringUtils.isBlank(string2)) continue;
                    arrayList.add(string2);
                }
            }
        }
        catch (IOException iOException) {
            FRLogger.getLogger().error(iOException.getMessage(), iOException);
        }
        return arrayList;
    }

    protected String getProcedureParametersSql(String string) {
        String[] stringArray = string.split("`");
        return "select param_list, body from mysql.proc where mysql.proc.name='" + stringArray[1] + "' and mysql.proc.db='" + stringArray[0] + "' and mysql.proc.type='PROCEDURE'";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getStoreProcedureText(java.sql.Connection connection, String string) {
        ResultSet resultSet;
        Statement statement;
        block8: {
            String string2;
            block7: {
                statement = null;
                resultSet = null;
                try {
                    String string3 = connection.getMetaData().getURL();
                    string3 = string3.substring(string3.lastIndexOf("/") == -1 ? 0 : string3.lastIndexOf("/") + 1, string3.length());
                    if (string3.indexOf("?") >= 0) {
                        string3 = string3.substring(0, string3.indexOf("?"));
                    }
                    String[] stringArray = string.split("\\.");
                    String string4 = this.getProcedureSql(string3 + "`" + stringArray[stringArray.length - 1]);
                    statement = connection.createStatement();
                    resultSet = statement.executeQuery(string4);
                    StringBuffer stringBuffer = new StringBuffer();
                    if (resultSet.next()) {
                        Blob blob = resultSet.getBlob("body");
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(blob.getBinaryStream()));
                        string2 = DataUtils.reader2String(bufferedReader);
                        DBUtils.closeResultSet(resultSet);
                        break block7;
                    }
                    DBUtils.closeResultSet(resultSet);
                    break block8;
                }
                catch (SQLException sQLException) {
                    FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
                    return "ERROR FETCHING...";
                }
            }
            DBUtils.closeStatement(statement);
            return string2;
        }
        DBUtils.closeStatement(statement);
        return "ERROR FETCHING...";
        finally {
            DBUtils.closeResultSet(resultSet);
            DBUtils.closeStatement(statement);
        }
    }

    protected String getProcedureSql(String string) {
        return this.getProcedureParametersSql(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String getTableCommentName(java.sql.Connection connection, String string, String string2, String string3) {
        ResultSet resultSet;
        Statement statement;
        block4: {
            String string4;
            statement = null;
            resultSet = null;
            try {
                statement = connection.createStatement();
                resultSet = statement.executeQuery("select table_comment from information_schema.tables  where table_schema = '" + connection.getCatalog() + "' and table_name ='" + string + "'");
                if (!resultSet.next()) break block4;
                string4 = resultSet.getString("table_comment");
            }
            catch (SQLException sQLException) {
                DBUtils.closeResultSet(resultSet);
                DBUtils.closeStatement(statement);
                catch (Throwable throwable) {
                    DBUtils.closeResultSet(resultSet);
                    DBUtils.closeStatement(statement);
                    throw throwable;
                }
            }
            DBUtils.closeResultSet(resultSet);
            DBUtils.closeStatement(statement);
            return string4;
        }
        DBUtils.closeResultSet(resultSet);
        DBUtils.closeStatement(statement);
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public List getTableFieldsInfor(java.sql.Connection connection, String string, String string2, String string3) {
        List list = super.getTableFieldsInfor(connection, string, string2, string3);
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery("select COLUMN_NAME, COLUMN_COMMENTfrom information_schema.COLUMNS where TABLE_SCHEMA='" + connection.getCatalog() + "' and table_name ='" + string + "'");
            HashMap<String, String> hashMap = new HashMap<String, String>();
            while (resultSet.next()) {
                hashMap.put(resultSet.getString("COLUMN_NAME"), resultSet.getString("COLUMN_COMMENT"));
            }
            for (Map map : list) {
                String string4 = (String)map.get("column_name");
                if (!hashMap.containsKey(string4)) continue;
                map.put("column_comment", hashMap.get(string4));
            }
        }
        catch (SQLException sQLException) {
            DBUtils.closeResultSet(resultSet);
            DBUtils.closeStatement(statement);
            catch (Throwable throwable) {
                DBUtils.closeResultSet(resultSet);
                DBUtils.closeStatement(statement);
                throw throwable;
            }
        }
        DBUtils.closeResultSet(resultSet);
        DBUtils.closeStatement(statement);
        return list;
    }

    public ResultSet createLimitResultSet(Connection connection, java.sql.Connection connection2, Statement statement, String[] stringArray, String string, String string2, String string3, long l2) throws SQLException {
        Table table = new Table(string, string2);
        String string4 = "select * from " + this.table2SQL(table) + " limit " + l2 + "," + Integer.MAX_VALUE;
        statement.setFetchSize(Integer.MIN_VALUE);
        return statement.executeQuery(this.dealWithSqlCharSet(string4, connection));
    }

    public Statement createLimitUseStatement(java.sql.Connection connection) throws SQLException {
        return connection.createStatement(1003, 1007);
    }

    public String createLimitSQL(String string, String[] stringArray, long l2) {
        if (string.indexOf("limit") != -1) {
            return "select * from (" + string + ") t limit " + l2 + "," + Integer.MAX_VALUE;
        }
        return string + " limit " + l2 + "," + Integer.MAX_VALUE;
    }

    public String getSpecificRowSql(String string, int n2) {
        return "select * from (" + string + ") as newTab limit " + (n2 - 1) + " , 1";
    }

    public String getRowRangeSql(String string, int n2, int n3, String[] stringArray) {
        String string2 = "select ";
        string2 = stringArray == null || stringArray.length == 0 ? string2 + "*" : string2 + StableUtils.join(stringArray, ",");
        string2 = string2 + " from (" + string + ") as newTab limit " + n2 + " , " + (n2 - n3);
        return string2;
    }

    public String getTopNRowSql(int n2, Table table) {
        return "select * from " + this.table2SQL(table) + " limit 0, " + n2;
    }

    private class CTC {
        private String url = null;
        private String user = null;
        private Table table = null;
        private String columnName = null;

        public CTC(java.sql.Connection connection, Table table, String string) {
            try {
                this.url = connection.getMetaData().getURL();
                this.user = connection.getMetaData().getUserName();
            }
            catch (SQLException sQLException) {
                FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
            }
            this.table = table;
            this.columnName = string;
        }

        public int hashCode() {
            int n2 = 0;
            n2 = 37 * n2 + this.url.hashCode();
            n2 = 37 * n2 + this.user.hashCode();
            n2 = 37 * n2 + this.table.hashCode();
            n2 = 37 * n2 + this.columnName.hashCode();
            return n2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof CTC)) {
                return false;
            }
            CTC cTC = (CTC)object;
            return ComparatorUtils.equals(this.url, cTC.url) && ComparatorUtils.equals(this.user, cTC.user) && ComparatorUtils.equals(this.table, cTC.table) && ComparatorUtils.equals(this.columnName, cTC.columnName);
        }
    }
}

