/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core.db.dialect;

import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.AbstractDialect;
import com.fr.data.core.db.dialect.AccessDialect;
import com.fr.data.core.db.dialect.DB2Dialect;
import com.fr.data.core.db.dialect.DB2V6Dialect;
import com.fr.data.core.db.dialect.DB2V7Dialect;
import com.fr.data.core.db.dialect.DB2V8Dialect;
import com.fr.data.core.db.dialect.DerbyDialect;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.H2Dialect;
import com.fr.data.core.db.dialect.HSQLDialect;
import com.fr.data.core.db.dialect.InformixDialect;
import com.fr.data.core.db.dialect.MSSQL2000Dialect;
import com.fr.data.core.db.dialect.MSSQL2005Dialect;
import com.fr.data.core.db.dialect.MSSQL2008Dialect;
import com.fr.data.core.db.dialect.MSSQLDialect;
import com.fr.data.core.db.dialect.MySQLDialect;
import com.fr.data.core.db.dialect.Oracle10gDialect;
import com.fr.data.core.db.dialect.Oracle8iDialect;
import com.fr.data.core.db.dialect.OracleDialect;
import com.fr.data.core.db.dialect.PostgreSQLDialect;
import com.fr.data.core.db.dialect.SybaseDialect;
import com.fr.data.impl.NameDatabaseConnection;
import com.fr.general.FRLogger;
import com.fr.general.GeneralUtils;
import com.fr.stable.StringUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class DialectFactory {
    private static final int ORACLE9_MAJOR_VERSION = 9;
    private static final int MSSQL2000_MAJOR_VERSION = 8;
    private static final int MSSQL2005_MAJOR_VERSION = 9;
    private static final int MSSQL2008_MAJOR_VERSION = 10;
    private static final int DB2V6_MAJOR_VERSION = 6;
    private static final int DB2V7_MAJOR_VERSION = 7;
    private static final int DB2V8_MAJOR_VERSION = 8;
    private static Dialect defaultDialect;
    private static Map dialectMap;
    private static Map databaseNameDialectMap;

    public static Dialect getDefaultDialect() {
        if (defaultDialect == null) {
            defaultDialect = new AbstractDialect();
        }
        return defaultDialect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dialect getDialectByName(String string) {
        Dialect dialect = (Dialect)databaseNameDialectMap.get(string);
        if (dialect == null) {
            Map map = databaseNameDialectMap;
            synchronized (map) {
                dialect = (Dialect)databaseNameDialectMap.get(string);
                if (dialect == null) {
                    dialect = DialectFactory.generateDialect(string);
                    databaseNameDialectMap.put(string, dialect);
                }
            }
        }
        return dialect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Dialect generateDialect(String string) {
        Dialect dialect;
        Connection connection = null;
        try {
            connection = new NameDatabaseConnection(string).createConnection();
            dialect = DialectFactory.generateDialect(connection);
        }
        catch (Exception exception) {
            Dialect dialect2;
            try {
                FRLogger.getLogger().error(exception.getMessage(), exception);
                dialect2 = DialectFactory.getDefaultDialect();
            }
            catch (Throwable throwable) {
                DBUtils.closeConnection(connection);
                throw throwable;
            }
            DBUtils.closeConnection(connection);
            return dialect2;
        }
        DBUtils.closeConnection(connection);
        return dialect;
    }

    public static Dialect try2GenerateDialectByDriver(String string) {
        if (StringUtils.isBlank(string)) {
            return null;
        }
        if (string.indexOf("hsqldb") != -1) {
            return new HSQLDialect();
        }
        if (string.indexOf("oracle") != -1) {
            return new OracleDialect();
        }
        if (string.indexOf("db2") != -1) {
            return new DB2Dialect();
        }
        if (string.indexOf("sqlserver") != -1) {
            return new MSSQLDialect();
        }
        if (string.indexOf("mysql") != -1) {
            return new MySQLDialect();
        }
        if (string.indexOf("sybase") != -1) {
            return new SybaseDialect();
        }
        if (string.indexOf("derby") != -1) {
            return new DerbyDialect();
        }
        if (string.indexOf("postgresql") != -1) {
            return new PostgreSQLDialect();
        }
        return null;
    }

    public static Dialect generateDialect(Connection connection) {
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String string = databaseMetaData.getDatabaseProductName();
            int n2 = -1;
            try {
                n2 = databaseMetaData.getDatabaseMajorVersion();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (StringUtils.isBlank(string)) {
                return DialectFactory.getDefaultDialect();
            }
            DBDialectMapper dBDialectMapper = (DBDialectMapper)dialectMap.get(string);
            if (dBDialectMapper == null) {
                return DialectFactory.getDefaultDialect();
            }
            return dBDialectMapper.getDialect(n2);
        }
        catch (SQLException sQLException) {
            return DialectFactory.getDefaultDialect();
        }
    }

    static {
        dialectMap = new HashMap();
        databaseNameDialectMap = new HashMap();
        dialectMap.put("Oracle", new DBDialectMapper(){

            public Dialect getDialect(int n2) {
                if (n2 < 9) {
                    return new Oracle8iDialect();
                }
                if (n2 > 9) {
                    return new Oracle10gDialect();
                }
                return new OracleDialect();
            }
        });
        dialectMap.put("Microsoft SQL Server", new DBDialectMapper(){

            public Dialect getDialect(int n2) {
                switch (n2) {
                    case 8: {
                        return new MSSQL2000Dialect();
                    }
                    case 9: {
                        return new MSSQL2005Dialect();
                    }
                    case 10: {
                        return new MSSQL2008Dialect();
                    }
                }
                return new MSSQLDialect();
            }
        });
        dialectMap.put("Microsoft SQL Server Database", new VersionInsensitiveMapper(MSSQLDialect.class.getName()));
        dialectMap.put("ACCESS", new VersionInsensitiveMapper(AccessDialect.class.getName()));
        dialectMap.put("Sybase SQL Server", new VersionInsensitiveMapper(SybaseDialect.class.getName()));
        dialectMap.put("Adaptive Server Enterprise", new VersionInsensitiveMapper(SybaseDialect.class.getName()));
        dialectMap.put("HSQL Database Engine", new VersionInsensitiveMapper(HSQLDialect.class.getName()));
        dialectMap.put("H2", new VersionInsensitiveMapper(H2Dialect.class.getName()));
        dialectMap.put("MySQL", new VersionInsensitiveMapper(MySQLDialect.class.getName()));
        dialectMap.put("PostgreSQL", new VersionInsensitiveMapper(PostgreSQLDialect.class.getName()));
        dialectMap.put("Apache Derby", new VersionInsensitiveMapper(DerbyDialect.class.getName()));
        dialectMap.put("Informix Dynamic Server", new VersionInsensitiveMapper(InformixDialect.class.getName()));
        dialectMap.put("DB2/NT", new DBDialectMapper(){

            public Dialect getDialect(int n2) {
                switch (n2) {
                    case 6: {
                        return new DB2V6Dialect();
                    }
                    case 7: {
                        return new DB2V7Dialect();
                    }
                    case 8: {
                        return new DB2V8Dialect();
                    }
                }
                return new DB2Dialect();
            }
        });
        dialectMap.put("DB2/LINUX", new DBDialectMapper(){

            public Dialect getDialect(int n2) {
                switch (n2) {
                    case 6: {
                        return new DB2V6Dialect();
                    }
                    case 7: {
                        return new DB2V7Dialect();
                    }
                    case 8: {
                        return new DB2V8Dialect();
                    }
                }
                return new DB2Dialect();
            }
        });
        dialectMap.put("DB2/6000", new DBDialectMapper(){

            public Dialect getDialect(int n2) {
                switch (n2) {
                    case 6: {
                        return new DB2V6Dialect();
                    }
                    case 7: {
                        return new DB2V7Dialect();
                    }
                    case 8: {
                        return new DB2V8Dialect();
                    }
                }
                return new DB2Dialect();
            }
        });
        dialectMap.put("DB2/HPUX", new DBDialectMapper(){

            public Dialect getDialect(int n2) {
                switch (n2) {
                    case 6: {
                        return new DB2V6Dialect();
                    }
                    case 7: {
                        return new DB2V7Dialect();
                    }
                    case 8: {
                        return new DB2V8Dialect();
                    }
                }
                return new DB2Dialect();
            }
        });
        dialectMap.put("DB2/SUN", new DBDialectMapper(){

            public Dialect getDialect(int n2) {
                switch (n2) {
                    case 6: {
                        return new DB2V6Dialect();
                    }
                    case 7: {
                        return new DB2V7Dialect();
                    }
                    case 8: {
                        return new DB2V8Dialect();
                    }
                }
                return new DB2Dialect();
            }
        });
        dialectMap.put("DB2/LINUX390", new DBDialectMapper(){

            public Dialect getDialect(int n2) {
                switch (n2) {
                    case 6: {
                        return new DB2V6Dialect();
                    }
                    case 7: {
                        return new DB2V7Dialect();
                    }
                    case 8: {
                        return new DB2V8Dialect();
                    }
                }
                return new DB2Dialect();
            }
        });
        dialectMap.put("DB2/AIX64", new DBDialectMapper(){

            public Dialect getDialect(int n2) {
                switch (n2) {
                    case 6: {
                        return new DB2V6Dialect();
                    }
                    case 7: {
                        return new DB2V7Dialect();
                    }
                    case 8: {
                        return new DB2V8Dialect();
                    }
                }
                return new DB2Dialect();
            }
        });
    }

    private static class VersionInsensitiveMapper
    implements DBDialectMapper {
        String dialectClass = null;

        public VersionInsensitiveMapper(String string) {
            this.dialectClass = string;
        }

        public Dialect getDialect(int n2) {
            try {
                return (Dialect)GeneralUtils.classForName(this.dialectClass).newInstance();
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage());
                return DialectFactory.getDefaultDialect();
            }
        }
    }

    private static interface DBDialectMapper {
        public Dialect getDialect(int var1);
    }
}

