/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core.db.dialect;

import com.fr.base.StoreProcedureParameter;
import com.fr.data.DataUtils;
import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.AbstractDialect;
import com.fr.data.core.db.dialect.TypeUtils;
import com.fr.general.FRLogger;
import java.io.BufferedReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class DB2Dialect
extends AbstractDialect {
    private int db2FetchSize = 50;
    private String defaultAutoIncrease = "GENERATED ALWAYS AS IDENTITY (START WITH 1,INCREMENT BY 1,MINVALUE 1,NO CACHE)";

    public DB2Dialect() {
        this.left_quote = "\"";
        this.right_quote = "\"";
    }

    public String columnType2SQL(int n2, String string) {
        switch (n2) {
            case -7: {
                return "varchar(1)";
            }
            case 4: {
                return "integer";
            }
            case 12: {
                return "varchar(" + string + ")";
            }
            case -3: {
                return "varbinary(" + string + ")";
            }
            case -6: {
                return "smallint";
            }
            case 3: {
                return "decimal(" + string + ")";
            }
            case 2: {
                return "numeric(" + string + ")";
            }
            case 1: {
                return "char(" + string + ")";
            }
            case -1: {
                return "long varchar";
            }
            case -4: {
                return "long varchar";
            }
            case 2004: {
                return "blob(" + string + ")";
            }
        }
        return TypeUtils.getTypeName(n2);
    }

    public int getFetchSize() {
        return this.db2FetchSize;
    }

    public void setFetchSize(int n2) {
        this.db2FetchSize = n2;
    }

    public String createSequence(Connection connection, String string, String string2, String string3) {
        return new StringBuffer().append(string3).append(' ').append(this.defaultAutoIncrease).toString();
    }

    public String getIdentitySelectString() {
        return "values identity_val_local()";
    }

    public String getLimitString(String string, int n2, int n3) {
        int n4 = string.toLowerCase().indexOf("select");
        StringBuffer stringBuffer = new StringBuffer(string.length() + 100).append(string.substring(0, n4)).append("select * from ( select ").append(this.getRowNumber(string));
        if (DB2Dialect.hasDistinct(string)) {
            stringBuffer.append(" row_.* from ( ").append(string.substring(n4)).append(" ) as row_");
        } else {
            stringBuffer.append(string.substring(n4 + 6));
        }
        stringBuffer.append(" ) as temp_ where rownumber_ ");
        stringBuffer.append("between " + (n2 + 1) + " and " + n3);
        return stringBuffer.toString();
    }

    private static boolean hasDistinct(String string) {
        return string.toLowerCase().indexOf("select distinct") >= 0;
    }

    private String getRowNumber(String string) {
        StringBuffer stringBuffer = new StringBuffer(50).append("rownumber() over(");
        int n2 = string.toLowerCase().indexOf("order by");
        if (n2 > 0 && !DB2Dialect.hasDistinct(string)) {
            stringBuffer.append(string.substring(n2));
        }
        stringBuffer.append(") as rownumber_,");
        return stringBuffer.toString();
    }

    public String quartzDelegateClass() {
        return "";
    }

    protected Object clone() throws CloneNotSupportedException {
        return "SELECT 1";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoreProcedureParameter[] getStoreProcedureDeclarationParameters(Connection connection, String string, String string2) {
        ArrayList<StoreProcedureParameter> arrayList = new ArrayList<StoreProcedureParameter>();
        String string3 = "SELECT * FROM SYSCAT.PROCPARMS where PROCNAME='" + string + "'";
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                String string4 = resultSet.getString("PARMNAME");
                String string5 = resultSet.getString("TYPENAME");
                String string6 = resultSet.getString("PARM_MODE");
                StoreProcedureParameter storeProcedureParameter = new StoreProcedureParameter(string4, string2, this.sql2ParameterType(string6), this.sql2ColumnTypeForProcedure(string5));
                arrayList.add(storeProcedureParameter);
            }
        }
        catch (SQLException sQLException) {
            try {
                FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
            }
            catch (Throwable throwable) {
                DBUtils.closeResultSet(resultSet);
                DBUtils.closeStatement(statement);
                throw throwable;
            }
            DBUtils.closeResultSet(resultSet);
            DBUtils.closeStatement(statement);
        }
        DBUtils.closeResultSet(resultSet);
        DBUtils.closeStatement(statement);
        return arrayList.toArray(new StoreProcedureParameter[arrayList.size()]);
    }

    protected String getProcedureParametersSql(String string) {
        return "SELECT text FROM syscat.routines WHERE ROUTINENAME='" + string + "' AND ROUTINETYPE='P'";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStoreProcedureText(Connection connection, String string) {
        ResultSet resultSet;
        Statement statement;
        block5: {
            String string2;
            block6: {
                String[] stringArray = string.split("\\.");
                String string3 = this.getProcedureSql(stringArray[stringArray.length - 1]);
                statement = null;
                resultSet = null;
                statement = connection.createStatement();
                resultSet = statement.executeQuery(string3);
                if (!resultSet.next()) break block5;
                Reader reader = resultSet.getCharacterStream("text");
                if (reader == null) break block6;
                BufferedReader bufferedReader = new BufferedReader(reader);
                String string4 = DataUtils.reader2String(bufferedReader);
                DBUtils.closeResultSet(resultSet);
                DBUtils.closeStatement(statement);
                return string4;
            }
            try {
                string2 = "ERROR FETCHING...";
            }
            catch (SQLException sQLException) {
                try {
                    FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
                }
                catch (Throwable throwable) {
                    DBUtils.closeResultSet(resultSet);
                    DBUtils.closeStatement(statement);
                    throw throwable;
                }
                DBUtils.closeResultSet(resultSet);
                DBUtils.closeStatement(statement);
            }
            DBUtils.closeResultSet(resultSet);
            DBUtils.closeStatement(statement);
            return string2;
        }
        DBUtils.closeResultSet(resultSet);
        DBUtils.closeStatement(statement);
        return "ERROR FETCHING...";
    }

    protected String getProcedureSql(String string) {
        return this.getProcedureParametersSql(string);
    }
}

