/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core.db;

import com.fr.data.core.DataCoreUtils;
import com.fr.data.core.db.ColumnInformation;
import com.fr.data.core.db.DBConstants;
import com.fr.data.core.db.TableProcedure;
import com.fr.data.core.db.dialect.AccessDialect;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.core.db.dialect.OracleDialect;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.handler.SQLTypeHandler;
import com.fr.data.impl.AbstractDatabaseConnection;
import com.fr.data.impl.Connection;
import com.fr.data.impl.JDBCDatabaseConnection;
import com.fr.data.impl.JNDIDatabaseConnection;
import com.fr.data.impl.NameDatabaseConnection;
import com.fr.data.pool.DBCPConnectionPoolAttr;
import com.fr.file.DatasourceManager;
import com.fr.general.ComparatorUtils;
import com.fr.general.DateUtils;
import com.fr.general.EnvProvider;
import com.fr.general.FRLogLevel;
import com.fr.general.FRLogger;
import com.fr.general.GeneralContext;
import com.fr.general.GeneralUtils;
import com.fr.general.Inter;
import com.fr.json.JSONObject;
import com.fr.stable.Primitive;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import oracle.jdbc.OracleCallableStatement;

public class DBUtils {
    private static final int DEFAULT_CACHE_LOG_SIZE = 200;

    private DBUtils() {
    }

    public static void applyColumnTypeValue(Dialect dialect, java.sql.Connection connection, Table table, String string, PreparedStatement preparedStatement, int n2, int n3, Object object) throws SQLException {
        if (FRLogger.getLogger().isLoggable(FRLogLevel.DEBUG)) {
            FRLogger.getLogger().info("columnIndex:" + n2 + "[" + n3 + "]" + "<--->" + "columnValue:" + GeneralUtils.objectToString(object) + "[" + (object == null ? "NULL" : object.getClass().getName()) + "]");
        }
        if (DBUtils.isNULL(object)) {
            if (DBUtils.isProcessSpecialNull(preparedStatement, n3, n2)) {
                return;
            }
            preparedStatement.setNull(n2, n3);
            return;
        }
        if (dialect.isYearData(connection, n3, table, string)) {
            object = DateUtils.date2Year(object);
        }
        SQLTypeHandler sQLTypeHandler = dialect.buildSQLTypeHandlerFactory().getTypeHandler(new Integer(n3));
        sQLTypeHandler.setValue(preparedStatement, n2, object, n3);
    }

    private static boolean isProcessSpecialNull(PreparedStatement preparedStatement, int n2, int n3) throws SQLException {
        if (n2 == -4 && DialectFactory.generateDialect(preparedStatement.getConnection()) instanceof AccessDialect) {
            preparedStatement.setString(n3, "");
            return true;
        }
        return false;
    }

    public static boolean isNULL(Object object) {
        return object == null || ComparatorUtils.equals(Primitive.NULL, object);
    }

    public static int getColumnFRType(int n2) {
        int n3;
        for (n3 = 0; n3 < DBConstants.STRING_ARRAY.length; ++n3) {
            if (DBConstants.STRING_ARRAY[n3] != n2) continue;
            return DBConstants.FR_STRING;
        }
        for (n3 = 0; n3 < DBConstants.NUMBER_ARRAY.length; ++n3) {
            if (DBConstants.NUMBER_ARRAY[n3] != n2) continue;
            return DBConstants.FR_NUMBER;
        }
        for (n3 = 0; n3 < DBConstants.NULL_ARRAY.length; ++n3) {
            if (DBConstants.NULL_ARRAY[n3] != n2) continue;
            return DBConstants.FR_NULL;
        }
        for (n3 = 0; n3 < DBConstants.STREAM_ARRAY.length; ++n3) {
            if (DBConstants.STREAM_ARRAY[n3] != n2) continue;
            return DBConstants.FR_STREAM;
        }
        for (n3 = 0; n3 < DBConstants.BOOLEAN_ARRAY.length; ++n3) {
            if (DBConstants.BOOLEAN_ARRAY[n3] != n2) continue;
            return DBConstants.FR_BOOLEAN;
        }
        return DBConstants.FR_NULL;
    }

    public static void closeConnection(java.sql.Connection connection) {
        try {
            if (connection != null) {
                connection.close();
                connection = null;
            }
        }
        catch (SQLException sQLException) {
            FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
        }
    }

    public static void closeStatement(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
                statement = null;
            }
        }
        catch (SQLException sQLException) {
            FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
        }
    }

    public static void closeResultSet(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
                resultSet = null;
            }
        }
        catch (SQLException sQLException) {
            FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
        }
    }

    public static void rollback(java.sql.Connection connection) {
        if (connection == null) {
            return;
        }
        try {
            if (!connection.getAutoCommit()) {
                connection.rollback();
                FRLogger.getLogger().info("Rollback Successfully");
            } else {
                FRLogger.getLogger().info("Failed to rollback because of the connection is autoCommit");
            }
        }
        catch (SQLException sQLException) {
            FRLogger.getLogger().error(Inter.getLocText("Data_Rollback_Failed"), sQLException);
        }
    }

    public static Object[] remoteProcedureCall(java.sql.Connection connection, String string) throws SQLException {
        Object[] objectArray = new Object[2];
        Statement statement = null;
        ResultSet resultSet = null;
        Dialect dialect = DialectFactory.generateDialect(connection);
        if (dialect instanceof OracleDialect) {
            PreparedStatement preparedStatement = null;
            int[] nArray = new int[]{1};
            if (string.indexOf("?") != -1) {
                int n2 = string.split("\\?").length - 1;
                statement = connection.prepareCall(string);
                preparedStatement = statement;
                for (int i2 = 1; i2 <= n2; ++i2) {
                    preparedStatement.registerOutParameter(i2, -10);
                }
            } else if (string.indexOf("$[") != -1) {
                DBUtils.dealWithOracleProcedureStatement(connection, string, nArray, statement, (CallableStatement)preparedStatement);
            }
            preparedStatement.execute();
            if (preparedStatement instanceof OracleCallableStatement) {
                resultSet = ((OracleCallableStatement)preparedStatement).getCursor(nArray[0]);
            } else {
                Object object = preparedStatement.getObject(nArray[0]);
                if (object instanceof ResultSet) {
                    resultSet = (ResultSet)object;
                } else {
                    String string2 = object.toString();
                    statement = connection.createStatement();
                    resultSet = statement.executeQuery(string2);
                }
            }
        } else {
            statement = connection.prepareCall(string, 1003, 1007);
            CallableStatement callableStatement = statement;
            resultSet = callableStatement.executeQuery();
        }
        objectArray[0] = statement;
        objectArray[1] = resultSet;
        return objectArray;
    }

    private static void dealWithOracleProcedureStatement(java.sql.Connection connection, String string, int[] nArray, Statement statement, CallableStatement callableStatement) throws SQLException {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        int n2 = 1;
        int n3 = 0;
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            int n4;
            int n5;
            if ((n3 = string.indexOf("$[", n5 = n3)) < 0) {
                stringBuffer.append(string.substring(n5));
                break;
            }
            stringBuffer.append(string.substring(n5, n3));
            int n6 = string.indexOf("]$", n3 + 2);
            if (n6 <= n3) break;
            String string2 = string.substring(n3 + 2, n6);
            if (string2 == null || string2.length() <= 0) {
                n3 = n6 + 2;
                continue;
            }
            if (string2.startsWith("@")) {
                nArray[0] = n2;
                string2 = string2.substring(1);
                bl = true;
            }
            if ((n4 = DataCoreUtils.calculateOracleType(string2)) == -10 && !bl) {
                nArray[0] = n2;
                bl = true;
            }
            hashMap.put(new Integer(n2), new Integer(n4));
            n3 = n6 + 2;
            stringBuffer.append('?');
            ++n2;
        }
        statement = connection.prepareCall(stringBuffer.toString());
        callableStatement = (CallableStatement)statement;
        for (Integer n7 : hashMap.keySet()) {
            callableStatement.registerOutParameter((int)n7, (int)((Integer)hashMap.get(n7)));
        }
    }

    public static String[] checkInColumnNames(java.sql.Connection connection, String string) {
        try {
            ColumnInformation[] columnInformationArray = DBUtils.checkInColumnInformation(connection, string);
            String[] stringArray = new String[columnInformationArray.length];
            for (int i2 = 0; i2 < columnInformationArray.length; ++i2) {
                stringArray[i2] = columnInformationArray[i2].getColumnName();
            }
            return stringArray;
        }
        catch (SQLException sQLException) {
            FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
            return new String[0];
        }
    }

    public static JSONObject checkInColumnTypeMap(java.sql.Connection connection, String string) {
        try {
            ColumnInformation[] columnInformationArray = DBUtils.checkInColumnInformation(connection, string);
            JSONObject jSONObject = new JSONObject();
            for (int i2 = 0; i2 < columnInformationArray.length; ++i2) {
                jSONObject.put(columnInformationArray[i2].getColumnName(), columnInformationArray[i2].getColumnType());
            }
            return jSONObject;
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
            return new JSONObject();
        }
    }

    public static NameDatabaseConnection checkDBConnection(String string) {
        DatasourceManager datasourceManager = DatasourceManager.getInstance();
        Iterator iterator = datasourceManager.getConnectionNameIterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            Connection connection = datasourceManager.getConnection(string2);
            if (connection == null || !ComparatorUtils.equals(string, string2)) continue;
            try {
                return new NameDatabaseConnection(string2);
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
            }
        }
        return null;
    }

    public static ColumnInformation[] checkInColumnInformation(java.sql.Connection connection, String string) throws SQLException {
        Object[] objectArray;
        if (connection == null) {
            throw new SQLException("Cannot connect to database!");
        }
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            if (DBUtils.isProcedure(string)) {
                objectArray = DBUtils.remoteProcedureCall(connection, string);
                statement = (Statement)objectArray[0];
                resultSet = (ResultSet)objectArray[1];
            } else {
                statement = connection.createStatement();
                try {
                    resultSet = statement.executeQuery("select * from (" + string + ") t" + " where 4 = 5");
                }
                catch (Exception exception) {
                    statement.close();
                    statement = connection.createStatement();
                    resultSet = statement.executeQuery(string);
                }
            }
        }
        catch (SQLException sQLException) {
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
            throw sQLException;
        }
        objectArray = DBUtils.checkInColumnInformationByMetaData(resultSet.getMetaData());
        resultSet.close();
        statement.close();
        return objectArray;
    }

    public static ColumnInformation[] checkInColumnInformationByMetaData(ResultSetMetaData resultSetMetaData) throws SQLException {
        return DBUtils.checkInColumnInformationByMetaData(resultSetMetaData, "", "");
    }

    public static ColumnInformation[] checkInColumnInformationByMetaData(ResultSetMetaData resultSetMetaData, String string, String string2) throws SQLException {
        int n2 = resultSetMetaData.getColumnCount();
        ColumnInformation[] columnInformationArray = new ColumnInformation[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            String string3 = resultSetMetaData.getColumnLabel(i2 + 1);
            string3 = DBUtils.changeCharset(string3, string, string2);
            columnInformationArray[i2] = new ColumnInformation(string3, resultSetMetaData.getColumnType(i2 + 1), resultSetMetaData.getColumnTypeName(i2 + 1), resultSetMetaData.getColumnDisplaySize(i2 + 1));
            resultSetMetaData.getScale(i2 + 1);
        }
        return columnInformationArray;
    }

    public static String changeCharset(String string, String string2, String string3) {
        if (StringUtils.isNotEmpty(string2) && StringUtils.isNotEmpty(string3)) {
            try {
                if (string3 != null && string3.length() > 0) {
                    return new String(string.getBytes(string2), string3);
                }
                return new String(string.getBytes(string2));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                FRLogger.getLogger().error(unsupportedEncodingException.getMessage(), unsupportedEncodingException);
            }
        }
        return string;
    }

    public static boolean isProcedure(String string) {
        if (string == null) {
            return false;
        }
        String string2 = string.replaceAll(" ", "").toUpperCase();
        return string2.startsWith("{CALL") || string2.startsWith("{?=CALL");
    }

    public static boolean isExsitedTable(Connection connection, String string) {
        try {
            for (TableProcedure tableProcedure : (TableProcedure[])GeneralContext.getEnvProvider().getTableProcedure(connection, "TABLE", null)) {
                if (!string.equalsIgnoreCase(tableProcedure.getName())) continue;
                return true;
            }
        }
        catch (Exception exception) {
            FRLogger.getLogger().info(exception.getMessage());
        }
        return false;
    }

    public static void refreshDatabase() {
        DatasourceManager datasourceManager = DatasourceManager.getInstance();
        Iterator iterator = datasourceManager.getConnectionNameIterator();
        while (iterator.hasNext()) {
            String string;
            String string2;
            String string3;
            Object object;
            AbstractDatabaseConnection abstractDatabaseConnection;
            String string4 = (String)iterator.next();
            Connection connection = datasourceManager.getConnection(string4);
            if (connection instanceof JDBCDatabaseConnection) {
                abstractDatabaseConnection = new JDBCDatabaseConnection();
                object = ((JDBCDatabaseConnection)connection).getDriver();
                string3 = ((JDBCDatabaseConnection)connection).getURL();
                string2 = ((JDBCDatabaseConnection)connection).getUser();
                string = ((JDBCDatabaseConnection)connection).getPassword();
                ((JDBCDatabaseConnection)abstractDatabaseConnection).setDriver((String)object);
                ((JDBCDatabaseConnection)abstractDatabaseConnection).setURL(string3);
                ((JDBCDatabaseConnection)abstractDatabaseConnection).setUser(string2);
                ((JDBCDatabaseConnection)abstractDatabaseConnection).setPassword(string);
                datasourceManager.putConnection(string4, abstractDatabaseConnection);
                continue;
            }
            if (!(connection instanceof JNDIDatabaseConnection)) continue;
            abstractDatabaseConnection = new JNDIDatabaseConnection();
            object = ((JNDIDatabaseConnection)connection).getContextHashtable();
            string3 = ((JNDIDatabaseConnection)connection).getJNDIName();
            string2 = ((JNDIDatabaseConnection)connection).getNewCharsetName();
            string = ((JNDIDatabaseConnection)connection).getOriginalCharsetName();
            ((JNDIDatabaseConnection)abstractDatabaseConnection).setContextHashtable((Hashtable)object);
            ((JNDIDatabaseConnection)abstractDatabaseConnection).setJNDIName(string3);
            abstractDatabaseConnection.setNewCharsetName(string2);
            abstractDatabaseConnection.setOriginalCharsetName(string);
            datasourceManager.putConnection(string4, abstractDatabaseConnection);
        }
    }

    public static JDBCDatabaseConnection getEmbeddedDB(String string, int n2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("hsqldb.cache_size_scale", new Integer(8));
        hashMap.put("hsqldb.cache_scale", new Integer(8));
        hashMap.put("hsqldb.cache_file_scale", new Integer(8));
        hashMap.put("hsqldb.default_table_type", "cached");
        hashMap.put("hsqldb.applog", new Integer(0));
        DBCPConnectionPoolAttr dBCPConnectionPoolAttr = new DBCPConnectionPoolAttr();
        dBCPConnectionPoolAttr.setInitialSize(10);
        dBCPConnectionPoolAttr.setMaxActive(100);
        dBCPConnectionPoolAttr.setMaxIdle(30);
        dBCPConnectionPoolAttr.setMinIdle(10);
        dBCPConnectionPoolAttr.setMaxWait(5000);
        return DBUtils.getEmbeddedDB(string, hashMap, n2, dBCPConnectionPoolAttr);
    }

    public static JDBCDatabaseConnection getEmbeddedDB(String string, Map map, int n2, DBCPConnectionPoolAttr dBCPConnectionPoolAttr) {
        Object object;
        Serializable serializable;
        String string2 = DBUtils.dealWithDBPath(string);
        String string3 = "emb:jdbc:hsqldb:file:" + StableUtils.pathJoin(new String[]{string2, string, "db"});
        if (map != null) {
            serializable = new StringBuffer(";");
            object = map.entrySet();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                ((StringBuffer)serializable).append(entry.getKey()).append("=").append(entry.getValue()).append(";");
            }
            string3 = string3 + ((StringBuffer)serializable).toString();
        }
        serializable = new JDBCDatabaseConnection("com.fr.third.org.hsqldb.jdbcDriver", string3, "sa", "");
        ((JDBCDatabaseConnection)serializable).setDbcpAttr(dBCPConnectionPoolAttr);
        object = null;
        try {
            if (n2 <= 0) {
                n2 = 1;
            } else if (n2 > 200) {
                n2 = 200;
            }
            object = ((JDBCDatabaseConnection)serializable).createConnection();
            object.createStatement().execute("SET LOGSIZE " + n2);
        }
        catch (Exception exception) {
            try {
                throw new RuntimeException("CREATE EMB-DB: SET LOGSIZE FAILED!", exception);
            }
            catch (Throwable throwable) {
                DBUtils.closeConnection(object);
                throw throwable;
            }
        }
        DBUtils.closeConnection((java.sql.Connection)object);
        return serializable;
    }

    private static String dealWithDBPath(String string) {
        EnvProvider envProvider = GeneralContext.getEnvProvider();
        if (envProvider == null) {
            return "";
        }
        if (envProvider.isPackDeploy()) {
            try {
                File file = new File(StableUtils.pathJoin(new String[]{envProvider.getPath(), string}));
                if (!file.exists()) {
                    InputStream inputStream = envProvider.readBean("db.data", string);
                    GeneralUtils.copy(inputStream, "db.data", file);
                }
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage());
            }
        }
        return envProvider.getPath();
    }
}

