/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.condition;

import com.fr.base.BaseScriptUtils;
import com.fr.data.condition.AbstractCondition;
import com.fr.data.core.Compare;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.GeneralUtils;
import com.fr.script.Calculator;
import com.fr.stable.ColumnRow;
import com.fr.stable.FormulaProvider;
import com.fr.stable.ModColumnRowProvider;
import com.fr.stable.Primitive;
import com.fr.stable.UtilEvalError;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.script.ExTool;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.List;

public class ObjectCondition
extends AbstractCondition {
    private Compare compare;

    public ObjectCondition() {
    }

    public ObjectCondition(Compare compare) {
        this.setCompare(compare);
    }

    public Compare getCompare() {
        return this.compare;
    }

    public void setCompare(Compare compare) {
        this.compare = compare;
    }

    public String[] getDependence() {
        return BaseScriptUtils.getDependenceByCompare(this.compare);
    }

    public void modColumnRow(ModColumnRowProvider modColumnRowProvider) {
        if (this.compare != null) {
            this.compare.modColumnRow(modColumnRowProvider);
        }
    }

    public void formula2Value(Calculator calculator) {
        if (this.compare != null) {
            this.compare.fm2Value(calculator);
        }
    }

    public void buidExecuteSequenceList(List list, Calculator calculator) {
        if (this.compare != null) {
            GeneralUtils.dealBuidExecuteSequence(this.compare.getValue(), list, calculator);
        }
    }

    public boolean eval(Object object, CalculatorProvider calculatorProvider) {
        if (this.compare == null) {
            return true;
        }
        Compare compare = this.getCompare();
        Object object2 = compare.getValue();
        if (object2 instanceof FormulaProvider) {
            try {
                object2 = calculatorProvider.evalValue(((FormulaProvider)object2).getContent().substring(1));
            }
            catch (UtilEvalError utilEvalError) {
                FRLogger.getLogger().error(utilEvalError.getMessage(), utilEvalError);
            }
        } else if (!(object2 instanceof String) && !(object2 instanceof Primitive)) {
            object2 = calculatorProvider.resolveVariable(object2);
        } else if (object2 instanceof String && ((String)object2).startsWith("@")) {
            object2 = calculatorProvider.resolveVariable(object2);
        }
        if (object2 != null) {
            try {
                compare = (Compare)compare.clone();
                compare.setValue(object2);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                FRLogger.getLogger().error(cloneNotSupportedException.getMessage(), cloneNotSupportedException);
            }
        }
        return compare.eval(object);
    }

    public void analyzeCorrelative(CalculatorProvider calculatorProvider, ExTool exTool, ColumnRow columnRow) {
        if (this.compare != null) {
            this.compare.analyzeCorrelative(calculatorProvider, exTool, columnRow);
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ObjectCondition)) {
            return false;
        }
        ObjectCondition objectCondition = (ObjectCondition)object;
        return ComparatorUtils.equals(objectCondition.getCompare(), this.getCompare());
    }

    public String toString() {
        return "currentValue " + this.getCompare();
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode() && ("Compare".equals(xMLableReader.getTagName()) || xMLableReader.getTagName().equals("Condition"))) {
            this.compare = new Compare(0, "");
            xMLableReader.readXMLObject(this.compare);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        if (this.getCompare() != null) {
            this.getCompare().writeXML(xMLPrintWriter);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ObjectCondition objectCondition = (ObjectCondition)super.clone();
        if (this.compare != null) {
            objectCondition.compare = (Compare)this.compare.clone();
        }
        return objectCondition;
    }
}

