/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data;

import com.fr.base.TableData;
import com.fr.base.TableDataNameObserver;
import com.fr.data.TableDataSource;
import com.fr.data.core.DataCoreUtils;
import com.fr.data.core.DataCoreXmlUtils;
import com.fr.data.impl.DBTableData;
import com.fr.data.impl.MultiTDTableData;
import com.fr.data.impl.RecursionTableData;
import com.fr.data.impl.storeproc.StoreProcedure;
import com.fr.file.DatasourceManager;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.GeneralUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractTableDataSource
implements TableDataSource,
TableDataNameObserver {
    public static final String XML_TAG = "TableDataMap";
    protected List tableDataNameList = new ArrayList();
    protected List tableDataList = new ArrayList();

    public Iterator getTableDataNameIterator() {
        return this.tableDataNameList.iterator();
    }

    public TableData getTableData(String string) {
        TableData tableData = null;
        tableData = this.isEmptyTableData(string);
        if (tableData == null) {
            tableData = DataCoreUtils.existsName(string, this);
        }
        return tableData;
    }

    public TableData isEmptyTableData(String string) {
        int n2 = this.tableDataNameList.indexOf(string);
        return n2 != -1 ? (TableData)this.tableDataList.get(n2) : null;
    }

    public void putTableData(String string, TableData tableData) {
        if (string == null) {
            return;
        }
        int n2 = this.tableDataNameList.indexOf(string);
        if (tableData == null) {
            if (n2 != -1) {
                this.tableDataNameList.remove(n2);
                this.tableDataList.remove(n2);
            }
        } else if (n2 != -1) {
            this.tableDataList.set(n2, tableData);
        } else {
            this.tableDataNameList.add(string);
            this.tableDataList.add(tableData);
        }
    }

    public boolean renameTableData(String string, String string2) {
        if (string2 == null || string == null) {
            return false;
        }
        if (ComparatorUtils.equals(string, string2)) {
            return false;
        }
        int n2 = this.tableDataNameList.indexOf(string);
        if (n2 == -1) {
            return false;
        }
        this.tableDataNameList.set(n2, string2);
        return true;
    }

    public void removeTableData(String string) {
        if (string == null) {
            return;
        }
        int n2 = this.tableDataNameList.indexOf(string);
        if (n2 != -1) {
            this.tableDataNameList.remove(n2);
            this.tableDataList.remove(n2);
        }
    }

    public void clearAllTableData() {
        this.tableDataNameList.clear();
        this.tableDataList.clear();
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals(XML_TAG)) {
            xMLableReader.readXMLObject(new XMLReadable(){

                public void readXML(XMLableReader xMLableReader) {
                    if (xMLableReader.isAttr()) {
                        AbstractTableDataSource.this.clearAllTableData();
                    }
                    if (xMLableReader.isChildNode()) {
                        final String string = xMLableReader.getAttrAsString("name", null);
                        if ("NameTableData".equals(xMLableReader.getTagName())) {
                            xMLableReader.readXMLObject(new XMLReadable(){

                                public void readXML(XMLableReader xMLableReader) {
                                    if (xMLableReader.getTagName().equals("TableData")) {
                                        TableData tableData = DataCoreXmlUtils.readXMLTableData(xMLableReader);
                                        AbstractTableDataSource.this.putTableData(string, tableData);
                                    }
                                }
                            });
                        } else {
                            TableData tableData = DataCoreXmlUtils.readXMLTableData(xMLableReader);
                            AbstractTableDataSource.this.dealWithTableData(tableData, xMLableReader, string);
                            AbstractTableDataSource.this.putTableData(string, tableData);
                        }
                    }
                }
            });
        }
    }

    private void dealWithTableData(TableData tableData, XMLableReader xMLableReader, String string) {
        Object object;
        Object object2;
        if (tableData == null && ComparatorUtils.equals(object2 = xMLableReader.getAttrAsString("class", null), "com.fr.data.impl.storeproc.StoreProcedure")) {
            object = null;
            try {
                object = (StoreProcedure)GeneralUtils.classForName((String)object2).newInstance();
            }
            catch (InstantiationException instantiationException) {
                FRLogger.getLogger().error(instantiationException.getMessage(), instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                FRLogger.getLogger().error(illegalAccessException.getMessage(), illegalAccessException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                FRLogger.getLogger().error(classNotFoundException.getMessage(), classNotFoundException);
            }
            if (object != null) {
                xMLableReader.readXMLObject((XMLReadable)object);
                DatasourceManager.getInstance().putProcedure(string + "from655", (StoreProcedure)object);
                return;
            }
        }
        if (tableData instanceof MultiTDTableData) {
            ((MultiTDTableData)tableData).setTableDataSource(this);
        } else if (tableData instanceof RecursionTableData) {
            object2 = (RecursionTableData)tableData;
            if (((RecursionTableData)object2).getOriginalTableDataName() == null && ((RecursionTableData)object2).getCon() != null) {
                object = "dsForTree";
                DBTableData dBTableData = new DBTableData(((RecursionTableData)object2).getCon(), ((RecursionTableData)object2).getQuery());
                dBTableData.setParameters(((RecursionTableData)object2).getParameters());
                ((RecursionTableData)object2).setOriginalTableDataName((String)object);
                this.putTableData((String)object, tableData);
                return;
            }
            ((RecursionTableData)object2).setTableDataSource(this);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        Iterator iterator = this.getTableDataNameIterator();
        if (iterator.hasNext()) {
            xMLPrintWriter.startTAG(XML_TAG);
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                TableData tableData = this.getTableData(string);
                DataCoreXmlUtils.writeXMLTableData(xMLPrintWriter, tableData, string);
            }
            xMLPrintWriter.end();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractTableDataSource abstractTableDataSource = (AbstractTableDataSource)super.clone();
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.tableDataNameList);
        abstractTableDataSource.tableDataNameList = arrayList;
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (int i2 = 0; i2 < this.tableDataList.size(); ++i2) {
            arrayList2.add(((TableData)this.tableDataList.get(i2)).clone());
        }
        abstractTableDataSource.tableDataList = arrayList2;
        return abstractTableDataSource;
    }

    protected void copyDataSourceAttr(AbstractTableDataSource abstractTableDataSource) {
        abstractTableDataSource.tableDataList = this.tableDataList;
        abstractTableDataSource.tableDataNameList = this.tableDataNameList;
    }

    public boolean equals(Object object) {
        return object instanceof AbstractTableDataSource && ComparatorUtils.equals(this.tableDataNameList, ((AbstractTableDataSource)object).tableDataNameList) && ComparatorUtils.equals(this.tableDataList, ((AbstractTableDataSource)object).tableDataList);
    }
}

