/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.web;

import com.fr.base.Parameter;
import com.fr.base.ParameterMapNameSpace;
import com.fr.base.Utils;
import com.fr.base.chart.BaseChartPainter;
import com.fr.base.chart.ChartWebSource;
import com.fr.chart.web.ChartHyperPoplink;
import com.fr.data.TableDataSource;
import com.fr.js.ChartHyperlink;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.ParameterProvider;
import com.fr.stable.html.Tag;
import com.fr.stable.script.NameSpace;
import com.fr.stable.web.Repository;
import com.fr.web.RepositoryDeal;
import com.fr.web.core.ActionCMD;
import com.fr.web.core.ErrorHandlerHelper;
import com.fr.web.core.SessionDealWith;
import com.fr.web.core.SessionIDInfor;
import com.fr.web.utils.WebUtils;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ChartPopIframeAction
implements ActionCMD {
    private static final int DAILOGHEIGHT = 30;

    public String getCMD() {
        return "pop_chart";
    }

    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws Exception {
        SessionIDInfor sessionIDInfor = SessionDealWith.getSessionIDInfor(string);
        if (sessionIDInfor == null) {
            ErrorHandlerHelper.getErrorHandler().error(httpServletRequest, httpServletResponse, "SessionID: \"" + string + "\" time out.");
            return;
        }
        ChartHyperlink chartHyperlink = this.getChartHyperlinkFromRepoWithHttpRequest(httpServletRequest, sessionIDInfor);
        if (!(chartHyperlink instanceof ChartHyperPoplink)) {
            return;
        }
        ChartHyperPoplink chartHyperPoplink = (ChartHyperPoplink)chartHyperlink;
        RepositoryDeal repositoryDeal = new RepositoryDeal(httpServletRequest, sessionIDInfor, 96);
        int n2 = chartHyperPoplink.getWidth();
        int n3 = chartHyperPoplink.getHeight();
        Calculator calculator = this.createCalculatorFormRepo(httpServletRequest, httpServletResponse, sessionIDInfor, repositoryDeal);
        BaseChartPainter baseChartPainter = chartHyperPoplink.getChartCollection().createChartPainterJustTableDataAndDealFormual(calculator, n2, n3);
        if (baseChartPainter == null) {
            return;
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("title", chartHyperPoplink.getChartDigTitle());
        Tag tag = new Tag("div");
        jSONObject.put("iframe", tag.toHtml());
        jSONObject.put("widget", baseChartPainter.createJSONConfig(repositoryDeal, n2, n3));
        jSONObject.put("width", n2);
        jSONObject.put("height", n3 + 30);
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        printWriter.print(jSONObject);
        printWriter.flush();
        printWriter.close();
    }

    protected ChartHyperlink getChartHyperlinkFromRepoWithHttpRequest(HttpServletRequest httpServletRequest, SessionIDInfor sessionIDInfor) {
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "ChartHyperlink_ID");
        Object object = ChartWebSource.getChartSource(sessionIDInfor.getSessionID(), string);
        if (object instanceof Map) {
            Map map = (Map)object;
            return (ChartHyperlink)map.get("ChartHyperlink_Value");
        }
        return null;
    }

    protected Calculator createCalculatorFormRepo(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, SessionIDInfor sessionIDInfor, Repository repository) {
        Map map = repository.getReportParameterMap();
        map.putAll(sessionIDInfor.getParameterMap4Execute());
        map.putAll(WebUtils.parameters4SessionIDInfor(httpServletRequest));
        Calculator calculator = sessionIDInfor.createSessionCalculator(httpServletRequest, httpServletResponse);
        calculator.pushNameSpace(this.createNameSpaceFromParaMeterMap(map));
        calculator.setAttribute(TableDataSource.class, sessionIDInfor.getTableDataSource());
        return calculator;
    }

    private NameSpace createNameSpaceFromParaMeterMap(Map map) {
        Iterator iterator = map.entrySet().iterator();
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Parameter parameter = new Parameter(Utils.objectToString(entry.getKey()), entry.getValue());
            arrayList.add(parameter);
        }
        return ParameterMapNameSpace.create(arrayList.toArray(new ParameterProvider[arrayList.size()]));
    }
}

