/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.chart.base.ChartUtils;
import com.fr.chart.chartglyph.AxisGlyph;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataPoint4XY;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.MarkerGlyph;
import com.fr.chart.chartglyph.RectanglePlotGlyph;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public class XYScatterPlotGlyph
extends RectanglePlotGlyph {
    private static final long serialVersionUID = 64495889773358205L;
    private static final double MARKER_SIZE = 5.0;
    private boolean isCurve = false;

    public void setCurve(boolean bl) {
        this.isCurve = bl;
    }

    public void layoutDataSeriesGlyph(int n2) {
        int n3 = this.getSeriesSize();
        for (int i2 = 0; i2 < n3; ++i2) {
            DataSeries dataSeries = this.getSeries(i2);
            int n4 = this.calculateLineDataCount(dataSeries);
            double[] dArray = new double[n4];
            double[] dArray2 = new double[n4];
            n4 = 0;
            GeneralPath generalPath = new GeneralPath();
            GeneralPath generalPath2 = new GeneralPath(1);
            boolean bl = true;
            for (int i3 = 0; i3 < dataSeries.getDataPointCount(); ++i3) {
                DataPoint4XY dataPoint4XY = (DataPoint4XY)dataSeries.getDataPoint(i3);
                if (dataPoint4XY.isValueIsNull()) {
                    if (!this.isNullValueBreak()) continue;
                    bl = true;
                    continue;
                }
                float f2 = (float)this.getxAxisGlyph().getPoint2D(dataPoint4XY.getX()).getX();
                float f3 = (float)this.getStartY(dataPoint4XY);
                dArray[n4] = f2;
                dArray2[n4] = f3;
                ++n4;
                bl = this.movePathAndMakeSureIsStartPoint(generalPath2, generalPath, bl, f2, f3);
                this.makeSureGlyph4Draw(dataPoint4XY, f2, f3);
                this.dealDataPointLabel(dataPoint4XY, n2);
            }
            if (this.isCurve) {
                this.dealCurveLinePath(generalPath, generalPath2, dataSeries);
            } else {
                this.dealCommonLinePath(generalPath, dataSeries);
            }
            this.trendLineFitting(dArray, dArray2, dataSeries);
        }
        this.dealLabelBoundsInOrder();
    }

    protected double getStartY(DataPoint dataPoint) {
        AxisGlyph axisGlyph = this.getyAxisGlyph();
        if (axisGlyph == null) {
            return 0.0;
        }
        if (axisGlyph.getBounds() == null) {
            return axisGlyph.getPoint2D(dataPoint.getValue()).getY();
        }
        return axisGlyph.getBounds().getY() + axisGlyph.getPoint2D(dataPoint.getValue()).getY();
    }

    protected Rectangle2D getDataPointLabelBoundsWithPosition(Dimension2D dimension2D, Rectangle2D rectangle2D, int n2) {
        return this.getDataPointLabelBoundsWithPosition4Line(dimension2D, rectangle2D, n2);
    }

    private int calculateLineDataCount(DataSeries dataSeries) {
        int n2 = 0;
        for (int i2 = 0; i2 < dataSeries.getDataPointCount(); ++i2) {
            if (dataSeries.getDataPoint(i2).isValueIsNull()) continue;
            ++n2;
        }
        return n2;
    }

    private boolean movePathAndMakeSureIsStartPoint(GeneralPath generalPath, GeneralPath generalPath2, boolean bl, float f2, float f3) {
        if (this.isCurve) {
            if (bl) {
                ChartUtils.curveTo(generalPath2, generalPath);
                generalPath.reset();
                generalPath.moveTo(f2, f3);
                generalPath2.moveTo(f2, f3);
                bl = false;
            } else {
                generalPath.lineTo(f2, f3);
            }
        } else if (bl) {
            generalPath2.moveTo(f2, f3);
            bl = false;
        } else {
            generalPath2.lineTo(f2, f3);
        }
        return bl;
    }

    private void makeSureGlyph4Draw(DataPoint dataPoint, float f2, float f3) {
        MarkerGlyph markerGlyph = new MarkerGlyph();
        markerGlyph.dealCondition4Line(this.getConditionCollection(), dataPoint, this.createColors4Series());
        markerGlyph.setShape(new Rectangle2D.Double((double)f2 - 5.0, (double)f3 - 5.0, 10.0, 10.0));
        dataPoint.setDrawImpl(markerGlyph);
    }

    public boolean equals(Object object) {
        return object instanceof XYScatterPlotGlyph && super.equals(object) && ((XYScatterPlotGlyph)object).isCurve == this.isCurve;
    }

    public Object clone() throws CloneNotSupportedException {
        XYScatterPlotGlyph xYScatterPlotGlyph = (XYScatterPlotGlyph)super.clone();
        return xYScatterPlotGlyph;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        jSONObject.put("isCurve", this.isCurve);
        return jSONObject;
    }

    public String getPlotGlyphType() {
        return "XYScatterPlotGlyph";
    }
}

