/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.chart.base.ChartUtils;
import com.fr.chart.chartglyph.FoldLine;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public class TrendLineGlyph
extends FoldLine {
    private static final long serialVersionUID = 6388397140455844687L;
    private double[] val = new double[2];
    private int equation = 1;
    private int square = 6;
    private int average = 5;

    public void setEquation(int n2) {
        this.equation = n2;
    }

    public void setAverage(int n2) {
        this.average = n2;
    }

    public int getAverage() {
        return this.average;
    }

    public void setSquare(int n2) {
        this.square = n2;
    }

    public void drawShape(Rectangle2D rectangle2D) {
        if (this.equation < 0 || this.equation > 4) {
            return;
        }
        boolean bl = true;
        GeneralPath generalPath = new GeneralPath();
        for (double d2 = rectangle2D.getX(); d2 < rectangle2D.getWidth() + rectangle2D.getX(); d2 += 1.0) {
            double d3 = this.calculator(d2);
            if (d3 > rectangle2D.getHeight() || d3 < 0.0) {
                bl = true;
                continue;
            }
            if (bl) {
                generalPath.moveTo((float)d2, (float)d3);
                bl = false;
                continue;
            }
            generalPath.lineTo((float)d2, (float)d3);
        }
        this.setGeneralPath(generalPath);
    }

    public void fitting(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            return;
        }
        int n2 = this.square = this.square > dArray.length - 1 ? dArray.length - 1 : this.square;
        if (this.equation == 0) {
            this.linear(dArray, dArray2);
        } else if (this.equation == 1) {
            this.polynomial(dArray, dArray2, this.square);
        } else if (this.equation == 2) {
            this.log(dArray, dArray2);
        } else if (this.equation == 3) {
            this.exponent(dArray, dArray2);
        } else if (this.equation == 4) {
            this.power(dArray, dArray2);
        } else if (this.equation == 5) {
            this.ma(dArray, dArray2);
        }
    }

    private double calculator(double d2) {
        if (this.equation == 0) {
            return this.linearFunc(d2);
        }
        if (this.equation == 1) {
            return this.polynomialFunc(d2);
        }
        if (this.equation == 2) {
            return this.logFunc(d2);
        }
        if (this.equation == 3) {
            return this.exponentFunc(d2);
        }
        if (this.equation == 4) {
            return this.powerFunc(d2);
        }
        return Double.NaN;
    }

    private void linear(double[] dArray, double[] dArray2) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n2 = dArray.length;
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            d2 += dArray[i2];
            d3 += dArray2[i2];
            d4 += dArray[i2] * dArray[i2];
            d5 += dArray[i2] * dArray2[i2];
        }
        if (d2 * d2 - d4 * (double)n2 == 0.0) {
            return;
        }
        this.val[0] = (d3 * d2 - d5 * (double)n2) / (d2 * d2 - d4 * (double)n2);
        this.val[1] = (d3 - d2 * this.val[0]) / (double)n2;
    }

    private double[][] initB(double[] dArray, int n2) {
        double[][] dArray2 = new double[n2][dArray.length];
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < dArray.length; ++i3) {
                double d2 = 1.0;
                for (int i4 = 0; i4 < i2; ++i4) {
                    d2 *= dArray[i3];
                }
                dArray2[i2][i3] = d2;
            }
        }
        return dArray2;
    }

    private double[][] initA(double[] dArray, int n2, double[][] dArray2) {
        int n3;
        double d2;
        int n4;
        int n5;
        double[][] dArray3 = new double[n2][n2];
        for (n5 = 0; n5 < n2; ++n5) {
            for (n4 = 0; n4 < n2; ++n4) {
                d2 = 0.0;
                for (n3 = 0; n3 < dArray.length; ++n3) {
                    d2 += dArray2[n5][n3] * dArray2[n4][n3];
                }
                dArray3[n5][n4] = d2;
            }
        }
        for (n5 = 1; n5 < n2; ++n5) {
            dArray3[n5][0] = dArray3[n5][0] / dArray3[0][0];
        }
        for (n5 = 1; n5 < n2; ++n5) {
            for (n4 = n5; n4 < n2; ++n4) {
                d2 = 0.0;
                for (n3 = 0; n3 < n5; ++n3) {
                    d2 += dArray3[n3][n4] * dArray3[n5][n3];
                }
                dArray3[n5][n4] = dArray3[n5][n4] - d2;
                if (n4 + 1 == n2) continue;
                d2 = 0.0;
                for (n3 = 0; n3 < n5; ++n3) {
                    d2 += dArray3[n3][n5] * dArray3[n4 + 1][n3];
                }
                dArray3[n4 + 1][n5] = (dArray3[n4 + 1][n5] - d2) / dArray3[n5][n5];
            }
        }
        return dArray3;
    }

    private void polynomial(double[] dArray, double[] dArray2, int n2) {
        int n3;
        double d2;
        int n4;
        double[][] dArray3 = this.initB(dArray, ++n2);
        double[][] dArray4 = this.initA(dArray, n2, dArray3);
        double[] dArray5 = new double[n2];
        double[] dArray6 = new double[n2];
        this.val = new double[n2];
        for (n4 = 0; n4 < n2; ++n4) {
            d2 = 0.0;
            for (n3 = 0; n3 < dArray.length; ++n3) {
                d2 += dArray2[n3] * dArray3[n4][n3];
            }
            dArray5[n4] = d2;
        }
        dArray6[0] = dArray5[0];
        for (n4 = 1; n4 < n2; ++n4) {
            d2 = 0.0;
            for (n3 = 0; n3 < n4; ++n3) {
                d2 += dArray4[n4][n3] * dArray6[n3];
            }
            dArray6[n4] = dArray5[n4] - d2;
        }
        this.val[n2 - 1] = dArray6[n2 - 1] / dArray4[n2 - 1][n2 - 1];
        for (n4 = n2 - 2; n4 >= 0; --n4) {
            d2 = 0.0;
            for (n3 = n4 + 1; n3 < n2; ++n3) {
                d2 += dArray4[n4][n3] * this.val[n3];
            }
            this.val[n4] = (dArray6[n4] - d2) / dArray4[n4][n4];
        }
    }

    private void log(double[] dArray, double[] dArray2) {
        int n2 = 0;
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            if (!(dArray[i2] > 0.0)) continue;
            ++n2;
        }
        double[] dArray3 = new double[n2];
        double[] dArray4 = new double[n2];
        n2 = 0;
        for (int i3 = 0; i3 < dArray.length; ++i3) {
            if (!(dArray[i3] > 0.0)) continue;
            dArray3[n2] = Math.log(dArray[i3]);
            dArray4[n2] = dArray2[i3];
            ++n2;
        }
        this.linear(dArray3, dArray4);
    }

    private void exponent(double[] dArray, double[] dArray2) {
        int n2 = 0;
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            if (!(dArray2[i2] > 0.0)) continue;
            ++n2;
        }
        double[] dArray3 = new double[n2];
        double[] dArray4 = new double[n2];
        n2 = 0;
        for (int i3 = 0; i3 < dArray2.length; ++i3) {
            if (!(dArray2[i3] > 0.0)) continue;
            dArray3[n2] = dArray[i3];
            dArray4[n2] = Math.log(dArray2[i3]);
            ++n2;
        }
        this.linear(dArray3, dArray4);
        double d2 = this.val[0];
        this.val[0] = Math.exp(this.val[1]);
        this.val[1] = d2;
    }

    private void power(double[] dArray, double[] dArray2) {
        int n2 = 0;
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            if (!(dArray[i2] > 0.0) || !(dArray2[i2] > 0.0)) continue;
            ++n2;
        }
        double[] dArray3 = new double[n2];
        double[] dArray4 = new double[n2];
        n2 = 0;
        for (int i3 = 0; i3 < dArray.length; ++i3) {
            if (!(dArray[i3] > 0.0) || !(dArray2[i3] > 0.0)) continue;
            dArray3[n2] = Math.log(dArray[i3]);
            dArray4[n2] = Math.log(dArray2[i3]);
            ++n2;
        }
        this.linear(dArray3, dArray4);
        double d2 = this.val[0];
        this.val[0] = Math.exp(this.val[1]);
        this.val[1] = d2;
    }

    private void ma(double[] dArray, double[] dArray2) {
        GeneralPath generalPath = new GeneralPath();
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            int n2;
            double d2;
            if (i2 == 0) {
                generalPath.moveTo((float)dArray[i2], (float)dArray2[i2]);
                continue;
            }
            if (i2 < this.getAverage()) {
                d2 = 0.0;
                for (n2 = 0; n2 < i2 + 1; ++n2) {
                    d2 += dArray2[n2];
                }
                generalPath.lineTo((float)dArray[i2], (float)d2 / (float)(i2 + 1));
                continue;
            }
            d2 = 0.0;
            for (n2 = 0; n2 < this.getAverage(); ++n2) {
                d2 += dArray2[i2 - n2];
            }
            generalPath.lineTo((float)dArray[i2], (float)d2 / (float)this.getAverage());
        }
        GeneralPath generalPath2 = new GeneralPath();
        ChartUtils.curveTo(generalPath2, generalPath);
        this.setGeneralPath(generalPath2);
    }

    private double linearFunc(double d2) {
        return this.val[0] * d2 + this.val[1];
    }

    private double polynomialFunc(double d2) {
        double d3 = 0.0;
        for (int i2 = 0; i2 < this.val.length; ++i2) {
            d3 += this.val[i2] * Math.pow(d2, i2);
        }
        return d3;
    }

    private double logFunc(double d2) {
        if (d2 <= 0.0) {
            return Double.NaN;
        }
        return this.val[0] * Math.log(d2) + this.val[1];
    }

    private double exponentFunc(double d2) {
        return this.val[0] * Math.exp(d2 * this.val[1]);
    }

    private double powerFunc(double d2) {
        return this.val[0] * Math.pow(d2, this.val[1]);
    }

    public String toString() {
        if (this.equation == 0) {
            if (this.val[1] < 0.0) {
                return this.val[0] + " * x - " + -this.val[1];
            }
            return this.val[0] + " * x + " + this.val[1];
        }
        if (this.equation == 1) {
            String string;
            String string2;
            if (this.val[0] < 0.0) {
                string2 = -this.val[0] + "";
                string = "-";
            } else {
                string2 = this.val[0] + "";
                string = "+";
            }
            for (int i2 = 1; i2 < this.val.length; ++i2) {
                string2 = " * POWER(x, " + i2 + ") " + string + " " + string2;
                if (this.val[i2] < 0.0) {
                    string2 = -this.val[i2] + string2;
                    string = "-";
                    continue;
                }
                string2 = this.val[i2] + string2;
                string = "+";
            }
            return string2;
        }
        if (this.equation == 2) {
            if (this.val[1] < 0.0) {
                return this.val[0] + " * LN(x) - " + -this.val[1];
            }
            return this.val[0] + " * LN(x) + " + this.val[1];
        }
        if (this.equation == 3) {
            return this.val[0] + " * EXP(" + this.val[1] + " * x)";
        }
        if (this.equation == 4) {
            return this.val[0] + " * POWER(x, " + this.val[1] + ")";
        }
        return "";
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        jSONObject.put("equation", this.equation);
        jSONObject.put("square", this.square);
        jSONObject.put("average", this.getAverage());
        return jSONObject;
    }
}

