/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.FRContext;
import com.fr.chart.base.AttrContents;
import com.fr.chart.base.AttrFillStyle;
import com.fr.chart.base.AttrTrendLine;
import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.base.ConditionTrendLine;
import com.fr.chart.base.LineStyleInfo;
import com.fr.chart.base.TrendLine;
import com.fr.chart.chartglyph.AxisGlyph;
import com.fr.chart.chartglyph.ConditionCollection;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.DataSheet;
import com.fr.chart.chartglyph.DataSheetGlyph;
import com.fr.chart.chartglyph.LegendItem;
import com.fr.chart.chartglyph.RectangleGlyph;
import com.fr.chart.chartglyph.TextGlyph;
import com.fr.chart.chartglyph.TrendLineGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.js.NameJavaScriptGroup;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.StringUtils;
import com.fr.stable.core.IteratorChain;
import com.fr.stable.web.Repository;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PlotGlyph
extends RectangleGlyph {
    protected static final double RESET_JAVA_FONT_X = 3.0;
    private static final long serialVersionUID = -2464599809725765353L;
    private static final int MAX_LABEL_NUM = 50;
    private static final double OUT_BOUNDS = -3.0;
    protected List seriesList = new ArrayList();
    private ConditionCollection conditionCollection = new ConditionCollection();
    private NameJavaScriptGroup hotHyperLink;
    private AttrContents hotTooltipStyle = null;
    private boolean isNullValueBreak;
    private AttrFillStyle plotFillStyle = null;
    protected int plotStyle = 0;
    private int autoRefreshPerSecond = 0;
    private boolean seriesDragEnable = false;

    public void addSeries(DataSeries dataSeries) {
        this.seriesList.add(dataSeries);
    }

    public int getSeriesSize() {
        return this.seriesList == null ? 0 : this.seriesList.size();
    }

    public DataSeries getSeries(int n2) {
        return n2 > -1 && n2 < this.getSeriesSize() ? (DataSeries)this.seriesList.get(n2) : new DataSeries();
    }

    public int getCategoryCount() {
        return this.getSeries(0) == null ? 0 : this.getSeries(0).getDataPointCount();
    }

    @Override
    public Iterator selectableChildren() {
        ArrayList<TextGlyph> arrayList = new ArrayList<TextGlyph>();
        this.getAllDataPointGlyph(arrayList);
        ArrayList<TrendLineGlyph> arrayList2 = new ArrayList<TrendLineGlyph>();
        this.getAllTrendLineGlyph(arrayList2);
        ArrayList arrayList3 = new ArrayList();
        if (!arrayList.isEmpty()) {
            arrayList3.add(arrayList.iterator());
        }
        if (!arrayList2.isEmpty()) {
            arrayList3.add(arrayList2.iterator());
        }
        arrayList3.add(this.seriesList.iterator());
        return new IteratorChain(arrayList3.toArray(new Iterator[0]));
    }

    public void getAllDataPointGlyph(List<TextGlyph> list) {
        for (int i2 = 0; i2 < this.getSeriesSize(); ++i2) {
            DataSeries dataSeries = (DataSeries)this.seriesList.get(i2);
            for (int i3 = 0; i3 < dataSeries.getDataPointCount(); ++i3) {
                list.add(dataSeries.getDataPoint(i3).getDataLabel());
            }
        }
    }

    public void getAllTrendLineGlyph(List<TrendLineGlyph> list) {
        for (int i2 = 0; i2 < this.getSeriesSize(); ++i2) {
            DataSeries dataSeries = (DataSeries)this.seriesList.get(i2);
            for (int i3 = 0; i3 < dataSeries.getTrendLineGlyphSize(); ++i3) {
                list.add(dataSeries.getTrendLineGlyph(i3));
            }
        }
    }

    public void setHotHyperLink(NameJavaScriptGroup nameJavaScriptGroup) {
        this.hotHyperLink = nameJavaScriptGroup;
    }

    public NameJavaScriptGroup getHotHyperLink() {
        return this.hotHyperLink;
    }

    public void setPlotStyle(int n2) {
        this.plotStyle = n2;
    }

    public int getPlotStyle() {
        return this.plotStyle;
    }

    public void setPlotFillStyle(AttrFillStyle attrFillStyle) {
        this.plotFillStyle = attrFillStyle;
    }

    public AttrFillStyle getPlotFillStyle() {
        return this.plotFillStyle;
    }

    public void setHotTooltipStyle(AttrContents attrContents) {
        this.hotTooltipStyle = attrContents;
    }

    public AttrContents getHotTooltipStyle() {
        return this.hotTooltipStyle;
    }

    public void setIsNullValueBreak(boolean bl) {
        this.isNullValueBreak = bl;
    }

    public boolean isNullValueBreak() {
        return this.isNullValueBreak;
    }

    public void setAutoRefreshPerSecond(int n2) {
        this.autoRefreshPerSecond = n2;
    }

    public int getAutoRefreshPerSecond() {
        return this.autoRefreshPerSecond;
    }

    public void setSeriesDragEnable(boolean bl) {
        this.seriesDragEnable = bl;
    }

    public boolean isSeriesDragEnable() {
        return this.seriesDragEnable;
    }

    public void setConditionCollection(ConditionCollection conditionCollection) {
        this.conditionCollection = conditionCollection;
    }

    public ConditionCollection getConditionCollection() {
        return this.conditionCollection;
    }

    public int[] getDrawSequence() {
        int[] nArray = new int[this.getSeriesSize()];
        for (int i2 = 0; i2 < this.getSeriesSize(); ++i2) {
            nArray[i2] = i2;
        }
        return nArray;
    }

    public void doLayout(DataSheetGlyph dataSheetGlyph) {
    }

    public DataSheetGlyph createDataSheetGlyph(DataSheet dataSheet, LegendItem[] legendItemArray) {
        return null;
    }

    public Color[] createColors4Series() {
        return ChartBaseUtils.createFillColorArray(this.getPlotFillStyle(), this.getSeriesSize());
    }

    public Color[] createColors4Cate() {
        return ChartBaseUtils.createFillColorArray(this.getPlotFillStyle(), this.getCategoryCount());
    }

    public double getPreGap4AxisTopUnit() {
        return 0.0;
    }

    public double getPreGap4AxisRightUnit() {
        return 0.0;
    }

    public double getPreLeft4DataSheet(int n2) {
        return 0.0;
    }

    protected void dealLabelBoundsInOrder() {
        List list = this.calculateOrderList();
        if (list.size() <= 0) {
            return;
        }
        List list2 = this.dealDataPointOrder(list);
        this.calculateDataPointLabelBounds(list2);
    }

    private List calculateOrderList() {
        int n2;
        ArrayList<DataPoint> arrayList = new ArrayList<DataPoint>();
        for (n2 = 0; n2 < this.getSeriesSize(); ++n2) {
            for (int i2 = 0; i2 < this.getCategoryCount(); ++i2) {
                DataPoint dataPoint;
                DataSeries dataSeries = this.getSeries(n2);
                if (dataSeries == null || (dataPoint = dataSeries.getDataPoint(i2)).getDataLabel() == null || dataPoint.getDataLabel().getBounds() == null) continue;
                arrayList.add(dataPoint);
            }
        }
        n2 = 50;
        if (arrayList.size() > n2) {
            ArrayList arrayList2 = new ArrayList();
            int n3 = arrayList.size() / n2;
            for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                if (i3 % n3 == 0) {
                    arrayList2.add(arrayList.get(i3));
                    continue;
                }
                DataPoint dataPoint = (DataPoint)arrayList.get(i3);
                dataPoint.getDataLabel().setBounds(null);
            }
            return arrayList2;
        }
        return arrayList;
    }

    private void reAddLabelPath(GeneralPath generalPath, List list, int n2) {
        generalPath.reset();
        for (int i2 = 0; i2 < n2; ++i2) {
            DataPoint dataPoint = (DataPoint)list.get(i2);
            if (dataPoint == null || dataPoint.getDataLabel() == null || dataPoint.getDataLabel().getBounds() == null) continue;
            generalPath.append(dataPoint.getDataLabel().getBounds(), false);
        }
    }

    private void calculateDataPointLabelBounds(List list) {
        Rectangle2D rectangle2D;
        DataPoint dataPoint;
        int n2;
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, this.getBounds().getWidth(), this.getBounds().getHeight());
        GeneralPath generalPath = new GeneralPath();
        int n3 = list.size();
        for (n2 = 0; n2 < n3; ++n2) {
            dataPoint = (DataPoint)list.get(n2);
            if (dataPoint.getDataLabel() == null) continue;
            rectangle2D = dataPoint.getDataLabel().getBounds();
            if ((rectangle2D = this.avoidCoverLabelBounds(generalPath, rectangle2D)) == null) {
                dataPoint.getDataLabel().setBounds(rectangle2D);
                continue;
            }
            if (double_.contains(rectangle2D)) {
                dataPoint.getDataLabel().setBounds(rectangle2D);
                continue;
            }
            this.reduceY(rectangle2D, double_, list, n2, generalPath);
            this.increaseX(rectangle2D, double_, list, n2, generalPath);
            this.reduceX(rectangle2D, double_, list, n2, generalPath);
            this.increaseY(rectangle2D, double_, list, n2, generalPath);
            if (this.isBoundsInPath(generalPath, rectangle2D, double_)) {
                generalPath.append(rectangle2D, false);
                dataPoint.getDataLabel().setBounds(rectangle2D);
                continue;
            }
            dataPoint.getDataLabel().setBounds(null);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            dataPoint = (DataPoint)list.get(n2);
            if (dataPoint.getDataLabel() == null || (rectangle2D = dataPoint.getDataLabel().getBounds()) != null && !(rectangle2D.getX() < -3.0) && !(rectangle2D.getY() < -3.0)) continue;
            dataPoint.getDataLabel().setBounds(null);
        }
    }

    private boolean isBoundsInPath(GeneralPath generalPath, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        return !generalPath.intersects(rectangle2D) && rectangle2D2.contains(rectangle2D) && !generalPath.contains(rectangle2D);
    }

    private void reduceY(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, List list, int n2, GeneralPath generalPath) {
        while (rectangle2D.getY() + rectangle2D.getHeight() > rectangle2D2.getY() + rectangle2D2.getHeight()) {
            rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY() - 1.0, rectangle2D.getWidth(), rectangle2D.getHeight());
        }
        this.dealBoundsIntersects(list, n2, generalPath, rectangle2D, 0.0, -1.0);
        this.reAddLabelPath(generalPath, list, n2);
    }

    private void increaseX(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, List list, int n2, GeneralPath generalPath) {
        while (rectangle2D.getX() < rectangle2D2.getX()) {
            rectangle2D.setRect(rectangle2D.getX() + 1.0, rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        }
        this.dealBoundsIntersects(list, n2, generalPath, rectangle2D, 1.0, 0.0);
        this.reAddLabelPath(generalPath, list, n2);
    }

    private void reduceX(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, List list, int n2, GeneralPath generalPath) {
        while (rectangle2D.getX() + rectangle2D.getWidth() > rectangle2D2.getX() + rectangle2D2.getWidth()) {
            rectangle2D.setRect(rectangle2D.getX() - 1.0, rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        }
        this.dealBoundsIntersects(list, n2, generalPath, rectangle2D, -1.0, 0.0);
        this.reAddLabelPath(generalPath, list, n2);
    }

    private void increaseY(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, List list, int n2, GeneralPath generalPath) {
        while (rectangle2D.getY() < rectangle2D2.getY()) {
            rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY() + 1.0, rectangle2D.getWidth(), rectangle2D.getHeight());
        }
        this.dealBoundsIntersects(list, n2, generalPath, rectangle2D, 0.0, 1.0);
        this.reAddLabelPath(generalPath, list, n2);
    }

    private void dealBoundsIntersects(List list, int n2, GeneralPath generalPath, Rectangle2D rectangle2D, double d2, double d3) {
        ArrayList<DataPoint> arrayList = new ArrayList<DataPoint>();
        if (n2 <= 0) {
            return;
        }
        int n3 = 1;
        while (generalPath.intersects(rectangle2D) && n2 - n3 >= 0) {
            DataPoint dataPoint = (DataPoint)list.get(n2 - n3);
            if (++n3 > list.size()) break;
            if (dataPoint == null || dataPoint.getDataLabel() == null) continue;
            if (this.isLabelIntersectWithDataPointLabel(dataPoint, rectangle2D, d2, d3)) {
                arrayList.add(dataPoint);
            }
            this.reAddLabelPath(generalPath, list, n2);
            this.dealOverlapping(arrayList, list, generalPath, d2, d3);
        }
    }

    private void dealOverlapping(List list, List list2, GeneralPath generalPath, double d2, double d3) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            DataPoint dataPoint = (DataPoint)list.get(i2);
            Rectangle2D rectangle2D = dataPoint.getDataLabel().getBounds();
            for (int i3 = 0; i3 < list2.size(); ++i3) {
                if (!ComparatorUtils.equals(list2.get(i3), dataPoint)) continue;
                this.dealBoundsIntersects(list2, i3, generalPath, rectangle2D, d2, d3);
            }
        }
    }

    protected boolean isDataPointXNotInPlotBounds(float f2) {
        Rectangle2D rectangle2D = this.getBounds();
        return f2 < -1.0f || (double)f2 > rectangle2D.getWidth() + 1.0;
    }

    public boolean isNeedDealHotHyperlink() {
        PlotGlyph plotGlyph = this;
        return plotGlyph.getHotHyperLink() != null || plotGlyph.getHotTooltipStyle() != null && StringUtils.isNotEmpty(plotGlyph.getHotTooltipStyle().getSeriesLabel());
    }

    public void dealPlotHotAttr(Repository repository) {
        PlotGlyph plotGlyph = this;
        if (plotGlyph.getHotHyperLink() != null) {
            int n2 = plotGlyph.getSeriesSize();
            for (int i2 = 0; i2 < n2; ++i2) {
                DataSeries dataSeries = plotGlyph.getSeries(i2);
                for (int i3 = 0; i3 < dataSeries.getDataPointCount(); ++i3) {
                    DataPoint dataPoint = dataSeries.getDataPoint(i3);
                    if (dataPoint.isValueIsNull()) continue;
                    dataPoint.createDataPointHotHyperLink(plotGlyph.getHotHyperLink(), repository);
                }
            }
        }
    }

    private boolean isLabelIntersectWithDataPointLabel(DataPoint dataPoint, Rectangle2D rectangle2D, double d2, double d3) {
        Rectangle2D rectangle2D2 = dataPoint.getDataLabel().getBounds();
        boolean bl = false;
        if (rectangle2D2 != null && rectangle2D.intersects(rectangle2D2)) {
            bl = true;
        }
        while (rectangle2D2 != null && rectangle2D.intersects(rectangle2D2)) {
            rectangle2D2.setRect(rectangle2D2.getX() + d2, rectangle2D2.getY() + d3, rectangle2D2.getWidth(), rectangle2D2.getHeight());
            dataPoint.getDataLabel().setBounds(rectangle2D2);
        }
        return bl;
    }

    private List dealDataPointOrder(List list) {
        ArrayList<DataPoint> arrayList = new ArrayList<DataPoint>();
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            DataPoint dataPoint = (DataPoint)list.get(0);
            for (int i3 = 0; i3 < list.size(); ++i3) {
                DataPoint dataPoint2 = (DataPoint)list.get(i3);
                if (dataPoint2.getDataLabel() == null || dataPoint2.getDataLabel().getBounds() == null) continue;
                Rectangle2D rectangle2D = dataPoint2.getDataLabel().getBounds();
                if (dataPoint.getDataLabel() == null || dataPoint.getDataLabel().getBounds() == null) continue;
                Rectangle2D rectangle2D2 = dataPoint.getDataLabel().getBounds();
                double d2 = rectangle2D2.getX();
                double d3 = rectangle2D2.getY();
                double d4 = rectangle2D.getX();
                double d5 = rectangle2D.getY();
                if (d5 < d3) {
                    dataPoint = dataPoint2;
                    continue;
                }
                if (d3 != d5 || !(d2 > d4)) continue;
                dataPoint = dataPoint2;
            }
            list.remove(dataPoint);
            arrayList.add(dataPoint);
        }
        return arrayList;
    }

    private boolean checkLeftTop(GeneralPath generalPath, Rectangle2D rectangle2D) {
        return generalPath.intersects(rectangle2D) || generalPath.contains(rectangle2D);
    }

    private boolean checkRightTop(GeneralPath generalPath, Rectangle2D rectangle2D) {
        return generalPath.intersects(rectangle2D) || generalPath.contains(rectangle2D);
    }

    private boolean checkLeftBottom(GeneralPath generalPath, Rectangle2D rectangle2D) {
        return generalPath.intersects(rectangle2D) || generalPath.contains(rectangle2D);
    }

    private boolean checkRightBottom(GeneralPath generalPath, Rectangle2D rectangle2D) {
        return generalPath.intersects(rectangle2D) || generalPath.contains(rectangle2D);
    }

    protected Rectangle2D avoidCoverLabelBounds(GeneralPath generalPath, Rectangle2D rectangle2D) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        if (rectangle2D == null) {
            return null;
        }
        double d2 = rectangle2D.getX();
        double d3 = rectangle2D.getY();
        double d4 = rectangle2D.getWidth();
        double d5 = rectangle2D.getHeight();
        boolean bl4 = this.checkLeftTop(generalPath, new Rectangle2D.Double(d2, d3, 1.0, 1.0));
        if (this.withoutAnyCorner(bl4, bl3 = this.checkRightTop(generalPath, new Rectangle2D.Double(d2 + d4 - 1.0, d3, 1.0, 1.0)), bl2 = this.checkLeftBottom(generalPath, new Rectangle2D.Double(d2, d3 + d5 - 1.0, 1.0, 1.0)), bl = this.checkRightBottom(generalPath, new Rectangle2D.Double(d2 + d4 - 1.0, d3 + d5 - 1.0, 1.0, 1.0)))) {
            if (generalPath.intersects(rectangle2D) || generalPath.contains(rectangle2D)) {
                this.whileTmp(generalPath, rectangle2D, 0.0, 1.0, d5);
            } else {
                Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth() + 2.0, rectangle2D.getHeight());
                generalPath.append(double_, false);
                return double_;
            }
        }
        if (this.withoutLeftTopCorner(bl4, bl3, bl2, bl)) {
            this.whileTmp(generalPath, rectangle2D, -1.0, -1.0, d4);
        } else if (this.withoutRightTopCorner(bl4, bl3, bl2, bl)) {
            this.whileTmp(generalPath, rectangle2D, 1.0, -1.0, d4);
        } else if (this.withoutLeftBottomCorner(bl4, bl3, bl2, bl)) {
            this.whileTmp(generalPath, rectangle2D, -1.0, 1.0, d4);
        } else if (this.withoutRightBottomCorner(bl4, bl3, bl2, bl)) {
            this.whileTmp(generalPath, rectangle2D, 1.0, 1.0, d4);
        } else if (this.withLeftAndRightBottom(bl4, bl3, bl2, bl)) {
            this.whileTmp(generalPath, rectangle2D, 0.0, -1.0, d5);
        } else if (this.withLeftBottomAndTop(bl4, bl3, bl2, bl)) {
            this.whileTmp(generalPath, rectangle2D, 1.0, 0.0, d4);
        } else if (this.withAllCorner(bl4, bl3, bl2, bl) || this.withLeftAndRightTop(bl4, bl3, bl2, bl)) {
            this.whileTmp(generalPath, rectangle2D, 0.0, 1.0, d5);
        } else if (this.withRightBottomAndTop(bl4, bl3, bl2, bl)) {
            this.whileTmp(generalPath, rectangle2D, -1.0, 0.0, d4);
        } else if (this.withLeftTopOnly(bl4, bl3, bl2, bl)) {
            this.whileTmp(generalPath, rectangle2D, 1.0, 0.0, d4);
            if (generalPath.intersects(rectangle2D)) {
                rectangle2D = new Rectangle2D.Double(d2, d3, d4, d5);
            }
            this.whileTmp(generalPath, rectangle2D, 0.0, 1.0, d5);
            if (generalPath.intersects(rectangle2D)) {
                rectangle2D = new Rectangle2D.Double(d2, d3, d4, d5);
            }
            this.whileTmp(generalPath, rectangle2D, 1.0, 1.0, d4);
        } else if (this.withRightTopOnly(bl4, bl3, bl2, bl)) {
            this.whileTmp(generalPath, rectangle2D, -1.0, 0.0, d4);
            if (generalPath.intersects(rectangle2D)) {
                rectangle2D = new Rectangle2D.Double(d2, d3, d4, d5);
            }
            this.whileTmp(generalPath, rectangle2D, 0.0, 1.0, d5);
            if (generalPath.intersects(rectangle2D)) {
                rectangle2D = new Rectangle2D.Double(d2, d3, d4, d5);
            }
            this.whileTmp(generalPath, rectangle2D, -1.0, 1.0, d4);
        } else if (this.withLeftBottomOnly(bl4, bl3, bl2, bl)) {
            this.whileTmp(generalPath, rectangle2D, 0.0, -1.0, d5);
            if (generalPath.intersects(rectangle2D)) {
                rectangle2D = new Rectangle2D.Double(d2, d3, d4, d5);
            }
            this.whileTmp(generalPath, rectangle2D, 1.0, 0.0, d4);
            if (generalPath.intersects(rectangle2D)) {
                rectangle2D = new Rectangle2D.Double(d2, d3, d4, d5);
            }
            this.whileTmp(generalPath, rectangle2D, 1.0, -1.0, d4);
        } else if (this.withRightBottomOnly(bl4, bl3, bl2, bl)) {
            this.whileTmp(generalPath, rectangle2D, -1.0, 0.0, d4);
            if (generalPath.intersects(rectangle2D)) {
                rectangle2D = new Rectangle2D.Double(d2, d3, d4, d5);
            }
            this.whileTmp(generalPath, rectangle2D, 0.0, -1.0, d5);
            if (generalPath.intersects(rectangle2D)) {
                rectangle2D = new Rectangle2D.Double(d2, d3, d4, d5);
            }
            this.whileTmp(generalPath, rectangle2D, -1.0, -1.0, d4);
        } else if (this.withLeftTopRightBottom(bl4, bl3, bl2, bl)) {
            this.whileTmp(generalPath, rectangle2D, -1.0, 1.0, d4);
            if (generalPath.intersects(rectangle2D)) {
                rectangle2D = new Rectangle2D.Double(d2, d3, d4, d5);
            }
            this.whileTmp(generalPath, rectangle2D, 1.0, -1.0, d4);
        } else if (this.withLeftBottomRightTop(bl4, bl3, bl2, bl)) {
            this.whileTmp(generalPath, rectangle2D, -1.0, -1.0, d4);
            if (generalPath.intersects(rectangle2D)) {
                rectangle2D = new Rectangle2D.Double(d2, d3, d4, d5);
            }
            this.whileTmp(generalPath, rectangle2D, 1.0, 1.0, d4);
        }
        if (!generalPath.intersects(rectangle2D) && !generalPath.contains(rectangle2D)) {
            Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth() + 2.0, rectangle2D.getHeight());
            generalPath.append(double_, false);
            return double_;
        }
        return null;
    }

    private void whileTmp(GeneralPath generalPath, Rectangle2D rectangle2D, double d2, double d3, double d4) {
        double d5 = 0.0;
        while (generalPath.intersects(rectangle2D)) {
            rectangle2D.setRect(rectangle2D.getX() + d2, rectangle2D.getY() + d3, rectangle2D.getWidth(), rectangle2D.getHeight());
            if (!((d5 += 1.0) > d4)) continue;
            break;
        }
    }

    @Override
    public void draw(Graphics graphics, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Shape shape = graphics2D.getClip();
        this.resetClip(graphics2D);
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        this.drawShape4Series(graphics, n2);
        this.drawLabel4Series(graphics, n2);
        this.drawTendLine(graphics, n2);
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
        graphics2D.setClip(shape);
    }

    protected void resetClip(Graphics2D graphics2D) {
        double d2 = 2.0;
        Rectangle2D.Double double_ = null;
        if (this.getBounds() != null) {
            Rectangle2D rectangle2D = this.getBounds();
            double d3 = Math.min(rectangle2D.getX(), rectangle2D.getX() + rectangle2D.getWidth()) - d2 / 2.0;
            double d4 = Math.min(rectangle2D.getY(), rectangle2D.getY() + rectangle2D.getHeight()) - d2 / 2.0;
            double d5 = Math.abs(rectangle2D.getWidth()) + d2 * 2.0;
            double d6 = Math.abs(rectangle2D.getHeight()) + d2 * 2.0;
            double_ = new Rectangle2D.Double(d3, d4, d5, d6);
        }
        graphics2D.clip(double_);
    }

    public void drawShape4Series(Graphics graphics, int n2) {
        int n3;
        int[] nArray = this.getDrawSequence();
        int n4 = this.getSeriesSize();
        for (n3 = 0; n3 < n4; ++n3) {
            this.getSeries(nArray[n3]).draw(graphics, n2);
        }
        n4 = this.getSeriesSize();
        for (n3 = 0; n3 < n4; ++n3) {
            this.getSeries(nArray[n3]).drawChartStyle(graphics);
        }
    }

    protected void drawLabel4Series(Graphics graphics, int n2) {
        int n3 = this.getSeriesSize();
        for (int i2 = 0; i2 < n3; ++i2) {
            this.getSeries(i2).drawLabel(graphics, n2);
        }
    }

    private void drawTendLine(Graphics graphics, int n2) {
        int n3 = this.getSeriesSize();
        for (int i2 = 0; i2 < n3; ++i2) {
            this.getSeries(i2).drawTrendLine(graphics, n2);
        }
    }

    public void drawInfo(Graphics graphics) {
        this.paint(graphics);
    }

    public abstract void layoutAxisGlyph(int var1);

    public abstract void layoutDataSeriesGlyph(int var1);

    protected void dealDataPointLabel(DataPoint dataPoint, int n2) {
        TextGlyph textGlyph = dataPoint.getDataLabel();
        if (textGlyph == null) {
            return;
        }
        if (this.notDealDataPointLabel(dataPoint, textGlyph)) {
            textGlyph.setBounds(null);
        } else {
            Dimension2D dimension2D = textGlyph.preferredDimension(n2);
            Rectangle2D rectangle2D = dataPoint.getShape().getBounds2D();
            AttrContents attrContents = (AttrContents)this.getConditionCollection().getDataSeriesCondition(AttrContents.class, dataPoint, null);
            int n3 = attrContents.getPosition();
            Rectangle2D rectangle2D2 = this.getDataPointLabelBoundsWithPosition(dimension2D, rectangle2D, n3);
            textGlyph.setBounds(rectangle2D2);
        }
    }

    private boolean notDealDataPointLabel(DataPoint dataPoint, TextGlyph textGlyph) {
        return dataPoint.getShape() == null || dataPoint.getShape().getBounds() == null || StringUtils.isBlank(textGlyph.getText());
    }

    protected Rectangle2D getDataPointLabelBoundsWithPosition(Dimension2D dimension2D, Rectangle2D rectangle2D, int n2) {
        return null;
    }

    protected Rectangle2D getDataPointLabelBoundsWithPosition4Line(Dimension2D dimension2D, Rectangle2D rectangle2D, int n2) {
        double d2 = 2.0;
        double d3 = rectangle2D.getX() + (rectangle2D.getWidth() - dimension2D.getWidth()) / 2.0;
        double d4 = rectangle2D.getY() - dimension2D.getHeight() - d2;
        return new Rectangle2D.Double(d3, d4, dimension2D.getWidth(), dimension2D.getHeight());
    }

    public void axisExtendsMaxMinValueWithTrendLine(AxisGlyph axisGlyph) {
        int n2 = 0;
        int n3 = 0;
        int n4 = this.getSeriesSize();
        for (int i2 = 0; i2 < n4; ++i2) {
            AttrTrendLine attrTrendLine = (AttrTrendLine)this.getConditionCollection().getDataSeriesCondition(AttrTrendLine.class, this.getSeries(i2), null);
            if (attrTrendLine == null) continue;
            for (int i3 = 0; i3 < attrTrendLine.size(); ++i3) {
                ConditionTrendLine conditionTrendLine = attrTrendLine.get(i3);
                if (conditionTrendLine.getBackward() > n2) {
                    n2 = conditionTrendLine.getBackward();
                }
                if (conditionTrendLine.getForward() <= n3) continue;
                n3 = conditionTrendLine.getForward();
            }
        }
        axisGlyph.setMaxValue(axisGlyph.getMaxValue() + (double)n2);
        axisGlyph.setMinValue(axisGlyph.getMinValue() - (double)n3);
    }

    protected void trendLineFitting(double[] dArray, double[] dArray2, DataSeries dataSeries) {
        dataSeries.clearTrendLineGlyph();
        AttrTrendLine attrTrendLine = (AttrTrendLine)this.getConditionCollection().getDataSeriesCondition(AttrTrendLine.class, dataSeries, null);
        if (attrTrendLine != null) {
            for (int i2 = 0; i2 < attrTrendLine.size(); ++i2) {
                ConditionTrendLine conditionTrendLine = attrTrendLine.get(i2);
                if (conditionTrendLine.getLine() == null) continue;
                TrendLine trendLine = conditionTrendLine.getLine();
                TrendLineGlyph trendLineGlyph = new TrendLineGlyph();
                trendLineGlyph.setEquation(trendLine.getEquation());
                trendLineGlyph.setSquare(trendLine.getSquare());
                trendLineGlyph.setAverage(trendLine.getMoveAverage());
                try {
                    trendLineGlyph.setLineStyleInfo((LineStyleInfo)trendLine.getLineStyleInfo().clone());
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    FRContext.getLogger().error(cloneNotSupportedException.getMessage(), cloneNotSupportedException);
                }
                trendLineGlyph.fitting(dArray, dArray2);
                trendLineGlyph.drawShape(new Rectangle2D.Double(0.0, 0.0, this.getBounds().getWidth(), this.getBounds().getHeight()));
                dataSeries.addTrendLineGlyph(trendLineGlyph);
            }
        }
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof PlotGlyph && super.equals(object) && ComparatorUtils.equals(((PlotGlyph)object).seriesList, this.seriesList) && ComparatorUtils.equals(((PlotGlyph)object).conditionCollection, this.conditionCollection) && ComparatorUtils.equals(((PlotGlyph)object).hotHyperLink, this.hotHyperLink) && ((PlotGlyph)object).isNullValueBreak == this.isNullValueBreak && ((PlotGlyph)object).seriesDragEnable == this.seriesDragEnable && ((PlotGlyph)object).autoRefreshPerSecond == this.autoRefreshPerSecond;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        PlotGlyph plotGlyph = (PlotGlyph)super.clone();
        if (this.conditionCollection != null) {
            plotGlyph.conditionCollection = (ConditionCollection)this.conditionCollection.clone();
        }
        if (this.seriesList != null) {
            plotGlyph.seriesList = new ArrayList();
            for (int i2 = 0; i2 < this.seriesList.size(); ++i2) {
                plotGlyph.seriesList.add(((DataSeries)this.seriesList.get(i2)).clone());
            }
        }
        if (this.hotHyperLink != null) {
            plotGlyph.hotHyperLink = (NameJavaScriptGroup)this.hotHyperLink.clone();
        }
        return plotGlyph;
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        return this.toJSONObject();
    }

    @Override
    public JSONObject toJSONObject() throws JSONException {
        Object[] objectArray;
        JSONObject jSONObject = super.toJSONObject();
        if (this.conditionCollection != null) {
            objectArray = this.seriesList.toArray(new DataSeries[this.seriesList.size()]);
            jSONObject.put("conditionCollection", this.conditionCollection.toJSONObject((DataSeries[])objectArray));
        }
        if (this.seriesList != null && this.seriesList.size() > 0) {
            objectArray = this.seriesList.toArray();
            Object[] objectArray2 = new Object[objectArray.length];
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                objectArray2[i2] = ((DataSeries)objectArray[i2]).toJSONObject();
            }
            jSONObject.put("seriesList", objectArray2);
        }
        if (this.hotHyperLink != null) {
            // empty if block
        }
        if (this.hotTooltipStyle != null) {
            jSONObject.put("hotTooltipStyle", this.hotTooltipStyle.toJSONObject());
        }
        if (this.plotFillStyle != null) {
            jSONObject.put("plotFillStyle", this.plotFillStyle.toJSONObject());
        }
        jSONObject.put("plotStyle", this.plotStyle);
        jSONObject.put("isNullValueBreak", this.isNullValueBreak);
        return jSONObject;
    }

    public abstract String getPlotGlyphType();

    private boolean withoutAnyCorner(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return !bl && !bl2 && !bl3 && !bl4;
    }

    private boolean withoutLeftTopCorner(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return !bl && bl2 && bl3 && bl4;
    }

    private boolean withoutRightTopCorner(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return bl && !bl2 && bl3 && bl4;
    }

    private boolean withoutLeftBottomCorner(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return bl && bl2 && !bl3 && bl4;
    }

    private boolean withoutRightBottomCorner(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return bl && bl2 && bl3 && !bl4;
    }

    private boolean withLeftAndRightBottom(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return !bl && !bl2 && bl3 && bl4;
    }

    private boolean withLeftBottomAndTop(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return bl && !bl2 && bl3 && !bl4;
    }

    private boolean withAllCorner(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return bl && bl2 && bl3 && bl4;
    }

    private boolean withLeftAndRightTop(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return bl && bl2 && !bl3 && !bl4;
    }

    private boolean withRightBottomAndTop(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return !bl && bl2 && !bl3 && bl4;
    }

    private boolean withLeftTopOnly(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return bl && !bl2 && !bl3 && !bl4;
    }

    private boolean withRightTopOnly(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return !bl && bl2 && !bl3 && !bl4;
    }

    private boolean withLeftBottomOnly(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return !bl && !bl2 && bl3 && !bl4;
    }

    private boolean withRightBottomOnly(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return !bl && !bl2 && !bl3 && bl4;
    }

    private boolean withLeftTopRightBottom(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return bl && !bl2 && !bl3 && bl4;
    }

    private boolean withLeftBottomRightTop(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return !bl && bl2 && bl3 && !bl4;
    }
}

