/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.DoubleDimension2D;
import com.fr.chart.base.GlyphUtils;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.Meter;
import com.fr.chart.chartglyph.MeterStyle;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.chart.chartglyph.TextGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import java.awt.Graphics;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;

public class MeterPlotGlyph
extends PlotGlyph {
    private static final long serialVersionUID = -7720249461263542792L;
    public static final double GAP = 5.0;
    private MeterStyle meterStyle;

    public void layoutAxisGlyph(int n2) {
    }

    public void setMeterStyle(MeterStyle meterStyle) {
        this.meterStyle = meterStyle;
    }

    public MeterStyle getMeterStyle() {
        return this.meterStyle;
    }

    public void layoutDataSeriesGlyph(int n2) {
        Rectangle2D rectangle2D = this.getBounds();
        int n3 = this.getSeriesSize();
        int n4 = this.getCategoryCount();
        double d2 = 0.0;
        double d3 = 0.0;
        if (n3 > 1) {
            d3 = 5.0;
        }
        if (n4 > 1) {
            d2 = 5.0;
        }
        double d4 = (rectangle2D.getHeight() - (double)(n3 + 1) * d3) / (double)n3;
        double d5 = (rectangle2D.getWidth() - (double)(n4 + 1) * d2) / (double)n4;
        for (int i2 = 0; i2 < n3; ++i2) {
            DataSeries dataSeries = this.getSeries(i2);
            for (int i3 = 0; i3 < n4; ++i3) {
                DataPoint dataPoint = dataSeries.getDataPoint(i3);
                this.layoutDataPoint(dataPoint, d5, d4, i2, i3, n2);
            }
        }
    }

    private void layoutDataPoint(DataPoint dataPoint, double d2, double d3, int n2, int n3, int n4) {
        int n5 = this.getSeriesSize();
        int n6 = this.getCategoryCount();
        double d4 = 0.0;
        double d5 = 0.0;
        if (n5 > 1) {
            d5 = 5.0;
        }
        if (n6 > 1) {
            d4 = 5.0;
        }
        String string = dataPoint.getCategoryName();
        TextGlyph textGlyph = new TextGlyph(string, this.getMeterStyle().getTitleTextAttr());
        Meter meter = new Meter(textGlyph, dataPoint.getValue(), this.getMeterStyle());
        dataPoint.setDrawImpl(meter);
        Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation(string, this.getMeterStyle().getTitleTextAttr(), n4);
        meter.setBounds(new Rectangle2D.Double((double)n3 * d2 + (double)(n3 + 1) * d4, (double)n2 * d3 + (double)(n2 + 1) * d5 + dimension2D.getHeight(), d2, d3 - dimension2D.getHeight()));
        dataPoint.setDataLabel(null);
    }

    public void draw(Graphics graphics, int n2) {
        this.resetAllMeterLabelDim();
        this.drawInfo(graphics);
        super.draw(graphics, n2);
    }

    private void resetAllMeterLabelDim() {
        Meter meter;
        DataPoint dataPoint;
        int n2;
        DataSeries dataSeries;
        int n3;
        int n4 = this.getSeriesSize();
        int n5 = this.getCategoryCount();
        Dimension2D dimension2D = new DoubleDimension2D(0.0, 0.0);
        for (n3 = 0; n3 < n4; ++n3) {
            dataSeries = this.getSeries(n3);
            for (n2 = 0; n2 < n5; ++n2) {
                dataPoint = dataSeries.getDataPoint(n2);
                meter = (Meter)dataPoint.getDrawImpl();
                meter.resetBeforeDraw();
                Dimension2D dimension2D2 = meter.getTickLableDim();
                if (!(dimension2D2.getWidth() > ((Dimension2D)dimension2D).getWidth())) continue;
                dimension2D = dimension2D2;
            }
        }
        for (n3 = 0; n3 < n4; ++n3) {
            dataSeries = this.getSeries(n3);
            for (n2 = 0; n2 < n5; ++n2) {
                dataPoint = dataSeries.getDataPoint(n2);
                meter = (Meter)dataPoint.getDrawImpl();
                meter.setMaxLabelDim(dimension2D);
            }
        }
    }

    public boolean equals(Object object) {
        return object instanceof MeterPlotGlyph && super.equals(object) && ComparatorUtils.equals(((MeterPlotGlyph)object).meterStyle, this.meterStyle);
    }

    public Object clone() throws CloneNotSupportedException {
        MeterPlotGlyph meterPlotGlyph = (MeterPlotGlyph)super.clone();
        if (this.meterStyle != null) {
            meterPlotGlyph.meterStyle = (MeterStyle)this.meterStyle.clone();
        }
        return meterPlotGlyph;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        if (this.meterStyle != null) {
            jSONObject.put("meterStyleType", this.meterStyle.getMeterStyleType());
            jSONObject.put("meterStyle", this.meterStyle.toJSONObject());
        }
        return jSONObject;
    }

    public String getPlotGlyphType() {
        return "MeterPlotGlyph";
    }
}

