/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.Base64;
import com.fr.base.BaseUtils;
import com.fr.base.MapCacheAttr;
import com.fr.base.MapXMLHelper;
import com.fr.base.Utils;
import com.fr.base.background.ColorBackground;
import com.fr.base.chart.ColorSelect4Shape;
import com.fr.base.chart.Glyph;
import com.fr.chart.base.AttrBackground;
import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.base.DataSeriesCondition;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.MapAttr;
import com.fr.chart.chartglyph.MapHotAreaColor;
import com.fr.chart.chartglyph.MapShapeValue;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.chart.chartglyph.ShapeGlyph;
import com.fr.chart.chartglyph.TextGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.web.Repository;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JPanel;

public class MapPlotGlyph
extends PlotGlyph {
    private static final long serialVersionUID = 1111932837975659038L;
    private static final double RADIUSSIZE = 5.0;
    private String mapName = "";
    private HashMap pathMap = new HashMap();
    private MapHotAreaColor areaColors = new MapHotAreaColor();

    public void layoutAxisGlyph(int n2) {
    }

    public void layoutDataSeriesGlyph(int n2) {
        MapAttr mapAttr = (MapAttr)MapXMLHelper.getInstance().getMapAttr(this.mapName);
        if (mapAttr == null || mapAttr.getMapImage() == null) {
            return;
        }
        AffineTransform affineTransform = this.getTransorm();
        for (int i2 = 0; i2 < this.getSeriesSize(); ++i2) {
            DataSeries dataSeries = this.getSeries(i2);
            int n3 = dataSeries.getDataPointCount();
            for (int i3 = 0; i3 < n3; ++i3) {
                Shape shape;
                MapShapeValue mapShapeValue;
                DataPoint dataPoint = dataSeries.getDataPoint(i3);
                if (!ComparatorUtils.equals(dataPoint.getSeriesName(), this.mapName)) continue;
                if (dataPoint.isValueIsNull()) {
                    mapShapeValue = null;
                    dataPoint.setDrawImpl((Glyph)((Object)mapShapeValue));
                    shape = null;
                    dataPoint.setDataLabel((TextGlyph)((Object)shape));
                    continue;
                }
                mapShapeValue = mapAttr.getShapeValue(dataPoint.getCategoryOriginalName());
                if (mapShapeValue == null) continue;
                shape = this.createDataPointShape(mapShapeValue, mapAttr, affineTransform);
                dataPoint.setDrawImpl(this.createDrawGlyph(dataPoint, shape));
                this.recalculateTextGlyphBounds(dataPoint, shape, n2);
            }
        }
    }

    private ColorSelect4Shape getCacheColorSelect(String string, Image image) {
        ColorSelect4Shape colorSelect4Shape = null;
        MapCacheAttr mapCacheAttr = MapCacheAttr.getInstance();
        if (MapCacheAttr.isContainsColorSelect(string)) {
            colorSelect4Shape = MapCacheAttr.getColorSelect(string);
            if (!colorSelect4Shape.hasLoadedImage(image)) {
                colorSelect4Shape.makesureImage(image);
            }
        } else {
            colorSelect4Shape = new ColorSelect4Shape();
            if (!colorSelect4Shape.hasLoadedImage(image)) {
                colorSelect4Shape.makesureImage(image);
            }
            MapCacheAttr.addColorSelect4Shape(string, colorSelect4Shape);
        }
        return colorSelect4Shape;
    }

    private Shape createDataPointShape(MapShapeValue mapShapeValue, MapAttr mapAttr, AffineTransform affineTransform) {
        Image image = mapAttr.getMapImage();
        Point[] pointArray = mapShapeValue.getShape();
        int n2 = mapShapeValue.getMarkType();
        GeneralPath generalPath = new GeneralPath();
        ColorSelect4Shape colorSelect4Shape = this.getCacheColorSelect(this.mapName, image);
        for (int i2 = 0; i2 < pointArray.length; ++i2) {
            Point point = pointArray[i2];
            if (n2 == 0) {
                generalPath.moveTo((float)point.getX(), (float)point.getY());
                double d2 = 5.0;
                double d3 = point.getX() - d2;
                double d4 = point.getY() - d2;
                generalPath.append(new Arc2D.Double(d3, d4, d2 * 2.0, d2 * 2.0, 0.0, 360.0, 0), false);
                continue;
            }
            colorSelect4Shape.makesureClickPoint(point.getX(), point.getY());
            GeneralPath generalPath2 = colorSelect4Shape.getSelectedPath();
            generalPath.append(generalPath2, false);
        }
        return generalPath.createTransformedShape(affineTransform);
    }

    private AffineTransform getTransorm() {
        Object object;
        MapAttr mapAttr = (MapAttr)MapXMLHelper.getInstance().getMapAttr(this.mapName);
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        if (mapAttr != null) {
            object = mapAttr.getMapImage();
            double_.setFrame(0.0, 0.0, ((Image)object).getWidth(new JPanel()), ((Image)object).getHeight(new JPanel()));
        }
        object = double_;
        Rectangle2D.Double double_2 = new Rectangle2D.Double(0.0, 0.0, this.getBounds().getWidth(), this.getBounds().getHeight());
        double d2 = ((RectangularShape)double_2).getWidth() / ((RectangularShape)object).getWidth();
        double d3 = ((RectangularShape)double_2).getHeight() / ((RectangularShape)object).getHeight();
        d2 = d3 = Math.min(d2, d3);
        double d4 = ((RectangularShape)double_2).getX() - d2 * ((RectangularShape)object).getX();
        double d5 = ((RectangularShape)double_2).getY() - d3 * ((RectangularShape)object).getY();
        if (d2 * ((RectangularShape)object).getWidth() < ((RectangularShape)double_2).getWidth()) {
            d4 += (((RectangularShape)double_2).getWidth() - d2 * ((RectangularShape)object).getWidth()) / 2.0;
        }
        if (d3 * ((RectangularShape)object).getHeight() < ((RectangularShape)double_2).getHeight()) {
            d5 += (((RectangularShape)double_2).getHeight() - d3 * ((RectangularShape)object).getHeight()) / 2.0;
        }
        return new AffineTransform(d2, 0.0, 0.0, d3, d4, d5);
    }

    public void setAreaColors(MapHotAreaColor mapHotAreaColor) {
        this.areaColors = mapHotAreaColor;
    }

    public MapHotAreaColor getAreaColors() {
        return this.areaColors;
    }

    private Glyph createDrawGlyph(DataPoint dataPoint, Shape shape) {
        ShapeGlyph shapeGlyph = new ShapeGlyph();
        Rectangle2D rectangle2D = shape.getBounds2D();
        if (rectangle2D.getWidth() == 0.0 || rectangle2D.getHeight() == 0.0) {
            shape = new Arc2D.Double(rectangle2D.getX() - 2.0, rectangle2D.getY() - 2.0, 4.0, 4.0, 0.0, 360.0, 0);
        }
        shapeGlyph.setShape(shape);
        DataSeriesCondition dataSeriesCondition = this.getConditionCollection().getAttrByResult(dataPoint).getExisted(AttrBackground.class);
        if (dataSeriesCondition != null) {
            shapeGlyph.dealCondition(this.getConditionCollection(), dataPoint, this.createColors4Series());
        } else if (this.areaColors != null) {
            Color color = this.areaColors.getColorWithValue(dataPoint.getValue());
            if (!dataPoint.isValueIsNull()) {
                shapeGlyph.setBackground(ColorBackground.getInstance(color));
            }
        }
        return shapeGlyph;
    }

    private void recalculateTextGlyphBounds(DataPoint dataPoint, Shape shape, int n2) {
        TextGlyph textGlyph = dataPoint.getDataLabel();
        if (textGlyph != null) {
            Dimension2D dimension2D = textGlyph.preferredDimension(n2);
            Rectangle2D rectangle2D = shape.getBounds2D();
            double d2 = dimension2D.getWidth();
            double d3 = dimension2D.getHeight();
            double d4 = rectangle2D.getCenterX() - d2 / 2.0;
            double d5 = rectangle2D.getCenterY() - d3 / 2.0;
            Rectangle2D.Double double_ = new Rectangle2D.Double(d4 + 2.0, d5 + 2.0, d2 - 2.0, d3 - 3.0);
            textGlyph.setBounds(double_);
        }
    }

    public String getPlotGlyphType() {
        return "MapPlotGlyph";
    }

    public void setMapName(String string) {
        this.mapName = string;
    }

    public String getMapName() {
        return this.mapName;
    }

    public void setPathMap(HashMap hashMap) {
        this.pathMap = hashMap;
    }

    public void draw(Graphics graphics, int n2) {
        int n3;
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.drawInfo(graphics);
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        this.drawBackgroundWithShapes(graphics2D);
        int n4 = this.getSeriesSize();
        for (n3 = 0; n3 < n4; ++n3) {
            this.getSeries(n3).draw(graphics, n2);
        }
        n4 = this.getSeriesSize();
        for (n3 = 0; n3 < n4; ++n3) {
            this.getSeries(n3).drawLabel(graphics, n2);
        }
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
    }

    private void drawBackgroundWithShapes(Graphics2D graphics2D) {
        MapAttr mapAttr = (MapAttr)MapXMLHelper.getInstance().getMapAttr(this.mapName);
        if (mapAttr != null) {
            Image image = mapAttr.getMapImage();
            if (image == null) {
                return;
            }
            Rectangle2D rectangle2D = this.getBounds();
            int n2 = (int)rectangle2D.getWidth();
            int n3 = (int)rectangle2D.getHeight();
            int n4 = image.getWidth(null);
            int n5 = image.getHeight(null);
            for (int i2 = 0; i2 < n2; i2 += n2) {
                for (int i3 = 0 % n3; i3 < n3; i3 += n3) {
                    double d2 = (double)n2 / (double)n4;
                    double d3 = (double)n3 / (double)n5;
                    int n6 = n2;
                    int n7 = n3;
                    if (d2 > d3) {
                        n6 = (int)((double)n2 * d3 / d2);
                        i2 = (n2 - n6) / 2;
                    } else {
                        n7 = (int)((double)n3 * d2 / d3);
                        i3 = (n3 - n7) / 2 + i3;
                    }
                    graphics2D.drawImage(image, i2, i3, n6, n7, null);
                }
            }
        }
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        jSONObject.put("mapAreaColor", this.getAreaColors().toJSONObject());
        jSONObject.put("mapName", this.mapName);
        this.putMapReturnButtonToJS(jSONObject, repository);
        this.pathMap.clear();
        HashMap<String, Dimension> hashMap = new HashMap<String, Dimension>();
        HashMap<String, Image> hashMap2 = new HashMap<String, Image>();
        MapAttr mapAttr = (MapAttr)MapXMLHelper.getInstance().getMapAttr(this.mapName);
        if (mapAttr != null) {
            Image image = mapAttr.getMapImage();
            int n2 = image.getWidth(new JPanel());
            int n3 = image.getHeight(new JPanel());
            ColorSelect4Shape colorSelect4Shape = this.getCacheColorSelect(this.mapName, image);
            hashMap2.put(this.mapName, image);
            hashMap.put(this.mapName, new Dimension(n2, n3));
            Iterator iterator = mapAttr.shapeValuesIterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                MapShapeValue mapShapeValue = mapAttr.getShapeValue(string);
                GeneralPath generalPath = this.createPathWithPoints(mapShapeValue, colorSelect4Shape);
                this.pathMap.put(string, generalPath);
            }
        }
        if (!this.pathMap.isEmpty()) {
            jSONObject.put("pathMap", this.pathMap2JSONArray());
        }
        this.putImageBounds4JS(hashMap, hashMap2, jSONObject, repository);
        return jSONObject;
    }

    private void putImageBounds4JS(HashMap hashMap, HashMap hashMap2, JSONObject jSONObject, Repository repository) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (Object k2 : hashMap.keySet()) {
            Dimension dimension = (Dimension)hashMap.get(k2);
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("mapName", k2);
            jSONObject2.put("mapWidth", dimension.getWidth());
            jSONObject2.put("mapHeight", dimension.getHeight());
            Image image = (Image)hashMap2.get(k2);
            if (repository.getBrowser().isIE()) {
                jSONObject2.put("onie", ChartBaseUtils.addImageAsEmb(image));
            } else {
                jSONObject2.put("onsrc", "data:image/png;base64," + Base64.encode(image, "png"));
            }
            jSONArray.put(jSONObject2);
        }
        jSONObject.put("imageBounds", jSONArray);
    }

    private void putMapReturnButtonToJS(JSONObject jSONObject, Repository repository) throws JSONException {
        if (this.getSeriesSize() > 1) {
            BufferedImage bufferedImage = BaseUtils.readImage("com/fr/chart/base/mapNormal.png");
            if (repository.getBrowser().isIE()) {
                jSONObject.put("normalIEsrc", ChartBaseUtils.addImageAsEmb(bufferedImage));
            } else {
                jSONObject.put("normalsrc", "data:image/png;base64," + Base64.encode(bufferedImage, "png"));
            }
        }
    }

    private GeneralPath createPathWithPoints(MapShapeValue mapShapeValue, ColorSelect4Shape colorSelect4Shape) {
        Point[] pointArray = mapShapeValue.getShape();
        MapCacheAttr mapCacheAttr = MapCacheAttr.getInstance();
        GeneralPath generalPath = mapCacheAttr.getShapeWithName(this.mapName, mapShapeValue.getName());
        if (generalPath != null) {
            return generalPath;
        }
        GeneralPath generalPath2 = new GeneralPath();
        if (mapShapeValue.getMarkType() == 0) {
            for (int i2 = 0; i2 < pointArray.length; ++i2) {
                generalPath2.moveTo((float)pointArray[i2].getX(), (float)pointArray[i2].getY());
                double d2 = 5.0;
                double d3 = pointArray[i2].getX() - d2;
                double d4 = pointArray[i2].getY() - d2;
                generalPath2.append(new Arc2D.Double(d3, d4, d2 * 2.0, d2 * 2.0, 0.0, 360.0, 0), false);
            }
        } else {
            for (int i3 = 0; i3 < pointArray.length; ++i3) {
                colorSelect4Shape.makesureClickPoint(pointArray[i3].getX(), pointArray[i3].getY());
                GeneralPath generalPath3 = colorSelect4Shape.getSelectedPath();
                generalPath2.append(generalPath3, false);
            }
        }
        MapCacheAttr.addShapes(this.mapName, mapShapeValue.getName(), generalPath2);
        return generalPath2;
    }

    public boolean equals(Object object) {
        return object instanceof MapPlotGlyph && super.equals(object);
    }

    private JSONArray pathMap2JSONArray() throws JSONException {
        JSONArray jSONArray = new JSONArray();
        MapAttr mapAttr = (MapAttr)MapXMLHelper.getInstance().getMapAttr(this.mapName);
        Iterator iterator = this.pathMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = Utils.objectToString(iterator.next());
            MapShapeValue mapShapeValue = mapAttr.getShapeValue(string);
            GeneralPath generalPath = (GeneralPath)this.pathMap.get(string);
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("key", string);
            jSONObject.put("path", ChartBaseUtils.generalPath2JS(generalPath));
            jSONObject.put("markType", mapShapeValue.getMarkType());
            jSONArray.put(jSONObject);
        }
        return jSONArray;
    }
}

