/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.CoreDecimalFormat;
import com.fr.base.background.AreaColor;
import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.chartglyph.AxisHelper;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

public class MapHotAreaColor
implements XMLable {
    private static final long serialVersionUID = 1532455023184207954L;
    public static final String XML_TAG = "MapHotAreaColor";
    private static final double TEN = 10.0;
    private static final double FOUR = 4.0;
    private static final double BASEVALUE = 0.4;
    public static final int AUTO = 0;
    public static final int CUSTOM = 1;
    private double maxValue = 100.0;
    private double minValue = 0.0;
    private Color mainColor = Color.blue;
    private List areaColorList = new ArrayList();
    private int areaNumber = 5;
    private int useType = 0;

    public void refreshMinMax(double d2, double d3) {
        if (this.useType == 0) {
            this.minValue = d2;
            this.maxValue = d3;
        } else {
            int n2;
            this.areaNumber = n2 = this.areaColorList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                AreaColor areaColor = (AreaColor)this.areaColorList.get(i2);
                this.minValue = Math.min(this.minValue, areaColor.getMin());
                this.maxValue = Math.max(this.maxValue, areaColor.getMax());
            }
        }
    }

    public int getAreaNumber() {
        return this.areaNumber;
    }

    public void clearColor() {
        this.areaColorList.clear();
    }

    public void addAreaColor(AreaColor areaColor) {
        this.areaColorList.add(areaColor);
    }

    public Color[] initColor() {
        if (this.useType == 0) {
            BigDecimal bigDecimal;
            this.clearColor();
            Color[] colorArray = ChartBaseUtils.createColorsWithAlpha(this.getMainColor(), this.areaNumber);
            double d2 = this.minValue;
            BigDecimal bigDecimal2 = new BigDecimal(Double.toString(this.maxValue - this.minValue));
            double d3 = AxisHelper.getMoveInt(bigDecimal2);
            if (d3 <= 0.0) {
                bigDecimal = new BigDecimal(Double.toString(d2));
                bigDecimal.setScale(1 - (int)d3, 1);
                d2 = bigDecimal.doubleValue();
            } else {
                int n2 = (int)Math.pow(10.0, d3);
                d2 = (int)(this.minValue / (double)n2) * n2;
            }
            bigDecimal = new BigDecimal(Double.toString((double)this.areaNumber / 10.0 * Math.pow(10.0, d3)));
            BigDecimal bigDecimal3 = new BigDecimal(Double.toString(0.0));
            while (bigDecimal3.doubleValue() < bigDecimal2.doubleValue()) {
                bigDecimal3 = bigDecimal3.add(bigDecimal);
            }
            double d4 = bigDecimal3.doubleValue() / (double)this.areaNumber;
            while (d2 + d4 * (double)this.areaNumber < this.maxValue) {
                bigDecimal3 = bigDecimal3.add(bigDecimal);
                d4 = bigDecimal3.doubleValue() / (double)this.areaNumber;
            }
            d4 = bigDecimal3.doubleValue() / (double)this.areaNumber;
            for (int i2 = 0; i2 < this.areaNumber; ++i2) {
                AreaColor areaColor = new AreaColor(d2 + d4 * (double)(this.areaNumber - i2 - 1), d2 + d4 * (double)(this.areaNumber - i2), colorArray[i2]);
                this.areaColorList.add(i2, areaColor);
            }
            return colorArray;
        }
        int n3 = this.areaColorList.size();
        Color[] colorArray = new Color[n3];
        for (int i3 = 0; i3 < n3; ++i3) {
            AreaColor areaColor = (AreaColor)this.areaColorList.get(i3);
            colorArray[i3] = areaColor.getAreaColor();
        }
        return colorArray;
    }

    public double[] initValues() {
        if (this.useType == 1) {
            int n2 = this.areaColorList.size();
            double[] dArray = new double[n2 + 1];
            for (int i2 = 0; i2 < n2; ++i2) {
                AreaColor areaColor = (AreaColor)this.areaColorList.get(i2);
                dArray[i2] = areaColor.getMin();
                dArray[i2 + 1] = areaColor.getMax();
            }
            return dArray;
        }
        return new double[0];
    }

    public void setUseType(int n2) {
        this.useType = n2;
    }

    public int getUseType() {
        return this.useType;
    }

    public void setMainColor(Color color) {
        this.mainColor = color;
    }

    public Color getMainColor() {
        return this.mainColor;
    }

    public List getAreaColorList() {
        return this.areaColorList;
    }

    public void setAreaNumber(int n2) {
        this.areaNumber = n2;
    }

    private boolean isUseChartFormat() {
        boolean bl = true;
        for (int i2 = 0; i2 < this.areaColorList.size(); ++i2) {
            AreaColor areaColor = (AreaColor)this.areaColorList.get(i2);
            if (areaColor.getMin() == (double)((int)areaColor.getMin()) && areaColor.getMax() == (double)((int)areaColor.getMax())) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public String getLabelWithInt(int n2) {
        AreaColor areaColor = (AreaColor)this.areaColorList.get(n2);
        boolean bl = this.isUseChartFormat();
        String string = "";
        String string2 = "";
        if (bl) {
            string = ChartBaseUtils.generalFormat(areaColor.getMin());
            string2 = ChartBaseUtils.generalFormat(areaColor.getMax());
        } else {
            CoreDecimalFormat coreDecimalFormat = new CoreDecimalFormat(new DecimalFormat(), "#.##");
            string = coreDecimalFormat.format(areaColor.getMin());
            string2 = coreDecimalFormat.format(areaColor.getMax());
        }
        return string + "--" + string2;
    }

    public int getColorsIndex(double d2) {
        int n2 = 0;
        for (int i2 = 0; i2 < this.areaColorList.size(); ++i2) {
            AreaColor areaColor = (AreaColor)this.areaColorList.get(i2);
            double d3 = Math.min(areaColor.getMin(), areaColor.getMax());
            double d4 = Math.max(areaColor.getMin(), areaColor.getMax());
            if (!(d3 <= d2) || !(d2 <= d4)) continue;
            n2 = i2;
            break;
        }
        return n2;
    }

    public Color getColorWithValue(double d2) {
        Color color = Color.white;
        int n2 = this.areaColorList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            AreaColor areaColor = (AreaColor)this.areaColorList.get(i2);
            double d3 = Math.min(areaColor.getMin(), areaColor.getMax());
            double d4 = Math.max(areaColor.getMin(), areaColor.getMax());
            if (!(d3 <= d2) || !(d2 <= d4)) continue;
            color = areaColor.getAreaColor();
            break;
        }
        return color;
    }

    public boolean inHotArea(double d2) {
        return d2 >= this.minValue && d2 <= this.maxValue;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        Object[] objectArray = new Object[this.areaColorList.size()];
        for (int i2 = 0; i2 < this.areaColorList.size(); ++i2) {
            objectArray[i2] = ((AreaColor)this.areaColorList.get(i2)).toJSONObject();
        }
        jSONObject.put("areaColors", objectArray);
        return jSONObject;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (ComparatorUtils.equals("MC_Attr", string)) {
                this.minValue = xMLableReader.getAttrAsDouble("minValue", 0.0);
                this.maxValue = xMLableReader.getAttrAsDouble("maxValue", 100.0);
                this.useType = xMLableReader.getAttrAsInt("useType", 0);
                this.areaNumber = xMLableReader.getAttrAsInt("areaNumber", 5);
                this.mainColor = xMLableReader.getAttrAsColor("mainColor", Color.blue);
            } else if (ComparatorUtils.equals("ColorList", string)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isChildNode() && ComparatorUtils.equals(xMLableReader.getTagName(), "AreaColor")) {
                            MapHotAreaColor.this.addAreaColor((AreaColor)xMLableReader.readXMLObject(new AreaColor()));
                        }
                    }
                });
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.startTAG("MC_Attr").attr("minValue", this.minValue).attr("maxValue", this.maxValue).attr("useType", this.useType).attr("areaNumber", this.areaNumber);
        if (this.mainColor != null) {
            xMLPrintWriter.attr("mainColor", this.mainColor.getRGB());
        }
        xMLPrintWriter.end();
        if (this.areaColorList.size() > 0) {
            xMLPrintWriter.startTAG("ColorList");
            for (int i2 = 0; i2 < this.areaColorList.size(); ++i2) {
                AreaColor areaColor = (AreaColor)this.areaColorList.get(i2);
                areaColor.writeXML(xMLPrintWriter);
            }
            xMLPrintWriter.end();
        }
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        MapHotAreaColor mapHotAreaColor = (MapHotAreaColor)super.clone();
        mapHotAreaColor.areaColorList = new ArrayList();
        mapHotAreaColor.clearColor();
        if (!this.areaColorList.isEmpty()) {
            for (int i2 = 0; i2 < this.areaColorList.size(); ++i2) {
                AreaColor areaColor = (AreaColor)this.areaColorList.get(i2);
                mapHotAreaColor.addAreaColor((AreaColor)areaColor.clone());
            }
        }
        return mapHotAreaColor;
    }

    public boolean equals(Object object) {
        if (!(object instanceof MapHotAreaColor)) {
            return false;
        }
        MapHotAreaColor mapHotAreaColor = (MapHotAreaColor)object;
        if (this.areaColorList.size() != mapHotAreaColor.areaColorList.size()) {
            return false;
        }
        int n2 = this.areaColorList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (ComparatorUtils.equals(this.areaColorList.get(i2), mapHotAreaColor.getAreaColorList().get(i2))) continue;
            return false;
        }
        return this.useType == mapHotAreaColor.useType && this.areaNumber == mapHotAreaColor.areaNumber && ComparatorUtils.equals(this.mainColor, mapHotAreaColor.mainColor);
    }
}

