/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.background.ColorBackground;
import com.fr.chart.base.AttrAlpha;
import com.fr.chart.base.AttrColor;
import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.chartglyph.Bar2DPlotGlyph;
import com.fr.chart.chartglyph.DataPoint4Gantt;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.DateAxisGlyph;
import com.fr.chart.chartglyph.DiamondFilledMarker;
import com.fr.chart.chartglyph.MarkerGlyph;
import com.fr.chart.chartglyph.RectanglePlotGlyph;
import com.fr.chart.chartglyph.ShapeGlyph;
import com.fr.chart.chartglyph.TriangleFilledMarker;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.util.Date;

public class GanttPlotGlyph
extends RectanglePlotGlyph {
    private static final long serialVersionUID = 7888272466260745014L;
    private static final float PLAN_UI = 0.8f;
    private static final double MARKERSCALE = 4.0;
    private Image errorImage;
    private String errorToopTip;

    public void setErrorImage(Image image) {
        this.errorImage = image;
    }

    public Image getErrorImage() {
        return this.errorImage;
    }

    public void setErrorToopTip(String string) {
        this.errorToopTip = string;
    }

    public String getErrorToopTip() {
        return this.errorToopTip;
    }

    public String getPlotGlyphType() {
        return "GanttPlotGlyph";
    }

    public void layoutAxisGlyph(int n2) {
        this.layoutDoubleAxisGlyph(this.getxAxisGlyph(), this.getyAxisGlyph(), this.getSecondAxisGlyph(), n2);
        this.getyAxisGlyph().getOrigin().setLocation(this.getyAxisGlyph().getOrigin().getX(), this.getyAxisGlyph().getBounds().getY());
    }

    public void layoutDataSeriesGlyph(int n2) {
        if (this.errorImage != null) {
            return;
        }
        Bar2DPlotGlyph bar2DPlotGlyph = new Bar2DPlotGlyph();
        bar2DPlotGlyph.setCategoryIntervalPercent(0.0);
        for (int i2 = 0; i2 < this.getSeriesSize(); ++i2) {
            DataSeries dataSeries = this.getSeries(i2);
            for (int i3 = 0; i3 < dataSeries.getDataPointCount(); ++i3) {
                DataPoint4Gantt dataPoint4Gantt = (DataPoint4Gantt)dataSeries.getDataPoint(i3);
                if (dataPoint4Gantt.isValueIsNull()) continue;
                this.layoutDataPoint4Gantt(bar2DPlotGlyph, dataPoint4Gantt);
            }
        }
    }

    private void layoutDataPoint4Gantt(Bar2DPlotGlyph bar2DPlotGlyph, DataPoint4Gantt dataPoint4Gantt) {
        AttrColor attrColor = (AttrColor)this.getConditionCollection().getDataSeriesCondition(AttrColor.class, dataPoint4Gantt, this.createColors4Series());
        AttrAlpha attrAlpha = (AttrAlpha)this.getConditionCollection().getDataSeriesCondition(AttrAlpha.class, dataPoint4Gantt, null);
        Rectangle2D rectangle2D = bar2DPlotGlyph.getBarShape4GanttPlot(dataPoint4Gantt.getPlanStart(), dataPoint4Gantt.getPlanEnd(), dataPoint4Gantt.getCategoryIndex(), this.getyAxisGlyph(), this.getxAxisGlyph(), this.getSeriesSize(), dataPoint4Gantt.getSeriesIndex());
        ShapeGlyph shapeGlyph = new ShapeGlyph(rectangle2D);
        shapeGlyph.setBackground(ColorBackground.getInstance(ChartBaseUtils.saturationDown(attrColor.getSeriesColor())));
        shapeGlyph.setAlpha(0.8f);
        dataPoint4Gantt.setPlanImpl(shapeGlyph);
        this.dealProgress4DataPoint(bar2DPlotGlyph, dataPoint4Gantt, attrColor, attrAlpha);
        this.dealRealStart4DataPoint(dataPoint4Gantt, rectangle2D, attrAlpha);
        this.dealRealEnd4DataPoint(dataPoint4Gantt, rectangle2D, attrAlpha);
    }

    private void dealProgress4DataPoint(Bar2DPlotGlyph bar2DPlotGlyph, DataPoint4Gantt dataPoint4Gantt, AttrColor attrColor, AttrAlpha attrAlpha) {
        if (dataPoint4Gantt.getProgress() >= 0.0) {
            Rectangle2D rectangle2D = bar2DPlotGlyph.getBarShape4GanttPlot(dataPoint4Gantt.getPlanStart(), dataPoint4Gantt.getPlanStart() + (dataPoint4Gantt.getPlanEnd() - dataPoint4Gantt.getPlanStart()) * dataPoint4Gantt.getProgress(), dataPoint4Gantt.getCategoryIndex(), this.getyAxisGlyph(), this.getxAxisGlyph(), this.getSeriesSize(), dataPoint4Gantt.getSeriesIndex());
            ShapeGlyph shapeGlyph = new ShapeGlyph(rectangle2D);
            shapeGlyph.setBackground(ColorBackground.getInstance(attrColor.getSeriesColor()));
            shapeGlyph.setAlpha(attrAlpha.getAlpha());
            dataPoint4Gantt.setProgressImpl(shapeGlyph);
        }
    }

    private void dealRealStart4DataPoint(DataPoint4Gantt dataPoint4Gantt, Rectangle2D rectangle2D, AttrAlpha attrAlpha) {
        if (dataPoint4Gantt.getRealStart() >= 0.0) {
            Date date = ChartBaseUtils.long2Date((long)dataPoint4Gantt.getRealStart(), 6);
            double d2 = ChartBaseUtils.date2Int(date, ((DateAxisGlyph)this.getxAxisGlyph()).getMainType());
            double d3 = this.getxAxisGlyph().getPoint2D(d2).getX();
            double d4 = rectangle2D.getHeight();
            TriangleFilledMarker triangleFilledMarker = new TriangleFilledMarker();
            triangleFilledMarker.setSize(d4 / 4.0);
            triangleFilledMarker.setBackground(ColorBackground.getInstance(Color.black));
            MarkerGlyph markerGlyph = new MarkerGlyph(triangleFilledMarker, Color.black);
            markerGlyph.setShape(new Rectangle2D.Double(d3 - d4 / 4.0, rectangle2D.getY() + d4 / 2.0, d4 / 2.0, d4 / 2.0));
            markerGlyph.setAlpha(attrAlpha.getAlpha());
            dataPoint4Gantt.setRealStartImpl(markerGlyph);
        }
    }

    private void dealRealEnd4DataPoint(DataPoint4Gantt dataPoint4Gantt, Rectangle2D rectangle2D, AttrAlpha attrAlpha) {
        if (dataPoint4Gantt.getRealEnd() >= 0.0) {
            Date date = ChartBaseUtils.long2Date((long)dataPoint4Gantt.getRealEnd(), 6);
            double d2 = ChartBaseUtils.date2Int(date, ((DateAxisGlyph)this.getxAxisGlyph()).getMainType());
            double d3 = this.getxAxisGlyph().getPoint2D(d2).getX();
            double d4 = rectangle2D.getHeight();
            DiamondFilledMarker diamondFilledMarker = new DiamondFilledMarker();
            diamondFilledMarker.setSize(d4 / 4.0);
            diamondFilledMarker.setBackground(ColorBackground.getInstance(new Color(122, 225, 108)));
            MarkerGlyph markerGlyph = new MarkerGlyph(diamondFilledMarker, new Color(122, 225, 108));
            markerGlyph.setShape(new Rectangle2D.Double(d3 - d4 / 4.0, rectangle2D.getY() + d4 / 2.0, d4 / 2.0, d4 / 2.0));
            markerGlyph.setAlpha(attrAlpha.getAlpha());
            dataPoint4Gantt.setRealEndImpl(markerGlyph);
        }
    }

    public void draw(Graphics graphics, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        if (this.errorImage != null) {
            int n3 = (int)(this.getBounds().getWidth() - (double)this.errorImage.getWidth(null)) / 2;
            int n4 = (int)(this.getBounds().getHeight() - (double)this.errorImage.getHeight(null)) / 2;
            graphics2D.drawImage(this.errorImage, n3, n4, null);
        }
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
        super.draw(graphics2D, n2);
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        jSONObject.put("errorToopTip", this.errorToopTip);
        if (this.errorImage != null) {
            ChartBaseUtils.image2JS(jSONObject, this.errorImage);
        }
        return jSONObject;
    }
}

