/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.DoubleDimension2D;
import com.fr.base.FRContext;
import com.fr.base.GraphHelper;
import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.base.GlyphUtils;
import com.fr.chart.base.TextAttr;
import com.fr.chart.chartglyph.AxisGlyph;
import com.fr.chart.chartglyph.CategoryPlotGlyph;
import com.fr.chart.chartglyph.ChartGlyph;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataPoint4Stock;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.LegendItem;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.chart.chartglyph.RectangleGlyph;
import com.fr.chart.chartglyph.StockPlotGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRFont;
import com.fr.general.Inter;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class DataSheetGlyph
extends RectangleGlyph {
    private static final long serialVersionUID = -6888178799836147561L;
    private static final double PADDING_GAP = 4.0;
    private static final double MAX_CATE_LINE = 4.0;
    private static final double MAX_WIDTH = 4.0;
    private List seriesList = new ArrayList();
    private LegendItem[] items;
    private FRFont font = null;
    private Format format = null;
    private double beginX;
    private double unitLength;
    private double seriesRowHeight;
    private double endLegendWidth;
    private double crossValue;
    private double arrowValue;
    private double cateRowCout;

    public DataSheetGlyph() {
    }

    public DataSheetGlyph(PlotGlyph plotGlyph) {
        this(plotGlyph, null);
    }

    public DataSheetGlyph(PlotGlyph plotGlyph, LegendItem[] legendItemArray) {
        this.setDataWithLegendItems(plotGlyph, legendItemArray);
    }

    public int getSeriesSize() {
        return this.seriesList == null ? 0 : this.seriesList.size();
    }

    private DataSeries getSeries(int n2) {
        return n2 > -1 && n2 < this.getSeriesSize() ? (DataSeries)this.seriesList.get(n2) : null;
    }

    public int getCategoryCount() {
        return this.getSeries(0) == null ? 0 : this.getSeries(0).getDataPointCount();
    }

    public Iterator selectableChildren() {
        return Collections.EMPTY_LIST.iterator();
    }

    public void setFont(FRFont fRFont) {
        this.font = fRFont;
    }

    public FRFont getFont() {
        return this.font == null ? FRFont.getInstance() : this.font;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public Format getFormat() {
        return this.format;
    }

    public double getBeginX() {
        return this.beginX;
    }

    public void setBeginX(double d2) {
        this.beginX = d2;
    }

    public double getHeight() {
        return this.seriesRowHeight;
    }

    public void setHeight(double d2) {
        this.seriesRowHeight = d2;
    }

    public void setCrossValue(double d2) {
        this.crossValue = d2;
    }

    public void setArrowValue(double d2) {
        this.arrowValue = d2;
    }

    public void setUnitLength(double d2) {
        this.unitLength = d2;
    }

    public Dimension2D getPrefferedSize(ChartGlyph chartGlyph, int n2) {
        if (this.getSeriesSize() < 1) {
            return new Dimension();
        }
        this._initSeriesRowHeightAndEndLegendWidth(chartGlyph, n2);
        String string = this.getMaxCateString(n2);
        double d2 = this.getCharNumber(new TextAttr(this.getFont()), (int)this.unitLength, n2);
        if (d2 == 0.0) {
            this.cateRowCout = 1.0;
        } else {
            double d3 = Math.max(Math.ceil((double)string.length() / d2), 1.0);
            this.cateRowCout = Math.min(4.0, d3);
        }
        return new DoubleDimension2D(this.endLegendWidth + 4.0 * 2.0, (this.seriesRowHeight + 4.0 * 2.0) * (double)this.seriesList.size() + this.cateRowCout * this.seriesRowHeight + 4.0 * 2.0);
    }

    private String getMaxCateString(int n2) {
        int n3 = ((DataSeries)this.seriesList.get(0)).getDataPointCount();
        Dimension2D dimension2D = new Dimension();
        String string = "";
        for (int i2 = 0; i2 < n3; ++i2) {
            String string2 = ((DataSeries)this.seriesList.get(0)).getDataPoint(i2).getCategoryName();
            Dimension2D dimension2D2 = GlyphUtils.calculateTextDimensionWithNoRotation(string2, new TextAttr(this.getFont()), n2);
            if (!(dimension2D2.getWidth() > ((Dimension2D)dimension2D).getWidth())) continue;
            dimension2D = dimension2D2;
            string = string2;
        }
        return string;
    }

    private void _initSeriesRowHeightAndEndLegendWidth(ChartGlyph chartGlyph, int n2) {
        this.seriesRowHeight = Double.MIN_VALUE;
        double d2 = Double.MIN_VALUE;
        double d3 = chartGlyph.getBounds().getWidth() / 4.0;
        for (int i2 = 0; i2 < this.getSeriesSize(); ++i2) {
            Dimension2D dimension2D = null;
            dimension2D = this.items != null && this.getSeriesSize() == this.items.length ? this.items[i2].prefferedSize(this.getFont(), n2) : GlyphUtils.calculateTextDimensionWithNoRotation(this.getSeries(i2).getSeriesName(), new TextAttr(this.getFont()), n2);
            if (dimension2D.getWidth() > d2) {
                d2 = Math.min(dimension2D.getWidth(), d3);
            }
            if (!(dimension2D.getHeight() > this.seriesRowHeight)) continue;
            this.seriesRowHeight = dimension2D.getHeight();
        }
        this.endLegendWidth = d2;
    }

    private int getCharNumber(TextAttr textAttr, int n2, int n3) {
        if (n2 <= 0) {
            return 0;
        }
        double d2 = GlyphUtils.calculateTextDimensionWithNoRotation(Inter.getLocText("Chart_Test"), textAttr, n3).getWidth();
        return (int)((double)n2 / d2);
    }

    private void setDataWithLegendItems(PlotGlyph plotGlyph, LegendItem[] legendItemArray) {
        this.initSeriesList(plotGlyph);
        if (legendItemArray != null) {
            try {
                this.items = new LegendItem[legendItemArray.length];
                for (int i2 = 0; i2 < legendItemArray.length; ++i2) {
                    this.items[i2] = (LegendItem)legendItemArray[i2].clone();
                }
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                FRContext.getLogger().error(cloneNotSupportedException.getMessage(), cloneNotSupportedException);
            }
        }
    }

    public void setDataWithoutLegendItems(PlotGlyph plotGlyph) {
        this.initSeriesList(plotGlyph);
    }

    private void initSeriesList(PlotGlyph plotGlyph) {
        if (plotGlyph != null) {
            int n2 = plotGlyph.getSeriesSize();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.seriesList.add(plotGlyph.getSeries(i2));
            }
        }
    }

    public void doLayout(PlotGlyph plotGlyph) {
        Rectangle2D rectangle2D = this.getBounds();
        if (plotGlyph instanceof CategoryPlotGlyph) {
            AxisGlyph axisGlyph = ((CategoryPlotGlyph)plotGlyph).getxAxisGlyph();
            AxisGlyph axisGlyph2 = ((CategoryPlotGlyph)plotGlyph).getyAxisGlyph();
            int n2 = axisGlyph.position;
            if (n2 == 1 || n2 == 3) {
                this.beginX = axisGlyph.getBounds().getX() + plotGlyph.getBounds().getX();
                this.unitLength = axisGlyph.getBounds().getWidth() / (double)plotGlyph.getCategoryCount();
                rectangle2D.setFrame(rectangle2D.getX(), rectangle2D.getY(), this.beginX + axisGlyph.axisLength - this.getBounds().getX(), rectangle2D.getHeight());
            } else {
                this.beginX = axisGlyph2.getBounds().getX() + plotGlyph.getBounds().getX();
                this.unitLength = (this.getBounds().getX() + this.getBounds().getWidth() - this.beginX) / (double)plotGlyph.getCategoryCount();
                rectangle2D.setFrame(rectangle2D.getX(), rectangle2D.getY(), this.beginX + axisGlyph2.axisLength - this.getBounds().getX(), rectangle2D.getHeight());
            }
            this.crossValue = axisGlyph.getCrossValue();
            this.arrowValue = axisGlyph.getArrowValue();
        } else if (plotGlyph instanceof StockPlotGlyph) {
            AxisGlyph axisGlyph = ((StockPlotGlyph)plotGlyph).getxAxisGlyph();
            this.beginX = axisGlyph.getBounds().getX() + plotGlyph.getBounds().getX();
            this.unitLength = axisGlyph.unitLength;
            rectangle2D.setFrame(rectangle2D.getX(), rectangle2D.getY(), this.beginX + axisGlyph.axisLength - this.getBounds().getX(), rectangle2D.getHeight());
            this.crossValue = axisGlyph.getCrossValue();
            this.arrowValue = axisGlyph.getArrowValue();
        }
        this.setBounds(rectangle2D);
    }

    public void draw(Graphics graphics, int n2) {
        double d2;
        if (this.getSeriesSize() < 1) {
            return;
        }
        Color color = graphics.getColor();
        graphics.setColor(this.getBorderColor());
        Rectangle2D rectangle2D = this.getBounds();
        double d3 = this.seriesRowHeight * this.cateRowCout + 4.0 * 2.0;
        double d4 = rectangle2D.getX();
        double d5 = rectangle2D.getY() + d3;
        this._newLine(graphics, d4, d5, d4, rectangle2D.getY() + rectangle2D.getHeight());
        this._newLine(graphics, d4, rectangle2D.getY() + rectangle2D.getHeight(), d4 + rectangle2D.getWidth(), rectangle2D.getY() + rectangle2D.getHeight());
        this._newLine(graphics, rectangle2D.getX() + rectangle2D.getWidth(), rectangle2D.getY(), rectangle2D.getX() + rectangle2D.getWidth(), rectangle2D.getY() + rectangle2D.getHeight());
        this._newLine(graphics, this.beginX, rectangle2D.getY(), rectangle2D.getX() + rectangle2D.getWidth(), rectangle2D.getY());
        for (d2 = this.beginX; d2 < rectangle2D.getX() + rectangle2D.getWidth(); d2 += this.unitLength) {
            this._newLine(graphics, d2, rectangle2D.getY(), d2, rectangle2D.getY() + rectangle2D.getHeight());
        }
        for (d2 = 0.0; d2 < (double)this.seriesList.size(); d2 += 1.0) {
            double d6 = rectangle2D.getY() + d3 + (this.seriesRowHeight + 4.0 * 2.0) * d2;
            this._newLine(graphics, rectangle2D.getX(), d6, rectangle2D.getX() + rectangle2D.getWidth(), d6);
        }
        this.drawSeriese(graphics, n2);
        this.drawLabel4Category(graphics, n2);
        this.drawLabel4DataPoint(graphics, n2);
        graphics.setColor(color);
    }

    private void _newLine(Graphics graphics, double d2, double d3, double d4, double d5) {
        Line2D.Double double_ = new Line2D.Double(d2, d3, d4, d5);
        GraphHelper.draw(graphics, double_, 1);
    }

    private void drawSeriese(Graphics graphics, int n2) {
        Rectangle2D rectangle2D = this.getBounds();
        double d2 = this.seriesRowHeight * this.cateRowCout + 4.0 * 2.0;
        for (int i2 = 0; i2 < this.getSeriesSize(); ++i2) {
            Object object;
            double d3 = d2 + rectangle2D.getY() + (this.seriesRowHeight + 8.0) * (double)i2 + 4.0;
            if (this.items != null && this.getSeriesSize() == this.items.length) {
                object = this.items[i2].prefferedSize(this.getFont(), n2);
                this.items[i2].setBounds(new Rectangle2D.Double(rectangle2D.getX() + 4.0, d3, Math.min(((Dimension2D)object).getWidth(), this.endLegendWidth), ((Dimension2D)object).getHeight()));
                boolean bl = this.items[i2].isDrawInCut();
                this.items[i2].setDrawInCut(true);
                this.items[i2].draw(graphics, this.getFont(), n2);
                this.items[i2].setDrawInCut(bl);
                continue;
            }
            object = this.getSeries(i2).getSeriesName();
            Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation((String)object, new TextAttr(this.getFont()), n2);
            GlyphUtils.drawStrings(graphics, (String)object, new TextAttr(this.getFont()), new Rectangle2D.Double(rectangle2D.getX() + 4.0, d3, dimension2D.getWidth(), dimension2D.getHeight()), n2);
        }
    }

    private void drawLabel4Category(Graphics graphics, int n2) {
        TextAttr textAttr = new TextAttr(this.getFont());
        int n3 = this.getCharNumber(textAttr, (int)this.unitLength, n2);
        if (n3 <= 0) {
            return;
        }
        String string = "";
        Dimension2D dimension2D = new DoubleDimension2D(0.0, 0.0);
        block0: for (int i2 = 0; i2 < this.getCategoryCount() && (double)i2 < this.arrowValue; ++i2) {
            int n4 = (int)((double)i2 - this.crossValue);
            if (n4 < 0) continue;
            String string2 = this.getSeries(0).getDataPoint(i2).getCategoryName();
            double d2 = this.beginX + (double)n4 * this.unitLength;
            int n5 = 0;
            while (true) {
                if (!((double)n5 < 4.0)) continue block0;
                int n6 = Math.min((n5 + 1) * n3, string2.length());
                string = string2.substring(n5 * n3, n6);
                dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation(string, textAttr, n2);
                Rectangle2D.Double double_ = new Rectangle2D.Double(d2 + (this.unitLength - dimension2D.getWidth()) / 2.0, this.bounds.getY() + (this.seriesRowHeight - dimension2D.getHeight()) / 2.0 + (double)n5 * this.seriesRowHeight + 4.0, dimension2D.getWidth(), dimension2D.getHeight());
                GlyphUtils.drawStrings(graphics, string, textAttr, double_, n2);
                if (n6 >= string2.length()) continue block0;
                ++n5;
            }
        }
    }

    private void drawLabel4DataPoint(Graphics graphics, int n2) {
        Rectangle2D rectangle2D = this.getBounds();
        double d2 = this.seriesRowHeight * this.cateRowCout + 4.0 * 2.0;
        for (int i2 = 0; i2 < this.getSeriesSize(); ++i2) {
            DataSeries dataSeries = this.getSeries(i2);
            double d3 = d2 + rectangle2D.getY() + (this.seriesRowHeight + 8.0) * (double)i2 + 4.0;
            for (int i3 = 0; i3 < this.getCategoryCount() && (double)i3 < this.arrowValue; ++i3) {
                DataPoint dataPoint = dataSeries.getDataPoint(i3);
                int n3 = (int)((double)i3 - this.crossValue);
                if (n3 < 0 || dataPoint.isValueIsNull()) continue;
                String string = String.valueOf(dataPoint.getValue());
                if (dataPoint instanceof DataPoint4Stock) {
                    string = String.valueOf(((DataPoint4Stock)dataPoint).getStockValues()[4]);
                }
                if (this.format != null) {
                    string = this.format.format(Double.valueOf(string));
                }
                Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation(string, new TextAttr(this.getFont()), n2);
                GlyphUtils.drawStrings(graphics, string, new TextAttr(this.getFont()), new Rectangle2D.Double(this.beginX + (double)n3 * this.unitLength + (this.unitLength - dimension2D.getWidth()) / 2.0, d3, dimension2D.getWidth(), dimension2D.getHeight()), n2);
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        DataSheetGlyph dataSheetGlyph = (DataSheetGlyph)super.clone();
        dataSheetGlyph.items = new LegendItem[this.items.length];
        for (int i2 = 0; i2 < this.items.length; ++i2) {
            dataSheetGlyph.items[i2] = (LegendItem)this.items[i2].clone();
        }
        return dataSheetGlyph;
    }

    public boolean equals(Object object) {
        return object instanceof DataSheetGlyph && super.equals(object) && ComparatorUtils.equals(((DataSheetGlyph)object).seriesList, this.seriesList) && ComparatorUtils.equals(((DataSheetGlyph)object).items, this.items) && ComparatorUtils.equals(((DataSheetGlyph)object).font, this.font) && ComparatorUtils.equals(((DataSheetGlyph)object).format, this.format);
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        if (this.items != null && this.items.length > 0) {
            JSONArray jSONArray = new JSONArray();
            for (int i2 = 0; i2 < this.items.length; ++i2) {
                jSONArray.put(this.items[i2].toJSONObject());
            }
            jSONObject.put("items", jSONArray);
        }
        if (this.font != null) {
            jSONObject.put("font", this.font.toJSONObject());
        }
        if (this.format != null) {
            jSONObject.put("format", ChartBaseUtils.format2JS(this.format));
        }
        return jSONObject;
    }
}

