/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.BaseXMLUtils;
import com.fr.base.FRContext;
import com.fr.base.ParameterMapNameSpace;
import com.fr.base.TemplateUtils;
import com.fr.chart.base.AttrAlpha;
import com.fr.chart.base.AttrBackground;
import com.fr.chart.base.AttrBorder;
import com.fr.chart.base.AttrColor;
import com.fr.chart.base.AttrContents;
import com.fr.chart.base.AttrLineStyle;
import com.fr.chart.base.StyleContactWithConditionCollection;
import com.fr.chart.base.TextAttr;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.general.ComparatorUtils;
import com.fr.script.Calculator;
import com.fr.stable.ParameterProvider;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.text.Format;

public class DataPointLabelInfo
implements XMLable,
StyleContactWithConditionCollection {
    private static final long serialVersionUID = 1945411573328281811L;
    private AttrContents seriesLabelContents = new AttrContents();

    public void setSeriesLabelContents(AttrContents attrContents) {
        this.seriesLabelContents = attrContents;
    }

    public AttrContents getSeriesLabelContents() {
        return this.seriesLabelContents;
    }

    public void setSeriesLabel(String string) {
        this.seriesLabelContents.setSeriesLabel(string);
    }

    public String getSeriesLabel() {
        return this.seriesLabelContents.getSeriesLabel();
    }

    public void setPosition(int n2) {
        this.seriesLabelContents.setPosition(n2);
    }

    public int getPosition() {
        return this.seriesLabelContents.getPosition();
    }

    public void setTextAttr(TextAttr textAttr) {
        this.seriesLabelContents.setTextAttr(textAttr);
    }

    public TextAttr getTextAttr() {
        return this.seriesLabelContents.getTextAttr();
    }

    public void setFormat(Format format) {
        this.seriesLabelContents.setFormat(format);
    }

    public Format getFormat() {
        return this.seriesLabelContents.getFormat();
    }

    public String createLabelText(DataPoint dataPoint) {
        String string = "";
        if (this.getSeriesLabelContents().getSeriesLabel() != null) {
            try {
                Calculator calculator = Calculator.createCalculator();
                ParameterProvider[] parameterProviderArray = dataPoint.getParameters4Labels(this.seriesLabelContents);
                string = TemplateUtils.renderTpl((CalculatorProvider)calculator, this.getSeriesLabelContents().getSeriesLabel(), ParameterMapNameSpace.create(parameterProviderArray));
            }
            catch (Exception exception) {
                FRContext.getLogger().error("Error in calculator DataPoint Label", exception);
            }
        }
        return string;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("Attr")) {
                String string2 = this.getSeriesLabel();
                String string3 = xMLableReader.getAttrAsString("cateName", null);
                if (string3 != null && Boolean.valueOf(string3).booleanValue()) {
                    string2 = "${CATEGORY}";
                }
                if ((string3 = xMLableReader.getAttrAsString("seriesName", null)) != null && Boolean.valueOf(string3).booleanValue()) {
                    string2 = string2 != null ? string2 + "${SERIES}" : "${SERIES}";
                }
                if ((string3 = xMLableReader.getAttrAsString("showValue", null)) != null && Boolean.valueOf(string3).booleanValue()) {
                    string2 = string2 != null ? string2 + "${VALUE}" : "${VALUE}";
                }
                if ((string3 = xMLableReader.getAttrAsString("piePercent", null)) != null && Boolean.valueOf(string3).booleanValue()) {
                    string2 = string2 != null ? string2 + "${PERCENT}" : "${PERCENT}";
                }
                this.setPosition(xMLableReader.getAttrAsInt("position", 1));
                if (xMLableReader.getAttrAsString("seriesLabel", null) != null) {
                    this.setSeriesLabel(xMLableReader.getAttrAsString("seriesLabel", null));
                }
            } else if ("TextAttr".equals(string)) {
                this.seriesLabelContents.setTextAttr((TextAttr)xMLableReader.readXMLObject(new TextAttr()));
            } else if ("Format".equals(string)) {
                this.seriesLabelContents.setFormat(BaseXMLUtils.readFormat(xMLableReader));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("XMLable");
        xMLPrintWriter.startTAG("Attr").attr("position", this.getPosition());
        if (this.getSeriesLabel() != null) {
            xMLPrintWriter.attr("seriesLabel", this.getSeriesLabel());
        }
        xMLPrintWriter.end();
        if (this.getTextAttr() != null) {
            this.getTextAttr().writeXML(xMLPrintWriter);
        }
        if (this.getFormat() != null) {
            BaseXMLUtils.writeFormat(xMLPrintWriter, this.getFormat());
        }
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        DataPointLabelInfo dataPointLabelInfo = (DataPointLabelInfo)super.clone();
        if (this.getTextAttr() != null) {
            dataPointLabelInfo.setTextAttr((TextAttr)this.getTextAttr().clone());
        }
        if (this.getFormat() != null) {
            dataPointLabelInfo.setFormat((Format)this.getFormat().clone());
        }
        return dataPointLabelInfo;
    }

    public boolean equals(Object object) {
        return object instanceof DataPointLabelInfo && ComparatorUtils.equals(((DataPointLabelInfo)object).getSeriesLabel(), this.getSeriesLabel()) && ((DataPointLabelInfo)object).getPosition() == this.getPosition() && ComparatorUtils.equals(((DataPointLabelInfo)object).getFormat(), this.getFormat()) && ComparatorUtils.equals(((DataPointLabelInfo)object).getTextAttr(), this.getTextAttr());
    }

    public void changeStyleAttrAlpha(AttrAlpha attrAlpha) {
    }

    public void changeStyleAttrBackground(AttrBackground attrBackground) {
    }

    public void changeStyleAttrBorder(AttrBorder attrBorder) {
    }

    public void changeStyleAttrColor(AttrColor attrColor) {
    }

    public void changeStyleAttrContents(AttrContents attrContents) {
        this.setSeriesLabelContents(attrContents);
    }

    public void changeStyleAttrLineStyle(AttrLineStyle attrLineStyle) {
    }
}

