/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.chart.base.AttrAlpha;
import com.fr.chart.base.AttrBackground;
import com.fr.chart.base.AttrBorder;
import com.fr.chart.base.AttrColor;
import com.fr.chart.base.AttrContents;
import com.fr.chart.base.AttrLineStyle;
import com.fr.chart.base.AttrMarkerType;
import com.fr.chart.base.ChartConstants;
import com.fr.chart.base.DataSeriesCondition;
import com.fr.chart.base.SimpleResult;
import com.fr.chart.base.StyleContactWithConditionCollection;
import com.fr.chart.chartglyph.ConditionAttr;
import com.fr.chart.chartglyph.ConditionAttrFactory;
import com.fr.chart.chartglyph.CustomAttr;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.data.condition.CommonCondition;
import com.fr.data.condition.ListCondition;
import com.fr.data.condition.Result;
import com.fr.general.ComparatorUtils;
import com.fr.general.data.MOD_COLUMN_ROW;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.xml.XMLObject;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class ConditionCollection
implements XMLable {
    private static final long serialVersionUID = 1829765835005242032L;
    public static final String XML_TAG = "ConditionCollection";
    private List conditionAttrList = new ArrayList();
    private ConditionAttr defaultAttr = new ConditionAttr();

    public void addConditionAttr(ConditionAttr conditionAttr) {
        this.conditionAttrList.add(conditionAttr);
    }

    public boolean isDefaultNullMarker() {
        AttrMarkerType attrMarkerType;
        return this.getDefaultAttr().getExisted(AttrMarkerType.class) != null && !ComparatorUtils.equals((attrMarkerType = (AttrMarkerType)this.getDefaultAttr().getExisted(AttrMarkerType.class)).getMarkerType(), "NullMarker");
    }

    public int getConditionAttrSize() {
        return this.conditionAttrList == null ? 0 : this.conditionAttrList.size();
    }

    public ConditionAttr getConditionAttr(int n2) {
        if (n2 < -1 || n2 > this.getConditionAttrSize() - 1) {
            return null;
        }
        return (ConditionAttr)this.conditionAttrList.get(n2);
    }

    public DataSeriesCondition getDataSeriesCondition(Class clazz, Result result, Color[] colorArray) {
        DataSeriesCondition dataSeriesCondition = this.getAttrByResult(result).getExisted(clazz);
        if (dataSeriesCondition == null && (dataSeriesCondition = this.defaultAttr.getExisted(clazz)) == null) {
            dataSeriesCondition = ConditionAttrFactory.createConditionAttr(clazz, result.getSeriesIndex(), colorArray);
        }
        return dataSeriesCondition;
    }

    public DataSeriesCondition getDataSeriesCondition(Class clazz, int n2) {
        return this.getDataSeriesCondition(clazz, new SimpleResult(n2), null);
    }

    public DataSeriesCondition getDataSeriesCondition(Class clazz, Result result) {
        return this.getDataSeriesCondition(clazz, result, null);
    }

    public void clearConditionAttr() {
        this.conditionAttrList.clear();
    }

    public ConditionAttr getDefaultAttr() {
        return this.defaultAttr;
    }

    public void setDefaultAttr(ConditionAttr conditionAttr) {
        this.defaultAttr = conditionAttr;
    }

    public ConditionAttr getAttrByResult(Result result) {
        Calculator calculator = Calculator.createCalculator();
        ConditionAttr conditionAttr = this.defaultAttr;
        int n2 = this.getConditionAttrSize();
        for (int i2 = 0; i2 < n2; ++i2) {
            ConditionAttr conditionAttr2 = this.getConditionAttr(i2);
            if (!conditionAttr2.eval(result, calculator)) continue;
            conditionAttr = conditionAttr2;
        }
        return conditionAttr;
    }

    public ConditionAttr getAttrBySeriesIndex(int n2) {
        return this.getAttrByResult(new SimpleResult(n2));
    }

    public void dealFormula(Calculator calculator) {
        int n2;
        if (this.defaultAttr != null) {
            this.defaultAttr.dealFormula(calculator);
        }
        if ((n2 = this.getConditionAttrSize()) > 0) {
            for (int i2 = 0; i2 < n2; ++i2) {
                ConditionAttr conditionAttr = (ConditionAttr)this.conditionAttrList.get(i2);
                conditionAttr.dealFormula(calculator);
            }
        }
    }

    public void modFormulaString(MOD_COLUMN_ROW mOD_COLUMN_ROW) {
        int n2;
        if (this.defaultAttr != null) {
            this.defaultAttr.modFormulaString(mOD_COLUMN_ROW);
        }
        if ((n2 = this.getConditionAttrSize()) > 0) {
            for (int i2 = 0; i2 < n2; ++i2) {
                ConditionAttr conditionAttr = (ConditionAttr)this.conditionAttrList.get(i2);
                conditionAttr.modFormulaString(mOD_COLUMN_ROW);
            }
        }
    }

    public void buidExecuteSequenceList(List list, Calculator calculator) {
        int n2;
        if (this.defaultAttr != null) {
            this.defaultAttr.buidExecuteSequenceList(list, calculator);
        }
        if ((n2 = this.getConditionAttrSize()) > 0) {
            for (int i2 = 0; i2 < n2; ++i2) {
                ConditionAttr conditionAttr = (ConditionAttr)this.conditionAttrList.get(i2);
                conditionAttr.buidExecuteSequenceList(list, calculator);
            }
        }
    }

    public void changeStyleConditionWithInfo(StyleContactWithConditionCollection styleContactWithConditionCollection, Result result, Color[] colorArray) {
        styleContactWithConditionCollection.changeStyleAttrColor((AttrColor)this.getDataSeriesCondition(AttrColor.class, result, colorArray));
        styleContactWithConditionCollection.changeStyleAttrAlpha((AttrAlpha)this.getDataSeriesCondition(AttrAlpha.class, result, colorArray));
        styleContactWithConditionCollection.changeStyleAttrBorder((AttrBorder)this.getDataSeriesCondition(AttrBorder.class, result, colorArray));
        styleContactWithConditionCollection.changeStyleAttrBackground((AttrBackground)this.getDataSeriesCondition(AttrBackground.class, result, colorArray));
        styleContactWithConditionCollection.changeStyleAttrContents((AttrContents)this.getDataSeriesCondition(AttrContents.class, result, null));
        styleContactWithConditionCollection.changeStyleAttrLineStyle((AttrLineStyle)this.getDataSeriesCondition(AttrLineStyle.class, result, null));
    }

    public void changeBackgroundWithInfo(StyleContactWithConditionCollection styleContactWithConditionCollection, Result result, Color[] colorArray) {
        styleContactWithConditionCollection.changeStyleAttrBackground((AttrBackground)this.getDataSeriesCondition(AttrBackground.class, result, colorArray));
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("DefaultAttr")) {
                this.defaultAttr = (ConditionAttr)GeneralXMLTools.readXMLable(xMLableReader);
            } else if (string.equals("ConditionAttrList")) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        int n2;
                        if (xMLableReader.isChildNode() && "List".equals(xMLableReader.getTagName()) && (n2 = xMLableReader.getAttrAsInt("index", -1)) != -1) {
                            xMLableReader.readXMLObject(new XMLObject(new Integer(n2)){

                                public void readXML(XMLableReader xMLableReader) {
                                    if (xMLableReader.isChildNode()) {
                                        String string = xMLableReader.getTagName();
                                        if (string.equals("ConditionAttr")) {
                                            ConditionAttr conditionAttr = new ConditionAttr();
                                            conditionAttr.readXML(xMLableReader);
                                            ConditionCollection.this.conditionAttrList.add(conditionAttr);
                                        } else if (string.equals("CustomAttr")) {
                                            CustomAttr customAttr = new CustomAttr();
                                            xMLableReader.readXMLObject(customAttr);
                                            ConditionCollection.this.conditionAttrList.add(customAttr);
                                        }
                                    }
                                }
                            });
                        }
                    }
                });
            } else if (string.equals("SeriesAttr")) {
                String string2 = xMLableReader.getAttrAsString("class", null);
                if (string2 != null) {
                    this.defaultAttr = string2.endsWith("CustomAttr") ? (CustomAttr)xMLableReader.readXMLObject(new CustomAttr()) : (ConditionAttr)xMLableReader.readXMLObject(new ConditionAttr());
                }
            } else if (ComparatorUtils.equals(string, "SeriesAttrMap")) {
                this.comOldAttr(xMLableReader);
            }
        }
    }

    private void comOldAttr(XMLableReader xMLableReader) {
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                int n2;
                if ("Entry".equals(xMLableReader.getTagName()) && (n2 = xMLableReader.getAttrAsInt("index", -1)) != -1) {
                    xMLableReader.readXMLObject(new XMLObject(new Integer(n2 + 1)){

                        public void readXML(XMLableReader xMLableReader) {
                            String string;
                            if (xMLableReader.isChildNode() && ComparatorUtils.equals(xMLableReader.getTagName(), "SeriesAttr") && (string = xMLableReader.getAttrAsString("class", null)) != null) {
                                ConditionAttr conditionAttr = null;
                                conditionAttr = string.endsWith("CustomAttr") ? (CustomAttr)xMLableReader.readXMLObject(new CustomAttr()) : (ConditionAttr)xMLableReader.readXMLObject(new ConditionAttr());
                                ListCondition listCondition = new ListCondition();
                                listCondition.addJoinCondition(0, new CommonCondition(ChartConstants.SERIES_INDEX, 0, this.obj));
                                conditionAttr.setCondition(listCondition);
                                ConditionCollection.this.conditionAttrList.add(conditionAttr);
                            }
                        }
                    });
                }
            }
        });
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        if (this.defaultAttr != null) {
            GeneralXMLTools.writeXMLable(xMLPrintWriter, this.defaultAttr, "DefaultAttr");
        }
        if (this.conditionAttrList != null && this.conditionAttrList.size() > 0) {
            xMLPrintWriter.startTAG("ConditionAttrList");
            for (int i2 = 0; i2 < this.conditionAttrList.size(); ++i2) {
                xMLPrintWriter.startTAG("List").attr("index", i2);
                ((ConditionAttr)this.conditionAttrList.get(i2)).writeXML(xMLPrintWriter);
                xMLPrintWriter.end();
            }
            xMLPrintWriter.end();
        }
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        ConditionCollection conditionCollection = (ConditionCollection)super.clone();
        if (this.defaultAttr != null) {
            conditionCollection.defaultAttr = (ConditionAttr)this.defaultAttr.clone();
        }
        if (this.conditionAttrList != null && this.conditionAttrList != null) {
            conditionCollection.conditionAttrList = new ArrayList();
            for (int i2 = 0; i2 < this.conditionAttrList.size(); ++i2) {
                conditionCollection.conditionAttrList.add(((ConditionAttr)this.conditionAttrList.get(i2)).clone());
            }
        }
        return conditionCollection;
    }

    public boolean equals(Object object) {
        return object instanceof ConditionCollection && ComparatorUtils.equals(((ConditionCollection)object).defaultAttr, this.defaultAttr) && ComparatorUtils.equals(((ConditionCollection)object).conditionAttrList, this.conditionAttrList);
    }

    public JSONObject toJSONObject(DataSeries[] dataSeriesArray) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (this.getConditionAttrSize() > 0) {
            JSONArray jSONArray = new JSONArray();
            for (int i2 = 0; i2 < this.getConditionAttrSize(); ++i2) {
                jSONArray.put(this.getConditionAttr(i2).toJSONObject(dataSeriesArray));
            }
            jSONObject.put("conditionAttrList", jSONArray);
        }
        if (this.defaultAttr != null) {
            jSONObject.put("defaultAttr", this.defaultAttr.toJSONObject());
        }
        return jSONObject;
    }
}

