/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.FRContext;
import com.fr.base.GraphHelper;
import com.fr.base.chart.BaseChartGlyph;
import com.fr.base.chart.Glyph;
import com.fr.chart.base.AttrFillStyle;
import com.fr.chart.base.ChartUtils;
import com.fr.chart.chartglyph.ChartGlyphLayout;
import com.fr.chart.chartglyph.DataSheetGlyph;
import com.fr.chart.chartglyph.LegendGlyph;
import com.fr.chart.chartglyph.MapPlotGlyph;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.chart.chartglyph.RectangleGlyph;
import com.fr.chart.chartglyph.TitleGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.CoreGraphHelper;
import com.fr.stable.web.Repository;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ChartGlyph
extends RectangleGlyph
implements BaseChartGlyph {
    private static final long serialVersionUID = -4023596592305921803L;
    private PlotGlyph plotGlyph;
    private LegendGlyph legendGlyph;
    private TitleGlyph titleGlyph;
    private DataSheetGlyph dataSheetGlyph;
    private boolean isJSDraw = false;
    private boolean isUseChangeChart = false;

    public void setPlotGlyph(PlotGlyph plotGlyph) {
        this.plotGlyph = plotGlyph;
    }

    public PlotGlyph getPlotGlyph() {
        return this.plotGlyph;
    }

    public void setLegendGlyph(LegendGlyph legendGlyph) {
        this.legendGlyph = legendGlyph;
    }

    public LegendGlyph getLegendGlyph() {
        return this.legendGlyph;
    }

    public void setTitleGlyph(TitleGlyph titleGlyph) {
        this.titleGlyph = titleGlyph;
    }

    public TitleGlyph getTitleGlyph() {
        return this.titleGlyph;
    }

    public void setJSDraw(boolean bl) {
        this.isJSDraw = bl;
    }

    public boolean isJSDraw() {
        return this.isJSDraw;
    }

    public void setUseChangeChart(boolean bl) {
        this.isUseChangeChart = bl;
    }

    public boolean isUseChangeChart() {
        return this.isUseChangeChart;
    }

    public void setDataSheetGlyph(DataSheetGlyph dataSheetGlyph) {
        this.dataSheetGlyph = dataSheetGlyph;
    }

    public DataSheetGlyph getDataSheetGlyph() {
        return this.dataSheetGlyph;
    }

    public Iterator selectableChildren() {
        ArrayList<RectangleGlyph> arrayList = new ArrayList<RectangleGlyph>();
        arrayList.add(this.plotGlyph);
        if (this.legendGlyph != null) {
            arrayList.add(this.legendGlyph);
        }
        if (this.titleGlyph != null) {
            arrayList.add(this.titleGlyph);
        }
        if (this.dataSheetGlyph != null) {
            arrayList.add(this.dataSheetGlyph);
        }
        return arrayList.iterator();
    }

    public Image toImage(int n2, int n3, int n4) {
        BufferedImage bufferedImage = CoreGraphHelper.createBufferedImage(n2, n3, 6);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        double d2 = this.do4IEBorderSize(GraphHelper.getLineStyleSize(this.getBorderStyle()));
        double d3 = this.do4IEGap(GraphHelper.getLineStyleSize(this.getBorderStyle()));
        this.makeSureBounds(d2, n2, n3);
        graphics2D.translate(d3 / 2.0, d3 / 2.0);
        this.draw(graphics2D, n4);
        bufferedImage.flush();
        graphics2D.translate(-d3 / 2.0, -d3 / 2.0);
        graphics2D.dispose();
        return bufferedImage;
    }

    public Map toJSONMap(String[] stringArray, double d2, double d3, Repository repository, int n2) {
        PlotGlyph plotGlyph = this.getPlotGlyph();
        if (plotGlyph != null && plotGlyph.isNeedDealHotHyperlink()) {
            plotGlyph.dealPlotHotAttr(repository);
        }
        JSONObject jSONObject = null;
        String string = "";
        try {
            jSONObject = this.toJSONObject(repository);
            string = JSONObject.valueToString(stringArray);
        }
        catch (JSONException jSONException) {
            FRContext.getLogger().error("ChartGlyph error in toJS");
            jSONObject = new JSONObject();
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("chartAttr", jSONObject);
        hashMap.put("width", String.valueOf(d2));
        hashMap.put("height", String.valueOf(d3));
        hashMap.put("dependence", string);
        hashMap.put("autoRefreshTime", Integer.valueOf("" + plotGlyph.getAutoRefreshPerSecond()));
        if (this.getPlotGlyph() instanceof MapPlotGlyph && repository.getBrowser().isIE()) {
            hashMap.put("actionModel", "1");
        } else if (this.isJSDraw()) {
            hashMap.put("actionModel", "0");
        } else {
            hashMap.put("actionModel", "1");
        }
        hashMap.put("sheetIndex", n2);
        String string2 = this.getCanvasInfo();
        hashMap.put("canvasInfo", string2);
        hashMap.put("canvasCount", this.getCanvasCount(string2));
        return hashMap;
    }

    public Image toImageWithoutDefaultTitle(int n2, int n3, int n4) {
        if (this.titleGlyph != null && ComparatorUtils.equals(this.titleGlyph.getText(), Inter.getLocText("Chart_Title"))) {
            this.titleGlyph = null;
        }
        return this.toImage(n2, n3, n4);
    }

    private double do4IEBorderSize(double d2) {
        return d2 == 1.0 ? 2.0 : d2;
    }

    private double do4IEGap(double d2) {
        return d2 == 2.0 ? 0.0 : d2;
    }

    private void makeSureBounds(double d2, int n2, int n3) {
        if (this.isRoundBorder()) {
            this.setBounds(new RoundRectangle2D.Double(0.0, 0.0, (double)n2 - d2, (double)n3 - d2, 10.0, 10.0));
        } else {
            this.setBounds(new Rectangle2D.Double(0.0, 0.0, (double)n2 - d2, (double)n3 - d2));
        }
    }

    public void draw(Graphics graphics, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        super.draw(graphics2D, n2);
        ChartGlyphLayout.doLayout(this, n2);
        this.drawGlyph(this.plotGlyph, graphics2D, n2);
        this.drawGlyph(this.legendGlyph, graphics2D, n2);
        this.drawGlyph(this.dataSheetGlyph, graphics2D, n2);
        this.drawGlyph(this.titleGlyph, graphics2D, n2);
        this.renewGraphics(graphics2D, paint, object);
    }

    private void drawGlyph(Glyph glyph, Graphics2D graphics2D, int n2) {
        if (glyph != null) {
            glyph.draw(graphics2D.create(), n2);
        }
    }

    private void renewGraphics(Graphics2D graphics2D, Paint paint, Object object) {
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
        if (object == null) {
            object = RenderingHints.VALUE_ANTIALIAS_OFF;
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        graphics2D.setPaint(paint);
    }

    public boolean equals(Object object) {
        return object instanceof ChartGlyph && super.equals(object) && ComparatorUtils.equals(((ChartGlyph)object).getPlotGlyph(), this.getPlotGlyph()) && ComparatorUtils.equals(((ChartGlyph)object).getTitleGlyph(), this.getTitleGlyph()) && ComparatorUtils.equals(((ChartGlyph)object).getLegendGlyph(), this.getLegendGlyph()) && ComparatorUtils.equals(((ChartGlyph)object).getDataSheetGlyph(), this.getDataSheetGlyph()) && ((ChartGlyph)object).isJSDraw() == this.isJSDraw;
    }

    public Object clone() throws CloneNotSupportedException {
        ChartGlyph chartGlyph = (ChartGlyph)super.clone();
        if (this.legendGlyph != null) {
            chartGlyph.legendGlyph = (LegendGlyph)this.legendGlyph.clone();
        }
        if (this.titleGlyph != null) {
            chartGlyph.titleGlyph = (TitleGlyph)this.titleGlyph.clone();
        }
        if (this.plotGlyph != null) {
            chartGlyph.plotGlyph = (PlotGlyph)this.plotGlyph.clone();
        }
        if (this.dataSheetGlyph != null) {
            chartGlyph.dataSheetGlyph = (DataSheetGlyph)this.dataSheetGlyph.clone();
            chartGlyph.dataSheetGlyph.setDataWithoutLegendItems(chartGlyph.plotGlyph);
        }
        return chartGlyph;
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        if (this.plotGlyph != null) {
            jSONObject.put("plotType", this.plotGlyph.getPlotGlyphType());
            jSONObject.put("plotGlyph", this.plotGlyph.toJSONObject(repository));
        }
        if (this.legendGlyph != null) {
            jSONObject.put("legendGlyph", this.legendGlyph.toJSONObject());
        }
        if (this.titleGlyph != null) {
            jSONObject.put("titleGlyph", this.titleGlyph.toJSONObject());
        }
        if (this.dataSheetGlyph != null) {
            jSONObject.put("dataSheetGlyph", this.dataSheetGlyph.toJSONObject());
        }
        jSONObject.put("isUseChangeChart", this.isUseChangeChart);
        AttrFillStyle attrFillStyle = ChartUtils.getColorFillStyleInPre();
        if (attrFillStyle != null) {
            jSONObject.put("currentStyle", attrFillStyle.toJSONObject());
        }
        String string = this.getCanvasInfo();
        jSONObject.put("canvasInfo", string);
        jSONObject.put("canvasCount", this.getCanvasCount(string));
        jSONObject.put("isFromReport", true);
        return jSONObject;
    }

    private String getCanvasInfo() {
        String string;
        String string2;
        String string3 = "";
        String string4 = string2 = this.getBackground() == null ? "" : this.getBackground().getBackgroundType();
        if (ComparatorUtils.equals(string2, "ImageBackground") || ComparatorUtils.equals(string2, "PatterBackground")) {
            string3 = string3 + "chart";
        }
        String string5 = string = this.plotGlyph == null || this.plotGlyph.getBackground() == null ? "" : this.plotGlyph.getBackground().getBackgroundType();
        if (ComparatorUtils.equals(string, "ImageBackground") || ComparatorUtils.equals(string, "PatterBackground") || this.plotGlyph instanceof MapPlotGlyph) {
            string3 = string3 + "plot";
        }
        return string3;
    }

    private int getCanvasCount(String string) {
        int n2 = 3;
        if (string.indexOf("chart") != -1) {
            ++n2;
        }
        if (string.indexOf("plot") != -1) {
            ++n2;
        }
        return n2;
    }
}

