/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.chartglyph.AxisGlyph;
import com.fr.chart.chartglyph.BarDataWithAxisGlyph;
import com.fr.chart.chartglyph.CategoryPlotGlyph;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.DateAxisGlyph;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.util.Date;

public abstract class BarPlotGlyph
extends CategoryPlotGlyph {
    private static final long serialVersionUID = 6835951801934449612L;
    private static final double GAP = 0.13;
    private static final double MAX_WIDTH = 40.0;
    protected boolean isHorizontal = false;
    protected double seriesOverlapPercent = -0.2;
    protected double categoryIntervalPercent = 2.0;

    public void setHorizontal(boolean bl) {
        this.isHorizontal = bl;
    }

    public boolean isHorizontal() {
        return this.isHorizontal;
    }

    public void setSeriesOverlapPercent(double d2) {
        this.seriesOverlapPercent = d2;
    }

    public void setCategoryIntervalPercent(double d2) {
        this.categoryIntervalPercent = d2;
    }

    protected Rectangle2D getBarShape(DataSeries dataSeries, CategoryPlotGlyph categoryPlotGlyph, int n2, BarDataWithAxisGlyph barDataWithAxisGlyph) {
        double d2 = this.getBarPercent(barDataWithAxisGlyph.barNumber);
        double d3 = d2 * (1.0 - this.seriesOverlapPercent) * (double)barDataWithAxisGlyph.barIndex + 0.5 * this.categoryIntervalPercent * d2 + (double)barDataWithAxisGlyph.xAxisGlyph.getTickIndex4Value(n2);
        double d4 = this.getDataPointPercentValue(dataSeries.getSeriesIndex(), n2);
        double d5 = barDataWithAxisGlyph.yAxisGlyph.getCrossValueInPlot();
        double d6 = barDataWithAxisGlyph.xAxisGlyph.getUnitLen() * d2;
        double d7 = this.calculateCateStart(barDataWithAxisGlyph, d2, d3);
        double[] dArray = this.calculateValueStartAndLength(dataSeries, categoryPlotGlyph, barDataWithAxisGlyph, d4, d5, n2);
        if (this.isHorizontal()) {
            return new Rectangle2D.Double(dArray[0], d7, dArray[1], d6);
        }
        return new Rectangle2D.Double(d7, dArray[0], d6, dArray[1]);
    }

    private double calculateCateStart(BarDataWithAxisGlyph barDataWithAxisGlyph, double d2, double d3) {
        if (this.isHorizontal()) {
            if (this.getxAxisGlyph().hasAxisReversed()) {
                return barDataWithAxisGlyph.xAxisGlyph.getPoint2D(d3).getY();
            }
            return barDataWithAxisGlyph.xAxisGlyph.getPoint2D(d3 + d2).getY();
        }
        if (this.getxAxisGlyph().hasAxisReversed()) {
            return barDataWithAxisGlyph.xAxisGlyph.getPoint2D(d3 + d2).getX();
        }
        return barDataWithAxisGlyph.xAxisGlyph.getPoint2D(d3).getX();
    }

    private double[] calculateValueStartAndLength(DataSeries dataSeries, CategoryPlotGlyph categoryPlotGlyph, BarDataWithAxisGlyph barDataWithAxisGlyph, double d2, double d3, int n2) {
        if (this.isStacked()) {
            return this.valueStartAndLength4Stacked(dataSeries, categoryPlotGlyph, barDataWithAxisGlyph, d2, n2);
        }
        return this.valueStartAndLength4Unstacked(dataSeries, barDataWithAxisGlyph, d2, d3, n2);
    }

    private double[] valueStartAndLength4Stacked(DataSeries dataSeries, CategoryPlotGlyph categoryPlotGlyph, BarDataWithAxisGlyph barDataWithAxisGlyph, double d2, int n2) {
        double d3;
        double d4;
        boolean bl = this.getyAxisGlyph().hasAxisReversed();
        if (d2 >= 0.0) {
            double d5 = categoryPlotGlyph.getPreSum4Bar(dataSeries.getSeriesIndex(), n2, false);
            d4 = this.isHorizontal() ? (bl ? barDataWithAxisGlyph.yAxisGlyph.getPointInBounds(d5 + d2).getX() : barDataWithAxisGlyph.yAxisGlyph.getPointInBounds(d5).getX()) : (bl ? barDataWithAxisGlyph.yAxisGlyph.getPointInBounds(d5).getY() : barDataWithAxisGlyph.yAxisGlyph.getPointInBounds(d5 + d2).getY());
            d3 = barDataWithAxisGlyph.yAxisGlyph.get2ValueLength(d5, d5 + d2);
        } else {
            double d6 = categoryPlotGlyph.getPreSum4Bar(dataSeries.getSeriesIndex(), n2, true);
            d4 = this.isHorizontal() ? (bl ? barDataWithAxisGlyph.yAxisGlyph.getPointInBounds(d6).getX() : barDataWithAxisGlyph.yAxisGlyph.getPointInBounds(d6 + d2).getX()) : (bl ? barDataWithAxisGlyph.yAxisGlyph.getPointInBounds(d6 + d2).getY() : barDataWithAxisGlyph.yAxisGlyph.getPointInBounds(d6).getY());
            d3 = barDataWithAxisGlyph.yAxisGlyph.get2ValueLength(d6 + d2, d6);
        }
        return new double[]{d4, d3};
    }

    private double[] valueStartAndLength4Unstacked(DataSeries dataSeries, BarDataWithAxisGlyph barDataWithAxisGlyph, double d2, double d3, int n2) {
        double d4 = d2 > d3 ? (this.isHorizontal() ? (this.getyAxisGlyph().hasAxisReversed() ? barDataWithAxisGlyph.yAxisGlyph.getPointInBounds(d2).getX() : barDataWithAxisGlyph.yAxisGlyph.getPointInBounds(d3).getX()) : (this.getyAxisGlyph().hasAxisReversed() ? barDataWithAxisGlyph.yAxisGlyph.getPointInBounds(d3).getY() : barDataWithAxisGlyph.yAxisGlyph.getPointInBounds(d2).getY())) : (this.isHorizontal() ? (this.getyAxisGlyph().hasAxisReversed() ? barDataWithAxisGlyph.yAxisGlyph.getPointInBounds(d3).getX() : barDataWithAxisGlyph.yAxisGlyph.getPointInBounds(d2).getX()) : (this.getyAxisGlyph().hasAxisReversed() ? barDataWithAxisGlyph.yAxisGlyph.getPointInBounds(d2).getY() : barDataWithAxisGlyph.yAxisGlyph.getPointInBounds(d3).getY()));
        double d5 = barDataWithAxisGlyph.yAxisGlyph.get2ValueLength(d2, d3);
        return new double[]{d4, d5};
    }

    protected double getBarPercent(int n2) {
        return 1.0 / ((double)n2 - (double)(n2 - 1) * this.seriesOverlapPercent + this.categoryIntervalPercent);
    }

    protected Rectangle2D getBarShape4GanttPlot(double d2, double d3, int n2, AxisGlyph axisGlyph, AxisGlyph axisGlyph2, int n3, int n4) {
        double d4 = this.getBarPercent(n3);
        double d5 = d4 * (1.0 - this.seriesOverlapPercent) * (double)n4 + (double)axisGlyph.getTickIndex4Value(n2) + 0.5 * this.categoryIntervalPercent * d4;
        Date date = ChartBaseUtils.long2Date((long)d2, 6);
        double d6 = ChartBaseUtils.date2Int(date, ((DateAxisGlyph)axisGlyph2).getMainType());
        Date date2 = ChartBaseUtils.long2Date((long)d3, 6);
        double d7 = ChartBaseUtils.date2Int(date2, ((DateAxisGlyph)axisGlyph2).getMainType());
        double d8 = axisGlyph2.getPointInBounds(d6).getX();
        double d9 = axisGlyph.getPointInBounds(d5).getY();
        double d10 = axisGlyph2.getPointInBounds(d7).getX() - d8;
        double d11 = axisGlyph.getUnitLen() * d4;
        double d12 = axisGlyph.getPointInBounds(n2).getY();
        double d13 = d12 + axisGlyph.getUnitLen();
        double d14 = 3.0;
        double d15 = 40.0;
        if (d9 < d12 + d14) {
            d11 -= (d12 + d14 - d9) * 2.0;
            d9 = d12 + d14;
        }
        if (d9 + d11 > d13 - d14) {
            d11 -= (d9 + d11 - d13 + d14) * 2.0;
            d9 = d13 - d14 - d11;
        }
        if (d11 > d15) {
            d9 += (d11 - d15) / 2.0;
            d11 = d15;
        }
        return new Rectangle2D.Double(d8, d9, d10, d11);
    }

    protected Rectangle2D getDataPointLabelBoundsWithPosition(Dimension2D dimension2D, Rectangle2D rectangle2D, int n2) {
        if (this.isHorizontal()) {
            return this.getLabelBoundsInHorizontal(dimension2D, rectangle2D, n2);
        }
        return this.getLabelBoundsInVertical(dimension2D, rectangle2D, n2);
    }

    protected abstract Rectangle2D getLabelBoundsInVertical(Dimension2D var1, Rectangle2D var2, int var3);

    protected abstract Rectangle2D getLabelBoundsInHorizontal(Dimension2D var1, Rectangle2D var2, int var3);

    public boolean equals(Object object) {
        return object instanceof BarPlotGlyph && super.equals(object) && ((BarPlotGlyph)object).isHorizontal == this.isHorizontal && ((BarPlotGlyph)object).seriesOverlapPercent == this.seriesOverlapPercent && ((BarPlotGlyph)object).categoryIntervalPercent == this.categoryIntervalPercent;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        jSONObject.put("seriesOverlapPercent", this.seriesOverlapPercent);
        jSONObject.put("isHorizontal", this.isHorizontal);
        jSONObject.put("categoryIntervalPercent", this.categoryIntervalPercent);
        return jSONObject;
    }
}

