/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.chart.chartglyph.BarDataWithAxisGlyph;
import com.fr.chart.chartglyph.BarPlotGlyph;
import com.fr.chart.chartglyph.Cubic;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.Plot3DGlyph;
import com.fr.chart.chartglyph.Projection;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Bar3DPlotGlyph
extends BarPlotGlyph
implements Plot3DGlyph {
    private static final long serialVersionUID = -8494817723580336519L;
    private static final double ZP = 100.0;
    private static final double LABEL_BAR_GAP = 8.0;
    private double seriesIntervalPercent = 0.0;
    private int deep = -1;
    private int deepBase = -1;
    private boolean horizontalDrawBar = false;
    private Projection projection = new Projection();

    public void setSeriesIntervalPercent(double d2) {
        this.seriesIntervalPercent = d2;
    }

    public void setDeep(int n2) {
        this.deep = n2;
    }

    public int getDeep() {
        return this.deep;
    }

    public void set3DDeepBase(int n2) {
        this.deepBase = n2;
    }

    public int getDeepBase() {
        return this.deepBase;
    }

    public void setHorizontalDrawBar(boolean bl) {
        this.horizontalDrawBar = bl;
    }

    public boolean isHorizontalDrawBar() {
        return this.horizontalDrawBar;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public void setProjection(Projection projection) {
        this.projection = projection;
    }

    protected void resetClip(Graphics2D graphics2D) {
    }

    public void layoutAxisGlyph(int n2) {
        this.resetPlotBoundsWith3DDeepAndProjectionBeforeAxisGlyph();
        this.layoutAxisGlyph4ThreeD(this.getxAxisGlyph(), this.getyAxisGlyph(), n2);
        if (this.isHorizontal) {
            this.threeDBase.setCovers(new byte[]{2});
        } else {
            this.threeDBase.setCovers(new byte[]{1});
        }
        this.threeDBase.setIsHorizontal(this.isHorizontal);
    }

    public void layoutDataSeriesGlyph(int n2) {
        GeneralPath generalPath = new GeneralPath();
        this.reinitDeep();
        int n3 = this.getSeriesSize();
        for (int i2 = 0; i2 < n3; ++i2) {
            DataSeries dataSeries = this.getSeries(i2);
            int n4 = dataSeries.getDataPointCount();
            for (int i3 = 0; i3 < n4; ++i3) {
                DataPoint dataPoint = dataSeries.getDataPoint(i3);
                if (dataPoint.isValueIsNull()) continue;
                this.dealWithDataPoint(dataSeries, dataPoint, generalPath, i2, i3, n2);
            }
        }
        this.dealLabelBoundsInOrder();
    }

    private void reinitDeep() {
        if (this.deep == -1) {
            this.deep = this.getProjection().projecteeDeep(this.getDeepBase());
        }
    }

    private void dealWithDataPoint(DataSeries dataSeries, DataPoint dataPoint, GeneralPath generalPath, int n2, int n3, int n4) {
        Cubic cubic = new Cubic();
        if (this.getSeriesSize() == 1) {
            cubic.dealCondition(this.getConditionCollection(), dataPoint, this.createColors4Series());
            cubic.dealConditionWithSeriesColor(this.getConditionCollection(), dataPoint, this.createColors4Cate());
        } else {
            cubic.dealCondition(this.getConditionCollection(), dataPoint, this.createColors4Series());
        }
        dataPoint.setDrawImpl(cubic);
        Rectangle2D rectangle2D = this.getBarShape(dataSeries, this, n3, new BarDataWithAxisGlyph(this.getxAxisGlyph(), this.getSeriesAxisGlyph(n2), this.getSeriesSize(), n2));
        double d2 = 0.0;
        double d3 = 0.0;
        if (!this.isStacked()) {
            d2 = (double)this.deep / ((1.0 + this.seriesIntervalPercent) * (double)this.getSeriesSize());
            d3 = -this.seriesIntervalPercent * d2 * (0.5 + (double)n2) - d2 * (double)n2;
        } else {
            d2 = (double)this.deep / (1.0 + this.seriesIntervalPercent);
            d3 = -this.seriesIntervalPercent * d2 / 2.0;
        }
        if (this.horizontalDrawBar) {
            d3 = 0.0;
            d2 = 100.0;
        }
        cubic.setCubic(rectangle2D.getX(), rectangle2D.getY(), d3, rectangle2D.getWidth(), rectangle2D.getHeight(), d2);
        this.dealDataPointLabel(dataPoint, n4);
    }

    public void draw(Graphics graphics, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.draw3DInfo(graphics, n2);
        this.drawAxisGlyph4ThreeD(this.getyAxisGlyph(), graphics, n2);
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        this.drawAxisGlyph4ThreeD(this.getxAxisGlyph(), graphics, n2);
        if (!this.isStacked()) {
            this.drawWhenUnStacked(graphics2D, n2);
        } else {
            this.drawWhenStacked(graphics2D, n2);
        }
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
    }

    private void drawWhenUnStacked(Graphics2D graphics2D, int n2) {
        int n3;
        if (this.horizontalDrawBar) {
            n3 = this.getCategoryCount();
            int n4 = this.getSeriesSize();
            for (int i2 = 0; i2 < n3; ++i2) {
                for (int i3 = 0; i3 < n4; ++i3) {
                    if (this.getSeries(i3) == null || this.getSeries(i3).getDataPoint(i2) == null) continue;
                    this.getSeries(i3).getDataPoint(i2).draw(graphics2D, n2);
                }
            }
        } else {
            for (n3 = this.getSeriesSize() - 1; n3 >= 0; --n3) {
                if (this.getSeries(n3) == null) continue;
                this.getSeries(n3).draw(graphics2D, n2);
            }
        }
        for (n3 = this.getSeriesSize() - 1; n3 >= 0; --n3) {
            if (this.getSeries(n3) == null) continue;
            this.getSeries(n3).drawLabel(graphics2D, n2);
        }
    }

    private void drawWhenStacked(Graphics2D graphics2D, int n2) {
        int n3;
        int n4 = this.getCategoryCount();
        int n5 = this.getSeriesSize();
        for (n3 = 0; n3 < n4; ++n3) {
            int n6;
            DataPoint[] dataPointArray = new DataPoint[n5];
            for (n6 = 0; n6 < n5; ++n6) {
                if (this.getSeries(n6) == null) continue;
                dataPointArray[n6] = this.getSeries(n6).getDataPoint(n3);
            }
            for (n6 = 0; n6 < n5; ++n6) {
                for (int i2 = n5 - 1; i2 > n6; --i2) {
                    if (dataPointArray[i2] == null || dataPointArray[i2].isValueIsNull() || !(dataPointArray[i2].getValue() < 0.0)) continue;
                    DataPoint dataPoint = dataPointArray[i2];
                    dataPointArray[i2] = dataPointArray[i2 - 1];
                    dataPointArray[i2 - 1] = dataPoint;
                }
            }
            for (n6 = 0; n6 < n5; ++n6) {
                if (dataPointArray[n6] == null) continue;
                dataPointArray[n6].draw(graphics2D, n2);
            }
        }
        for (n3 = 0; n3 < n5; ++n3) {
            if (this.getSeries(n3) == null) continue;
            this.getSeries(n3).drawLabel(graphics2D, n2);
        }
    }

    public boolean equals(Object object) {
        return object instanceof Bar3DPlotGlyph && super.equals(object) && ((Bar3DPlotGlyph)object).deep == this.deep && ((Bar3DPlotGlyph)object).seriesIntervalPercent == this.seriesIntervalPercent && ComparatorUtils.equals(((Bar3DPlotGlyph)object).projection, this.projection);
    }

    public Object clone() throws CloneNotSupportedException {
        Bar3DPlotGlyph bar3DPlotGlyph = (Bar3DPlotGlyph)super.clone();
        if (this.projection != null) {
            bar3DPlotGlyph.projection = (Projection)this.projection.clone();
        }
        return bar3DPlotGlyph;
    }

    public Shape getOutline4Fill() {
        if (this.isHorizontal) {
            Point2D point2D = this.threeDBase.getBasePoint();
            double d2 = this.threeDBase.getWidth();
            double d3 = this.threeDBase.getHeight() - this.getyAxisGlyph().getBounds().getHeight();
            return new Rectangle2D.Double(point2D.getX(), point2D.getY(), d2, d3);
        }
        return super.getOutline4Fill();
    }

    protected Rectangle2D getLabelBoundsInHorizontal(Dimension2D dimension2D, Rectangle2D rectangle2D, int n2) {
        double d2 = 0.0;
        switch (n2) {
            case 5: {
                d2 = rectangle2D.getX() + rectangle2D.getWidth() - dimension2D.getWidth() - 8.0;
                break;
            }
            case 6: {
                d2 = rectangle2D.getX() + rectangle2D.getWidth();
                break;
            }
            default: {
                d2 = rectangle2D.getX() + (rectangle2D.getWidth() - dimension2D.getWidth()) / 2.0;
            }
        }
        return new Rectangle2D.Double(d2, rectangle2D.getY() + (rectangle2D.getHeight() - dimension2D.getHeight()) / 2.0, dimension2D.getWidth(), dimension2D.getHeight());
    }

    protected Rectangle2D getLabelBoundsInVertical(Dimension2D dimension2D, Rectangle2D rectangle2D, int n2) {
        double d2 = 0.0;
        switch (n2) {
            case 5: {
                d2 = rectangle2D.getY() + 8.0;
                break;
            }
            case 6: {
                d2 = rectangle2D.getY() - dimension2D.getHeight();
                break;
            }
            default: {
                d2 = rectangle2D.getY() + (rectangle2D.getHeight() - dimension2D.getHeight()) / 2.0;
            }
        }
        return new Rectangle2D.Double(rectangle2D.getX() + (rectangle2D.getWidth() - dimension2D.getWidth()) / 2.0, d2, dimension2D.getWidth(), dimension2D.getHeight());
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        jSONObject.put("deep", this.deep);
        jSONObject.put("seriesIntervalPercent", this.seriesIntervalPercent);
        jSONObject.put("horizontalDrawBar", this.horizontalDrawBar);
        jSONObject.put("isHorizontal", this.isHorizontal);
        if (this.projection != null) {
            jSONObject.put("projection", this.projection.toJSONObject());
        }
        return jSONObject;
    }

    public String getPlotGlyphType() {
        return "Bar3DPlotGlyph";
    }
}

