/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.base.GlyphUtils;
import com.fr.chart.base.TextAttr;
import com.fr.chart.chartglyph.Cubic;
import com.fr.chart.chartglyph.SpecialGlyph;
import com.fr.chart.chartglyph.TextGlyph;
import com.fr.chart.chartglyph.ValueAxisGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.StableUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.math.BigDecimal;
import java.text.Format;

public abstract class AxisGlyph
extends SpecialGlyph {
    private static final long serialVersionUID = -1928073768268210599L;
    protected static final float TICK_WIDTH = 1.0f;
    protected static final int MAIN_TICK_LENGTH = 5;
    protected static final int SEC_TICK_LENGTH = 3;
    protected static final double MAX_AXIS_LABEL_HEIGHT = 0.2;
    protected static final double MAX_AXIS_LABEL_WIDTH = 0.2;
    protected Dimension2D titleDim = new Dimension(0, 0);
    protected transient Point2D originPoint;
    protected transient double unitLength;
    protected transient double axisLength;
    protected transient double axisGridLength;
    public static final double MIN_TICK_LENGTH = 15.0;
    public static final int DEFAULT_SAMPLING_TIME = 1;
    protected transient Rectangle2D plotZeroBounds;
    protected transient Rectangle2D plotLastBounds;
    protected transient Rectangle2D bounds;
    protected transient double axisLabelWidth = 8.0;
    protected transient Dimension2D startLabelDim = new Dimension(0, 0);
    protected transient Dimension2D endLabelDim = new Dimension(0, 0);
    protected int tickMarkType = 2;
    protected int secTickMarkType = 1;
    protected int position = 3;
    protected boolean axisReversed = false;
    protected int mainGridStyle = 0;
    protected Color mainGridColor = null;
    protected Color lineColor = new Color(176, 176, 176);
    protected int lineStyle = 1;
    protected TextAttr textAttr = new TextAttr();
    protected Format format;
    protected int labelNumber = 0;
    protected boolean isShowAxisLabel = true;
    protected boolean isArrowShow = false;
    protected boolean isCustomMinValue = false;
    protected double minValue = 0.0;
    protected boolean isCustomMaxValue = false;
    protected double maxValue = 0.0;
    protected BigDecimal mainUnit = new BigDecimal("0");
    private boolean isCustomMainUnit = false;
    private boolean isCustomSecUnit = false;
    private double secUnit = 0.0;
    private String axisType = "";
    private boolean drawBetweenTick = false;
    private boolean isZoom = false;
    private TextGlyph titleGlyph = null;
    private transient Cubic cubic;
    protected transient Cubic threeDBase;

    public void notShowAllAttr() {
        this.setTickMarkType(0);
        this.setShowAxisLabel(false);
        this.setTitleGlyph(null);
        this.setArrowShow(false);
        this.setLineColor(null);
        this.setLineStyle(0);
    }

    public abstract void initMinMaxValue(double var1, double var3);

    public abstract void drawAxisGrid(Graphics var1);

    protected void drawAfterPlot4AlertValues(Graphics2D graphics2D, int n2) {
    }

    protected abstract void drawAxisLine(Graphics var1, int var2);

    protected abstract void calculateAxisLengthUnit();

    protected abstract double getMaxLabelWidthAndInitStartEndLabelDim(int var1);

    protected abstract void drawTicks(Graphics var1, int var2);

    public abstract double getCrossValue();

    public abstract double getArrowValue();

    public abstract String getJSAxisType();

    public void dealPlotBoundsWithAxisLabel(Rectangle2D rectangle2D, int n2) {
        double d2 = this.getCateLabelWidth(rectangle2D, n2);
        if (d2 > 0.0) {
            d2 += 4.0;
        }
        this.setAxisLabelWidth(d2 += this.getTickLengthShow());
        this.calculateTitleDimesion(n2);
        if (this.getBounds() == null) {
            this.setBounds(rectangle2D);
        }
        this.calculateBoundsWidthOrientationAndTitle(rectangle2D, d2, this.titleDim);
        this.calBoundsWithMoreLabel4Cate(rectangle2D);
    }

    public void dealPlotBoundsWithLabelInHorizontal(Rectangle2D rectangle2D) {
        if (this.getPosition() == 2 || this.getPosition() == 4) {
            this.dealPlotBoundsLabelLeftRight(rectangle2D);
        } else {
            this.dealPlotBoundsLabelTopBottom(rectangle2D);
        }
    }

    public void dealPlotBoundsWithAxisTitle(Rectangle2D rectangle2D, int n2) {
        this.calculateTitleDimesion(n2);
        if (this.getBounds() == null) {
            this.setBounds(rectangle2D);
        }
        this.calculateBoundsWidthOrientationAndTitle(rectangle2D, 0.0, this.titleDim);
    }

    public void dealPlotBoundsWithLabel(Rectangle2D rectangle2D, int n2) {
        double d2 = this.getCateLabelWidth(rectangle2D, n2);
        if (d2 > 0.0) {
            d2 += 4.0;
        }
        this.setAxisLabelWidth(d2 += this.getTickLengthShow());
        Dimension dimension = new Dimension(0, 0);
        this.calculateBoundsWidthOrientationAndTitle(rectangle2D, d2, dimension);
        this.calBoundsWithMoreLabel4Cate(rectangle2D);
    }

    protected double getCateLabelWidth(Rectangle2D rectangle2D, int n2) {
        double d2 = this.getMaxLabelWidthAndInitStartEndLabelDim(n2);
        if (this.shouldBeHeight()) {
            return Math.min(rectangle2D.getHeight() * 0.2, d2);
        }
        return Math.min(rectangle2D.getWidth() * 0.2, d2);
    }

    private void dealPlotBoundsLabelLeftRight(Rectangle2D rectangle2D) {
        double d2;
        double d3;
        double d4;
        double d5 = this.endLabelDim.getHeight() / 2.0;
        if (d5 > (d4 = rectangle2D.getY() - this.plotZeroBounds.getY())) {
            rectangle2D.setFrame(rectangle2D.getX(), rectangle2D.getY() + d5 - d4, rectangle2D.getWidth(), rectangle2D.getHeight() - d5 + d4);
        }
        if ((d3 = this.startLabelDim.getHeight() / 2.0) > (d2 = this.plotZeroBounds.getY() + this.plotZeroBounds.getHeight() - rectangle2D.getY() - rectangle2D.getHeight()) && Math.round(d2) > 0L) {
            rectangle2D.setFrame(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight() - d3 + d2);
        }
    }

    private void dealPlotBoundsLabelTopBottom(Rectangle2D rectangle2D) {
        double d2;
        double d3;
        double d4;
        double d5 = this.endLabelDim.getWidth() / 2.0;
        if (d5 > (d4 = this.plotZeroBounds.getX() + this.plotZeroBounds.getWidth() - rectangle2D.getX() - rectangle2D.getWidth())) {
            rectangle2D.setFrame(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth() - d5 + d4, rectangle2D.getHeight());
        }
        if ((d3 = this.startLabelDim.getWidth() / 2.0) > (d2 = rectangle2D.getX() - this.plotZeroBounds.getX())) {
            rectangle2D.setFrame(rectangle2D.getX() + d3 - d2, rectangle2D.getY(), rectangle2D.getWidth() - d3 + d2, rectangle2D.getHeight());
        }
    }

    protected double getTickLengthShow() {
        return Math.max(this.getTickLength4Type(this.tickMarkType, 5), this.getTickLength4Type(this.secTickMarkType, 3));
    }

    private double getTickLength4Type(int n2, int n3) {
        double d2 = 0.0;
        switch (n2) {
            case 2: {
                d2 = n3;
                break;
            }
            case 3: {
                d2 = n3 / 2;
            }
        }
        return d2;
    }

    protected void calculateTitleDimesion(int n2) {
        if (this.titleGlyph != null && this.titleGlyph.isVisible()) {
            this.titleDim = this.titleGlyph.preferredDimension(n2);
        }
    }

    protected void calBoundsWithMoreLabel4Cate(Rectangle2D rectangle2D) {
    }

    private void calculateBoundsWidthOrientationAndTitle(Rectangle2D rectangle2D, double d2, Dimension2D dimension2D) {
        double d3 = rectangle2D.getX();
        double d4 = rectangle2D.getY();
        double d5 = rectangle2D.getWidth();
        double d6 = rectangle2D.getHeight();
        double d7 = dimension2D.getWidth() > 0.0 ? dimension2D.getWidth() + 4.0 : 0.0;
        double d8 = dimension2D.getHeight() > 0.0 ? dimension2D.getHeight() + 4.0 : 0.0;
        switch (this.getPosition()) {
            case 2: {
                d3 += d2 + d7;
                d5 -= d2 + d7;
                break;
            }
            case 3: {
                d6 -= d2 + d8;
                break;
            }
            case 4: {
                d5 -= d2 + d7;
                break;
            }
            default: {
                d4 += d2 + d8;
                d6 -= d2 + d8;
            }
        }
        rectangle2D.setRect(d3, d4, d5, d6);
    }

    public void calculateAxisGlyph(Rectangle2D rectangle2D) {
        this.init(rectangle2D);
        this.calculateAxisLengthUnit();
        this.plotLastBounds = rectangle2D;
    }

    protected void init(Rectangle2D rectangle2D) {
        switch (this.getPosition()) {
            case 2: {
                this.leftCase(rectangle2D);
                break;
            }
            case 3: {
                this.bottomCase(rectangle2D);
                break;
            }
            case 4: {
                this.rightCase(rectangle2D);
                break;
            }
            default: {
                this.defaultCase(rectangle2D);
            }
        }
    }

    private void defaultCase(Rectangle2D rectangle2D) {
        double d2 = rectangle2D.getWidth();
        double d3 = rectangle2D.getHeight();
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, -this.axisLabelWidth, rectangle2D.getWidth(), this.axisLabelWidth);
        Point2D.Double double_2 = !this.hasAxisReversed() ? new Point2D.Double(0.0, this.axisLabelWidth) : new Point2D.Double(rectangle2D.getWidth(), this.axisLabelWidth);
        this.setAttr(double_, double_2, d2, d3);
    }

    private void rightCase(Rectangle2D rectangle2D) {
        double d2 = rectangle2D.getHeight();
        double d3 = rectangle2D.getWidth();
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getWidth(), 0.0, this.axisLabelWidth, rectangle2D.getHeight());
        Point2D.Double double_2 = !this.hasAxisReversed() ? new Point2D.Double(0.0, rectangle2D.getHeight()) : new Point2D.Double(0.0, 0.0);
        this.setAttr(double_, double_2, d2, d3);
    }

    private void bottomCase(Rectangle2D rectangle2D) {
        Point2D.Double double_;
        Rectangle2D.Double double_2;
        double d2;
        double d3;
        boolean bl = this instanceof ValueAxisGlyph;
        if (this.getCubic() == null || !bl) {
            d3 = rectangle2D.getWidth();
            d2 = rectangle2D.getHeight();
            double_2 = new Rectangle2D.Double(0.0, rectangle2D.getHeight(), rectangle2D.getWidth(), this.axisLabelWidth);
            double_ = !this.hasAxisReversed() ? new Point2D.Double(0.0, 0.0) : new Point2D.Double(rectangle2D.getWidth(), 0.0);
        } else {
            d3 = this.getCubic().getWidth();
            d2 = this.getCubic().getHeight() - this.axisLabelWidth;
            double_2 = new Rectangle2D.Double(0.0, d2, d3, this.axisLabelWidth);
            double_ = new Point2D.Double(0.0, d2);
        }
        this.setAttr(double_2, double_, d3, d2);
    }

    private void leftCase(Rectangle2D rectangle2D) {
        Point2D.Double double_;
        Rectangle2D.Double double_2;
        double d2;
        double d3;
        boolean bl = this instanceof ValueAxisGlyph;
        if (this.getCubic() == null || !bl) {
            d3 = rectangle2D.getHeight();
            d2 = rectangle2D.getWidth();
            double_2 = new Rectangle2D.Double(-this.axisLabelWidth, 0.0, this.axisLabelWidth, rectangle2D.getHeight());
            double_ = !this.hasAxisReversed() ? new Point2D.Double(this.axisLabelWidth, rectangle2D.getHeight()) : new Point2D.Double(this.axisLabelWidth, 0.0);
        } else {
            d3 = this.getCubic().getHeight();
            d2 = this.getCubic().getWidth() - this.axisLabelWidth;
            double_2 = new Rectangle2D.Double(0.0, 0.0, this.axisLabelWidth, d3);
            double_ = new Point2D.Double(this.axisLabelWidth, d3);
        }
        this.setAttr(double_2, double_, d3, d2);
    }

    private void setAttr(Rectangle2D rectangle2D, Point2D point2D, double d2, double d3) {
        this.setBounds(rectangle2D);
        this.setOrigin(point2D);
        this.setAxisLength(d2);
        this.setAxisGridLength(d3);
    }

    protected double getAxisLabelWidth(String string, int n2) {
        Dimension2D dimension2D = this.getAxisLabelDim(string, n2);
        return this.shouldBeHeight() ? dimension2D.getHeight() : dimension2D.getWidth();
    }

    protected Dimension2D getAxisLabelDim(String string, int n2) {
        if (string == null) {
            return new Dimension(0, 0);
        }
        TextAttr textAttr = this.getTextAttr();
        if (textAttr == null) {
            textAttr = new TextAttr();
        }
        return GlyphUtils.calculateTextDimensionWithRotation(string, textAttr, n2);
    }

    protected boolean shouldBeHeight() {
        return this.getPosition() == 1 || this.getPosition() == 3;
    }

    protected String value2String(double d2) {
        Format format = this.getFormat();
        String string = format != null ? format.format(new Double(d2)) : ChartBaseUtils.generalFormat(d2);
        return string;
    }

    public Point2D getOrigin() {
        return this.originPoint;
    }

    protected void setOrigin(Point2D point2D) {
        this.originPoint = point2D;
    }

    public double getCrossValueInPlot() {
        return 0.0;
    }

    public double getAxisLength() {
        return this.axisLength;
    }

    public void setAxisLength(double d2) {
        this.axisLength = d2;
    }

    public void setCustomSecUnit(boolean bl) {
        this.isCustomSecUnit = bl;
    }

    protected boolean isCustomSecUnit() {
        return this.isCustomSecUnit;
    }

    public double getUnitLen() {
        return this.unitLength;
    }

    public void setUnitLen(double d2) {
        this.unitLength = d2;
    }

    protected double getAxisGridLength() {
        return this.axisGridLength;
    }

    protected void setAxisGridLength(double d2) {
        this.axisGridLength = d2;
    }

    public void setTitleGlyph(TextGlyph textGlyph) {
        this.titleGlyph = textGlyph;
    }

    public abstract double getPreLeftWidth4DataSheet(int var1);

    public Rectangle2D getBounds() {
        return this.bounds;
    }

    public void setBounds(Rectangle2D rectangle2D) {
        this.bounds = rectangle2D;
    }

    public void setPlotZeroBounds(Rectangle2D rectangle2D) {
        this.plotZeroBounds = rectangle2D;
    }

    public Rectangle2D getPlotZeroBounds() {
        return this.plotZeroBounds;
    }

    public Rectangle2D getPlotLastBounds() {
        return this.plotLastBounds;
    }

    public void setMinValue(double d2) {
        this.minValue = d2;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setCustomMinValue(boolean bl) {
        this.isCustomMinValue = bl;
    }

    protected boolean isCustomMinValue() {
        return this.isCustomMinValue;
    }

    public void setMaxValue(double d2) {
        this.maxValue = d2;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setCustomMaxValue(boolean bl) {
        this.isCustomMaxValue = bl;
    }

    protected boolean isCustomMaxValue() {
        return this.isCustomMaxValue;
    }

    public void setZoom(boolean bl) {
        this.isZoom = bl;
    }

    public void setTickMarkType(int n2) {
        this.tickMarkType = n2;
    }

    public int getTickMarkType() {
        return this.tickMarkType;
    }

    public void setSecTickMarkType(int n2) {
        this.secTickMarkType = n2;
    }

    public int getSecTickMarkType() {
        return this.secTickMarkType;
    }

    public void setMainGridStyle(int n2) {
        this.mainGridStyle = n2;
    }

    public int getMainGridStyle() {
        return this.mainGridStyle;
    }

    public void setMainGridColor(Color color) {
        this.mainGridColor = color;
    }

    public Color getMainGridColor() {
        return this.mainGridColor;
    }

    public void setLineColor(Color color) {
        this.lineColor = color;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineStyle(int n2) {
        this.lineStyle = n2;
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public void setTextAttr(TextAttr textAttr) {
        this.textAttr = textAttr;
    }

    public TextAttr getTextAttr() {
        return this.textAttr;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public Format getFormat() {
        return this.format;
    }

    public void setPosition(int n2) {
        this.position = n2;
    }

    public int getPosition() {
        return this.position;
    }

    public boolean hasAxisReversed() {
        return this.axisReversed;
    }

    public void setAxisReversed(boolean bl) {
        this.axisReversed = bl;
    }

    public void setLabelNumber(int n2) {
        this.labelNumber = n2;
    }

    public int getLabelNumber() {
        return this.labelNumber;
    }

    public void setArrowShow(boolean bl) {
        this.isArrowShow = bl;
    }

    public boolean isArrowShow() {
        return this.isArrowShow;
    }

    public void setShowAxisLabel(boolean bl) {
        this.isShowAxisLabel = bl;
    }

    public boolean isShowAxisLabel() {
        return this.isShowAxisLabel;
    }

    public boolean isLog() {
        return false;
    }

    public void setLog(boolean bl) {
    }

    public boolean isPercentage() {
        return false;
    }

    public void setAxisType(String string) {
        this.axisType = string;
    }

    public String getAxisType() {
        return this.axisType;
    }

    public void setMainUnit(BigDecimal bigDecimal) {
        this.mainUnit = bigDecimal;
    }

    public double getMainUnit() {
        return this.mainUnit.doubleValue();
    }

    public BigDecimal getBigDecimalMainUnit() {
        return this.mainUnit;
    }

    public void setCustomMainUnit(boolean bl) {
        this.isCustomMainUnit = bl;
    }

    public boolean isCustomMainUnit() {
        return this.isCustomMainUnit;
    }

    public Dimension2D getTitleDim() {
        return this.titleDim;
    }

    public Point2D getPointInBounds(double d2) {
        if (d2 < this.getCrossValue()) {
            d2 = this.getCrossValue();
        }
        if (d2 > this.getArrowValue()) {
            d2 = this.getArrowValue();
        }
        return this.getPoint2D(d2);
    }

    public double get2ValueLength(double d2, double d3) {
        Point2D point2D = this.getPointInBounds(d2);
        Point2D point2D2 = this.getPointInBounds(d3);
        if (this.position == 2 || this.position == 4) {
            return Math.abs(point2D.getY() - point2D2.getY());
        }
        return Math.abs(point2D.getX() - point2D2.getX());
    }

    public int getTickIndex4Value(int n2) {
        return n2;
    }

    public Point2D getPoint2D(double d2) {
        Point2D.Double double_ = null;
        d2 -= this.getCrossValue();
        if (this.getPosition() == 2) {
            double d3 = this.getBounds().getY();
            double_ = d3 == this.originPoint.getY() || this.hasAxisReversed() ? new Point2D.Double(this.originPoint.getX(), this.originPoint.getY() + this.unitLength * d2) : new Point2D.Double(this.originPoint.getX(), this.originPoint.getY() - this.unitLength * d2);
        } else if (this.getPosition() == 4) {
            double d4 = this.hasAxisReversed() ? this.unitLength * d2 : -this.unitLength * d2;
            double_ = new Point2D.Double(this.originPoint.getX(), this.originPoint.getY() + d4);
        } else if (this.getPosition() == 1 || this.getPosition() == 3) {
            double d5 = this.hasAxisReversed() ? -this.unitLength * d2 : this.unitLength * d2;
            double_ = new Point2D.Double(this.originPoint.getX() + d5, this.originPoint.getY());
        }
        return double_;
    }

    protected Line2D getTickLine(double d2, int n2, int n3) {
        Point2D point2D = this.getPoint2D(d2);
        return this.getTickLineByCenterPoint(point2D, n2, n3);
    }

    protected Line2D getTickLineByCenterPoint(Point2D point2D, int n2, int n3) {
        Point2D.Double double_ = new Point2D.Double(point2D.getX() - (double)n2, point2D.getY());
        Point2D.Double double_2 = new Point2D.Double(point2D.getX() + (double)n2, point2D.getY());
        Point2D.Double double_3 = new Point2D.Double(point2D.getX(), point2D.getY() - (double)n2);
        Point2D.Double double_4 = new Point2D.Double(point2D.getX(), point2D.getY() + (double)n2);
        if (n3 == 3) {
            Point2D.Double double_5 = new Point2D.Double(point2D.getX() - (double)(n2 / 2), point2D.getY());
            Point2D.Double double_6 = new Point2D.Double(point2D.getX() + (double)(n2 / 2), point2D.getY());
            Point2D.Double double_7 = new Point2D.Double(point2D.getX(), point2D.getY() - (double)(n2 / 2));
            Point2D.Double double_8 = new Point2D.Double(point2D.getX(), point2D.getY() + (double)(n2 / 2));
            if (this.getPosition() == 2 || this.getPosition() == 4) {
                return new Line2D.Double(double_5, double_6);
            }
            return new Line2D.Double(double_7, double_8);
        }
        if (n3 == 1) {
            if (this.getPosition() == 2) {
                return new Line2D.Double(point2D, double_2);
            }
            if (this.getPosition() == 1) {
                return new Line2D.Double(point2D, double_4);
            }
            if (this.getPosition() == 4) {
                return new Line2D.Double(point2D, double_);
            }
            return new Line2D.Double(point2D, double_3);
        }
        if (n3 == 2) {
            if (this.getPosition() == 2) {
                return new Line2D.Double(point2D, double_);
            }
            if (this.getPosition() == 1) {
                return new Line2D.Double(point2D, double_3);
            }
            if (this.getPosition() == 4) {
                return new Line2D.Double(point2D, double_2);
            }
            return new Line2D.Double(point2D, double_4);
        }
        return null;
    }

    public void setDrawBetweenTick(boolean bl) {
        this.drawBetweenTick = bl;
    }

    public boolean isDrawBetweenTick() {
        return this.drawBetweenTick;
    }

    public void setCubic(Cubic cubic) {
        this.cubic = cubic;
    }

    public Cubic getCubic() {
        return this.cubic;
    }

    public Cubic getThreeDBase() {
        return this.threeDBase;
    }

    public void setThreeDBase(Cubic cubic) {
        this.threeDBase = cubic;
    }

    public void setSecUnit(double d2) {
        this.secUnit = d2;
    }

    public double getSecUnit() {
        return this.secUnit;
    }

    public String getShowUnit() {
        return null;
    }

    protected void drawLabel(Graphics graphics, double d2, double d3, String string, int n2) {
        if (!this.isShowAxisLabel) {
            return;
        }
        Rectangle2D rectangle2D = this.getLabelBounds(d2, d3, string, n2);
        String string2 = this.changeAxisLabelStringWithLabelBounds(string, rectangle2D, n2);
        GlyphUtils.drawStrings(graphics, string2, this.textAttr, rectangle2D, n2);
    }

    protected String changeAxisLabelStringWithLabelBounds(String string, Rectangle2D rectangle2D, int n2) {
        Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithRotation(string, this.textAttr, n2);
        if (this.shouldBeHeight()) {
            if (dimension2D.getHeight() > rectangle2D.getHeight()) {
                for (int i2 = 0; i2 < string.length(); ++i2) {
                    String string2 = string.substring(0, i2) + "\u2026";
                    Dimension2D dimension2D2 = GlyphUtils.calculateTextDimensionWithRotation(string2, this.textAttr, n2);
                    if (!(dimension2D2.getHeight() > rectangle2D.getHeight())) continue;
                    if (i2 == 0) {
                        return "\u2026";
                    }
                    return string.substring(0, i2 - 1) + "\u2026";
                }
            }
            return string;
        }
        if (dimension2D.getWidth() > rectangle2D.getWidth()) {
            for (int i3 = 0; i3 < string.length(); ++i3) {
                String string3 = string.substring(0, i3) + "\u2026";
                Dimension2D dimension2D3 = GlyphUtils.calculateTextDimensionWithRotation(string3, this.textAttr, n2);
                if (!(dimension2D3.getWidth() > rectangle2D.getWidth())) continue;
                if (i3 == 0) {
                    return "\u2026";
                }
                return string.substring(0, i3 - 1) + "\u2026";
            }
        }
        return string;
    }

    protected void drawLabel(Graphics graphics, double d2, double d3, String string, GeneralPath generalPath, int n2) {
        if (!this.isShowAxisLabel) {
            return;
        }
        Rectangle2D rectangle2D = this.getLabelBounds(d2, d3, string, n2);
        String string2 = this.changeAxisLabelStringWithLabelBounds(string, rectangle2D, n2);
        if (this.getLabelNumber() != 0) {
            GlyphUtils.drawStrings(graphics, string2, this.textAttr, rectangle2D, n2);
        } else if (!generalPath.intersects(rectangle2D)) {
            generalPath.append(rectangle2D, false);
            GlyphUtils.drawStrings(graphics, string2, this.textAttr, rectangle2D, n2);
        }
    }

    public int getTickSamplingTime() {
        int n2 = 1;
        double d2 = (this.getMaxValue() - this.getMinValue()) / this.mainUnit.doubleValue();
        while (this.axisLength > 15.0 && this.axisLength / Math.ceil(d2 / (double)n2 * this.getMainUnit()) < 15.0) {
            ++n2;
        }
        return n2;
    }

    protected Rectangle2D getLabelBounds(double d2, double d3, String string, int n2) {
        if (this.plotLastBounds == null) {
            return null;
        }
        Point2D point2D = this.getPoint2D(d2 + d3);
        TextAttr textAttr = this.getTextAttr();
        if (textAttr == null) {
            textAttr = new TextAttr();
        }
        Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithRotation(string, textAttr, n2);
        int n3 = this.getPosition();
        double d4 = 4.0 + this.getTickLengthShow();
        double d5 = dimension2D.getHeight();
        double d6 = dimension2D.getWidth();
        if (this.shouldBeHeight()) {
            if (textAttr.getAlignText() == 1) {
                d5 += (double)textAttr.getFRFont().getSize();
            }
            d5 = Math.min(d5, this.axisLabelWidth - d4);
        } else {
            d6 = Math.min(d6, this.axisLabelWidth - d4);
        }
        Rectangle2D.Double double_ = n3 == 2 ? new Rectangle2D.Double(point2D.getX() - d6 - d4, point2D.getY() - d5 / 2.0, d6, d5) : (n3 == 1 ? new Rectangle2D.Double(point2D.getX() - d6 / 2.0, point2D.getY() - d5 - d4, d6, d5) : (n3 == 4 ? new Rectangle2D.Double(point2D.getX() + d4, point2D.getY() - d5 / 2.0, d6, d5) : new Rectangle2D.Double(point2D.getX() - d6 / 2.0, point2D.getY() + d4, d6, d5)));
        return double_;
    }

    protected void drawTickLine(Graphics graphics, Line2D line2D, BasicStroke basicStroke) {
        if (this.shouldDrawTickLine(line2D)) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Paint paint = graphics2D.getPaint();
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(basicStroke);
            graphics2D.setPaint(this.lineColor);
            graphics2D.draw(line2D);
            graphics2D.setPaint(paint);
            graphics2D.setStroke(stroke);
        }
    }

    private boolean shouldDrawTickLine(Line2D line2D) {
        return line2D != null && this.lineColor != null && this.lineStyle != 0;
    }

    public void draw(Graphics graphics, int n2) {
        if (this.getBounds() == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        this.drawAxisLine(graphics2D, n2);
        this.drawAxisTitle(graphics2D, n2);
        this.drawAfterPlot4AlertValues(graphics2D, n2);
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
    }

    public void drawWithOutAlert(Graphics graphics, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        this.drawAxisLine(graphics2D, n2);
        this.drawAxisTitle(graphics2D, n2);
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
    }

    public void draw4ThreeD(Graphics graphics, int n2) {
    }

    protected void drawAxisTitle(Graphics graphics, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.titleGlyph != null) {
            Rectangle2D rectangle2D = this.calculatorTitleBounds(n2);
            this.titleGlyph.setBounds(rectangle2D);
            int n3 = this.titleGlyph.getTextAttr().getRotation();
            if (this.titleGlyph.getTextAttr().getAlignText() == 1) {
                if (this.getPosition() == 2) {
                    this.titleGlyph.getTextAttr().setRotation(90);
                } else if (this.getPosition() == 4) {
                    this.titleGlyph.getTextAttr().setRotation(-90);
                }
            }
            this.titleGlyph.drawAxisTitle(graphics2D, n2);
            if (this.titleGlyph.getTextAttr().getAlignText() == 1) {
                this.titleGlyph.getTextAttr().setRotation(n3);
            }
        }
    }

    public void drawArrow(Graphics2D graphics2D, Point2D point2D, Point2D point2D2) {
        if (this.isArrowShow()) {
            Point2D.Double double_ = new Point2D.Double(point2D2.getX() - point2D.getX(), point2D2.getY() - point2D.getY());
            Point2D.Double double_2 = new Point2D.Double();
            double d2 = point2D.distance(point2D2);
            double d3 = 9.0;
            double d4 = 15.0;
            double d5 = 7.0;
            double d6 = 3.0;
            ((Point2D)double_2).setLocation(d3 * ((Point2D)double_).getX() / d2, d3 * ((Point2D)double_).getY() / d2);
            Point2D.Double double_3 = new Point2D.Double(point2D2.getX() + ((Point2D)double_2).getX(), point2D2.getY() + ((Point2D)double_2).getY());
            ((Point2D)double_2).setLocation(d4 * ((Point2D)double_).getX() / d2, d4 * ((Point2D)double_).getY() / d2);
            Point2D.Double double_4 = new Point2D.Double(point2D2.getX() + ((Point2D)double_2).getX(), point2D2.getY() + ((Point2D)double_2).getY());
            ((Point2D)double_2).setLocation(d5 * ((Point2D)double_).getX() / d2, d5 * ((Point2D)double_).getY() / d2);
            Point2D.Double double_5 = new Point2D.Double(point2D2.getX() + ((Point2D)double_2).getX(), point2D2.getY() + ((Point2D)double_2).getY());
            Point2D.Double double_6 = new Point2D.Double(((Point2D)double_5).getX() + ((Point2D)double_).getY() / d2 * d6, ((Point2D)double_5).getY() - ((Point2D)double_).getX() / d2 * d6);
            Point2D.Double double_7 = new Point2D.Double(((Point2D)double_5).getX() - ((Point2D)double_).getY() / d2 * d6, ((Point2D)double_5).getY() + ((Point2D)double_).getX() / d2 * d6);
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo((float)((Point2D)double_3).getX(), (float)((Point2D)double_3).getY());
            generalPath.lineTo((float)((Point2D)double_6).getX(), (float)((Point2D)double_6).getY());
            generalPath.lineTo((float)((Point2D)double_4).getX(), (float)((Point2D)double_4).getY());
            generalPath.lineTo((float)((Point2D)double_7).getX(), (float)((Point2D)double_7).getY());
            generalPath.closePath();
            graphics2D.draw(new Line2D.Double(point2D2, double_3));
            graphics2D.draw(generalPath);
            graphics2D.fill(generalPath);
        }
    }

    public Line2D[] getGridLine(double d2) {
        Point2D point2D = this.getPoint2D(d2);
        Line2D.Double double_ = this.getPosition() == 2 ? new Line2D.Double(point2D.getX(), point2D.getY(), point2D.getX() + this.getAxisGridLength(), point2D.getY()) : (this.getPosition() == 4 ? new Line2D.Double(point2D.getX() - this.getAxisGridLength(), point2D.getY(), point2D.getX(), point2D.getY()) : (this.getPosition() == 1 ? new Line2D.Double(point2D.getX(), point2D.getY() + this.getAxisGridLength(), point2D.getX(), point2D.getY()) : new Line2D.Double(point2D.getX(), point2D.getY() - this.getAxisGridLength(), point2D.getX(), point2D.getY())));
        return new Line2D[]{double_};
    }

    public Shape getShape() {
        Rectangle2D rectangle2D = this.getBounds();
        if (rectangle2D == null) {
            return new Rectangle();
        }
        if (this.getPosition() == 4 || this.getPosition() == 2) {
            return this.getVerticalShapeWithLabel(rectangle2D);
        }
        return this.getHorizontalShapeWithLabel(rectangle2D);
    }

    private Shape getVerticalShapeWithLabel(Rectangle2D rectangle2D) {
        return new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY() - this.endLabelDim.getHeight() / 2.0, rectangle2D.getWidth(), rectangle2D.getHeight() + this.endLabelDim.getHeight() / 2.0 + this.startLabelDim.getHeight() / 2.0);
    }

    private Shape getHorizontalShapeWithLabel(Rectangle2D rectangle2D) {
        return new Rectangle2D.Double(rectangle2D.getX() - this.startLabelDim.getWidth() / 2.0, rectangle2D.getY(), rectangle2D.getWidth() + this.startLabelDim.getWidth() / 2.0 + this.endLabelDim.getWidth() / 2.0, rectangle2D.getHeight());
    }

    public void setAxisLabelWidth(double d2) {
        this.axisLabelWidth = d2;
    }

    public double getAxisLabelWidth() {
        return this.axisLabelWidth;
    }

    private Rectangle2D calculatorTitleBounds(int n2) {
        Rectangle2D rectangle2D = null;
        Dimension2D dimension2D = this.titleGlyph.preferredDimension(n2);
        int n3 = this.titleGlyph.getPosition();
        if (this.getPosition() == 1) {
            rectangle2D = this.getTopTitleBounds(dimension2D, n3);
        } else if (this.getPosition() == 2) {
            rectangle2D = this.getLeftTitleBounds(dimension2D, n3);
        } else if (this.getPosition() == 3) {
            rectangle2D = this.getBottomTitleBounds(dimension2D, n3);
        } else if (this.getPosition() == 4) {
            rectangle2D = this.getRightTitleBounds(dimension2D, n3);
        }
        return rectangle2D;
    }

    private Rectangle2D getTopTitleBounds(Dimension2D dimension2D, int n2) {
        return new Rectangle2D.Double(this.getTopBottomX(n2), -4.0 - dimension2D.getHeight(), dimension2D.getWidth(), dimension2D.getHeight());
    }

    protected double getTopBottomX(int n2) {
        double d2 = (this.axisLength - this.titleDim.getWidth()) / 2.0;
        if (n2 == 2) {
            d2 = -8.0;
        } else if (n2 == 4) {
            d2 = this.axisLength - this.titleDim.getWidth() + 8.0;
        }
        return d2;
    }

    protected Rectangle2D getBottomTitleBounds(Dimension2D dimension2D, int n2) {
        return new Rectangle2D.Double(this.getTopBottomX(n2), this.getAxisLabelWidth() + 4.0, dimension2D.getWidth(), dimension2D.getHeight());
    }

    private Rectangle2D getLeftTitleBounds(Dimension2D dimension2D, int n2) {
        return new Rectangle2D.Double(-dimension2D.getWidth() - 4.0, this.getLeftRightY(n2), dimension2D.getWidth(), dimension2D.getHeight());
    }

    private double getLeftRightY(int n2) {
        double d2 = (this.axisLength - this.titleDim.getHeight()) / 2.0;
        if (n2 == 2) {
            d2 = -8.0;
        } else if (n2 == 4) {
            d2 = this.axisLength - this.titleDim.getHeight() + 8.0;
        }
        return d2;
    }

    private Rectangle2D getRightTitleBounds(Dimension2D dimension2D, int n2) {
        return new Rectangle2D.Double(this.getAxisLabelWidth() + 4.0, this.getLeftRightY(n2), dimension2D.getWidth(), dimension2D.getHeight());
    }

    public boolean equals(Object object) {
        return object instanceof AxisGlyph && ComparatorUtils.equals(object.getClass().getName(), this.getClass().getName()) && ((AxisGlyph)object).maxValue == this.maxValue && ((AxisGlyph)object).minValue == this.minValue && ((AxisGlyph)object).isArrowShow == this.isArrowShow && ((AxisGlyph)object).isCustomMaxValue == this.isCustomMaxValue && ((AxisGlyph)object).isCustomMinValue == this.isCustomMinValue && ((AxisGlyph)object).axisGridLength == this.axisGridLength && ((AxisGlyph)object).isShowAxisLabel == this.isShowAxisLabel && ((AxisGlyph)object).axisLabelWidth == this.axisLabelWidth && ((AxisGlyph)object).axisLength == this.axisLength && ((AxisGlyph)object).labelNumber == this.labelNumber && ((AxisGlyph)object).lineStyle == this.lineStyle && ((AxisGlyph)object).mainGridStyle == this.mainGridStyle && ((AxisGlyph)object).position == this.position && ((AxisGlyph)object).secTickMarkType == this.secTickMarkType && ((AxisGlyph)object).secUnit == this.secUnit && ComparatorUtils.equals(((AxisGlyph)object).mainUnit, this.mainUnit) && ((AxisGlyph)object).tickMarkType == this.tickMarkType && ((AxisGlyph)object).isZoom == this.isZoom && ((AxisGlyph)object).unitLength == this.unitLength && ComparatorUtils.equals(((AxisGlyph)object).titleDim, this.titleDim) && ComparatorUtils.equals(((AxisGlyph)object).bounds, this.bounds) && ComparatorUtils.equals(((AxisGlyph)object).originPoint, this.originPoint) && ComparatorUtils.equals(((AxisGlyph)object).lineColor, this.lineColor) && ComparatorUtils.equals(((AxisGlyph)object).axisType, this.axisType) && ComparatorUtils.equals(((AxisGlyph)object).textAttr, this.textAttr) && ComparatorUtils.equals(((AxisGlyph)object).format, this.format) && ComparatorUtils.equals(((AxisGlyph)object).titleGlyph, this.titleGlyph) && ComparatorUtils.equals(((AxisGlyph)object).mainGridColor, this.mainGridColor) && ((AxisGlyph)object).axisReversed == this.axisReversed;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        jSONObject.put("isShowAxisLabel", this.isShowAxisLabel);
        jSONObject.put("lineStyle", this.lineStyle);
        jSONObject.put("mainGridStyle", this.mainGridStyle);
        jSONObject.put("position", this.position);
        jSONObject.put("secTickMarkType", this.secTickMarkType);
        jSONObject.put("tickMarkType", this.tickMarkType);
        if (this.format != null) {
            jSONObject.put("format", ChartBaseUtils.format2JS(this.format));
        }
        jSONObject.put("lineColor", StableUtils.javaColorToCSSColor(this.lineColor));
        if (this.mainGridColor != null) {
            jSONObject.put("mainGridColor", StableUtils.javaColorToCSSColor(this.mainGridColor));
        }
        if (this.textAttr != null) {
            jSONObject.put("textAttr", this.textAttr.toJSONObject());
        }
        jSONObject.put("isArrowShow", this.isArrowShow);
        jSONObject.put("labelNumber", this.labelNumber);
        jSONObject.put("isCustomMinValue", this.isCustomMinValue());
        jSONObject.put("minValue", this.getMinValue());
        jSONObject.put("isCustomMaxValue", this.isCustomMaxValue());
        jSONObject.put("maxValue", this.getMaxValue());
        if (this.titleGlyph != null) {
            jSONObject.put("titleGlyph", this.titleGlyph.toJSONObject());
        }
        jSONObject.put("isCustomSecUnit", this.isCustomSecUnit);
        jSONObject.put("smallTickLength", this.getSecUnit());
        jSONObject.put("isCustomMainUnit", this.isCustomMainUnit);
        jSONObject.put("tickLength", this.getMainUnit());
        jSONObject.put("drawBetweenTick", this.drawBetweenTick);
        jSONObject.put("isZoom", this.isZoom);
        jSONObject.put("axisReversed", this.axisReversed);
        return jSONObject;
    }
}

