/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartdata;

import com.fr.base.Utils;
import com.fr.base.chartdata.ChartData;
import com.fr.chart.chartdata.MapChartData;
import com.fr.chart.chartdata.MapSingleLayerTableDefinition;
import com.fr.chart.chartdata.SeriesDefinition;
import com.fr.chart.chartdata.TableDataDefinition;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.general.data.DataModel;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MapMoreLayerTableDefinition
extends TableDataDefinition {
    public static final String XML_TAG = "MapMoreLayerTableDefinition";
    private static final long serialVersionUID = 3389355131090619354L;
    private List nameValueList = new ArrayList();

    public ChartData createChartData(DataModel dataModel) {
        MapChartData mapChartData = new MapChartData();
        mapChartData.clearAllMap();
        for (int i2 = 0; i2 < this.nameValueList.size(); ++i2) {
            MapSingleLayerTableDefinition mapSingleLayerTableDefinition = (MapSingleLayerTableDefinition)this.nameValueList.get(i2);
            if (mapSingleLayerTableDefinition == null) continue;
            mapSingleLayerTableDefinition.createMapDataWithLayerIndex(mapChartData, dataModel);
        }
        mapChartData.setHasLayerTo(true);
        return mapChartData;
    }

    public void clearNameValues() {
        this.nameValueList.clear();
    }

    public MapSingleLayerTableDefinition[] getNameValues() {
        return this.nameValueList.toArray(new MapSingleLayerTableDefinition[this.nameValueList.size()]);
    }

    public void addNameValue(MapSingleLayerTableDefinition mapSingleLayerTableDefinition) {
        this.nameValueList.add(mapSingleLayerTableDefinition);
    }

    public int size() {
        return this.nameValueList.size();
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        super.writeXML(xMLPrintWriter);
        if (this.nameValueList != null && !this.nameValueList.isEmpty()) {
            xMLPrintWriter.startTAG("MoreMapSingle");
            for (int i2 = 0; i2 < this.nameValueList.size(); ++i2) {
                ((MapSingleLayerTableDefinition)this.nameValueList.get(i2)).writeXML(xMLPrintWriter);
            }
            xMLPrintWriter.end();
        }
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (ComparatorUtils.equals("MoreMapSingle", string)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (ComparatorUtils.equals("MapSingleLayerTableDefinition", xMLableReader.getTagName())) {
                            Object object = xMLableReader.readXMLObject(new MapSingleLayerTableDefinition());
                            MapMoreLayerTableDefinition.this.addNameValue((MapSingleLayerTableDefinition)object);
                        }
                    }
                });
            } else if (ComparatorUtils.equals("MoreTableNameValue", string)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (ComparatorUtils.equals("SeriesDefinition", xMLableReader.getTagName())) {
                            SeriesDefinition seriesDefinition = (SeriesDefinition)xMLableReader.readXMLObject(new SeriesDefinition());
                            MapSingleLayerTableDefinition mapSingleLayerTableDefinition = new MapSingleLayerTableDefinition();
                            if (seriesDefinition.getSeriesName() != null) {
                                mapSingleLayerTableDefinition.setAreaName(Utils.objectToString(seriesDefinition.getSeriesName()));
                                seriesDefinition.setSeriesName(Inter.getLocText("Value"));
                                mapSingleLayerTableDefinition.addTitleValue(seriesDefinition);
                                MapMoreLayerTableDefinition.this.addNameValue(mapSingleLayerTableDefinition);
                            }
                        }
                    }
                });
            }
            this.com4MoreIndex();
        }
    }

    private void com4MoreIndex() {
        MapSingleLayerTableDefinition[] mapSingleLayerTableDefinitionArray = this.getNameValues();
        if (mapSingleLayerTableDefinitionArray.length <= 1) {
            return;
        }
        MapSingleLayerTableDefinition mapSingleLayerTableDefinition = new MapSingleLayerTableDefinition();
        mapSingleLayerTableDefinition.setAreaName(mapSingleLayerTableDefinitionArray[mapSingleLayerTableDefinitionArray.length - 1].getAreaName());
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        for (int i2 = 0; i2 < mapSingleLayerTableDefinitionArray.length; ++i2) {
            MapSingleLayerTableDefinition mapSingleLayerTableDefinition2 = mapSingleLayerTableDefinitionArray[i2];
            int n2 = mapSingleLayerTableDefinition2.getTitleValueSize();
            for (int i3 = 0; i3 < n2; ++i3) {
                SeriesDefinition seriesDefinition = mapSingleLayerTableDefinition2.getTitleValueWithIndex(i3);
                if (hashMap.containsKey(seriesDefinition.getSeriesName())) {
                    if (ComparatorUtils.equals(hashMap.get(seriesDefinition.getSeriesName()), seriesDefinition.getValue())) continue;
                    mapSingleLayerTableDefinition.addTitleValue(seriesDefinition);
                    continue;
                }
                hashMap.put(seriesDefinition.getSeriesName(), seriesDefinition.getValue());
                mapSingleLayerTableDefinition.addTitleValue(seriesDefinition);
            }
        }
        this.clearNameValues();
        this.addNameValue(mapSingleLayerTableDefinition);
    }
}

