/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartattr;

import com.fr.base.Formula;
import com.fr.base.Utils;
import com.fr.chart.base.TextAttr;
import com.fr.chart.chartglyph.GeneralGlyph;
import com.fr.chart.chartglyph.GeneralInfo;
import com.fr.chart.chartglyph.RectangleGlyph;
import com.fr.chart.chartglyph.TextGlyph;
import com.fr.chart.chartglyph.TitleGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRFont;
import com.fr.general.GeneralUtils;
import com.fr.general.Inter;
import com.fr.general.data.MOD_COLUMN_ROW;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.FCloneable;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;
import java.util.List;

public class Title
extends GeneralInfo
implements XMLable {
    private static final long serialVersionUID = 1L;
    public static final String XML_TAG = "Title";
    private Object text;
    private TextAttr textAttr = new TextAttr();
    private boolean titleVisble = true;
    private int position = 0;

    public Title() {
        FRFont fRFont = FRFont.getInstance("Microsoft YaHei", 0, 11.0f);
        this.textAttr.setFRFont(fRFont);
        this.text = Inter.getLocText("Chart_Title");
        this.setBorderColor(new Color(150, 150, 150));
        this.setBorderStyle(0);
    }

    public Title(Object object) {
        this.text = object;
    }

    public TitleGlyph createGlyph() {
        FCloneable fCloneable;
        String string = Utils.objectToString(this.text);
        if (this.text instanceof Formula && ((Formula)(fCloneable = (Formula)this.text)).getResult() != null) {
            string = Utils.objectToString(((Formula)fCloneable).getResult());
        }
        fCloneable = new TitleGlyph(string.trim(), this.textAttr);
        ((GeneralGlyph)fCloneable).setGeneralInfo(this);
        ((TextGlyph)fCloneable).setPosition(this.position);
        ((RectangleGlyph)fCloneable).setVisible(this.isTitleVisble());
        return fCloneable;
    }

    public TextGlyph createGlyph4AxisTitle() {
        FCloneable fCloneable;
        String string = Utils.objectToString(this.text);
        if (this.text instanceof Formula && ((Formula)(fCloneable = (Formula)this.text)).getResult() != null) {
            string = Utils.objectToString(((Formula)fCloneable).getResult());
        }
        fCloneable = new TextGlyph(string.trim(), this.textAttr);
        ((GeneralGlyph)fCloneable).setGeneralInfo(this);
        ((TextGlyph)fCloneable).setPosition(this.position);
        ((RectangleGlyph)fCloneable).setVisible(this.isTitleVisble());
        return fCloneable;
    }

    public Object getTextObject() {
        return this.text;
    }

    public void setTextObject(Object object) {
        this.text = object;
    }

    public TextAttr getTextAttr() {
        return this.textAttr;
    }

    public void setTextAttr(TextAttr textAttr) {
        this.text = textAttr;
    }

    public void setPosition(int n2) {
        this.position = n2;
    }

    public int getPosition() {
        return this.position;
    }

    public void setTitleVisble(boolean bl) {
        this.titleVisble = bl;
    }

    public boolean isTitleVisble() {
        return this.titleVisble;
    }

    public void dealFormula(Calculator calculator) {
        Utils.dealFormulaValue(this.text, calculator);
    }

    public void buidExecuteSequenceList(List list, Calculator calculator) {
        GeneralUtils.dealBuidExecuteSequence(this.text, list, calculator);
    }

    public void modFormulaString(MOD_COLUMN_ROW mOD_COLUMN_ROW) {
        mOD_COLUMN_ROW.mod_object(this.text);
    }

    public Object clone() throws CloneNotSupportedException {
        Title title = (Title)super.clone();
        if (this.textAttr != null) {
            title.textAttr = (TextAttr)this.textAttr.clone();
        }
        if (this.text instanceof Formula) {
            title.text = ((Formula)this.text).clone();
        }
        return title;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("O".equals(string)) {
                this.text = GeneralXMLTools.readObject(xMLableReader);
            } else if ("TextAttr".equals(string)) {
                this.textAttr = new TextAttr();
                xMLableReader.readXMLObject(this.textAttr);
                if (this.textAttr != null) {
                    this.textAttr.setRotation(0);
                }
            } else if ("TitleVisible".equals(string)) {
                String string2 = xMLableReader.getAttrAsString("value", null);
                if (string2 != null) {
                    this.titleVisble = Boolean.valueOf(string2);
                }
                this.position = xMLableReader.getAttrAsInt("position", 0);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        super.writeXML(xMLPrintWriter);
        if (this.text != null) {
            GeneralXMLTools.writeObject(xMLPrintWriter, this.text);
        }
        if (this.textAttr != null) {
            this.textAttr.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.startTAG("TitleVisible").attr("value", this.titleVisble).attr("position", this.position).end();
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        return object instanceof Title && super.equals(object) && ComparatorUtils.equals(((Title)object).getTextObject(), this.text) && ComparatorUtils.equals(((Title)object).getTextAttr(), this.textAttr) && ((Title)object).isTitleVisble() == this.titleVisble && ((Title)object).getPosition() == this.position;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        if (this.textAttr != null) {
            jSONObject.put("textAttr", this.textAttr.toJSONObject());
        }
        jSONObject.put("text", this.text);
        jSONObject.put("titleVisble", this.titleVisble);
        jSONObject.put("position", this.position);
        return jSONObject;
    }
}

