/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartattr;

import com.fr.base.Utils;
import com.fr.base.chartdata.ChartData;
import com.fr.chart.chartattr.ChartXMLUtils;
import com.fr.chart.chartattr.Plot;
import com.fr.chart.chartdata.MeterChartData;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.MeterCustomStyle;
import com.fr.chart.chartglyph.MeterPlotGlyph;
import com.fr.chart.chartglyph.MeterStyle;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.general.data.MOD_COLUMN_ROW;
import com.fr.script.Calculator;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.List;

public class MeterPlot
extends Plot {
    private static final long serialVersionUID = 1L;
    public static String XML_TAG = "MeterPlot";
    public static final String[] METERTYPE = new String[]{Inter.getLocText("Meter_Single"), Inter.getLocText("Meter_More")};
    protected MeterStyle meterStyle = new MeterStyle();
    private static final MeterChartData METERDATA = new MeterChartData(new String[]{Inter.getLocText("ChartF-Meter")}, new String[]{"120"});

    public MeterPlot() {
        this.resetNullLegendAttr();
    }

    public void setMeterStyle(MeterStyle meterStyle) {
        this.meterStyle = meterStyle;
    }

    public MeterStyle getMeterStyle() {
        return this.meterStyle;
    }

    public String getPlotName() {
        return Inter.getLocText("ChartF-Meter");
    }

    public PlotGlyph createPlotGlyph(ChartData chartData) {
        MeterPlotGlyph meterPlotGlyph = new MeterPlotGlyph();
        this.install4PlotGlyph(meterPlotGlyph, chartData);
        return meterPlotGlyph;
    }

    public void install4PlotGlyph(MeterPlotGlyph meterPlotGlyph, ChartData chartData) {
        super.install4PlotGlyph(meterPlotGlyph, chartData);
        meterPlotGlyph.setMeterStyle(this.meterStyle);
    }

    protected void addSeries2PlotGlyph(PlotGlyph plotGlyph, ChartData chartData) {
        MeterChartData meterChartData = ChartXMLUtils.chartData4Meter(chartData);
        this.addSeriesByIndex(plotGlyph, meterChartData);
    }

    protected void addSeriesByIndex(PlotGlyph plotGlyph, MeterChartData meterChartData) {
        int n2 = meterChartData.getCategoryLabelCount();
        DataSeries dataSeries = this.createDataSeries(0);
        dataSeries.setSeriesName("1");
        plotGlyph.addSeries(dataSeries);
        for (int i2 = 0; i2 < n2; ++i2) {
            DataPoint dataPoint = this.createDataPoint();
            dataPoint.setCategoryIndex(i2);
            dataPoint.setSeriesIndex(0);
            double d2 = 0.0;
            Number number = meterChartData.getValue(i2);
            if (number != null) {
                d2 = number.doubleValue();
            } else {
                dataPoint.setValueIsNull(true);
                d2 = 0.0;
            }
            dataPoint.setValue(d2);
            if (i2 < meterChartData.getCategoryLabelCount()) {
                dataPoint.setCategoryName(Utils.objectToString(meterChartData.getCategoryPresentLabel(i2)));
                dataPoint.setCategoryOriginalName(Utils.objectToString(meterChartData.getCategoryOriginalLabel(i2)));
            }
            dataPoint.setSeriesName("1");
            dataPoint.setSeriesOriginalName("1");
            dataSeries.addDataPoint(dataPoint);
        }
        this.createDataPointLabel(plotGlyph);
    }

    public boolean isSupportSeriesFilter() {
        return false;
    }

    public boolean matchPlotType(Plot plot) {
        return plot instanceof MeterPlot;
    }

    public ChartData defaultChartData() {
        return METERDATA;
    }

    public void clearConditionAttrAndRenewLegend(Plot plot) {
        super.clearConditionAttrAndRenewLegend(plot);
        this.resetNullLegendAttr();
    }

    public String getPlotDataPaneName() {
        return XML_TAG;
    }

    public void dealFormula(Calculator calculator) {
        super.dealFormula(calculator);
        if (this.meterStyle != null) {
            this.meterStyle.dealFormula(calculator);
        }
    }

    public void buidExecuteSequenceList(List list, Calculator calculator) {
        super.buidExecuteSequenceList(list, calculator);
        if (this.meterStyle != null) {
            this.meterStyle.buidExecuteSequenceList(list, calculator);
        }
    }

    public void modFormulaString(MOD_COLUMN_ROW mOD_COLUMN_ROW) {
        super.modFormulaString(mOD_COLUMN_ROW);
        if (this.meterStyle != null) {
            this.meterStyle.modFormulaString(mOD_COLUMN_ROW);
        }
    }

    public boolean isSupportDataSeriesCondition() {
        return false;
    }

    public boolean isSupportDataLabelAttr() {
        return false;
    }

    public boolean isSupportTooltipInInteractivePane() {
        return false;
    }

    public boolean isHaveAxis() {
        return false;
    }

    public ChartData createNullChartData() {
        return new MeterChartData(new String[]{""}, new String[]{"0"});
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        super.writeXML(xMLPrintWriter);
        if (this.meterStyle != null) {
            this.meterStyle.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("MeterStyle".equals(string)) {
                this.meterStyle = (MeterStyle)xMLableReader.readXMLObject(new MeterStyle());
            } else if ("MeterCustomStyle".equals(string)) {
                this.meterStyle = (MeterStyle)xMLableReader.readXMLObject(new MeterCustomStyle());
            }
        }
    }

    public boolean equals(Object object) {
        return object instanceof MeterPlot && super.equals(object) && ComparatorUtils.equals(((MeterPlot)object).getMeterStyle(), this.meterStyle);
    }

    public Object clone() throws CloneNotSupportedException {
        MeterPlot meterPlot = (MeterPlot)super.clone();
        if (this.meterStyle != null) {
            meterPlot.setMeterStyle((MeterStyle)this.meterStyle.clone());
        }
        return meterPlot;
    }
}

