/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartattr;

import com.fr.base.chartdata.ChartData;
import com.fr.chart.chartattr.DonutPlot;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.Donut3DPlotGlyph;
import com.fr.chart.chartglyph.LineMarkerIcon;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.chart.chartglyph.Projection;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;

public class Donut3DPlot
extends DonutPlot {
    private int depth = 20;
    private Projection projection = new Projection();

    public Donut3DPlot() {
        this.projection.setRotation(0);
        this.projection.setElevation(33);
        this.projection.setFocus(800);
    }

    public PlotGlyph createPlotGlyph(ChartData chartData) {
        Donut3DPlotGlyph donut3DPlotGlyph = new Donut3DPlotGlyph();
        this.install4PlotGlyph(donut3DPlotGlyph, chartData);
        return donut3DPlotGlyph;
    }

    public void install4PlotGlyph(Donut3DPlotGlyph donut3DPlotGlyph, ChartData chartData) {
        this.setSeriesGap(0.05);
        this.setCategoryGap(0.3);
        this.setInnerRadiusPercent(0.2);
        super.install4PlotGlyph(donut3DPlotGlyph, chartData);
        donut3DPlotGlyph.setDepth(this.depth);
        donut3DPlotGlyph.setProjection(this.projection);
    }

    protected void dealCondition(LineMarkerIcon lineMarkerIcon, DataSeries dataSeries, Color[] colorArray) {
        this.dealColorCondition(lineMarkerIcon, dataSeries, colorArray);
    }

    public void setProjection(Projection projection) {
        this.projection = projection;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public String getPlotName() {
        return Inter.getLocText("Chart_3D") + super.getPlotName();
    }

    public boolean is3D() {
        return true;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("Projection".equals(string)) {
                this.projection = (Projection)xMLableReader.readXMLObject(new Projection());
            } else if ("Depth".equals(string)) {
                this.depth = xMLableReader.getAttrAsInt("value", 20);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("Plot");
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("Depth").attr("value", this.depth).end();
        if (this.projection != null) {
            this.projection.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public boolean isSupportSeriesDrag() {
        return false;
    }

    public boolean needAnalysisLinePane() {
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        Donut3DPlot donut3DPlot = (Donut3DPlot)super.clone();
        if (this.projection != null) {
            donut3DPlot.projection = (Projection)this.projection.clone();
        }
        return donut3DPlot;
    }

    public boolean isSupport3D() {
        return true;
    }

    public boolean equals(Object object) {
        return object instanceof Donut3DPlot && super.equals(object) && ((Donut3DPlot)object).depth == this.depth && ComparatorUtils.equals(((Donut3DPlot)object).getProjection(), this.projection);
    }
}

