/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartattr;

import com.fr.base.FRContext;
import com.fr.base.Utils;
import com.fr.base.chartdata.ChartData;
import com.fr.base.chartdata.TopDefinition;
import com.fr.chart.chartattr.Area3DPlot;
import com.fr.chart.chartattr.AreaPlot;
import com.fr.chart.chartattr.Axis;
import com.fr.chart.chartattr.Bar2DPlot;
import com.fr.chart.chartattr.Bar3DPlot;
import com.fr.chart.chartattr.BubblePlot;
import com.fr.chart.chartattr.CategoryAxis;
import com.fr.chart.chartattr.Chart;
import com.fr.chart.chartattr.CustomPlot;
import com.fr.chart.chartattr.GanttPlot;
import com.fr.chart.chartattr.LinePlot;
import com.fr.chart.chartattr.MapPlot;
import com.fr.chart.chartattr.MeterCustomPlot;
import com.fr.chart.chartattr.MeterPlot;
import com.fr.chart.chartattr.Pie3DPlot;
import com.fr.chart.chartattr.PiePlot;
import com.fr.chart.chartattr.Plot;
import com.fr.chart.chartattr.RadarPlot;
import com.fr.chart.chartattr.RangePlot;
import com.fr.chart.chartattr.StockPlot;
import com.fr.chart.chartattr.ValueAxis;
import com.fr.chart.chartattr.XYScatterPlot;
import com.fr.chart.chartdata.BubbleChartData;
import com.fr.chart.chartdata.BubbleReportDefinition;
import com.fr.chart.chartdata.BubbleSeriesValue;
import com.fr.chart.chartdata.BubbleTableDefinition;
import com.fr.chart.chartdata.ChartSummaryColumn;
import com.fr.chart.chartdata.GanttChartData;
import com.fr.chart.chartdata.MapSingleLayerReportDefinition;
import com.fr.chart.chartdata.MapSingleLayerTableDefinition;
import com.fr.chart.chartdata.MeterChartData;
import com.fr.chart.chartdata.MoreNameCDDefinition;
import com.fr.chart.chartdata.NormalChartData;
import com.fr.chart.chartdata.NormalReportDataDefinition;
import com.fr.chart.chartdata.OneValueCDDefinition;
import com.fr.chart.chartdata.ScatterChartData;
import com.fr.chart.chartdata.ScatterReportDefinition;
import com.fr.chart.chartdata.ScatterSeriesValue;
import com.fr.chart.chartdata.ScatterTableDefinition;
import com.fr.chart.chartdata.SeriesDefinition;
import com.fr.chart.chartdata.StockChartData;
import com.fr.general.GeneralUtils;
import com.fr.general.Inter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.util.HashMap;

public class ChartXMLUtils {
    private static HashMap plotNames = null;

    private ChartXMLUtils() {
    }

    private static String getPlotClassName(String string) {
        if (string != null) {
            String string2 = "com.fr.chart.plot.MapPlot";
            string2.split("\\.");
            String[] stringArray = string.split("\\.");
            String string3 = stringArray[stringArray.length - 1];
            if (plotNames == null) {
                plotNames = new HashMap();
                plotNames.put("Bar2DPlot", Bar2DPlot.class.getName());
                plotNames.put("Bar3DPlot", Bar3DPlot.class.getName());
                plotNames.put("LinePlot", LinePlot.class.getName());
                plotNames.put("PiePlot", PiePlot.class.getName());
                plotNames.put("Pie3DPlot", Pie3DPlot.class.getName());
                plotNames.put("AreaPlot", AreaPlot.class.getName());
                plotNames.put("Area3DPlot", Area3DPlot.class.getName());
                plotNames.put("XYScatterPlot", XYScatterPlot.class.getName());
                plotNames.put("BubblePlot", BubblePlot.class.getName());
                plotNames.put("RadarPlot", RadarPlot.class.getName());
                plotNames.put("StockPlot", StockPlot.class.getName());
                plotNames.put("MeterPlot", MeterPlot.class.getName());
                plotNames.put("MeterCustomPlot", MeterCustomPlot.class.getName());
                plotNames.put("RangePlot", RangePlot.class.getName());
                plotNames.put("CustomPlot", CustomPlot.class.getName());
                plotNames.put("MapPlot", MapPlot.class.getName());
                plotNames.put("GanttPlot", GanttPlot.class.getName());
            }
            if (plotNames.containsKey(string3)) {
                return Utils.objectToString(plotNames.get(string3));
            }
        }
        return null;
    }

    public static XMLable readChartPlot(XMLableReader xMLableReader, String string) {
        String string2 = ChartXMLUtils.getPlotClassName(string);
        XMLable xMLable = null;
        if (string2 != null) {
            try {
                xMLable = (XMLable)GeneralUtils.classForName(string2).newInstance();
                xMLableReader.readXMLObject(xMLable);
            }
            catch (Exception exception) {
                FRContext.getLogger().error(exception.getMessage(), exception);
            }
        }
        return xMLable;
    }

    public static Axis readAxis(XMLableReader xMLableReader) {
        Axis axis = null;
        String string = xMLableReader.getAttrAsString("class", null);
        if (string != null) {
            if (string.endsWith(".ValueAxis")) {
                axis = new ValueAxis();
            } else if (string.endsWith(".CategoryAxis")) {
                axis = new CategoryAxis();
            } else if (string.endsWith(".DateAxis")) {
                axis = new CategoryAxis();
            }
        }
        if (axis != null) {
            axis = (Axis)xMLableReader.readXMLObject(axis);
        }
        return axis;
    }

    public static final BubbleChartData chartData4Bubble(ChartData chartData) {
        BubbleChartData bubbleChartData = null;
        if (chartData instanceof BubbleChartData) {
            bubbleChartData = (BubbleChartData)chartData;
        } else if (chartData instanceof NormalChartData) {
            bubbleChartData = (BubbleChartData)new BubblePlot().createNullChartData();
        }
        return bubbleChartData;
    }

    public static final ScatterChartData chartData4XY(ChartData chartData) {
        ScatterChartData scatterChartData = null;
        if (chartData instanceof ScatterChartData) {
            scatterChartData = (ScatterChartData)chartData;
        } else if (chartData instanceof NormalChartData) {
            scatterChartData = (ScatterChartData)new XYScatterPlot().createNullChartData();
        }
        return scatterChartData;
    }

    public static final StockChartData chartData4Stock(ChartData chartData) {
        StockChartData stockChartData = null;
        if (chartData instanceof StockChartData) {
            stockChartData = (StockChartData)chartData;
        } else if (chartData instanceof NormalChartData) {
            stockChartData = (StockChartData)new StockPlot().createNullChartData();
        }
        return stockChartData;
    }

    public static final GanttChartData chartData4Gantt(ChartData chartData) {
        GanttChartData ganttChartData = null;
        ganttChartData = chartData instanceof GanttChartData ? (GanttChartData)chartData : (chartData instanceof NormalChartData ? (GanttChartData)new GanttPlot().createNullChartData() : (GanttChartData)new GanttPlot().createNullChartData());
        return ganttChartData;
    }

    public static MeterChartData chartData4Meter(ChartData chartData) {
        MeterChartData meterChartData = null;
        if (chartData instanceof MeterChartData) {
            meterChartData = (MeterChartData)chartData;
        } else if (chartData instanceof NormalChartData) {
            meterChartData = (MeterChartData)new MeterPlot().createNullChartData();
        }
        return meterChartData;
    }

    public static final TopDefinition deal65XMLDefinition(Chart chart, TopDefinition topDefinition) {
        Plot plot = chart.getPlot();
        if (plot instanceof XYScatterPlot) {
            return ChartXMLUtils.combSpecXYDefinition(topDefinition);
        }
        if (plot instanceof BubblePlot) {
            return ChartXMLUtils.combSpecBubbleDefinition(topDefinition);
        }
        if (plot instanceof MapPlot && (topDefinition instanceof OneValueCDDefinition || topDefinition instanceof NormalReportDataDefinition)) {
            return ChartXMLUtils.combSpecMapDefinition(topDefinition);
        }
        return topDefinition;
    }

    private static TopDefinition combSpecGisMapDefinition(TopDefinition topDefinition) {
        return topDefinition;
    }

    private static TopDefinition combSpecMapDefinition(TopDefinition topDefinition) {
        if (topDefinition instanceof OneValueCDDefinition) {
            OneValueCDDefinition oneValueCDDefinition = (OneValueCDDefinition)topDefinition;
            MapSingleLayerTableDefinition mapSingleLayerTableDefinition = new MapSingleLayerTableDefinition();
            mapSingleLayerTableDefinition.setTableData(oneValueCDDefinition.getTableData());
            mapSingleLayerTableDefinition.setAreaName(oneValueCDDefinition.getSeriesColumnName());
            SeriesDefinition seriesDefinition = new SeriesDefinition();
            seriesDefinition.setSeriesName(Inter.getLocText("Value"));
            seriesDefinition.setValue(oneValueCDDefinition.getValueColumnName());
            mapSingleLayerTableDefinition.addTitleValue(seriesDefinition);
            return mapSingleLayerTableDefinition;
        }
        if (topDefinition instanceof NormalReportDataDefinition) {
            NormalReportDataDefinition normalReportDataDefinition = (NormalReportDataDefinition)topDefinition;
            MapSingleLayerReportDefinition mapSingleLayerReportDefinition = new MapSingleLayerReportDefinition();
            if (normalReportDataDefinition.size() >= 1) {
                SeriesDefinition seriesDefinition = (SeriesDefinition)normalReportDataDefinition.get(0);
                SeriesDefinition seriesDefinition2 = new SeriesDefinition();
                seriesDefinition2.setSeriesName(Inter.getLocText("Value"));
                seriesDefinition2.setValue(seriesDefinition.getValue());
                mapSingleLayerReportDefinition.setCategoryName(seriesDefinition.getSeriesName());
                mapSingleLayerReportDefinition.addTitleValue(seriesDefinition2);
                return mapSingleLayerReportDefinition;
            }
        }
        return topDefinition;
    }

    private static TopDefinition combSpecBubbleDefinition(TopDefinition topDefinition) {
        if (topDefinition instanceof MoreNameCDDefinition) {
            MoreNameCDDefinition moreNameCDDefinition = (MoreNameCDDefinition)topDefinition;
            ChartSummaryColumn[] chartSummaryColumnArray = moreNameCDDefinition.getChartSummaryColumn();
            if (chartSummaryColumnArray.length == 3) {
                BubbleTableDefinition bubbleTableDefinition = new BubbleTableDefinition();
                bubbleTableDefinition.setTableData(moreNameCDDefinition.getTableData());
                for (int i2 = 0; i2 < chartSummaryColumnArray.length; ++i2) {
                    if (i2 == 0) {
                        bubbleTableDefinition.setBubbleX(chartSummaryColumnArray[i2].getName());
                        bubbleTableDefinition.setSeriesName(moreNameCDDefinition.getCategoryName());
                        continue;
                    }
                    if (i2 == 1) {
                        bubbleTableDefinition.setBubbleY(chartSummaryColumnArray[i2].getName());
                        continue;
                    }
                    if (i2 != 2) continue;
                    bubbleTableDefinition.setBubbleSize(chartSummaryColumnArray[i2].getName());
                }
                ChartXMLUtils.comDefinitionPresent(bubbleTableDefinition, moreNameCDDefinition);
                return bubbleTableDefinition;
            }
            return null;
        }
        if (topDefinition instanceof NormalReportDataDefinition) {
            NormalReportDataDefinition normalReportDataDefinition = (NormalReportDataDefinition)topDefinition;
            if (normalReportDataDefinition.size() == 3) {
                BubbleReportDefinition bubbleReportDefinition = new BubbleReportDefinition();
                BubbleSeriesValue bubbleSeriesValue = new BubbleSeriesValue();
                SeriesDefinition seriesDefinition = (SeriesDefinition)normalReportDataDefinition.get(0);
                bubbleSeriesValue.setBubbleSeriesX(seriesDefinition.getValue());
                SeriesDefinition seriesDefinition2 = (SeriesDefinition)normalReportDataDefinition.get(1);
                bubbleSeriesValue.setBubbleSeriesY(seriesDefinition2.getValue());
                bubbleSeriesValue.setBubbleSeriesName(seriesDefinition2.getSeriesName());
                SeriesDefinition seriesDefinition3 = (SeriesDefinition)normalReportDataDefinition.get(2);
                bubbleSeriesValue.setBubbleSeriesSize(seriesDefinition3.getValue());
                bubbleReportDefinition.add(bubbleSeriesValue);
                ChartXMLUtils.comDefinitionPresent(bubbleReportDefinition, normalReportDataDefinition);
                return bubbleReportDefinition;
            }
            return null;
        }
        return topDefinition;
    }

    private static TopDefinition combSpecXYDefinition(TopDefinition topDefinition) {
        if (topDefinition instanceof MoreNameCDDefinition) {
            MoreNameCDDefinition moreNameCDDefinition = (MoreNameCDDefinition)topDefinition;
            ChartSummaryColumn[] chartSummaryColumnArray = moreNameCDDefinition.getChartSummaryColumn();
            if (chartSummaryColumnArray.length == 1) {
                ScatterTableDefinition scatterTableDefinition = new ScatterTableDefinition();
                scatterTableDefinition.setTableData(moreNameCDDefinition.getTableData());
                scatterTableDefinition.setScatterX(moreNameCDDefinition.getCategoryName());
                scatterTableDefinition.setScatterY(chartSummaryColumnArray[0].getName());
                scatterTableDefinition.setSeriesName(chartSummaryColumnArray[0].getCustomName() + " ");
                ChartXMLUtils.comDefinitionPresent(scatterTableDefinition, moreNameCDDefinition);
                return scatterTableDefinition;
            }
            return null;
        }
        if (topDefinition instanceof NormalReportDataDefinition) {
            NormalReportDataDefinition normalReportDataDefinition = (NormalReportDataDefinition)topDefinition;
            ScatterReportDefinition scatterReportDefinition = new ScatterReportDefinition();
            for (int i2 = 0; i2 < normalReportDataDefinition.size(); ++i2) {
                ScatterSeriesValue scatterSeriesValue = new ScatterSeriesValue();
                SeriesDefinition seriesDefinition = (SeriesDefinition)normalReportDataDefinition.get(i2);
                scatterSeriesValue.setScatterSeriesX(normalReportDataDefinition.getCategoryName());
                scatterSeriesValue.setScatterSeriesY(seriesDefinition.getValue());
                scatterSeriesValue.setScatterSeriesName(seriesDefinition.getSeriesName());
                scatterReportDefinition.add(scatterSeriesValue);
            }
            ChartXMLUtils.comDefinitionPresent(scatterReportDefinition, normalReportDataDefinition);
            return scatterReportDefinition;
        }
        return topDefinition;
    }

    private static void comDefinitionPresent(TopDefinition topDefinition, TopDefinition topDefinition2) {
        topDefinition.setDiscardOtherCate(topDefinition2.isDiscardOtherCate());
        topDefinition.setDiscardOtherSeries(topDefinition2.isDiscardOtherSeries());
        topDefinition.setTopCate(topDefinition2.getTopCate());
        topDefinition.setTopSeries(topDefinition2.getTopSeries());
        topDefinition.setCategoryPresent(topDefinition2.getCategoryPresent());
        topDefinition.setSeriesPresent(topDefinition2.getSeriesPresent());
    }
}

