/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartattr;

import com.fr.base.FRContext;
import com.fr.base.chart.BaseChart;
import com.fr.base.chart.BaseChartGlyph;
import com.fr.base.chart.BasePlot;
import com.fr.base.chartdata.ChartData;
import com.fr.base.chartdata.TopDefinition;
import com.fr.chart.chartattr.ChartXMLCompatibleUtils;
import com.fr.chart.chartattr.ChartXMLUtils;
import com.fr.chart.chartattr.CustomPlot;
import com.fr.chart.chartattr.LinePlot;
import com.fr.chart.chartattr.MapPlot;
import com.fr.chart.chartattr.MeterPlot;
import com.fr.chart.chartattr.PiePlot;
import com.fr.chart.chartattr.Plot;
import com.fr.chart.chartattr.Title;
import com.fr.chart.chartdata.ChartSummaryColumn;
import com.fr.chart.chartdata.MoreNameCDDefinition;
import com.fr.chart.chartdata.NormalChartData;
import com.fr.chart.chartdata.NormalReportDataDefinition;
import com.fr.chart.chartdata.NormalTableDataDefinition;
import com.fr.chart.chartdata.OneValueCDDefinition;
import com.fr.chart.chartdata.SeriesDefinition;
import com.fr.chart.chartglyph.ChartGlyph;
import com.fr.chart.chartglyph.ConditionCollection;
import com.fr.chart.chartglyph.CustomAttr;
import com.fr.chart.chartglyph.DataSheetGlyph;
import com.fr.chart.chartglyph.GeneralInfo;
import com.fr.chart.chartglyph.LegendGlyph;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.chart.chartglyph.TitleGlyph;
import com.fr.data.util.function.DataFunction;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRFont;
import com.fr.general.RegistEditionException;
import com.fr.general.VT4FR;
import com.fr.general.data.MOD_COLUMN_ROW;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.js.NameJavaScriptGroup;
import com.fr.script.Calculator;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;
import java.text.Format;
import java.util.List;

public class Chart
extends GeneralInfo
implements BaseChart {
    private static final long serialVersionUID = -2818043793300636874L;
    public static final String XML_TAG = "Chart";
    private TopDefinition filterDefinition;
    private Title title = new Title();
    private Plot plot;
    private boolean isJSDraw = true;

    public Chart() {
        this(null);
    }

    public Chart(Plot plot) {
        this.plot = plot;
        this.setBorderColor(new Color(150, 150, 150));
        this.setBorderStyle(0);
    }

    public void initChart(BasePlot basePlot) {
        this.plot = (Plot)basePlot;
        this.setBorderColor(new Color(150, 150, 150));
        this.setBorderStyle(0);
    }

    public Title getTitle() {
        return this.title;
    }

    public void setTitle(Title title) {
        this.title = title;
    }

    public Plot getPlot() {
        return this.plot;
    }

    public BasePlot getBasePlot() {
        return this.plot;
    }

    public void setFilterDefinition(TopDefinition topDefinition) {
        this.filterDefinition = topDefinition;
    }

    public TopDefinition getFilterDefinition() {
        return this.filterDefinition;
    }

    public String getChartName() {
        return this.plot == null ? "" : this.plot.getPlotName();
    }

    public void setPlot(Plot plot) {
        this.plot = plot;
    }

    public void changePlotFormat4ADHOC(Format format) {
        this.getPlot().getHotTooltipStyle().setFormat(format);
    }

    public void setJSDraw(boolean bl) {
        this.isJSDraw = bl;
    }

    public boolean isJSDraw() {
        return this.isJSDraw;
    }

    public BaseChartGlyph createGlyph(ChartData chartData) {
        ChartGlyph chartGlyph = new ChartGlyph();
        chartGlyph.setGeneralInfo(this);
        chartGlyph.setJSDraw(this.isJSDraw());
        this.createTitleGlyph4ChartGlyph(chartGlyph);
        PlotGlyph plotGlyph = this.createPlotGlyph4ChartGlyph(chartData, chartGlyph);
        this.createLegendGlyph(chartGlyph, plotGlyph);
        String string = "aaaaa";
        if (!this.isMoreCateData(chartData)) {
            this.createDataSheetGlyph4ChartGlyph(chartGlyph, plotGlyph);
        }
        return chartGlyph;
    }

    private boolean isMoreCateData(ChartData chartData) {
        if (chartData instanceof NormalChartData) {
            NormalChartData normalChartData = (NormalChartData)chartData;
            return normalChartData.getSecondCates() != null && normalChartData.getSecondCates().length > 0;
        }
        return false;
    }

    public ChartData createNullChartData() {
        return this.getPlot() != null ? this.getPlot().createNullChartData() : new NormalChartData(new Object[]{""}, new Object[]{""}, new Object[][]{{""}});
    }

    private void createTitleGlyph4ChartGlyph(ChartGlyph chartGlyph) {
        if (this.title != null) {
            try {
                TitleGlyph titleGlyph = this.title.createGlyph();
                chartGlyph.setTitleGlyph(titleGlyph);
            }
            catch (Exception exception) {
                chartGlyph.setTitleGlyph(new TitleGlyph());
                String string = "Error happens at Chart Title.\nerror message is " + exception.getMessage();
                FRContext.getLogger().error(string, exception);
            }
        }
    }

    private void createLegendGlyph(ChartGlyph chartGlyph, PlotGlyph plotGlyph) {
        LegendGlyph legendGlyph = this.plot.createLegendGlyph(plotGlyph);
        chartGlyph.setLegendGlyph(legendGlyph);
    }

    private PlotGlyph createPlotGlyph4ChartGlyph(ChartData chartData, ChartGlyph chartGlyph) {
        PlotGlyph plotGlyph = null;
        try {
            plotGlyph = this.plot.createPlotGlyph(chartData);
            chartGlyph.setPlotGlyph(plotGlyph);
        }
        catch (Exception exception) {
            chartGlyph.setPlotGlyph(null);
            String string = "Error happens at Chart Plot.\nerror message is " + exception.getMessage();
            FRContext.getLogger().error(string, exception);
        }
        return plotGlyph;
    }

    public void changeSimDemo4ADHOC() {
        this.setTitle(null);
        this.getPlot().setLegend(null);
        if (this.getPlot().getDataSheet() != null) {
            this.getPlot().getDataSheet().setFont(FRFont.getInstance("SimSun", 0, 1.0f));
        }
        if (this.getPlot() instanceof MeterPlot) {
            ((MeterPlot)this.getPlot()).getMeterStyle().setTickLabelsVisible(false);
        }
    }

    public ChartData defaultChartData() {
        if (this.plot != null) {
            if (this.isUseMoreDate() && this.plot.isSupportMoreCate()) {
                int n2 = this.filterDefinition.getMoreCateSize();
                if (n2 == 1) {
                    return this.plot.defaultSecondMoreCate();
                }
                return this.plot.defaultThirdMoreCate();
            }
            return this.plot.defaultChartData();
        }
        return null;
    }

    public boolean isUseMoreDate() {
        return this.filterDefinition != null && this.filterDefinition.getMoreCateSize() > 0;
    }

    private void createDataSheetGlyph4ChartGlyph(ChartGlyph chartGlyph, PlotGlyph plotGlyph) {
        try {
            DataSheetGlyph dataSheetGlyph = this.plot.createDataSheetGlyph(plotGlyph);
            chartGlyph.setDataSheetGlyph(dataSheetGlyph);
        }
        catch (Exception exception) {
            String string = "Error happens at Chart Legend or DataSheet.\nerror message is " + exception.getMessage();
            FRContext.getLogger().error(string, exception);
        }
    }

    public void dealFormula(Calculator calculator) {
        if (this.title != null) {
            this.title.dealFormula(calculator);
        }
        if (this.plot != null) {
            this.plot.dealFormula(calculator);
        }
    }

    public void buidExecuteSequenceList(List list, Calculator calculator) {
        if (this.title != null) {
            this.title.buidExecuteSequenceList(list, calculator);
        }
        if (this.plot != null) {
            this.plot.buidExecuteSequenceList(list, calculator);
        }
    }

    public void modFormulaString(MOD_COLUMN_ROW mOD_COLUMN_ROW) {
        if (this.title != null) {
            this.title.modFormulaString(mOD_COLUMN_ROW);
        }
        if (this.plot != null) {
            this.plot.modFormulaString(mOD_COLUMN_ROW);
        }
        if (this.getFilterDefinition() != null) {
            this.getFilterDefinition().modDefinitionFormulaString(mOD_COLUMN_ROW);
        }
    }

    public void changePlotInNewType(Plot plot) {
        if (plot == null) {
            return;
        }
        if (!plot.matchPlotType(this.plot)) {
            this.setPlot(plot);
        }
    }

    public void switchPlot(Plot plot) {
        if (plot == null) {
            return;
        }
        plot.clearConditionAttrAndRenewLegend(this.getPlot());
        Plot plot2 = this.getPlot();
        if (plot2 != null && plot2.getHotHyperLink() != null && ComparatorUtils.equals(plot.getClass(), plot2.getClass())) {
            NameJavaScriptGroup nameJavaScriptGroup = plot2.getHotHyperLink();
            try {
                plot.setHotHyperLink((NameJavaScriptGroup)nameJavaScriptGroup.clone());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                FRContext.getLogger().error("Error in Hyperlink, Please Check it.", cloneNotSupportedException);
            }
        }
        if (!plot.match4GUI(this.getPlot())) {
            this.setPlot(plot);
        }
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("Title")) {
                this.title = new Title();
                xMLableReader.readXMLObject(this.title);
                this.changeTitleStyle4XML();
            } else if (string.equals("Plot")) {
                String string2 = xMLableReader.getAttrAsString("class", null);
                if (string2 != null && string2.endsWith("Line3DPlot")) {
                    this.plot = (Plot)xMLableReader.readXMLObject(new LinePlot());
                } else {
                    this.plot = (Plot)GeneralXMLTools.readXMLable(xMLableReader);
                    if (!(!(this.plot instanceof MapPlot) || VT4FR.isLicAvailable(StableUtils.getBytes()) && VT4FR.CHART_MAP.support())) {
                        throw new RegistEditionException(VT4FR.CHART_MAP);
                    }
                    this.check4Custom();
                }
            } else if (string.equals("ChartAttr")) {
                this.setJSDraw(xMLableReader.getAttrAsBoolean("isJSDraw", true));
            } else if (ComparatorUtils.equals(string, "ChartDefinition")) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        Chart.this.filterDefinition = ChartXMLUtils.deal65XMLDefinition(Chart.this, ChartXMLCompatibleUtils.readDefinition(xMLableReader));
                    }
                });
                Chart.comChange4PiePlot(this, xMLableReader);
            }
        }
    }

    private void check4Custom() {
        ConditionCollection conditionCollection;
        if (this.plot instanceof CustomPlot && (conditionCollection = this.plot.getConditionCollection()) != null && !(conditionCollection.getDefaultAttr() instanceof CustomAttr)) {
            conditionCollection.setDefaultAttr(new CustomAttr());
        }
    }

    public static void comChange4PiePlot(Chart chart, XMLableReader xMLableReader) {
        if (chart == null) {
            return;
        }
        Plot plot = chart.getPlot();
        if (plot instanceof PiePlot) {
            TopDefinition topDefinition;
            if (xMLableReader.getXMLVersion().isBefore702_FOR_CHART_PIE()) {
                Chart.readPieDefinition(chart);
            }
            if ((topDefinition = chart.getFilterDefinition()) == null) {
                return;
            }
            if (topDefinition.getCategoryPresent() != null && topDefinition.getSeriesPresent() == null) {
                topDefinition.setSeriesPresent(topDefinition.getCategoryPresent());
                topDefinition.setCategoryPresent(null);
            }
            if (topDefinition instanceof NormalTableDataDefinition) {
                ((NormalTableDataDefinition)topDefinition).setCategoryName("");
            } else if (topDefinition instanceof NormalReportDataDefinition) {
                ((NormalReportDataDefinition)topDefinition).setCategoryName("");
            }
        }
    }

    private static void readPieDefinition(Chart chart) {
        Object object;
        SeriesDefinition seriesDefinition;
        NormalReportDataDefinition normalReportDataDefinition;
        TopDefinition topDefinition = chart.getFilterDefinition();
        if (topDefinition instanceof MoreNameCDDefinition) {
            ChartSummaryColumn[] chartSummaryColumnArray;
            MoreNameCDDefinition moreNameCDDefinition = (MoreNameCDDefinition)topDefinition;
            String string = moreNameCDDefinition.getCategoryName();
            if (!StringUtils.isEmpty(string) && (chartSummaryColumnArray = moreNameCDDefinition.getChartSummaryColumn()) != null && chartSummaryColumnArray.length > 0) {
                ChartSummaryColumn chartSummaryColumn = chartSummaryColumnArray[0];
                String string2 = chartSummaryColumn.getName();
                DataFunction dataFunction = chartSummaryColumn.getFunction();
                OneValueCDDefinition oneValueCDDefinition = new OneValueCDDefinition(moreNameCDDefinition.getTableData(), "", string, string2, dataFunction);
                if (moreNameCDDefinition.getCategoryPresent() != null && moreNameCDDefinition.getSeriesPresent() == null) {
                    oneValueCDDefinition.setSeriesPresent(moreNameCDDefinition.getCategoryPresent());
                }
                chart.setFilterDefinition(oneValueCDDefinition);
            }
        } else if (topDefinition instanceof OneValueCDDefinition) {
            OneValueCDDefinition oneValueCDDefinition = (OneValueCDDefinition)topDefinition;
            if (!StringUtils.isEmpty(oneValueCDDefinition.getCategoryName()) && StringUtils.isEmpty(oneValueCDDefinition.getSeriesColumnName())) {
                oneValueCDDefinition.setSeriesColumnName(oneValueCDDefinition.getCategoryName());
            }
        } else if (topDefinition instanceof NormalReportDataDefinition && (normalReportDataDefinition = (NormalReportDataDefinition)topDefinition).size() == 1 && (seriesDefinition = (SeriesDefinition)normalReportDataDefinition.get(0)) != null && (object = seriesDefinition.getSeriesName()) != null) {
            String string = object.toString();
            if (string.startsWith("=")) {
                if (StringUtils.isEmpty(string)) {
                    seriesDefinition.setSeriesName(normalReportDataDefinition.getCategoryName());
                }
            } else if (StringUtils.isEmpty(object.toString())) {
                seriesDefinition.setSeriesName(normalReportDataDefinition.getCategoryName());
            }
        }
    }

    private void changeTitleStyle4XML() {
        if (this.title != null && this.title.getTextAttr() != null) {
            this.title.getTextAttr().setAlignText(0);
            this.title.getTextAttr().setRotation(0);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG).attr("class", this.getClass().getName());
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("ChartAttr").attr("isJSDraw", this.isJSDraw).end();
        if (this.title != null) {
            this.title.writeXML(xMLPrintWriter);
        }
        if (this.plot != null) {
            GeneralXMLTools.writeXMLable(xMLPrintWriter, this.plot, "Plot");
        }
        if (this.filterDefinition != null) {
            xMLPrintWriter.startTAG("ChartDefinition");
            this.filterDefinition.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        Chart chart = (Chart)super.clone();
        if (this.title != null) {
            chart.title = (Title)this.title.clone();
        }
        if (this.plot != null) {
            chart.plot = (Plot)this.plot.clone();
        }
        if (this.getFilterDefinition() != null) {
            chart.setFilterDefinition((TopDefinition)this.getFilterDefinition().clone());
        }
        return chart;
    }

    public boolean equals(Object object) {
        return object instanceof Chart && super.equals(object) && ComparatorUtils.equals(((Chart)object).getPlot(), this.plot) && ComparatorUtils.equals(((Chart)object).getTitle(), this.title) && ComparatorUtils.equals(((Chart)object).getFilterDefinition(), this.getFilterDefinition()) && ((Chart)object).isJSDraw() == this.isJSDraw;
    }
}

