/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartattr;

import com.fr.base.chartdata.ChartData;
import com.fr.chart.chartattr.CategoryPlot;
import com.fr.chart.chartattr.Plot;
import com.fr.chart.chartglyph.BarPlotGlyph;
import com.fr.general.Inter;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;

public abstract class BarPlot
extends CategoryPlot {
    private static final long serialVersionUID = 6388999613764540798L;
    private static final double STA_SERIES_GAP = -0.25;
    protected boolean isHorizontal = false;
    protected double seriesOverlapPercent = -0.25;
    protected double categoryIntervalPercent = 1.0;

    public void install4PlotGlyph(BarPlotGlyph barPlotGlyph, ChartData chartData) {
        super.install4PlotGlyph(barPlotGlyph, chartData);
        barPlotGlyph.setHorizontal(this.isHorizontal);
        barPlotGlyph.setSeriesOverlapPercent(this.seriesOverlapPercent);
        barPlotGlyph.setCategoryIntervalPercent(this.categoryIntervalPercent);
    }

    public void setHorizontal(boolean bl) {
        this.isHorizontal = bl;
        if (!this.getxAxis().hasAxisReversed() && !this.getyAxis().hasAxisReversed()) {
            if (bl) {
                this.getxAxis().setPosition(2);
                this.getyAxis().setPosition(3);
            } else {
                this.getxAxis().setPosition(3);
                this.getyAxis().setPosition(2);
            }
        }
    }

    public boolean isHorizontal() {
        return this.isHorizontal;
    }

    public boolean isSupportDataSheet() {
        return !this.isHorizontal;
    }

    public boolean isSupportMoreCate() {
        return !this.isHorizontal;
    }

    public void setSeriesOverlapPercent(double d2) {
        this.seriesOverlapPercent = d2;
    }

    public double getSeriesOverlapPercent() {
        return this.seriesOverlapPercent;
    }

    public String getPlotName() {
        String string = "";
        string = this.isHorizontal() ? Inter.getLocText("ChartF-Bar") : Inter.getLocText("ChartF-Column");
        if (this.isStacked()) {
            string = Inter.getLocText("ChartF-Stacked") + string;
        }
        if (this.getyAxis().isPercentage()) {
            string = Inter.getLocText("StyleFormat-Percent") + string;
        }
        return string;
    }

    public void setCategoryIntervalPercent(double d2) {
        this.categoryIntervalPercent = d2;
    }

    public double getCategoryIntervalPercent() {
        return this.categoryIntervalPercent;
    }

    public boolean match4GUI(Plot plot) {
        return super.match4GUI(plot) && this.isHorizontal == ((BarPlot)plot).isHorizontal;
    }

    public boolean matchPlotType(Plot plot) {
        return plot instanceof BarPlot && ((BarPlot)plot).isHorizontal == this.isHorizontal;
    }

    public boolean isSupportSeriesDrag() {
        return true;
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && "BarAttr".equals(string = xMLableReader.getTagName())) {
            this.setHorizontal(xMLableReader.getAttrAsBoolean("isHorizontal", false));
            this.setSeriesOverlapPercent(xMLableReader.getAttrAsDouble("overlap", -0.25));
            this.setCategoryIntervalPercent(xMLableReader.getAttrAsDouble("interval", 1.0));
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("BarAttr").attr("isHorizontal", this.isHorizontal).attr("overlap", this.seriesOverlapPercent).attr("interval", this.categoryIntervalPercent).end();
    }

    public boolean equals(Object object) {
        return object instanceof BarPlot && super.equals(object) && ((BarPlot)object).getCategoryIntervalPercent() == this.categoryIntervalPercent && ((BarPlot)object).getSeriesOverlapPercent() == this.seriesOverlapPercent && ((BarPlot)object).isHorizontal() == this.isHorizontal;
    }
}

