/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartattr;

import com.fr.base.BaseXMLUtils;
import com.fr.base.FRContext;
import com.fr.base.Formula;
import com.fr.base.Utils;
import com.fr.base.background.ColorBackground;
import com.fr.base.chartdata.ChartData;
import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.base.TextAttr;
import com.fr.chart.chartattr.AxisData;
import com.fr.chart.chartattr.Title;
import com.fr.chart.chartglyph.AxisGlyph;
import com.fr.general.Background;
import com.fr.general.ComparatorUtils;
import com.fr.general.DateUtils;
import com.fr.general.FArray;
import com.fr.general.GeneralUtils;
import com.fr.general.data.MOD_COLUMN_ROW;
import com.fr.script.Calculator;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;
import java.math.BigDecimal;
import java.text.Format;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;

public abstract class Axis
implements XMLable {
    public static final String XML_TAG = "Axis";
    private static final long serialVersionUID = 3591400366172688862L;
    private static final int LABEL_NONE = 0;
    private static final int LABEL_AROUND = 3;
    protected boolean axisReversed = false;
    protected int position = 3;
    private Color lineColor = new Color(176, 176, 176);
    private int lineStyle = 1;
    private boolean isArrowShow = false;
    private boolean isZoom = false;
    protected AxisData axisData = new AxisData();

    public abstract AxisGlyph createAxisGlyph(ChartData var1);

    public void checkSimpleAxis4PlotDemo() {
    }

    public void initAxisGlyph(AxisGlyph axisGlyph) {
        this.initAxisGlyphLinesGridTickAttr(axisGlyph);
        this.initAxisGlyphLabelsAttr(axisGlyph);
        this.initAxisGlyphMinMaxValues(axisGlyph);
        axisGlyph.setZoom(this.isZoom);
    }

    private void initAxisGlyphLinesGridTickAttr(AxisGlyph axisGlyph) {
        axisGlyph.setPosition(this.getPosition());
        axisGlyph.setAxisReversed(this.axisReversed);
        axisGlyph.setTickMarkType(this.getTickMarkType());
        axisGlyph.setSecTickMarkType(this.getSecTickMarkType());
        axisGlyph.setMainGridStyle(this.getMainGridStyle());
        axisGlyph.setMainGridColor(this.getMainGridColor());
        axisGlyph.setLineColor(this.getAxisColor());
        axisGlyph.setLineStyle(this.getAxisStyle());
    }

    private void initAxisGlyphLabelsAttr(AxisGlyph axisGlyph) {
        Number number;
        try {
            axisGlyph.setTextAttr((TextAttr)this.getTextAttr().clone());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            FRContext.getLogger().error(cloneNotSupportedException.getMessage(), cloneNotSupportedException);
        }
        if (this.getFormat() != null) {
            axisGlyph.setFormat((Format)this.getFormat().clone());
        }
        if ((number = ChartBaseUtils.formula2Number(this.getLabelNumber())) != null) {
            axisGlyph.setLabelNumber(number.intValue());
        } else {
            axisGlyph.setLabelNumber(0);
        }
        axisGlyph.setShowAxisLabel(this.isShowAxisLabel());
        axisGlyph.setArrowShow(this.isShowAxisWithLineStyle(this.getAxisStyle()));
        if (this.getTitle() != null && this.getTitle().isTitleVisble()) {
            axisGlyph.setTitleGlyph(this.getTitle().createGlyph4AxisTitle());
        }
    }

    private boolean isShowAxisWithLineStyle(int n2) {
        return n2 == 22 || n2 == 23 || n2 == 21;
    }

    private void initAxisGlyphMinMaxValues(AxisGlyph axisGlyph) {
        axisGlyph.setCustomMaxValue(this.isCustomMaxValue());
        if (this.isCustomMaxValue()) {
            axisGlyph.setMaxValue(this.dealFormual2Value(this.getMaxValue()));
        }
        axisGlyph.setCustomMinValue(this.isCustomMinValue());
        if (this.isCustomMinValue()) {
            axisGlyph.setMinValue(this.dealFormual2Value(this.getMinValue()));
        }
        axisGlyph.setCustomMainUnit(this.isCustomMainUnit());
        if (this.isCustomMainUnit()) {
            axisGlyph.setMainUnit(this.dealMainUnitBigDecimal());
        }
        axisGlyph.setCustomSecUnit(this.isCustomSecUnit());
        if (this.isCustomSecUnit()) {
            axisGlyph.setSecUnit(this.dealSecondUnitFormula());
        }
    }

    private double dealFormual2Value(Formula formula) {
        Object object = formula.getResult();
        if (object instanceof FArray) {
            return this.dealStringOrDate2Value(((FArray)object).elementAt(0));
        }
        Number number = ChartBaseUtils.formula2Number(formula);
        if (number != null) {
            return number.doubleValue();
        }
        double d2 = this.dealStringOrDate2Value(formula);
        if (d2 != 0.0) {
            return d2;
        }
        return 0.0;
    }

    private double dealStringOrDate2Value(Object object) {
        if (object != null) {
            Number number = Utils.string2Number(Utils.objectToString(object));
            if (number != null) {
                return number.doubleValue();
            }
            if (object instanceof Date) {
                return ((Date)object).getTime();
            }
            String string = Pattern.compile("=").matcher(Utils.objectToString(object)).replaceAll("");
            string = Pattern.compile("\"").matcher(string).replaceAll("");
            Date date = DateUtils.string2Date(string, true);
            if (date != null) {
                return ChartBaseUtils.date2Int(date, 6);
            }
        }
        return 0.0;
    }

    private BigDecimal dealMainUnitBigDecimal() {
        Number number;
        if (this.isCustomMainUnit() && (number = ChartBaseUtils.formula2Number(this.getMainUnit())) != null) {
            return new BigDecimal(Double.toString(number.doubleValue()));
        }
        return new BigDecimal("1");
    }

    private double dealSecondUnitFormula() {
        Number number;
        if (this.isCustomSecUnit() && (number = ChartBaseUtils.formula2Number(this.getSecUnit())) != null) {
            return number.doubleValue();
        }
        return 1.0;
    }

    public void setAxisReversed(boolean bl) {
        this.axisReversed = bl;
    }

    public boolean hasAxisReversed() {
        return this.axisReversed;
    }

    public void setCustomMinValue(boolean bl) {
        this.axisData.isCustomMinValue = bl;
    }

    public boolean isCustomMinValue() {
        return this.axisData.isCustomMinValue;
    }

    public void setMinValue(Formula formula) {
        this.axisData.minValue = formula;
    }

    public Formula getMinValue() {
        return this.axisData.minValue;
    }

    public void setCustomMaxValue(boolean bl) {
        this.axisData.isCustomMaxValue = bl;
    }

    public boolean isCustomMaxValue() {
        return this.axisData.isCustomMaxValue;
    }

    public void setMaxValue(Formula formula) {
        this.axisData.maxValue = formula;
    }

    public Formula getMaxValue() {
        return this.axisData.maxValue;
    }

    public void setArrowShow(boolean bl) {
        this.isArrowShow = bl;
    }

    public boolean isArrowShow() {
        return this.isArrowShow;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int n2) {
        this.position = n2;
    }

    public Title getTitle() {
        return this.axisData.title;
    }

    public void setTitle(Title title) {
        this.axisData.title = title;
    }

    public int getMainGridStyle() {
        return this.axisData.mainGridStyle;
    }

    public void setMainGridStyle(int n2) {
        this.axisData.mainGridStyle = n2;
    }

    public Color getMainGridColor() {
        return this.axisData.mainGridColor;
    }

    public void setMainGridColor(Color color) {
        this.axisData.mainGridColor = color;
    }

    public void setLabelIntervalNumber(Formula formula) {
        this.axisData.labelIntervalNumber = formula;
    }

    public Formula getLabelNumber() {
        return this.axisData.labelIntervalNumber;
    }

    public void setShowAxisLabel(boolean bl) {
        this.axisData.isShowAxisLabel = bl;
    }

    public boolean isShowAxisLabel() {
        return this.axisData.isShowAxisLabel;
    }

    public boolean isPercentage() {
        return false;
    }

    public void setPercentage(boolean bl) {
    }

    public boolean isLog() {
        return false;
    }

    public void setLog(boolean bl) {
    }

    public void setFormat(Format format) {
        this.axisData.format = format;
    }

    public Format getFormat() {
        return this.axisData.format;
    }

    public void setTextAttr(TextAttr textAttr) {
        this.axisData.textAttr = textAttr;
    }

    public TextAttr getTextAttr() {
        return this.axisData.textAttr;
    }

    public Color getAxisColor() {
        return this.lineColor;
    }

    public void setAxisColor(Color color) {
        this.lineColor = color;
    }

    public void setAxisStyle(int n2) {
        this.lineStyle = n2;
    }

    public int getAxisStyle() {
        return this.lineStyle;
    }

    public void setZoom(boolean bl) {
        this.isZoom = bl;
    }

    public boolean isZoom() {
        return this.isZoom;
    }

    public void setCustomMainUnit(boolean bl) {
        this.axisData.isCustomMainUnit = bl;
    }

    public boolean isCustomMainUnit() {
        return this.axisData.isCustomMainUnit;
    }

    public void setMainUnit(Formula formula) {
        this.axisData.mainUnit = formula;
    }

    public Formula getMainUnit() {
        return this.axisData.mainUnit;
    }

    public void setSecUnit(Formula formula) {
        this.axisData.secUnit = formula;
    }

    public Formula getSecUnit() {
        return this.axisData.secUnit;
    }

    public void setCustomSecUnit(boolean bl) {
        this.axisData.isCustomSecUnit = bl;
    }

    public boolean isCustomSecUnit() {
        return this.axisData.isCustomSecUnit;
    }

    public int getTickMarkType() {
        return this.axisData.tickMarkType;
    }

    public void setTickMarkType(int n2) {
        this.axisData.tickMarkType = n2;
    }

    public void setSecTickMarkType(int n2) {
        this.axisData.secTickMarkType = n2;
    }

    public int getSecTickMarkType() {
        return this.axisData.secTickMarkType;
    }

    public void dealFormula(Calculator calculator) {
        Object object;
        Date date;
        Formula formula;
        if (this.isCustomSecUnit() && this.getSecUnit() != null) {
            Utils.dealFormulaValue(this.getSecUnit(), calculator);
        }
        if (this.isCustomMainUnit() && this.getMainUnit() != null) {
            Utils.dealFormulaValue(this.getMainUnit(), calculator);
        }
        if (this.axisData.title != null) {
            this.axisData.title.dealFormula(calculator);
        }
        if (this.axisData.labelIntervalNumber != null) {
            Utils.dealFormulaValue(this.axisData.labelIntervalNumber, calculator);
        }
        if (this.axisData.isCustomMinValue && this.axisData.minValue != null) {
            formula = this.axisData.minValue;
            date = null;
            if (this.isDateForm(this.getFormulaContents(formula))) {
                date = DateUtils.string2Date(this.getFormulaContents(formula), true);
            }
            if (date == null) {
                Utils.dealFormulaValue(this.axisData.minValue, calculator);
                object = formula.getResult();
                if (object instanceof Date) {
                    formula.setResult(new Double(ChartBaseUtils.date2Int((Date)object, 6)));
                }
            } else {
                this.axisData.minValue.setResult(ChartBaseUtils.formula2Number(formula));
            }
        }
        if (this.axisData.isCustomMaxValue && this.axisData.maxValue != null) {
            formula = this.axisData.maxValue;
            date = DateUtils.string2Date(this.getFormulaContents(formula), true);
            if (date == null) {
                Utils.dealFormulaValue(this.axisData.maxValue, calculator);
                object = formula.getResult();
                if (object instanceof Date) {
                    formula.setResult(new Double(ChartBaseUtils.date2Int((Date)object, 6)));
                }
            } else {
                this.axisData.maxValue.setResult(ChartBaseUtils.formula2Number(formula));
            }
        }
    }

    private boolean isDateForm(String string) {
        string = Pattern.compile("\"").matcher(string).replaceAll("");
        if (string.matches("^[+-]?[0-9]*[0-9]$")) {
            return false;
        }
        return DateUtils.string2Date(string, true) != null;
    }

    public void buidExecuteSequenceList(List list, Calculator calculator) {
        GeneralUtils.dealBuidExecuteSequence(this.getSecUnit(), list, calculator);
        GeneralUtils.dealBuidExecuteSequence(this.getMainUnit(), list, calculator);
        if (this.axisData.title != null) {
            this.axisData.title.buidExecuteSequenceList(list, calculator);
        }
        GeneralUtils.dealBuidExecuteSequence(this.axisData.labelIntervalNumber, list, calculator);
        GeneralUtils.dealBuidExecuteSequence(this.axisData.minValue, list, calculator);
        GeneralUtils.dealBuidExecuteSequence(this.axisData.maxValue, list, calculator);
    }

    private String getFormulaContents(Formula formula) {
        String string = Utils.objectToString(formula);
        if (string.startsWith("=")) {
            string = string.substring(1);
        }
        return string;
    }

    public void modFormulaString(MOD_COLUMN_ROW mOD_COLUMN_ROW) {
        if (this.getMainUnit() != null) {
            this.getMainUnit().modColumnRow(mOD_COLUMN_ROW);
        }
        if (this.getSecUnit() != null) {
            this.getSecUnit().modColumnRow(mOD_COLUMN_ROW);
        }
        if (this.axisData.title != null) {
            this.axisData.title.modFormulaString(mOD_COLUMN_ROW);
        }
        if (this.axisData.labelIntervalNumber != null) {
            this.axisData.labelIntervalNumber.modColumnRow(mOD_COLUMN_ROW);
        }
        if (this.axisData.maxValue != null) {
            this.axisData.maxValue.modColumnRow(mOD_COLUMN_ROW);
        }
        if (this.axisData.minValue != null) {
            this.axisData.minValue.modColumnRow(mOD_COLUMN_ROW);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        Axis axis = (Axis)super.clone();
        if (this.axisData != null) {
            axis.axisData = (AxisData)this.axisData.clone();
        }
        return axis;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (ComparatorUtils.equals(string, "Title")) {
                Title title = new Title();
                xMLableReader.readXMLObject(title);
                this.setTitle(title);
            } else if (ComparatorUtils.equals("TickLine201106", string)) {
                this.setTickMarkType(xMLableReader.getAttrAsInt("type", 2));
                this.setSecTickMarkType(xMLableReader.getAttrAsInt("secType", 0));
            } else if (ComparatorUtils.equals(string, "AxisLabelCount")) {
                this.setLabelIntervalNumber(new Formula(xMLableReader.getAttrAsString("value", "0")));
            } else if (ComparatorUtils.equals(string, "AxisLineStyle")) {
                this.setAxisStyle(xMLableReader.getAttrAsInt("AxisStyle", 1));
                this.setMainGridStyle(xMLableReader.getAttrAsInt("MainGridStyle", 0));
            } else if (ComparatorUtils.equals("newLineColor", string)) {
                this.setMainGridColor(xMLableReader.getAttrAsColor("mainGridColor", null));
                this.lineColor = xMLableReader.getAttrAsColor("lineColor", null);
            } else if (ComparatorUtils.equals(string, "newAxisAttr")) {
                this.axisData.isShowAxisLabel = xMLableReader.getAttrAsBoolean("isShowAxisLabel", true);
            } else if (ComparatorUtils.equals(string, "ZoomAxisAttr")) {
                this.setZoom(xMLableReader.getAttrAsBoolean("isZoom", false));
            } else if (ComparatorUtils.equals(string, "axisReversed")) {
                this.setAxisReversed(xMLableReader.getAttrAsBoolean("axisReversed", false));
            } else if (ComparatorUtils.equals("TextAttr", string)) {
                this.setTextAttr((TextAttr)xMLableReader.readXMLObject(new TextAttr()));
            } else if (ComparatorUtils.equals(string, "Format")) {
                this.setFormat(BaseXMLUtils.readFormat(xMLableReader));
            } else if (ComparatorUtils.equals(string, "ArrowShow")) {
                this.setArrowShow(xMLableReader.getAttrAsBoolean("arrowShow", false));
            } else if (ComparatorUtils.equals(string, "AxisRange")) {
                this.readAxisRange(xMLableReader);
            } else if (ComparatorUtils.equals(string, "AxisPosition")) {
                this.setPosition(xMLableReader.getAttrAsInt("value", 3));
            } else if (ComparatorUtils.equals(string, "AxisUnit201106")) {
                this.readAxisUnit(xMLableReader);
            } else {
                this.combine(xMLableReader);
            }
        }
    }

    private void combine(XMLableReader xMLableReader) {
        String string = xMLableReader.getTagName();
        if (ComparatorUtils.equals("AxisLine", string)) {
            this.setAxisStyle(xMLableReader.getAttrAsInt("style", 1));
            this.lineColor = xMLableReader.getAttrAsColor("color", new Color(176, 176, 176));
        } else if (ComparatorUtils.equals(string, "AxisLineBackground")) {
            this.combiAxisLineBackground(xMLableReader);
        } else if (ComparatorUtils.equals("MainGridLine", string)) {
            this.setMainGridStyle(xMLableReader.getAttrAsInt("style", 0));
            this.setMainGridColor(xMLableReader.getAttrAsColor("color", null));
        } else if (ComparatorUtils.equals(string, "MainGridBackground")) {
            this.combiGridBackground(xMLableReader);
        } else if (ComparatorUtils.equals(string, "AxisShow")) {
            if (!xMLableReader.getAttrAsBoolean("axisShow", true)) {
                this.setAxisStyle(0);
            }
        } else if (ComparatorUtils.equals(string, "AxisLabelPosition")) {
            this.setShowAxisLabel(xMLableReader.getAttrAsInt("value", 3) != 0);
        } else if (ComparatorUtils.equals(string, "TickLine")) {
            this.combineLine(xMLableReader);
        }
    }

    private void readAxisRange(XMLableReader xMLableReader) {
        String string = "";
        string = xMLableReader.getAttrAsString("minValue", null);
        if (string != null) {
            this.setCustomMinValue(true);
            this.setMinValue(new Formula(string));
        }
        if ((string = xMLableReader.getAttrAsString("maxValue", null)) != null) {
            this.setCustomMaxValue(true);
            this.setMaxValue(new Formula(string));
        }
    }

    private void readAxisUnit(XMLableReader xMLableReader) {
        String string = "";
        this.axisData.isCustomMainUnit = xMLableReader.getAttrAsBoolean("isCustomMainUnit", false);
        this.axisData.isCustomSecUnit = xMLableReader.getAttrAsBoolean("isCustomSecUnit", false);
        string = xMLableReader.getAttrAsString("mainUnit", null);
        if (string != null) {
            this.axisData.mainUnit = new Formula(string);
        }
        if ((string = xMLableReader.getAttrAsString("secUnit", null)) != null) {
            this.axisData.secUnit = new Formula(string);
        }
    }

    private void combiAxisLineBackground(XMLableReader xMLableReader) {
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                Background background;
                if (ComparatorUtils.equals(xMLableReader.getTagName(), "Background") && (background = BaseXMLUtils.readBackground(xMLableReader)) instanceof ColorBackground) {
                    Axis.this.lineColor = ((ColorBackground)background).getColor();
                }
            }
        });
    }

    private void combiGridBackground(XMLableReader xMLableReader) {
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                Background background;
                if (ComparatorUtils.equals(xMLableReader.getTagName(), "Background") && (background = BaseXMLUtils.readBackground(xMLableReader)) instanceof ColorBackground) {
                    ColorBackground colorBackground = (ColorBackground)background;
                    Axis.this.setMainGridColor(colorBackground.getColor());
                }
            }
        });
    }

    private void combineLine(XMLableReader xMLableReader) {
        if (xMLableReader.getAttrAsInt("len", 8) == 0 || xMLableReader.getAttrAsFloat("mainStroke", 1.0f) == 0.0f) {
            this.setTickMarkType(0);
        } else {
            this.setTickMarkType(xMLableReader.getAttrAsInt("type", 2));
        }
        if (xMLableReader.getAttrAsInt("secLen", 0) == 0 || xMLableReader.getAttrAsFloat("secStroke", 1.0f) == 0.0f) {
            this.setSecTickMarkType(0);
        } else {
            this.setSecTickMarkType(xMLableReader.getAttrAsInt("secType", 1));
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        if (this.getTitle() != null) {
            this.getTitle().writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.startTAG("newAxisAttr").attr("isShowAxisLabel", this.axisData.isShowAxisLabel).end();
        xMLPrintWriter.startTAG("AxisLineStyle").attr("AxisStyle", this.getAxisStyle()).attr("MainGridStyle", this.getMainGridStyle()).end();
        xMLPrintWriter.startTAG("newLineColor");
        if (this.getMainGridColor() != null) {
            xMLPrintWriter.attr("mainGridColor", this.getMainGridColor().getRGB());
        }
        if (this.lineColor != null) {
            xMLPrintWriter.attr("lineColor", this.lineColor.getRGB());
        } else {
            xMLPrintWriter.attr("lineColor", "");
        }
        xMLPrintWriter.end();
        xMLPrintWriter.startTAG("AxisPosition").attr("value", this.getPosition()).end();
        xMLPrintWriter.startTAG("TickLine201106").attr("type", this.getTickMarkType()).attr("secType", this.getSecTickMarkType()).end();
        xMLPrintWriter.startTAG("ArrowShow").attr("arrowShow", this.isArrowShow()).end();
        if (this.getTextAttr() != null) {
            this.getTextAttr().writeXML(xMLPrintWriter);
        }
        if (this.getFormat() != null) {
            BaseXMLUtils.writeFormat(xMLPrintWriter, this.getFormat());
        }
        if (this.getLabelNumber() != null) {
            xMLPrintWriter.startTAG("AxisLabelCount").attr("value", Utils.objectToString(this.getLabelNumber())).end();
        }
        xMLPrintWriter.startTAG("AxisRange");
        if (this.isCustomMinValue() && this.getMinValue() != null) {
            xMLPrintWriter.attr("minValue", this.getMinValue().toString());
        }
        if (this.isCustomMaxValue() && this.getMaxValue() != null) {
            xMLPrintWriter.attr("maxValue", this.getMaxValue().toString());
        }
        xMLPrintWriter.end();
        xMLPrintWriter.startTAG("AxisUnit201106").attr("isCustomMainUnit", this.axisData.isCustomMainUnit).attr("isCustomSecUnit", this.axisData.isCustomSecUnit);
        if (this.axisData.mainUnit != null) {
            xMLPrintWriter.attr("mainUnit", this.axisData.mainUnit.toString());
        }
        if (this.axisData.secUnit != null) {
            xMLPrintWriter.attr("secUnit", this.axisData.secUnit.toString());
        }
        xMLPrintWriter.end();
        xMLPrintWriter.startTAG("ZoomAxisAttr").attr("isZoom", this.isZoom()).end();
        xMLPrintWriter.startTAG("axisReversed").attr("axisReversed", this.axisReversed).end();
    }

    public boolean equals(Object object) {
        return object instanceof Axis && ComparatorUtils.equals(((Axis)object).getMainGridColor(), this.getMainGridColor()) && ((Axis)object).getMainGridStyle() == this.getMainGridStyle() && ((Axis)object).getAxisStyle() == this.getAxisStyle() && ComparatorUtils.equals(((Axis)object).lineColor, this.lineColor) && ComparatorUtils.equals(((Axis)object).getTitle(), this.getTitle()) && ((Axis)object).getPosition() == this.getPosition() && ((Axis)object).getSecTickMarkType() == this.getSecTickMarkType() && ((Axis)object).getTickMarkType() == this.getTickMarkType() && ComparatorUtils.equals(((Axis)object).getTextAttr(), this.getTextAttr()) && ComparatorUtils.equals(((Axis)object).getFormat(), this.getFormat()) && ComparatorUtils.equals(((Axis)object).getLabelNumber(), this.getLabelNumber()) && ((Axis)object).isShowAxisLabel() == this.isShowAxisLabel() && ((Axis)object).isArrowShow() == this.isArrowShow() && ((Axis)object).isCustomMinValue() == this.isCustomMinValue() && ComparatorUtils.equals(((Axis)object).getMinValue(), this.getMinValue()) && ((Axis)object).isCustomMaxValue() == this.isCustomMaxValue() && ComparatorUtils.equals(((Axis)object).getMaxValue(), this.getMaxValue()) && ((Axis)object).axisData.isCustomMainUnit == this.axisData.isCustomMainUnit && ComparatorUtils.equals(((Axis)object).axisData.mainUnit, this.axisData.mainUnit) && ((Axis)object).axisData.isCustomSecUnit == this.axisData.isCustomSecUnit && ComparatorUtils.equals(((Axis)object).getSecUnit(), this.getSecUnit()) && ((Axis)object).isZoom == this.isZoom && ((Axis)object).axisReversed == this.axisReversed;
    }
}

