/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartattr;

import com.fr.base.chartdata.ChartData;
import com.fr.chart.chartattr.AreaPlot;
import com.fr.chart.chartattr.CategoryPlot;
import com.fr.chart.chartattr.Plot;
import com.fr.chart.chartglyph.Area3DPlotGlyph;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.LineMarkerIcon;
import com.fr.chart.chartglyph.Plot3D;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.chart.chartglyph.Projection;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;

public class Area3DPlot
extends CategoryPlot
implements Plot3D {
    private static final int DEFAULT_ELEVATION = 60;
    private static final long serialVersionUID = -2168856417697999430L;
    private Projection projection = new Projection();
    private double seriesIntervalPercent = 1.0;
    private int deep = -1;

    public Area3DPlot() {
        this.projection.setElevation(60);
    }

    public PlotGlyph createPlotGlyph(ChartData chartData) {
        Area3DPlotGlyph area3DPlotGlyph = new Area3DPlotGlyph();
        this.install4PlotGlyph(area3DPlotGlyph, chartData);
        this.installAxisGlyph(area3DPlotGlyph, chartData);
        return area3DPlotGlyph;
    }

    public void install4PlotGlyph(Area3DPlotGlyph area3DPlotGlyph, ChartData chartData) {
        super.install4PlotGlyph(area3DPlotGlyph, chartData);
        area3DPlotGlyph.setProjection(this.projection);
        area3DPlotGlyph.setDeep(this.deep);
        area3DPlotGlyph.setSeriesIntervalPercent(this.seriesIntervalPercent);
    }

    protected void dealCondition(LineMarkerIcon lineMarkerIcon, DataSeries dataSeries, Color[] colorArray) {
        this.dealColorCondition(lineMarkerIcon, dataSeries, colorArray);
    }

    public boolean isSupport3D() {
        return true;
    }

    public boolean isSupportBorder() {
        return false;
    }

    public boolean is3D() {
        return true;
    }

    public void setProjection(Projection projection) {
        this.projection = projection;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public String getPlotName() {
        String string = Inter.getLocText("I-AreaStyle_Normal");
        if (this.isStacked()) {
            string = Inter.getLocText("ChartF-Stacked") + string;
        }
        if (this.getyAxis().isPercentage()) {
            string = Inter.getLocText("StyleFormat-Percent") + string;
        }
        return Inter.getLocText("Chart_3D") + string;
    }

    public void setDeep(int n2) {
        this.deep = n2;
    }

    public int getDeep() {
        return this.deep;
    }

    public void setSeriesIntervalPercent(double d2) {
        this.seriesIntervalPercent = d2;
    }

    public double getSeriesIntervalPercent() {
        return this.seriesIntervalPercent;
    }

    public boolean matchPlotType(Plot plot) {
        return plot instanceof Area3DPlot || plot instanceof AreaPlot;
    }

    public ChartData defaultChartData() {
        return AreaPlot.AREACHARTDATA;
    }

    public boolean isSupportSeriesDrag() {
        return false;
    }

    public boolean needAnalysisLinePane() {
        return false;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("Projection".equals(string)) {
                this.projection = (Projection)xMLableReader.readXMLObject(new Projection());
            } else if ("Area3DAttr".equals(string)) {
                this.seriesIntervalPercent = xMLableReader.getAttrAsDouble("seriesIntervalPercent", 1.0);
                this.deep = xMLableReader.getAttrAsInt("deep", -1);
            }
        }
    }

    public int[] getInteractivePaneArrayThatNotSurpport() {
        return new int[]{2};
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("CategoryPlot");
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("Area3DAttr").attr("seriesIntervalPercent", this.seriesIntervalPercent);
        if (this.deep != -1) {
            xMLPrintWriter.attr("deep", this.deep);
        }
        xMLPrintWriter.end();
        if (this.projection != null) {
            this.projection.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        Area3DPlot area3DPlot = (Area3DPlot)super.clone();
        if (this.projection != null) {
            area3DPlot.projection = (Projection)this.projection.clone();
        }
        return area3DPlot;
    }

    public boolean equals(Object object) {
        return object instanceof Area3DPlot && super.equals(object) && ((Area3DPlot)object).getSeriesIntervalPercent() == this.seriesIntervalPercent && ((Area3DPlot)object).getDeep() == this.deep && ComparatorUtils.equals(((Area3DPlot)object).getProjection(), this.projection);
    }
}

