/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.base;

import com.fr.chart.base.AttrColor;
import com.fr.chart.base.LineStyleInfo;
import com.fr.chart.base.TrendLine;
import com.fr.general.Inter;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;

public class ConditionTrendLine
implements XMLable {
    private static final long serialVersionUID = -475952327323573496L;
    public static final String XML_TAG = "ConditionTrendLine";
    private TrendLine line = new TrendLine();
    private int forward = 0;
    private int backward = 0;
    private String paneName = "";

    public ConditionTrendLine() {
        TrendLine trendLine = new TrendLine();
        LineStyleInfo lineStyleInfo = new LineStyleInfo();
        lineStyleInfo.setAttrLineColor(new AttrColor(Color.gray));
        trendLine.setLineStyleInfo(lineStyleInfo);
        this.setLine(trendLine);
    }

    public void setLine(TrendLine trendLine) {
        this.line = trendLine;
    }

    public TrendLine getLine() {
        return this.line;
    }

    public void setPaneName(String string) {
        this.paneName = string;
    }

    public String getPaneName() {
        return this.paneName;
    }

    public void setForward(int n2) {
        this.forward = n2;
    }

    public int getForward() {
        return this.forward;
    }

    public void setBackward(int n2) {
        this.backward = n2;
    }

    public int getBackward() {
        return this.backward;
    }

    public JSONObject toJSONObject() throws JSONException {
        if (this.line != null) {
            return this.line.toJSONObject();
        }
        return null;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("TrendLine")) {
                this.line = (TrendLine)xMLableReader.readXMLObject(new TrendLine());
            } else if (string.equals("Attr")) {
                if (xMLableReader.getAttrAsString("name", null) != null) {
                    this.line.setTrendLineName(xMLableReader.getAttrAsString("name", Inter.getLocText("Chart_TrendLine")));
                }
                this.setForward(xMLableReader.getAttrAsInt("forward", 0));
                this.setBackward(xMLableReader.getAttrAsInt("backward", 0));
                String string2 = xMLableReader.getAttrAsString("paneName", Inter.getLocText("Chart_TrendLine"));
                this.setPaneName(StringUtils.isBlank(string2) ? Inter.getLocText("Chart_TrendLine") : string2);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        if (this.line != null) {
            xMLPrintWriter.startTAG(XML_TAG);
            this.line.writeXML(xMLPrintWriter);
            xMLPrintWriter.startTAG("Attr").attr("forward", this.forward).attr("backward", this.backward).attr("paneName", this.paneName).end();
            xMLPrintWriter.end();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

