/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.base;

import com.fr.base.BaseUtils;
import com.fr.base.ChartPreStyleServerManager;
import com.fr.base.Formula;
import com.fr.chart.base.AttrFillStyle;
import com.fr.chart.base.ChartPreStyle;
import com.fr.chart.base.GlyphUtils;
import com.fr.chart.base.TextAttr;
import com.fr.general.DateUtils;
import com.fr.general.FRFont;
import com.fr.general.Inter;
import com.fr.stable.ColumnRow;
import com.fr.stable.StableUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Date;

public class ChartUtils {
    private static final double CENTER = 0.5;
    private static final int FONT_SIZE_NORENDER = 14;
    private static final float SCALE = 0.6f;
    private static final float CIRCLE = 360.0f;
    public static final Object[] CATEGORY_STRING = new Object[]{Inter.getLocText("ChartF-Category") + "1", Inter.getLocText("ChartF-Category") + "2", Inter.getLocText("ChartF-Category") + "3"};
    public static final Object[] MORE_SECOND_CATE = new Object[]{Inter.getLocText("ChartF-Category") + "Y1", Inter.getLocText("ChartF-Category") + "Y2", Inter.getLocText("ChartF-Category") + "Y3", Inter.getLocText("ChartF-Category") + "Y1", Inter.getLocText("ChartF-Category") + "Y2", Inter.getLocText("ChartF-Category") + "Y3"};
    public static final Object[] SECOND_CATE = new Object[]{Inter.getLocText("ChartF-Category") + "X1", Inter.getLocText("ChartF-Category") + "X2"};
    public static final Object[] MORE_SERIES = new Object[]{Inter.getLocText("ChartF-Series") + "1", Inter.getLocText("ChartF-Series") + "2", Inter.getLocText("ChartF-Series") + "3"};
    public static final Object[][] MORE_SECOND_VALUES = new Object[][]{{"40", "50", "30", "40", "50", "30"}, {"25", "45", "55", "25", "45", "55"}, {"25", "45", "55", "25", "45", "55"}};
    public static final Object[] MORE_THIRD_CATE = new Object[]{Inter.getLocText("ChartF-Category") + "Z1", Inter.getLocText("ChartF-Category") + "Z2", Inter.getLocText("ChartF-Category") + "Z1", Inter.getLocText("ChartF-Category") + "Z2", Inter.getLocText("ChartF-Category") + "Z1", Inter.getLocText("ChartF-Category") + "Z2", Inter.getLocText("ChartF-Category") + "Z1", Inter.getLocText("ChartF-Category") + "Z2"};
    public static final Object[] THIRD_SECOND_CATE = new Object[]{Inter.getLocText("ChartF-Category") + "Y1", Inter.getLocText("ChartF-Category") + "Y2"};
    public static final Object[] THIRD_CATE = new Object[]{Inter.getLocText("ChartF-Category") + "X1", Inter.getLocText("ChartF-Category") + "X2"};
    public static final Object[][] MORE_THIRD_VALUES = new Object[][]{{"40", "50", "30", "40", "50", "30", "40", "50"}, {"25", "45", "55", "25", "45", "55", "40", "50"}, {"25", "45", "55", "25", "45", "55", "25", "45"}};
    public static final Object[] CATEGORY_DATE = new Object[]{DateUtils.createDate(2001, 1, 1), DateUtils.createDate(2001, 1, 2), DateUtils.createDate(2001, 1, 3)};
    public static final Object[] LONG_CATEGORY_STRING = new Object[]{"Apple", "Banana", "Pear", "Orange", "Grape", "Plum"};
    public static final Object[] LONG_CATEGORY_DATE = new Object[]{new Date(0L), new Date(86400000L), new Date(172800000L), new Date(259200000L), new Date(345600000L), new Date(432000000L)};
    public static final Object[] STOCK_CATEGORY_DATE = new Object[]{new Date(0L), new Date(86400000L), new Date(172800000L), new Date(259200000L), new Date(345600000L), new Date(432000000L), new Date(518400000L), new Date(604800000L), new Date(691200000L), new Date(777600000L), new Date(864000000L), new Date(950400000L), new Date(1036800000L), new Date(1123200000L), new Date(1209600000L), new Date(1296000000L), new Date(1382400000L), new Date(1468800000L), new Date(1555200000L), new Date(1641600000L), new Date(1728000000L), new Date(1814400000L), new Date(1900800000L), new Date(1987200000L), new Date(2073600000L)};
    public static final String[] STOCK_CATEGORY_STRING = new String[]{"2010-08-23", "2010-08-24", "2010-08-25", "2010-08-26", "2010-08-27", "2010-08-28", "2010-08-29", "2010-08-30", "2010-08-31", "2010-09-01", "2010-09-02", "2010-09-03", "2010-09-04", "2010-09-05", "2010-09-06", "2010-09-07", "2010-09-08", "2010-09-08", "2010-09-10", "2010-09-11", "2010-09-12", "2010-09-13", "2010-09-14", "2010-09-15", "2010-09-16", "2010-09-17", "2010-09-18", "2010-09-19", "2010-09-20", "2010-09-21", "2010-09-22", "2010-09-23"};

    private ChartUtils() {
    }

    public static final Image string2Image(String string, TextAttr textAttr) {
        if (textAttr == null) {
            textAttr = new TextAttr(FRFont.getInstance());
        }
        if (textAttr.getFRFont() == null) {
            textAttr.setFRFont(FRFont.getInstance());
        }
        FRFont fRFont = textAttr.getFRFont();
        Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation(string, new TextAttr(FRFont.getInstance("SimSun", 0, fRFont.getSize() + 1)), 72);
        BufferedImage bufferedImage = new BufferedImage((int)dimension2D.getWidth() + 3, (int)dimension2D.getHeight() + 1, 6);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (fRFont.getSize() <= 14) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        graphics2D.setPaint(fRFont.getForeground());
        graphics2D.setFont(fRFont);
        graphics2D.drawString(string, 2, fRFont.getSize());
        graphics2D.dispose();
        bufferedImage.flush();
        return bufferedImage;
    }

    public static Point2D getArc2DCenterAnglePoint(Shape shape) {
        if (!(shape instanceof Arc2D)) {
            return null;
        }
        Arc2D arc2D = (Arc2D)shape;
        double d2 = Math.toRadians(-arc2D.getAngleStart() - arc2D.getAngleExtent() / 2.0);
        double d3 = arc2D.getX() + (Math.cos(d2) * 0.5 + 0.5) * arc2D.getWidth();
        double d4 = arc2D.getY() + (Math.sin(d2) * 0.5 + 0.5) * arc2D.getHeight();
        return new Point2D.Double(d3, d4);
    }

    public static AttrFillStyle getColorFillStyleInPre() {
        ChartPreStyleServerManager chartPreStyleServerManager = ChartPreStyleServerManager.getInstance();
        Object object = chartPreStyleServerManager.getStyleEditing();
        if (object instanceof ChartPreStyle) {
            ChartPreStyle chartPreStyle = (ChartPreStyle)object;
            return chartPreStyle.getAttrFillStyle();
        }
        Object object2 = chartPreStyleServerManager.getDefaultPreStyle();
        if (object2 instanceof ChartPreStyle) {
            ChartPreStyle chartPreStyle = (ChartPreStyle)object2;
            return chartPreStyle.getAttrFillStyle();
        }
        return null;
    }

    public static int getStyleInPre() {
        ChartPreStyleServerManager chartPreStyleServerManager = ChartPreStyleServerManager.getInstance();
        Object object = chartPreStyleServerManager.getStyleEditing();
        if (object instanceof ChartPreStyle) {
            ChartPreStyle chartPreStyle = (ChartPreStyle)object;
            return chartPreStyle.getPrePlotStyle();
        }
        Object object2 = chartPreStyleServerManager.getDefaultPreStyle();
        if (object2 instanceof ChartPreStyle) {
            ChartPreStyle chartPreStyle = (ChartPreStyle)object2;
            return chartPreStyle.getPrePlotStyle();
        }
        return 0;
    }

    public static Color brighterWithFactor(Color color, double d2) {
        int n2 = color.getRed();
        int n3 = color.getGreen();
        int n4 = color.getBlue();
        int n5 = (int)(1.0 / (1.0 - d2));
        if (n2 == 0 && n3 == 0 && n4 == 0) {
            return new Color(n5, n5, n5);
        }
        if (n2 > 0 && n2 < n5) {
            n2 = n5;
        }
        if (n3 > 0 && n3 < n5) {
            n3 = n5;
        }
        if (n4 > 0 && n4 < n5) {
            n4 = n5;
        }
        return new Color(Math.min((int)((double)n2 / d2), 255), Math.min((int)((double)n3 / d2), 255), Math.min((int)((double)n4 / d2), 255));
    }

    public static GeneralPath getBoundsWithoutTop(Rectangle2D rectangle2D) {
        float f2 = (float)rectangle2D.getX();
        float f3 = (float)rectangle2D.getY();
        float f4 = (float)rectangle2D.getWidth();
        float f5 = (float)rectangle2D.getHeight();
        if (f4 <= 0.0f || f5 <= 0.0f) {
            return new GeneralPath();
        }
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(f2, f3);
        generalPath.lineTo(f2, f3 + f5);
        generalPath.lineTo(f2 + f4, f3 + f5);
        generalPath.lineTo(f2 + f4, f3);
        return generalPath;
    }

    public static GeneralPath getBoundsWithoutBottom(Rectangle2D rectangle2D) {
        float f2 = (float)rectangle2D.getX();
        float f3 = (float)rectangle2D.getY();
        float f4 = (float)rectangle2D.getWidth();
        float f5 = (float)rectangle2D.getHeight();
        if (f4 <= 0.0f || f5 <= 0.0f) {
            return new GeneralPath();
        }
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(f2, f3 + f5);
        generalPath.lineTo(f2, f3);
        generalPath.lineTo(f2 + f4, f3);
        generalPath.lineTo(f2 + f4, f3 + f5);
        return generalPath;
    }

    public static GeneralPath getBoundsWithoutLeft(Rectangle2D rectangle2D) {
        float f2 = (float)rectangle2D.getX();
        float f3 = (float)rectangle2D.getY();
        float f4 = (float)rectangle2D.getWidth();
        float f5 = (float)rectangle2D.getHeight();
        if (f4 <= 0.0f || f5 <= 0.0f) {
            return new GeneralPath();
        }
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(f2, f3);
        generalPath.lineTo(f2 + f4, f3);
        generalPath.lineTo(f2 + f4, f3 + f5);
        generalPath.lineTo(f2, f3 + f5);
        return generalPath;
    }

    public static GeneralPath getBoundsWithoutRight(Rectangle2D rectangle2D) {
        float f2 = (float)rectangle2D.getX();
        float f3 = (float)rectangle2D.getY();
        float f4 = (float)rectangle2D.getWidth();
        float f5 = (float)rectangle2D.getHeight();
        if (f4 <= 0.0f || f5 <= 0.0f) {
            return new GeneralPath();
        }
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(f2 + f4, f3 + f5);
        generalPath.lineTo(f2, f3 + f5);
        generalPath.lineTo(f2, f3);
        generalPath.lineTo(f2 + f4, f3);
        return generalPath;
    }

    public static GeneralPath getBoundsLeftAndRight(Rectangle2D rectangle2D) {
        float f2 = (float)rectangle2D.getX();
        float f3 = (float)rectangle2D.getY();
        float f4 = (float)rectangle2D.getWidth();
        float f5 = (float)rectangle2D.getHeight();
        if (f4 <= 0.0f || f5 <= 0.0f) {
            return new GeneralPath();
        }
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(f2, f3);
        generalPath.lineTo(f2, f3 + f5);
        generalPath.moveTo(f2 + f4, f3);
        generalPath.lineTo(f2 + f4, f3 + f5);
        return generalPath;
    }

    public static GeneralPath getBoundsTopAndBottom(Rectangle2D rectangle2D) {
        float f2 = (float)rectangle2D.getX();
        float f3 = (float)rectangle2D.getY();
        float f4 = (float)rectangle2D.getWidth();
        float f5 = (float)rectangle2D.getHeight();
        if (f4 <= 0.0f || f5 <= 0.0f) {
            return new GeneralPath();
        }
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(f2, f3);
        generalPath.lineTo(f2 + f4, f3);
        generalPath.moveTo(f2, f3 + f5);
        generalPath.lineTo(f2 + f4, f3 + f5);
        return generalPath;
    }

    public static void curveTo(GeneralPath generalPath, GeneralPath generalPath2) {
        Object[] objectArray;
        ArrayList<double[]> arrayList = new ArrayList<double[]>();
        PathIterator pathIterator = generalPath2.getPathIterator(new AffineTransform());
        while (!pathIterator.isDone()) {
            objectArray = new double[2];
            pathIterator.currentSegment((double[])objectArray);
            pathIterator.next();
            arrayList.add((double[])objectArray);
        }
        if (arrayList.size() <= 2) {
            generalPath.append(generalPath2, true);
        } else {
            Object[] objectArray2;
            objectArray = new float[arrayList.size()];
            float[] fArray = new float[arrayList.size()];
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                objectArray2 = (double[])arrayList.get(i2);
                objectArray[i2] = (float)objectArray2[0];
                fArray[i2] = (float)objectArray2[1];
            }
            float[] fArray2 = new float[arrayList.size() - 1];
            objectArray2 = new float[arrayList.size() - 1];
            for (int i3 = 0; i3 < fArray2.length; ++i3) {
                fArray2[i3] = (float)((objectArray[i3] + objectArray[i3 + 1]) / 2.0f);
                objectArray2[i3] = (fArray[i3] + fArray[i3 + 1]) / 2.0f;
            }
            float[] fArray3 = new float[(objectArray.length - 2) * 2];
            float[] fArray4 = new float[(fArray.length - 2) * 2];
            for (int i4 = 1; i4 < fArray2.length; ++i4) {
                double d2 = objectArray[i4] - (fArray2[i4 - 1] + fArray2[i4]) / 2.0f;
                float f2 = fArray[i4] - (objectArray2[i4 - 1] + objectArray2[i4]) / 2.0f;
                fArray3[(i4 - 1) * 2] = (float)(objectArray[i4] + (fArray2[i4 - 1] + d2 - objectArray[i4]) * 0.6f);
                fArray4[(i4 - 1) * 2] = fArray[i4] + (objectArray2[i4 - 1] + f2 - fArray[i4]) * 0.6f;
                fArray3[(i4 - 1) * 2 + 1] = (float)(objectArray[i4] + (fArray2[i4] + d2 - objectArray[i4]) * 0.6f);
                fArray4[(i4 - 1) * 2 + 1] = fArray[i4] + (objectArray2[i4] + f2 - fArray[i4]) * 0.6f;
            }
            GeneralPath generalPath3 = new GeneralPath(1);
            generalPath3.moveTo((float)objectArray[0], fArray[0]);
            for (int i5 = 1; i5 < objectArray.length; ++i5) {
                if (i5 == 1) {
                    generalPath3.quadTo(fArray3[0], fArray4[0], (float)objectArray[i5], fArray[i5]);
                    continue;
                }
                if (i5 == objectArray.length - 1) {
                    generalPath3.quadTo(fArray3[fArray3.length - 1], fArray4[fArray4.length - 1], (float)objectArray[i5], fArray[i5]);
                    continue;
                }
                generalPath3.curveTo(fArray3[(i5 - 1) * 2 - 1], fArray4[(i5 - 1) * 2 - 1], fArray3[(i5 - 1) * 2], fArray4[(i5 - 1) * 2], (float)objectArray[i5], fArray[i5]);
            }
            generalPath.append(generalPath3, true);
        }
    }

    public static Object string2FormulaStr(String string) {
        if (string == null || string.trim().length() == 0) {
            return "";
        }
        String string2 = "";
        String[] stringArray = StableUtils.splitString(string.trim(), ',');
        if (stringArray != null && stringArray.length > 0) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String[] stringArray2 = StableUtils.splitString(stringArray[i2].trim(), ':');
                if (stringArray2 == null || stringArray2.length <= 0) continue;
                boolean bl = true;
                for (int i3 = 0; i3 < stringArray2.length; ++i3) {
                    ColumnRow columnRow = BaseUtils.convertCellStringToColumnRow(stringArray2[i3].trim());
                    if (ColumnRow.validate(columnRow)) continue;
                    bl = false;
                }
                if (bl) {
                    if (i2 == 0) {
                        string2 = stringArray[i2].trim();
                        continue;
                    }
                    string2 = string2 + ", " + stringArray[i2].trim();
                    continue;
                }
                string2 = i2 == 0 ? "\"" + stringArray[i2].trim() + "\"" : string2 + ", \"" + stringArray[i2].trim() + "\"";
            }
            if (stringArray.length > 1) {
                return new Formula("[" + string2 + "]");
            }
            if (!(stringArray.length != 1 || string2.startsWith("\"") && string2.endsWith("\""))) {
                return new Formula(string2);
            }
            return stringArray[0].trim();
        }
        return string2;
    }

    public static boolean rectangleOverlapped(Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        if (rectangle2D == null || rectangle2D2 == null) {
            return true;
        }
        double d2 = Math.max(rectangle2D.getX(), rectangle2D2.getX());
        double d3 = Math.max(rectangle2D.getY(), rectangle2D2.getY());
        double d4 = Math.min(rectangle2D.getX() + rectangle2D.getWidth(), rectangle2D2.getX() + rectangle2D2.getWidth());
        double d5 = Math.min(rectangle2D.getY() + rectangle2D.getHeight(), rectangle2D2.getY() + rectangle2D2.getHeight());
        return d2 <= d4 && d3 <= d5;
    }

    public static Color getColorFromBaseColor(Color color, double d2, double d3, double d4) {
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), new float[3]);
        fArray[0] = fArray[0] + (float)d2;
        fArray[1] = fArray[1] + (float)d3;
        fArray[2] = fArray[2] + (float)d4;
        return ChartUtils.HSB2RGB(fArray[0], fArray[1], fArray[2]);
    }

    private static Color HSB2RGB(float f2, float f3, float f4) {
        if (f2 < 0.0f) {
            f2 = 0.0f;
        } else if (f2 >= 360.0f) {
            f2 = 360.0f;
        }
        if (f3 < 0.0f) {
            f3 = 0.0f;
        } else if (f3 > 1.0f) {
            f3 = 1.0f;
        }
        if (f4 < 0.0f) {
            f4 = 0.0f;
        } else if (f4 > 1.0f) {
            f4 = 1.0f;
        }
        return Color.getHSBColor(f2, f3, f4);
    }

    public static Color getShadeStartColor(Color color, float f2) {
        float[] fArray = color.getRGBColorComponents(new float[3]);
        float[] fArray2 = new float[3];
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            float f3 = fArray[i2];
            fArray2[i2] = (double)f3 <= 0.5 ? 2.0f * f3 * (1.0f - f2) : 1.0f - 2.0f * (1.0f - f3) * f2;
        }
        return new Color(fArray2[0], fArray2[1], fArray2[2]);
    }

    public static Color getShadeEndColor(Color color, float f2) {
        float[] fArray = color.getRGBColorComponents(new float[3]);
        float[] fArray2 = new float[3];
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            float f3 = fArray[i2];
            fArray2[i2] = (double)f3 <= 0.5 ? 2.0f * f3 * f2 : 1.0f - 2.0f * (1.0f - f3) * (1.0f - f2);
        }
        return new Color(fArray2[0], fArray2[1], fArray2[2]);
    }
}

