/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.base;

import com.fr.base.Base64;
import com.fr.base.FRContext;
import com.fr.base.Formula;
import com.fr.base.TextFormat;
import com.fr.base.Utils;
import com.fr.base.background.ImageBackground;
import com.fr.base.background.PatternBackground;
import com.fr.base.background.TextureBackground;
import com.fr.cache.Attachment;
import com.fr.cache.AttachmentSource;
import com.fr.chart.base.AttrFillStyle;
import com.fr.chart.base.ChartConstants;
import com.fr.chart.base.ChartUtils;
import com.fr.chart.base.GlyphUtils;
import com.fr.chart.base.TextAttr;
import com.fr.general.Background;
import com.fr.general.DateUtils;
import com.fr.general.GeneralUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.core.UUID;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ChartBaseUtils {
    private static final int COINT = 6;
    private static final double BAOHE = 0.3;
    private static final double GAP = 0.8;
    private static final double MORE_BAO = 0.9;
    private static final double CHART_BOUNDER = 10.0;

    public static String dealLabelStringAutoWrap(String string, TextAttr textAttr, int n2, double d2) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n3 = string.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            char c2 = string.charAt(i2);
            stringBuffer2.append(c2);
            Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation(stringBuffer2 + " ", textAttr, n2);
            if (!(dimension2D.getWidth() > d2) || c2 == '\\') continue;
            stringBuffer.append(stringBuffer2 + "\n");
            stringBuffer2.delete(0, stringBuffer2.length());
        }
        stringBuffer.append(stringBuffer2);
        return Utils.objectToString(stringBuffer);
    }

    public static Number formula2Number(Formula formula) {
        if (formula == null) {
            return null;
        }
        if (formula.getResult() != null) {
            Date date;
            String string = Utils.objectToString(formula.getResult());
            Number number = Utils.string2Number(string);
            if (number == null && (date = DateUtils.string2Date(string, true)) != null) {
                return new Double(ChartBaseUtils.date2Int(date, 6));
            }
            return number;
        }
        String string = formula.getContent();
        if (string.startsWith("=")) {
            string = string.substring(1);
        }
        return Utils.string2Number(string);
    }

    public static JSONObject generalPath2JS(GeneralPath generalPath) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        JSONArray jSONArray2 = new JSONArray();
        JSONArray jSONArray3 = new JSONArray();
        JSONArray jSONArray4 = new JSONArray();
        double[] dArray = new double[6];
        int n2 = -1;
        PathIterator pathIterator = generalPath.getPathIterator(new AffineTransform());
        while (!pathIterator.isDone()) {
            JSONObject jSONObject2;
            n2 = pathIterator.currentSegment(dArray);
            if (n2 == 0 || n2 == 1) {
                jSONArray.put(dArray[0]);
                jSONArray2.put(dArray[1]);
                jSONArray3.put(n2);
                jSONArray4.put("");
            } else if (n2 == 4) {
                jSONArray.put(0);
                jSONArray2.put(0);
                jSONArray3.put(n2);
                jSONArray4.put("");
            } else if (n2 == 2) {
                jSONArray.put(dArray[2]);
                jSONArray2.put(dArray[3]);
                jSONArray3.put(n2);
                jSONObject2 = new JSONObject();
                jSONObject2.put("x", dArray[0]);
                jSONObject2.put("y", dArray[1]);
                jSONArray4.put(jSONObject2);
            } else if (n2 == 3) {
                jSONArray.put(dArray[4]);
                jSONArray2.put(dArray[5]);
                jSONArray3.put(n2);
                jSONObject2 = new JSONObject();
                jSONObject2.put("x0", dArray[0]);
                jSONObject2.put("y0", dArray[1]);
                jSONObject2.put("x1", dArray[2]);
                jSONObject2.put("y1", dArray[3]);
                jSONArray4.put(jSONObject2);
            }
            pathIterator.next();
        }
        jSONObject.put("x", jSONArray);
        jSONObject.put("y", jSONArray2);
        jSONObject.put("type", jSONArray3);
        jSONObject.put("ctrl", jSONArray4);
        return jSONObject;
    }

    public static Color saturationDown(Color color) {
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), new float[3]);
        fArray[1] = (float)((double)fArray[1] * 0.3);
        return Color.getHSBColor(fArray[0], fArray[1], fArray[2]);
    }

    public static Color[] createFillColorArray(AttrFillStyle attrFillStyle, int n2) {
        Color[] colorArray;
        block5: {
            block6: {
                block3: {
                    AttrFillStyle attrFillStyle2;
                    block4: {
                        colorArray = new Color[n2];
                        if (attrFillStyle != null && attrFillStyle.getColorStyle() != 0) break block3;
                        attrFillStyle2 = ChartUtils.getColorFillStyleInPre();
                        if (attrFillStyle2 != null && attrFillStyle2.getColorStyle() != 0) break block4;
                        for (int i2 = 0; i2 < n2; ++i2) {
                            colorArray[i2] = ChartConstants.CHART_COLOR_ARRAY[i2 % ChartConstants.CHART_COLOR_ARRAY.length];
                        }
                        break block5;
                    }
                    return ChartBaseUtils.createFillColorArray(attrFillStyle2, n2);
                }
                if (attrFillStyle.getColorStyle() != 1) break block6;
                for (int i3 = 0; i3 < n2; ++i3) {
                    colorArray[i3] = attrFillStyle.getColorIndex(i3);
                }
                break block5;
            }
            if (attrFillStyle.getColorStyle() != 2 || attrFillStyle.getColorSize() != 2) break block5;
            for (int i4 = 0; i4 < n2; ++i4) {
                colorArray[i4] = ChartBaseUtils.getSeriesColor(attrFillStyle.getColorIndex(0), attrFillStyle.getColorIndex(1), i4, n2);
            }
        }
        return colorArray;
    }

    public static Color[] createColorsWithAlpha(Color color, int n2) {
        Color[] colorArray = new Color[n2];
        int n3 = color.getRed();
        int n4 = color.getGreen();
        int n5 = color.getBlue();
        if (n2 == 1) {
            colorArray[0] = color;
            return colorArray;
        }
        double d2 = 0.8 / (double)(n2 - 1);
        for (int i2 = 0; i2 < n2; ++i2) {
            int n6 = (int)(255.0 * (1.0 - (double)i2 * d2));
            if (n6 < 0) {
                n6 = 0;
            } else if (n6 > 255) {
                n6 = 255;
            }
            colorArray[i2] = new Color(n3, n4, n5, n6);
        }
        return colorArray;
    }

    private static Color getSaturationSeriesColor(Color color, int n2, int n3) {
        if (n3 <= 1) {
            return color;
        }
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), new float[3]);
        if (color.getRed() == color.getBlue() && color.getBlue() == color.getGreen()) {
            fArray[2] = (float)(0.9 - 0.8 / (double)(n3 - 1) * (double)n2);
        } else {
            fArray[1] = (float)(1.0 - 0.9 / (double)(n3 - 1) * (double)n2);
        }
        return Color.getHSBColor(fArray[0], fArray[1], fArray[2]);
    }

    private static Color getSeriesColor(Color color, Color color2, int n2, int n3) {
        if (n3 <= 1) {
            return color;
        }
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), new float[3]);
        float[] fArray2 = Color.RGBtoHSB(color2.getRed(), color2.getGreen(), color2.getBlue(), new float[3]);
        float[] fArray3 = new float[3];
        for (int i2 = 0; i2 < 3; ++i2) {
            fArray3[i2] = fArray[i2] - (fArray[i2] - fArray2[i2]) / (float)(n3 - 1) * (float)n2;
        }
        return Color.getHSBColor(fArray3[0] - (float)((int)fArray3[0]), fArray3[1], fArray3[2]);
    }

    public static String generalFormat(double d2) {
        String string = "";
        string = d2 == (double)((int)d2) ? "" + (int)d2 : "" + d2;
        return string;
    }

    public static double date2Int(Date date, int n2) {
        if (date == null) {
            date = new Date();
        }
        Date date2 = DateUtils.createDate(1970, 1, 1);
        return ChartBaseUtils.getTwoDateLength(date, date2, n2);
    }

    private static double getTwoDateLength(Date date, Date date2, int n2) {
        long l2 = 86400000L;
        if (n2 == 6) {
            l2 = 1000L;
        } else if (n2 == 5) {
            l2 = 60000L;
        } else if (n2 == 4) {
            l2 = 3600000L;
        }
        return (date.getTime() - date2.getTime()) / l2;
    }

    public static Date long2Date(long l2, int n2) {
        Date date = DateUtils.createDate(1970, 1, 1);
        long l3 = 86400000L;
        if (n2 == 6) {
            l3 = 1000L;
        } else if (n2 == 5) {
            l3 = 60000L;
        } else if (n2 == 4) {
            l3 = 3600000L;
        }
        long l4 = l2 * l3 + date.getTime();
        return new Date(l4);
    }

    public static Object getObject(int n2, Object[] objectArray) {
        if (objectArray == null || objectArray.length <= 0) {
            return null;
        }
        int n3 = n2 % objectArray.length;
        return objectArray[n3];
    }

    public static RectangularShape rectangle2RoundRectangle(Rectangle2D rectangle2D, boolean bl) {
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight(), 10.0, 10.0);
        return bl ? double_ : rectangle2D;
    }

    public static JSONObject background2JS(Background background) {
        JSONObject jSONObject = null;
        try {
            jSONObject = background.toJSONObject();
            if (background instanceof ImageBackground) {
                ImageBackground imageBackground = (ImageBackground)background;
                ChartBaseUtils.image2JS(jSONObject, imageBackground.getImage());
            } else if (background instanceof PatternBackground) {
                PatternBackground patternBackground = (PatternBackground)background;
                ChartBaseUtils.image2JS(jSONObject, patternBackground.getImage());
            } else if (background instanceof TextureBackground) {
                TextureBackground textureBackground = (TextureBackground)background;
                ChartBaseUtils.image2JS(jSONObject, textureBackground.getImage());
            }
        }
        catch (JSONException jSONException) {
            FRContext.getLogger().error(jSONException.getMessage(), jSONException);
        }
        return jSONObject;
    }

    public static void image2JS(JSONObject jSONObject, Image image) throws JSONException {
        if (image == null) {
            return;
        }
        jSONObject.put("iesrc", ChartBaseUtils.addImageAsEmb(image));
        jSONObject.put("src", "data:image/png;base64," + Base64.encode(image, "png"));
    }

    public static String addImageAsEmb(Image image) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GeneralUtils.writeImage(image, "png", byteArrayOutputStream);
        String string = UUID.randomUUID().toString();
        Attachment attachment = new Attachment(string, "image", "attach.png", byteArrayOutputStream.toByteArray());
        AttachmentSource.putAttachment(string, attachment);
        return string;
    }

    public static String format2JS(Format format) {
        if (format == null) {
            return null;
        }
        String string = "";
        if (format instanceof SimpleDateFormat) {
            string = "D" + ((SimpleDateFormat)format).toPattern().trim();
        } else if (format instanceof DecimalFormat) {
            string = ((DecimalFormat)format).toPattern().trim();
        } else if (format instanceof TextFormat) {
            string = "T";
        }
        return string;
    }

    public static BufferedImage shapeToImage(Shape shape, int n2) {
        BufferedImage bufferedImage = new BufferedImage((int)shape.getBounds().getWidth() + 2 * n2, (int)shape.getBounds().getHeight() + 2 * n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(Color.BLACK);
        graphics2D.translate(-shape.getBounds().getX(), -shape.getBounds().getY());
        if (n2 <= 0) {
            graphics2D.fill(shape);
        } else {
            graphics2D.translate(n2, n2);
            graphics2D.setStroke(new BasicStroke(n2));
            graphics2D.draw(shape);
            graphics2D.translate(-n2, -n2);
        }
        graphics2D.translate(shape.getBounds().getX(), shape.getBounds().getY());
        bufferedImage.flush();
        graphics2D.dispose();
        return bufferedImage;
    }

    public static Object cloneObject(Object object) throws CloneNotSupportedException {
        if (object instanceof Formula) {
            return ((Formula)object).clone();
        }
        return null;
    }
}

