/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.present;

import com.fr.base.FRContext;
import com.fr.base.Formula;
import com.fr.base.present.AbstractPresent;
import com.fr.general.ComparatorUtils;
import com.fr.general.PageCalObj;
import com.fr.general.PageCalRelationRuntimeException;
import com.fr.script.Calculator;
import com.fr.script.CurrentValueNameSpace;
import com.fr.stable.ColumnRow;
import com.fr.stable.StringUtils;
import com.fr.stable.UtilEvalError;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.script.ExTool;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;

public class FormulaPresent
extends AbstractPresent {
    private String formulaContent = "";

    public FormulaPresent() {
    }

    public FormulaPresent(String string) {
        this.setFormulaContent(string);
    }

    public String getFormulaContent() {
        return this.formulaContent;
    }

    public void setFormulaContent(String string) {
        if (string == null) {
            string = "";
        }
        this.formulaContent = string;
    }

    public Object present(Object object, Calculator calculator) {
        ColumnRow columnRow = (ColumnRow)calculator.getAttribute(ColumnRow.class);
        return this.present(object, calculator, columnRow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object present(Object object, Calculator calculator, ColumnRow columnRow) {
        if (StringUtils.isBlank(this.formulaContent) || object == null) {
            return super.present(object, calculator);
        }
        if (object instanceof Formula) {
            object = ((Formula)object).getResult();
        }
        CurrentValueNameSpace currentValueNameSpace = new CurrentValueNameSpace(object);
        calculator.pushNameSpace(currentValueNameSpace);
        String string = this.getPureFormulaContent();
        calculator.setAttribute(ColumnRow.class, columnRow);
        try {
            Object object2 = calculator.evalValue(string);
            return object2;
        }
        catch (PageCalRelationRuntimeException pageCalRelationRuntimeException) {
            PageCalObj pageCalObj = new PageCalObj(calculator.exStatement((ColumnRow)calculator.getAttribute(ColumnRow.class), string));
            return pageCalObj;
        }
        catch (UtilEvalError utilEvalError) {
            FRContext.getLogger().error("Present Formula Error, " + (this.formulaContent.startsWith("=") ? this.formulaContent : "=" + this.formulaContent) + " : " + utilEvalError.getMessage(), utilEvalError);
        }
        finally {
            calculator.removeNameSpace(currentValueNameSpace);
        }
        return object;
    }

    public void analyzeCorrelative(CalculatorProvider calculatorProvider, ExTool exTool, ColumnRow columnRow) {
        exTool.setCreateRelation(true);
        calculatorProvider.exStatement(columnRow, this.getPureFormulaContent());
        exTool.setCreateRelation(false);
    }

    private String getPureFormulaContent() {
        return this.formulaContent.startsWith("=") ? this.formulaContent.substring(1) : this.formulaContent;
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isChildNode() && "Content".equals(xMLableReader.getTagName()) && (string = xMLableReader.getElementValue()) != null) {
            this.formulaContent = string;
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        if (StringUtils.isNotBlank(this.formulaContent)) {
            xMLPrintWriter.startTAG("Content").textNode(this.getFormulaContent()).end();
        }
    }

    public boolean equals(Object object) {
        return object instanceof FormulaPresent && ComparatorUtils.equals(this.formulaContent, ((FormulaPresent)object).formulaContent);
    }
}

