/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.io;

import com.fr.base.FRContext;
import com.fr.base.io.XMLEncryptUtils;
import com.fr.data.AbstractTableDataSource;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLVersion;
import com.fr.stable.xml.XMLableReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;

public abstract class IOFile
extends AbstractTableDataSource {
    private String designerVersion = null;
    protected XMLVersion xmlVersion = null;
    private int previewType;
    public static final int DEFAULT_PREVIEW_TYPE = 0;
    public static final int WRITE_PREVIEW_TYPE = 1;
    public static final int ANA_PREVIEW_TYPE = 2;

    public abstract void readStream(InputStream var1) throws Exception;

    public boolean export(OutputStream outputStream) throws Exception {
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XMLPrintWriter xMLPrintWriter = XMLPrintWriter.create(byteArrayOutputStream);
        xMLPrintWriter.startTAG(this.openTag());
        this.mainContent(xMLPrintWriter);
        this.writeExtra(xMLPrintWriter);
        xMLPrintWriter.end();
        xMLPrintWriter.flush();
        xMLPrintWriter.close();
        InputStream inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        inputStream = XMLEncryptUtils.encodeInputStream(inputStream);
        byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n2 = inputStream.read()) != -1) {
            byteArrayOutputStream.write(n2);
        }
        byteArrayOutputStream.writeTo(outputStream);
        outputStream.flush();
        outputStream.close();
        byteArrayOutputStream.flush();
        byteArrayOutputStream.close();
        return true;
    }

    protected abstract String openTag();

    protected abstract void mainContent(XMLPrintWriter var1);

    protected void readExtra(XMLableReader xMLableReader) {
        if (!xMLableReader.isChildNode()) {
            return;
        }
        String string = xMLableReader.getAttrAsString("DesignerVersion", null);
        if (string != null) {
            this.designerVersion = string;
            if (this.isHigherThanCurrent(this.designerVersion)) {
                FRContext.getLogger().log(Level.WARNING, Inter.getLocText("Server-version-warging"));
            }
        }
        this.previewType = xMLableReader.getAttrAsInt("PreviewType", 0);
    }

    public String getXMLDesignerVersion() {
        return this.designerVersion;
    }

    public XMLVersion getXmlVersion() {
        return this.xmlVersion;
    }

    protected boolean isHigherThanCurrent(String string) {
        if (StringUtils.isBlank(string)) {
            return false;
        }
        int n2 = ComparatorUtils.compare(string, "HBA");
        return n2 > 0;
    }

    private void writeExtra(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("DesignerVersion").attr("DesignerVersion", "HBA");
        xMLPrintWriter.end();
        xMLPrintWriter.startTAG("PreviewType").attr("PreviewType", this.previewType);
        xMLPrintWriter.end();
    }

    public int getPreviewType() {
        return this.previewType;
    }

    public void setPreviewType(int n2) {
        this.previewType = n2;
    }
}

