/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.headerfooter;

import com.fr.base.FRContext;
import com.fr.base.GraphHelper;
import com.fr.base.headerfooter.AbstractHFElement;
import com.fr.general.ComparatorUtils;
import com.fr.general.DefaultValues;
import com.fr.general.FRFont;
import com.fr.stable.StringUtils;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.geom.Dimension2D;
import java.util.StringTokenizer;

public class TextHFElement
extends AbstractHFElement {
    protected String text = null;
    private FRFont frFont = null;

    public TextHFElement() {
        this("", null);
    }

    public TextHFElement(String string, FRFont fRFont) {
        this.setText(string);
        if (fRFont == null) {
            DefaultValues defaultValues = FRContext.getDefaultValues();
            fRFont = defaultValues.getFRFont();
        }
        this.setFRFont(fRFont);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }

    public FRFont getFRFont() {
        return this.frFont;
    }

    public void setFRFont(FRFont fRFont) {
        this.frFont = fRFont;
    }

    public Dimension2D getSize(int n2) {
        StringTokenizer stringTokenizer = StringUtils.text2StringTokenizer(this.getText());
        int n3 = stringTokenizer.countTokens();
        int n4 = 0;
        FontMetrics fontMetrics = GraphHelper.getFontMetrics(this.getFRFont().applyResolutionNP(n2));
        while (stringTokenizer.hasMoreElements()) {
            String string = stringTokenizer.nextToken();
            if (string == null) {
                string = "";
            }
            n4 = Math.max(fontMetrics.stringWidth(string), n4);
        }
        return new Dimension(n4, fontMetrics.getHeight() * n3);
    }

    public boolean equals(Object object) {
        return object instanceof TextHFElement && ComparatorUtils.equals(this.frFont, ((TextHFElement)object).frFont) && ComparatorUtils.equals(this.getText(), ((TextHFElement)object).getText());
    }

    public Object clone() throws CloneNotSupportedException {
        TextHFElement textHFElement = (TextHFElement)super.clone();
        if (this.getFRFont() != null) {
            textHFElement.setFRFont((FRFont)this.getFRFont().clone());
        }
        return textHFElement;
    }

    public String toString() {
        return this.getText();
    }
}

