/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.background;

import com.fr.base.GraphHelper;
import com.fr.base.background.AbstractBackground;
import com.fr.general.Background;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.CoreGraphHelper;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;

public class PatternBackground
extends AbstractBackground {
    public static final int PATTERN_COUNT = 48;
    private int patternIndex = 0;
    private Color foreground = null;
    private Color background = null;
    static byte[] staticByteArray = new byte[]{-86, 85, -86, 85, -86, 85, -86, 85, -69, -18, -69, -18, -69, -18, -69, -18, 34, -120, 34, -120, 34, -120, 34, -120, 0, -1, -1, 0, 0, -1, -1, 0, 102, 102, 102, 102, 102, 102, 102, 102, 56, 28, 14, 7, -125, -63, -32, 112, 7, 14, 28, 56, 112, -32, -63, -125, 102, 102, -103, -103, 102, 102, -103, -103, -103, -1, 102, -1, -103, -1, 102, -1, 0, -1, 0, 0, 0, -1, 0, 0, 68, 68, 68, 68, 68, 68, 68, 68, 17, -120, 68, 34, 17, -120, 68, 34, 34, 68, -120, 17, 34, 68, -120, 17, -120, -120, -120, -1, -120, -120, -120, -1, 68, -86, 17, -86, 68, -86, 17, -86, 0, 34, 0, -120, 0, 34, 0, -120, 0, -128, 0, 8, 0, -128, 0, 8, 0, 0, 0, -128, 0, 0, 0, 8, 21, -86, 85, -86, 81, -86, 85, -86, -86, -35, -86, 119, -86, -35, -86, 119, -1, -18, -1, -69, -1, -18, -1, -69, -1, -3, -1, -33, -1, -3, -1, -33, -2, -1, -1, -1, -17, -1, -1, -1, -16, 15, 15, 15, 15, -16, -16, -16, -128, -1, -128, -128, -128, -128, -128, -128, 0, -86, 0, 32, 0, 32, 0, 32, 16, -1, 1, 1, 1, -1, 16, 16, 64, -128, 1, 3, -124, 72, 48, 32, -86, -86, -86, -86, -86, -86, -86, -86, 0, -1, 0, -1, 0, -1, 0, -1, 8, -128, -128, -128, -128, 8, 8, 8, 0, 0, 0, -16, 0, 0, 0, 15, -103, -52, 102, 51, -103, -52, 102, 51, 102, -52, -103, 51, 102, -52, -103, 51, 17, 0, 0, 0, 0, -120, 68, 34, 0, 0, 0, 17, 34, 68, -120, 0, 0, 16, 56, 124, -2, 124, 56, 16, 68, -126, 1, -126, 68, 40, 16, 40, 0, -120, 0, 2, 0, -120, 0, 32, -40, 27, 3, 48, -79, -115, 12, -64, 16, 2, 64, 8, -128, 4, 32, 1, 72, -124, 3, 48, 72, -124, 3, 48, 32, 64, 32, 0, 4, 2, 4, 0, 24, 0, 3, -92, 24, 0, 3, -92, 12, 3, -128, 64, 64, -64, 33, 18, -126, 68, 42, 17, -118, 68, -88, 17, 30, 85, -86, 85, -86, 30, 30, 30, 62, -35, 98, -29, -29, -35, 38, 62};

    public PatternBackground() {
        this(0, Color.lightGray, Color.black);
    }

    public PatternBackground(int n2, Color color, Color color2) {
        this.setPatternIndex(n2);
        this.setForeground(color);
        this.setBackground(color2);
    }

    private TexturePaint createPattern(int n2) {
        Color color;
        Color color2;
        if (n2 < 0 || n2 >= 48) {
            n2 = 0;
        }
        if ((color2 = this.getForeground()) == null) {
            color2 = Color.lightGray;
        }
        if ((color = this.getBackground()) == null) {
            color = Color.black;
        }
        int n3 = this.createColorInt(color2);
        int n4 = this.createColorInt(color);
        BufferedImage bufferedImage = CoreGraphHelper.createBufferedImage(8, 8, 1);
        int n5 = 8 * n2;
        for (int i2 = 0; i2 < 8; ++i2) {
            byte by = staticByteArray[n5 + i2];
            int n6 = 7;
            for (int i3 = 0; i3 < 8; ++i3) {
                bufferedImage.setRGB(n6--, i2, (by & 1 << i3) != 0 ? n4 : n3);
            }
        }
        Rectangle rectangle = new Rectangle(0, 0, 8, 8);
        return new TexturePaint(bufferedImage, rectangle);
    }

    private int createColorInt(Color color) {
        return color.getRed() << 16 | color.getGreen() << 8 | color.getBlue();
    }

    public int getPatternIndex() {
        return this.patternIndex;
    }

    public void setPatternIndex(int n2) {
        this.patternIndex = n2;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(Color color) {
        this.foreground = color;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color color) {
        this.background = color;
    }

    public void paint(Graphics graphics, Shape shape) {
        TexturePaint texturePaint = this.createPattern(this.getPatternIndex());
        if (texturePaint == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(texturePaint);
        GraphHelper.fill(graphics2D, shape);
        graphics2D.setPaint(paint);
    }

    public void drawWithGradientLine(Graphics graphics, Shape shape) {
        TexturePaint texturePaint = this.createPattern(this.getPatternIndex());
        if (texturePaint == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(texturePaint);
        graphics2D.draw(shape);
        graphics2D.setPaint(paint);
    }

    public boolean equals(Object object) {
        return object instanceof PatternBackground && ((PatternBackground)object).patternIndex == this.patternIndex && ComparatorUtils.equals(((PatternBackground)object).foreground, this.foreground) && ComparatorUtils.equals(((PatternBackground)object).background, this.background);
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        return jSONObject;
    }

    public Image getImage() {
        return this.createPattern(this.patternIndex).getImage();
    }

    public String getBackgroundType() {
        return "PatterBackground";
    }

    public Background readAdditionalAttr(XMLableReader xMLableReader) {
        this.setPatternIndex(xMLableReader.getAttrAsInt("patternIndex", 0));
        this.setForeground(xMLableReader.getAttrAsColor("foreground", Color.black));
        this.setBackground(xMLableReader.getAttrAsColor("background", Color.black));
        return this;
    }

    public void writeAdditionalAttr(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.attr("name", "PatternBackground");
        xMLPrintWriter.attr("patternIndex", this.getPatternIndex());
        if (this.getForeground() != null) {
            xMLPrintWriter.attr("foreground", this.getForeground().getRGB());
        }
        if (this.getBackground() != null) {
            xMLPrintWriter.attr("background", this.getBackground().getRGB());
        }
    }
}

