/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base;

import com.fr.base.DataModelCreator;
import com.fr.base.TableData;
import com.fr.data.TableDataSource;
import com.fr.data.impl.AbstractDBDataModel;
import com.fr.data.impl.DBTableData;
import com.fr.data.impl.SharedDBDataModel;
import com.fr.data.impl.storeproc.ProcedureDataModel;
import com.fr.data.impl.storeproc.StoreProcedure;
import com.fr.data.index.DefaultIndexDataModel;
import com.fr.file.DatasourceManager;
import com.fr.general.FRLogger;
import com.fr.general.ManagerFactory;
import com.fr.general.data.DataModel;
import com.fr.script.Calculator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizedLiveDataModelUtils {
    public static final Object CUR_LIVE_RS = new Object();
    private static ThreadLocal<DataModelCreator> tlOfSheetExecuter = new ThreadLocal();

    public static DataModelCreator getSheetExecuter() {
        return tlOfSheetExecuter.get();
    }

    public static void put(DataModelCreator dataModelCreator) {
        tlOfSheetExecuter.set(dataModelCreator);
    }

    public static DataModel getSELiveDataModel4Share(Calculator calculator, String string) {
        TableDataSource tableDataSource;
        if (calculator == null) {
            return null;
        }
        Map map = (Map)calculator.getAttribute(CUR_LIVE_RS);
        if (map != null && (tableDataSource = (TableDataSource)calculator.getAttribute(TableDataSource.class)) != null) {
            return SynchronizedLiveDataModelUtils.getLiveDataModel(map, calculator, tableDataSource, string);
        }
        return null;
    }

    public static DataModel getLiveDataModel(Map<String, DataModel> map, Calculator calculator, TableDataSource tableDataSource, String string) {
        Object object;
        if (map.containsKey(string)) {
            return map.get(string);
        }
        TableData tableData = SynchronizedLiveDataModelUtils.getSourceTableData(tableDataSource, string);
        DataModel dataModel = tableData.createDataModel(calculator);
        if (dataModel == DataModel.EMPTY_DATAMODEL) {
            object = DatasourceManager.getInstance();
            List<String> list = ((DatasourceManager)object).getProcedureNames();
            boolean bl = ((DatasourceManager)object).isProcedureName(string);
            boolean bl2 = false;
            StoreProcedure storeProcedure = null;
            String string2 = null;
            if (bl) {
                string2 = string;
                storeProcedure = ((DatasourceManager)object).getProcedure(string);
            } else {
                String[] stringArray = string.split("_");
                bl2 = stringArray.length == 1;
                StringBuffer stringBuffer = new StringBuffer();
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    if (i2 == 0) {
                        stringBuffer.append(stringArray[i2]);
                    } else {
                        stringBuffer.append("_" + stringArray[i2]);
                    }
                    if (list.contains(stringBuffer.toString())) {
                        string2 = stringBuffer.toString();
                        storeProcedure = ((DatasourceManager)object).getProcedure(stringBuffer.toString());
                        break;
                    }
                    if (SynchronizedLiveDataModelUtils.getSourceTableData(tableDataSource, stringBuffer.toString()) == TableData.EMPTY_TABLEDATA) continue;
                    string2 = stringBuffer.toString();
                    storeProcedure = (StoreProcedure)SynchronizedLiveDataModelUtils.getSourceTableData(tableDataSource, stringBuffer.toString());
                    break;
                }
            }
            dataModel = SynchronizedLiveDataModelUtils.getStoreProcedureDataModel(storeProcedure, string, calculator, map, string2, bl || bl2);
        }
        object = new DefaultIndexDataModel(dataModel);
        map.put(string, (DataModel)object);
        return object;
    }

    protected static DataModel getStoreProcedureDataModel(StoreProcedure storeProcedure, String string, Calculator calculator, Map<String, DataModel> map, String string2, boolean bl) {
        DataModel dataModel = DataModel.EMPTY_DATAMODEL;
        DatasourceManager datasourceManager = DatasourceManager.getInstance();
        if (storeProcedure == null) {
            storeProcedure = datasourceManager.getProcedureBy_dsName(string);
        }
        if (storeProcedure == null) {
            return dataModel;
        }
        ProcedureDataModel[] procedureDataModelArray = storeProcedure.creatDataModel(calculator);
        int n2 = procedureDataModelArray.length;
        if (n2 > 0) {
            for (int i2 = 0; i2 < n2; ++i2) {
                ProcedureDataModel procedureDataModel = procedureDataModelArray[i2];
                map.put(string2 + "_" + procedureDataModel.getName(), procedureDataModel);
            }
            if (bl) {
                return procedureDataModelArray[0];
            }
            DataModel dataModel2 = map.get(string);
            return dataModel2 == null ? DataModel.EMPTY_DATAMODEL : dataModel2;
        }
        return dataModel;
    }

    public static TableData getSourceTableData(TableDataSource tableDataSource, String string) {
        DatasourceManager datasourceManager;
        TableData tableData = tableDataSource.getTableData(string);
        if (tableData == null && (tableData = (datasourceManager = DatasourceManager.getInstance()).getTableData(string)) == null) {
            tableData = TableData.EMPTY_TABLEDATA;
        }
        return tableData;
    }

    public static DataModel createDefaultDBDataModel(DBTableData dBTableData, String string) {
        if (dBTableData == null) {
            return null;
        }
        if (dBTableData.isShareTableData()) {
            AbstractDBDataModel abstractDBDataModel = (AbstractDBDataModel)ManagerFactory.getCacheProvider().get(dBTableData.getDatabase(), string, dBTableData.getMaxMemRowCount());
            SharedDBDataModel sharedDBDataModel = new SharedDBDataModel(abstractDBDataModel);
            abstractDBDataModel.register(sharedDBDataModel);
            return sharedDBDataModel;
        }
        if (FRLogger.getLogger().isLoggable(Level.CONFIG)) {
            FRLogger.getLogger().info("SQL: " + string);
        }
        return DBTableData.createCacheableDBResultSet(dBTableData.getDatabase(), string, dBTableData.getMaxMemRowCount());
    }
}

