/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base;

import com.fr.base.FRContext;
import com.fr.general.GeneralUtils;
import com.fr.stable.core.PropertyChangeListener;
import com.fr.stable.module.Module;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleContext {
    private static Set startedModules = new HashSet();
    private static PropertyChangeListener<String> moduleChangeListener = null;

    public static boolean isModuleStarted(String string) {
        return startedModules.contains(string);
    }

    public static void startModule(String string) {
        if (ModuleContext.isModuleStarted(string)) {
            return;
        }
        try {
            Module module = (Module)GeneralUtils.classForName(string).newInstance();
            if (moduleChangeListener != null) {
                moduleChangeListener.propertyChange(module.getInterNationalName());
            }
            ModuleContext.registerStartedModule(string);
            module.start();
            FRContext.getLogger().info("Module " + string + " is started.");
        }
        catch (InstantiationException instantiationException) {
            FRContext.getLogger().error("Can't start the module: " + string, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            FRContext.getLogger().error("Can't start the module: " + string, illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            FRContext.getLogger().info("Can't found the module: " + string);
        }
        catch (ClassCastException classCastException) {
            FRContext.getLogger().error("Can't start the module: " + string, classCastException);
        }
    }

    public static void registerStartedModule(String string) {
        startedModules.add(string);
    }

    public static void registerPropertyChangeListener(PropertyChangeListener<String> propertyChangeListener) {
        moduleChangeListener = propertyChangeListener;
    }

    public static void stopModules() {
        Iterator iterator = startedModules.iterator();
        while (iterator.hasNext()) {
            try {
                Module module = (Module)GeneralUtils.classForName(iterator.next().toString()).newInstance();
                if (!module.isNeedReleaseResource()) continue;
                module.stop();
            }
            catch (Exception exception) {
                FRContext.getLogger().error(exception.getMessage());
            }
        }
        startedModules.clear();
    }
}

