/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base;

import Sense4.Elite4;
import Sense4.LockUtils;
import com.fr.base.ConfigManager;
import com.fr.base.Env;
import com.fr.base.FRContext;
import com.fr.base.Utils;
import com.fr.general.ComparatorUtils;
import com.fr.general.GeneralContext;
import com.fr.general.GeneralUtils;
import com.fr.general.Inter;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.ArrayUtils;
import com.fr.stable.Consts;
import com.fr.stable.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Calendar;

public class FRCoreContext {
    public static final ThreadLocal TMAP = new ThreadLocal();
    private static byte[] lic_bytes = null;
    private static byte[] lock_bytes = null;
    private static final long ONE_YEAR_MILLISECOND = 31536000000L;
    private static final BigInteger N = new BigInteger("61103299352066102812915201580370346997919089893149305765565972348630053713717591736527153881172892494135635969333391530396986735629281282430026953431657619628355730192943385620088393498664105803897708601718035436482482749378713844253725606147581454234307387984660050507963063894825237808748868429675256901161");
    private static final BigInteger D = new BigInteger("65537");

    private FRCoreContext() {
    }

    public static final byte[] getBytes() {
        byte[] byArray = FRCoreContext.getLicBytes();
        if ((byArray == null || byArray.length == 0) && ConfigManager.getInstance().isLicUseLock()) {
            byArray = FRCoreContext.getLockBytes();
        }
        return byArray;
    }

    public static final void resetBytes() {
        lic_bytes = null;
    }

    public static final void retryLicLock() {
        byte[] byArray = FRCoreContext.getLicBytes();
        if ((byArray == null || byArray.length == 0) && ConfigManager.getInstance().isLicUseLock()) {
            lock_bytes = null;
            byArray = FRCoreContext.getLockBytes();
        }
    }

    private static final byte[] getLicBytes() {
        if (lic_bytes == null) {
            InputStream inputStream = null;
            Env env = FRContext.getCurrentEnv();
            try {
                if (env != null) {
                    inputStream = env.readBean(env.getLicName(), "resources");
                }
                if (inputStream != null) {
                    byte[] byArray = Utils.inputStream2Bytes(inputStream);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    FRCoreContext.decode(byArray, (OutputStream)byteArrayOutputStream);
                    JSONObject jSONObject = new JSONObject(new String(byteArrayOutputStream.toByteArray(), "UTF-8"));
                    if (jSONObject.getLong("DEADLINE") < Calendar.getInstance().getTimeInMillis()) {
                        return null;
                    }
                    if (FRCoreContext.checkValid(jSONObject)) {
                        lic_bytes = byArray;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return lic_bytes;
    }

    private static boolean checkValid(JSONObject jSONObject) {
        try {
            return FRCoreContext.isTempLic(jSONObject) || FRCoreContext.isVersionMatched(jSONObject) && FRCoreContext.isMacAddressMatched(jSONObject) && FRCoreContext.isAppNameMatched(jSONObject) && FRCoreContext.isUUIDMatched(jSONObject);
        }
        catch (Exception exception) {
            FRContext.getLogger().info(exception.getMessage());
            return false;
        }
    }

    private static boolean isTempLic(JSONObject jSONObject) throws JSONException {
        return jSONObject.getLong("DEADLINE") - Calendar.getInstance().getTimeInMillis() < 31536000000L;
    }

    private static boolean isVersionMatched(JSONObject jSONObject) throws JSONException {
        return jSONObject.has("VERSION") && ComparatorUtils.equals(Consts.VERSION, jSONObject.getString("VERSION"));
    }

    private static boolean isMacAddressMatched(JSONObject jSONObject) throws JSONException, IOException {
        return !jSONObject.has("MACADDRESS") || GeneralUtils.isMacAddressMatch(jSONObject.getString("MACADDRESS"));
    }

    private static boolean isAppNameMatched(JSONObject jSONObject) throws JSONException {
        return !jSONObject.has("APPNAME") || StringUtils.isEmpty(jSONObject.getString("APPNAME")) || GeneralContext.getCurrentAppNameOfEnv().equalsIgnoreCase(jSONObject.getString("APPNAME"));
    }

    private static boolean isUUIDMatched(JSONObject jSONObject) throws JSONException {
        return !jSONObject.has("UUID") || GeneralUtils.isUUIDMatch(jSONObject.getString("UUID"));
    }

    private static final byte[] getLockBytes() {
        if (lock_bytes == null) {
            try {
                byte[] byArray = null;
                try {
                    byArray = Elite4.readBytesFromElitee4();
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    FRContext.getLogger().error(Inter.getLocText("NS_register_sense"));
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                FRCoreContext.decode(byArray, (OutputStream)byteArrayOutputStream);
                JSONObject jSONObject = new JSONObject(new String(byteArrayOutputStream.toByteArray(), "UTF-8"));
                if (ComparatorUtils.equals(jSONObject.getString("VERSION"), Consts.VERSION)) {
                    String string = LockUtils.toHexString((byte[])Elite4.readElite4Serial());
                    if (jSONObject.has("SERIALNUMBER")) {
                        if (ComparatorUtils.equals(string, jSONObject.getString("SERIALNUMBER"))) {
                            lock_bytes = byArray;
                        } else {
                            FRContext.getLogger().error("The Encryption Lock is Illegal or Fake!");
                        }
                    }
                } else {
                    FRContext.getLogger().error("LicVersion[" + jSONObject.getString("VERSION") + "] != JarVersion[" + Consts.VERSION + "]");
                }
            }
            catch (Error error) {
                FRContext.getLogger().errorWithServerLevel(error.getMessage(), error);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return lock_bytes;
    }

    public static void decode(byte[] byArray, OutputStream outputStream) {
        if (byArray == null || byArray.length == 0) {
            return;
        }
        FRCoreContext.decode(FRCoreContext.byte2hex(byArray), outputStream);
    }

    private static void decode(String string, OutputStream outputStream) {
        String[] stringArray = string.split(FRCoreContext.byte2hex(N.toByteArray()));
        try {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                outputStream.write(FRCoreContext.tinyDecode(FRCoreContext.hex2byte(stringArray[i2])));
            }
        }
        catch (IOException iOException) {
            FRContext.getLogger().error(iOException.getMessage(), iOException);
        }
    }

    private static String byte2hex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            string = Integer.toHexString(byArray[i2] & 0xFF);
            if (string.length() == 1) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString().toUpperCase();
    }

    private static byte[] hex2byte(String string) {
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        if (n2 % 2 == 1) {
            return null;
        }
        byte[] byArray = new byte[n2 / 2];
        for (int i2 = 0; i2 != n2 / 2; ++i2) {
            byArray[i2] = (byte)Integer.parseInt(string.substring(i2 * 2, i2 * 2 + 2), 16);
        }
        return byArray;
    }

    private static byte[] tinyDecode(byte[] byArray) {
        byArray = new BigInteger(byArray).modPow(D, N).toByteArray();
        return ArrayUtils.subarray(byArray, 1, byArray.length);
    }
}

