/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base;

import com.fr.general.ComparatorUtils;
import com.fr.general.GeneralUtils;
import com.fr.stable.StringUtils;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.FieldPosition;

public class CoreDecimalFormat
extends DecimalFormat {
    private DecimalFormat format;
    private String pattern;

    public CoreDecimalFormat() {
        this.format = new DecimalFormat();
    }

    public CoreDecimalFormat(DecimalFormat decimalFormat, String string) {
        this.format = decimalFormat;
        this.pattern = string;
    }

    public String toPattern() {
        return this.pattern;
    }

    public void applyPattern(String string) {
        if (this.format == null) {
            this.format = new DecimalFormat(string);
        }
        this.format.applyPattern(string);
        this.pattern = string;
    }

    public String formatRoundingModeUp(Object object) {
        return this.formatNumberInJDK1_4(object);
    }

    private String formatNumberInJDK1_4(Object object) {
        if (StringUtils.isEmpty(this.pattern)) {
            return GeneralUtils.objectToString(object);
        }
        if (this.format instanceof DecimalFormat) {
            if (this.pattern.indexOf("%") != -1 || this.pattern.indexOf("E") != -1 || this.pattern.indexOf("\u00a4") != -1) {
                return this.format.format(object);
            }
            BigDecimal bigDecimal = null;
            String[] stringArray = this.pattern.split("\\.");
            if (stringArray.length > 1) {
                int n2 = stringArray[1].length();
                bigDecimal = new BigDecimal(GeneralUtils.objectToString(object)).setScale(n2, 4);
            } else if (stringArray.length == 1) {
                bigDecimal = new BigDecimal(GeneralUtils.objectToString(object)).setScale(0, 4);
            }
            return this.format.format(bigDecimal);
        }
        return this.format.format(object);
    }

    public StringBuffer format(double d2, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.format.format(d2, stringBuffer, fieldPosition);
    }

    public StringBuffer format(long l2, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.format.format(l2, stringBuffer, fieldPosition);
    }

    public boolean equals(Object object) {
        return object instanceof CoreDecimalFormat && ComparatorUtils.equals(((CoreDecimalFormat)object).pattern, this.pattern);
    }

    public int hashCode() {
        return this.format.hashCode();
    }
}

