/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base;

import com.fr.base.BaseUtils;
import com.fr.base.CoreDecimalFormat;
import com.fr.base.DynamicNumberList;
import com.fr.base.FRContext;
import com.fr.base.GraphHelper;
import com.fr.base.MultiFieldParameter;
import com.fr.base.NameStyle;
import com.fr.base.Parameter;
import com.fr.base.StoreProcedureParameter;
import com.fr.base.Style;
import com.fr.base.TextFormat;
import com.fr.base.Utils;
import com.fr.base.background.ColorBackground;
import com.fr.general.Background;
import com.fr.general.FRFont;
import com.fr.general.GeneralUtils;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.stable.ParameterProvider;
import com.fr.stable.StableUtils;
import com.fr.stable.xml.StableXMLUtils;
import com.fr.stable.xml.XMLFileReader;
import com.fr.stable.xml.XMLObject;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLWriter;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

public class BaseXMLUtils {
    private BaseXMLUtils() {
    }

    public static Object readXMLFile(InputStream inputStream, XMLFileReader xMLFileReader) throws Exception {
        return BaseXMLUtils.readXMLFile(new InputStreamReader(inputStream, "UTF-8"), xMLFileReader);
    }

    private static Object readXMLFile(Reader reader, XMLFileReader xMLFileReader) throws Exception {
        XMLableReader xMLableReader = XMLableReader.createXMLableReader(reader);
        if (xMLableReader != null) {
            String string = xMLableReader.getTagName();
            if (string == null) {
                throw new Exception("Error template file.");
            }
            return xMLFileReader.readFileContent(xMLableReader);
        }
        return null;
    }

    public static void writeXMLFile(OutputStream outputStream, XMLWriter xMLWriter) {
        XMLPrintWriter xMLPrintWriter = XMLPrintWriter.create(outputStream);
        xMLWriter.writeXML(xMLPrintWriter);
        xMLPrintWriter.flush();
        xMLPrintWriter.close();
    }

    public static Background readBackground(XMLableReader xMLableReader) {
        Background background = null;
        String string = null;
        String string2 = xMLableReader.getAttrAsString("name", null);
        if (string2 != null) {
            if (string2.equals("ColorBackground")) {
                string = "com.fr.base.background.ColorBackground";
            } else if (string2.equals("GradientBackground")) {
                string = "com.fr.base.background.GradientBackground";
            } else if (string2.equals("TextureBackground")) {
                string = "com.fr.base.background.TextureBackground";
            } else if (string2.equals("PatternBackground")) {
                string = "com.fr.base.background.PatternBackground";
            } else if (string2.equals("ImageBackground")) {
                string = "com.fr.base.background.ImageBackground";
            } else if (string2.equals("BGBackground")) {
                string = "com.fr.base.background.IntervalColorBackground";
            } else if (string2.equals("NullBackground")) {
                // empty if block
            }
        }
        if (string == null && (string = xMLableReader.getAttrAsString("class", null)) != null && !"null".equals(string)) {
            string = Utils.replaceAllString(string2, "com.fr.report.background", "com.fr.base.background");
        }
        if (string == null) {
            return null;
        }
        try {
            background = (Background)GeneralUtils.classForName(string).newInstance();
        }
        catch (Exception exception) {
            FRContext.getLogger().errorWithServerLevel("Load class with name: " + string2, exception);
        }
        if (background != null) {
            background = background.readAdditionalAttr(xMLableReader);
        }
        return background;
    }

    public static void writeFormat(XMLPrintWriter xMLPrintWriter, Format format) {
        xMLPrintWriter.startTAG("Format").attr("class", format.getClass().getName());
        if (format instanceof CoreDecimalFormat) {
            xMLPrintWriter.textNode(((CoreDecimalFormat)format).toPattern());
        } else if (format instanceof SimpleDateFormat) {
            xMLPrintWriter.textNode(((SimpleDateFormat)format).toPattern());
        }
        xMLPrintWriter.end();
    }

    public static Format readFormat(XMLableReader xMLableReader) {
        Format format = null;
        CoreDecimalFormat coreDecimalFormat = null;
        String string = xMLableReader.getAttrAsString("class", null);
        if (string != null) {
            if (string.endsWith(".TextFormat")) {
                format = TextFormat.getInstance();
            } else if (string.endsWith(".CoreDecimalFormat")) {
                format = new CoreDecimalFormat();
            } else if (string.endsWith(".SimpleDateFormat")) {
                format = new SimpleDateFormat();
            } else {
                try {
                    format = (Format)GeneralUtils.classForName(string).newInstance();
                }
                catch (Exception exception) {
                    FRContext.getLogger().error("Error in read Format", exception);
                }
            }
        } else {
            format = TextFormat.getInstance();
        }
        if (format instanceof DecimalFormat) {
            coreDecimalFormat = new CoreDecimalFormat(new DecimalFormat(), "");
        }
        if (format != null) {
            String string2 = null;
            string = xMLableReader.getElementValue();
            if (string != null) {
                string2 = string;
            }
            if (string2 != null) {
                if (format instanceof CoreDecimalFormat) {
                    ((CoreDecimalFormat)format).applyPattern(string2);
                } else if (format instanceof SimpleDateFormat) {
                    ((SimpleDateFormat)format).applyPattern(string2);
                }
                if (coreDecimalFormat != null) {
                    coreDecimalFormat.applyPattern(string2);
                }
            }
        }
        return coreDecimalFormat == null ? format : coreDecimalFormat;
    }

    public static void writeBackground(XMLPrintWriter xMLPrintWriter, Background background) {
        xMLPrintWriter.startTAG("Background");
        if (background == null) {
            xMLPrintWriter.attr("name", "NullBackground").end();
            return;
        }
        background.writeAdditionalAttr(xMLPrintWriter);
        xMLPrintWriter.end();
    }

    public static FRFont readFRFont(XMLableReader xMLableReader) {
        String string = "";
        int n2 = 0;
        int n3 = 0;
        String string2 = xMLableReader.getAttrAsString("name", null);
        if (string2 != null) {
            string = string2;
        }
        n2 = xMLableReader.getAttrAsInt("style", 0);
        n3 = xMLableReader.getAttrAsInt("size", 0);
        if (!xMLableReader.getXMLVersion().isAfterREPORT_REFECT_FOR65_4_XML_VERSION()) {
            n3 = n3 * 8 * 3 / 4;
        }
        FRFont fRFont = FRFont.getInstanceFromFRSize(string, n2, n3);
        fRFont = fRFont.applyForeground(xMLableReader.getAttrAsColor("foreground", Color.black));
        fRFont = fRFont.applyUnderline(xMLableReader.getAttrAsInt("underline", 0));
        fRFont = fRFont.applyStrikethrough(xMLableReader.getAttrAsBoolean("isStrikethrough", false));
        fRFont = fRFont.applyShadow(xMLableReader.getAttrAsBoolean("isShadow", false));
        fRFont = fRFont.applySuperscript(xMLableReader.getAttrAsBoolean("isSuperscript", false));
        fRFont = fRFont.applySubscript(xMLableReader.getAttrAsBoolean("isSubscript", false));
        return fRFont;
    }

    public static void writeFRFont(XMLPrintWriter xMLPrintWriter, FRFont fRFont) {
        xMLPrintWriter.startTAG("FRFont").attr("name", fRFont.getName()).attr("style", fRFont.getStyle()).attr("size", fRFont.getFRSize());
        if (fRFont.getForeground() != null && !fRFont.getForeground().equals(Color.black)) {
            xMLPrintWriter.attr("foreground", fRFont.getForeground().getRGB());
        }
        if (fRFont.getUnderline() != 0) {
            xMLPrintWriter.attr("underline", fRFont.getUnderline());
        }
        if (fRFont.isStrikethrough()) {
            xMLPrintWriter.attr("isStrikethrough", fRFont.isStrikethrough());
        }
        if (fRFont.isShadow()) {
            xMLPrintWriter.attr("isShadow", fRFont.isShadow());
        }
        if (fRFont.isSuperscript()) {
            xMLPrintWriter.attr("isSuperscript", fRFont.isSuperscript());
        }
        if (fRFont.isSubscript()) {
            xMLPrintWriter.attr("isSubscript", fRFont.isSubscript());
        }
        xMLPrintWriter.end();
    }

    public static boolean isFRFontTagName(String string) {
        if (string == null) {
            return false;
        }
        return string.equals("CellFont") || string.equals("ReportFont") || string.equals("FRFont");
    }

    public static void writeTexturePaint(XMLPrintWriter xMLPrintWriter, TexturePaint texturePaint) {
        xMLPrintWriter.startTAG("TexturePaint");
        Rectangle2D rectangle2D = texturePaint.getAnchorRect();
        xMLPrintWriter.startTAG("Rectangle2D").attr("x", rectangle2D.getX()).attr("y", rectangle2D.getY()).attr("width", rectangle2D.getWidth()).attr("height", rectangle2D.getHeight()).end();
        GeneralXMLTools.writeImage(xMLPrintWriter, texturePaint.getImage());
        xMLPrintWriter.end();
    }

    public static TexturePaint readTexturePaint(XMLableReader xMLableReader) {
        XMLObject xMLObject = new XMLObject(new Object[2]){

            public void readXML(XMLableReader xMLableReader) {
                if (xMLableReader.isChildNode()) {
                    String string = xMLableReader.getTagName();
                    if (string.equals("Rectangle2D")) {
                        double d2 = xMLableReader.getAttrAsDouble("x", 0.0);
                        double d3 = xMLableReader.getAttrAsDouble("y", 0.0);
                        double d4 = xMLableReader.getAttrAsDouble("width", 0.0);
                        double d5 = xMLableReader.getAttrAsDouble("height", 0.0);
                        ((Object[])this.obj)[0] = new Rectangle2D.Double(d2, d3, d4, d5);
                    } else if (string.equals("IM")) {
                        ((Object[])this.obj)[1] = GraphHelper.createBufferedImageFromImage(GeneralXMLTools.readImage(xMLableReader));
                    } else if ("Image".equals(xMLableReader.getTagName())) {
                        ((Object[])this.obj)[1] = GraphHelper.createBufferedImageFromImage(GeneralXMLTools.deprecatedReadImage(xMLableReader));
                    }
                }
            }
        };
        xMLableReader.readXMLObject(xMLObject);
        return new TexturePaint((BufferedImage)((Object[])xMLObject.getObject())[1], (Rectangle2D)((Object[])xMLObject.getObject())[0]);
    }

    public static Rectangle readRectangle(String string) {
        Rectangle rectangle = new Rectangle();
        String[] stringArray = StableUtils.splitString(string, ",");
        if (stringArray != null && stringArray.length == 4) {
            rectangle.x = Integer.parseInt(stringArray[0]);
            rectangle.y = Integer.parseInt(stringArray[1]);
            rectangle.width = Integer.parseInt(stringArray[2]);
            rectangle.height = Integer.parseInt(stringArray[3]);
        }
        return rectangle;
    }

    public static String getRectangleText(Rectangle rectangle) {
        return rectangle.x + "," + rectangle.y + "," + rectangle.width + "," + rectangle.height;
    }

    public static Parameter[] readParameters(XMLableReader xMLableReader) {
        final ArrayList arrayList = new ArrayList();
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                if (xMLableReader.isChildNode()) {
                    if (xMLableReader.getTagName().equals("Parameter")) {
                        arrayList.add(BaseXMLUtils.readParameter(xMLableReader));
                    } else if (xMLableReader.getTagName().equals("MultiFieldParameter")) {
                        arrayList.add(BaseXMLUtils.readMultiFieldParameter(xMLableReader));
                    }
                }
            }
        });
        return arrayList.toArray(new Parameter[arrayList.size()]);
    }

    public static Parameter readParameter(XMLableReader xMLableReader) {
        Parameter parameter = new Parameter();
        xMLableReader.readXMLObject(parameter);
        return parameter;
    }

    public static Parameter readMultiFieldParameter(XMLableReader xMLableReader) {
        MultiFieldParameter multiFieldParameter = new MultiFieldParameter();
        xMLableReader.readXMLObject(multiFieldParameter);
        return multiFieldParameter;
    }

    public static void writeParameters(XMLPrintWriter xMLPrintWriter, ParameterProvider[] parameterProviderArray) {
        StableXMLUtils.writeParameters(xMLPrintWriter, parameterProviderArray);
    }

    public static void writeParameter(XMLPrintWriter xMLPrintWriter, ParameterProvider parameterProvider) {
        StableXMLUtils.writeParameter(xMLPrintWriter, parameterProvider);
    }

    public static StoreProcedureParameter[] readStoreParameters(XMLableReader xMLableReader) {
        final ArrayList arrayList = new ArrayList();
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("Parameter")) {
                    arrayList.add(BaseXMLUtils.readStoreParameter(xMLableReader));
                }
            }
        });
        return arrayList.toArray(new StoreProcedureParameter[arrayList.size()]);
    }

    public static StoreProcedureParameter readStoreParameter(XMLableReader xMLableReader) {
        StoreProcedureParameter storeProcedureParameter = new StoreProcedureParameter();
        xMLableReader.readXMLObject(storeProcedureParameter);
        return storeProcedureParameter;
    }

    public static Style readAuthorityStyle(XMLableReader xMLableReader) {
        Style style = Style.getInstance();
        if (xMLableReader.getAttrAsBoolean("isAuthorityEdited", false)) {
            style = style.deriveBackground(ColorBackground.getInstance(new Color(255, 153, 203)));
        }
        return style;
    }

    public static Style readFullStyle(XMLableReader xMLableReader) {
        String string = xMLableReader.getAttrAsString("style_name", null);
        if (string != null) {
            return NameStyle.getInstance(string);
        }
        Style style = Style.getInstance();
        string = xMLableReader.getAttrAsString("horizontal_alignment", null);
        if (string != null) {
            int n2 = Integer.parseInt(string);
            style = style.deriveHorizontalAlignment(n2);
        }
        if ((string = xMLableReader.getAttrAsString("vertical_alignment", null)) != null) {
            style = style.deriveVerticalAlignment(Integer.parseInt(string));
        }
        if ((string = xMLableReader.getAttrAsString("textStyle", null)) != null) {
            style = style.deriveTextStyle(Integer.parseInt(string));
        }
        if ((string = xMLableReader.getAttrAsString("isVerticalText", null)) != null) {
            style = style.deriveVerticalText(Integer.parseInt(string));
        }
        if ((string = xMLableReader.getAttrAsString("textDirection", null)) != null) {
            style = style.deriveTextDirection(Integer.parseInt(string));
        }
        if ((string = xMLableReader.getAttrAsString("rotation", null)) != null) {
            style = style.deriveRotation(Integer.parseInt(string));
        }
        if ((string = xMLableReader.getAttrAsString("imageLayout", null)) != null) {
            style = style.deriveImageLayout(Integer.parseInt(string));
        }
        if (!xMLableReader.getXMLVersion().isAfterREPORT_REFECT_FOR65_4_XML_VERSION()) {
            string = xMLableReader.getAttrAsString("paddingLeft", null);
            if (string != null || (string = xMLableReader.getAttrAsString("leftIndent", null)) != null) {
                style = style.derivePaddingLeft(Math.round((float)Integer.parseInt(string) * 3.0f / 4.0f));
            }
            if ((string = xMLableReader.getAttrAsString("paddingRight", null)) != null || (string = xMLableReader.getAttrAsString("rightIndent", null)) != null) {
                style = style.derivePaddingRight(Math.round((float)Integer.parseInt(string) * 3.0f / 4.0f));
            }
            if ((string = xMLableReader.getAttrAsString("spacingBefore", null)) != null) {
                style = style.deriveSpacingBefore(Math.round((float)Integer.parseInt(string) * 3.0f / 4.0f));
            }
            if ((string = xMLableReader.getAttrAsString("spacingAfter", null)) != null) {
                style = style.deriveSpacingAfter(Math.round((float)Integer.parseInt(string) * 3.0f / 4.0f));
            }
            if ((string = xMLableReader.getAttrAsString("lineSpacing", null)) != null) {
                style = style.deriveLineSpacing(Math.round((float)Integer.parseInt(string) * 3.0f / 4.0f));
            }
        } else {
            string = xMLableReader.getAttrAsString("paddingLeft", null);
            if (string != null) {
                style = style.derivePaddingLeft(Integer.parseInt(string));
            }
            if ((string = xMLableReader.getAttrAsString("paddingRight", null)) != null) {
                style = style.derivePaddingRight(Integer.parseInt(string));
            }
            if ((string = xMLableReader.getAttrAsString("spacingBefore", null)) != null) {
                style = style.deriveSpacingBefore(Integer.parseInt(string));
            }
            if ((string = xMLableReader.getAttrAsString("spacingAfter", null)) != null) {
                style = style.deriveSpacingAfter(Integer.parseInt(string));
            }
            if ((string = xMLableReader.getAttrAsString("lineSpacing", null)) != null) {
                style = style.deriveLineSpacing(Integer.parseInt(string));
            }
        }
        XMLObject xMLObject = new XMLObject(style){

            public void readXML(XMLableReader xMLableReader) {
                if (xMLableReader.isChildNode()) {
                    String string = xMLableReader.getTagName();
                    if (string.equals("Format")) {
                        this.obj = ((Style)this.obj).deriveFormat(BaseXMLUtils.readFormat(xMLableReader));
                    } else if (BaseXMLUtils.isFRFontTagName(string)) {
                        this.obj = ((Style)this.obj).deriveFRFont(BaseXMLUtils.readFRFont(xMLableReader));
                    } else if (string.equals("Background")) {
                        this.obj = ((Style)this.obj).deriveBackground(BaseXMLUtils.readBackground(xMLableReader));
                    }
                    this.obj = BaseXMLUtils.readBorderStyle(xMLableReader, (Style)this.obj);
                }
            }
        };
        xMLableReader.readXMLObject(xMLObject);
        return (Style)xMLObject.getObject();
    }

    public static Style readBorderStyle(XMLableReader xMLableReader, Style style) {
        String string;
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals("Border")) {
            XMLObject xMLObject = new XMLObject(style){

                public void readXML(XMLableReader xMLableReader) {
                    if (xMLableReader.isChildNode()) {
                        String string = xMLableReader.getTagName();
                        int n2 = 0;
                        Color color = Color.black;
                        if (string.equals("Top")) {
                            String string2 = xMLableReader.getAttrAsString("style", null);
                            if (string2 != null) {
                                n2 = Integer.parseInt(string2);
                            }
                            if ((string2 = xMLableReader.getAttrAsString("color", null)) != null) {
                                color = new Color(Integer.parseInt(string2), true);
                            }
                            this.obj = ((Style)this.obj).deriveBorderTop(n2, color);
                        } else if (string.equals("Left")) {
                            String string3 = xMLableReader.getAttrAsString("style", null);
                            if (string3 != null) {
                                n2 = Integer.parseInt(string3);
                            }
                            if ((string3 = xMLableReader.getAttrAsString("color", null)) != null) {
                                color = new Color(Integer.parseInt(string3), true);
                            }
                            this.obj = ((Style)this.obj).deriveBorderLeft(n2, color);
                        } else if (string.equals("Bottom")) {
                            String string4 = xMLableReader.getAttrAsString("style", null);
                            if (string4 != null) {
                                n2 = Integer.parseInt(string4);
                            }
                            if ((string4 = xMLableReader.getAttrAsString("color", null)) != null) {
                                color = new Color(Integer.parseInt(string4), true);
                            }
                            this.obj = ((Style)this.obj).deriveBorderBottom(n2, color);
                        } else if (string.equals("Right")) {
                            String string5 = xMLableReader.getAttrAsString("style", null);
                            if (string5 != null) {
                                n2 = Integer.parseInt(string5);
                            }
                            if ((string5 = xMLableReader.getAttrAsString("color", null)) != null) {
                                color = new Color(Integer.parseInt(string5), true);
                            }
                            this.obj = ((Style)this.obj).deriveBorderRight(n2, color);
                        }
                    }
                }
            };
            xMLableReader.readXMLObject(xMLObject);
            return (Style)xMLObject.getObject();
        }
        return style;
    }

    public static void writeStyle(XMLPrintWriter xMLPrintWriter, Style style) {
        BaseXMLUtils.writeStyle(xMLPrintWriter, style, false);
    }

    public static void writeStyle(XMLPrintWriter xMLPrintWriter, Style style, boolean bl) {
        if (style instanceof NameStyle) {
            if (!bl) {
                xMLPrintWriter.startTAG("Style").attr("style_name", ((NameStyle)style).getName()).end();
                return;
            }
            style = ((NameStyle)style).getRealStyle();
        }
        xMLPrintWriter.startTAG("Style");
        if (BaseUtils.getAlignment4Horizontal(style) != -1) {
            xMLPrintWriter.attr("horizontal_alignment", BaseUtils.getAlignment4Horizontal(style));
        }
        if (style.getVerticalAlignment() != 0) {
            xMLPrintWriter.attr("vertical_alignment", style.getVerticalAlignment());
        }
        if (style.getTextStyle() != 0) {
            xMLPrintWriter.attr("textStyle", style.getTextStyle());
        }
        if (style.getVerticalText() != 0) {
            xMLPrintWriter.attr("isVerticalText", style.getVerticalText()).attr("textDirection", style.getTextDirection());
        }
        if (style.getRotation() != 0) {
            xMLPrintWriter.attr("rotation", style.getRotation());
        }
        if (style.getImageLayout() != 3) {
            xMLPrintWriter.attr("imageLayout", style.getImageLayout());
        }
        if (style.getPaddingLeft() != 2) {
            xMLPrintWriter.attr("paddingLeft", style.getPaddingLeft());
        }
        if (style.getPaddingRight() != 2) {
            xMLPrintWriter.attr("paddingRight", style.getPaddingRight());
        }
        if (style.getSpacingBefore() != 0) {
            xMLPrintWriter.attr("spacingBefore", style.getSpacingBefore());
        }
        if (style.getSpacingAfter() != 0) {
            xMLPrintWriter.attr("spacingAfter", style.getSpacingAfter());
        }
        if (style.getLineSpacing() != 0) {
            xMLPrintWriter.attr("lineSpacing", style.getLineSpacing());
        }
        if (style.getFormat() != null) {
            BaseXMLUtils.writeFormat(xMLPrintWriter, style.getFormat());
        }
        if (style.getFRFont() != null) {
            BaseXMLUtils.writeFRFont(xMLPrintWriter, style.getFRFont());
        }
        BaseXMLUtils.writeBackground(xMLPrintWriter, style.getBackground());
        BaseXMLUtils.writeBorderStyle(xMLPrintWriter, style);
        xMLPrintWriter.end();
    }

    public static void writeBorderStyle(XMLPrintWriter xMLPrintWriter, Style style) {
        xMLPrintWriter.startTAG("Border");
        if (style.getBorderTop() != 0 || style.getBorderTopColor() != Color.black) {
            xMLPrintWriter.startTAG("Top");
            if (style.getBorderTop() != 0) {
                xMLPrintWriter.attr("style", style.getBorderTop());
            }
            if (style.getBorderTopColor() != Color.black) {
                xMLPrintWriter.attr("color", style.getBorderTopColor().getRGB());
            }
            xMLPrintWriter.end();
        }
        if (style.getBorderBottom() != 0 || style.getBorderBottomColor() != Color.black) {
            xMLPrintWriter.startTAG("Bottom");
            if (style.getBorderBottom() != 0) {
                xMLPrintWriter.attr("style", style.getBorderBottom());
            }
            if (style.getBorderBottomColor() != Color.black) {
                xMLPrintWriter.attr("color", style.getBorderBottomColor().getRGB());
            }
            xMLPrintWriter.end();
        }
        if (style.getBorderLeft() != 0 || style.getBorderLeftColor() != Color.black) {
            xMLPrintWriter.startTAG("Left");
            if (style.getBorderLeft() != 0) {
                xMLPrintWriter.attr("style", style.getBorderLeft());
            }
            if (style.getBorderLeftColor() != Color.black) {
                xMLPrintWriter.attr("color", style.getBorderLeftColor().getRGB());
            }
            xMLPrintWriter.end();
        }
        if (style.getBorderRight() != 0 || style.getBorderRightColor() != Color.black) {
            xMLPrintWriter.startTAG("Right");
            if (style.getBorderRight() != 0) {
                xMLPrintWriter.attr("style", style.getBorderRight());
            }
            if (style.getBorderRightColor() != Color.black) {
                xMLPrintWriter.attr("color", style.getBorderRightColor().getRGB());
            }
            xMLPrintWriter.end();
        }
        xMLPrintWriter.end();
    }

    public static void writeDynamicNumberList(XMLPrintWriter xMLPrintWriter, DynamicNumberList dynamicNumberList) {
        xMLPrintWriter.attr("defaultValue", dynamicNumberList.getDefaultValue());
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = dynamicNumberList.size();
        for (int i2 = 0; i2 <= n2; ++i2) {
            if (i2 != 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(dynamicNumberList.get(i2));
        }
        xMLPrintWriter.textNode(stringBuffer.toString());
    }

    public static DynamicNumberList readDynamicNumberList(XMLableReader xMLableReader) {
        String string;
        DynamicNumberList dynamicNumberList = null;
        dynamicNumberList = new DynamicNumberList(xMLableReader.getAttrAsInt("defaultValue", 10));
        if (dynamicNumberList != null && (string = xMLableReader.getElementValue()) != null) {
            String[] stringArray = StableUtils.splitString(string, ',');
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (stringArray[i2] == null || stringArray[i2].length() <= 0) continue;
                dynamicNumberList.set(i2, (int)Double.parseDouble(stringArray[i2]));
            }
        }
        return dynamicNumberList;
    }
}

