/*
 * Decompiled with CFR 0.152.
 */
package com.fr.adhoc.report.core;

import com.fr.adhoc.report.core.StepAdhocGroup;
import com.fr.data.condition.FormulaCondition;
import com.fr.general.ComparatorUtils;
import com.fr.general.DateUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.report.cell.cellattr.core.group.ConditionGroup;
import com.fr.report.cell.cellattr.core.group.CustomGrouper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DateAdhocGroup
extends StepAdhocGroup {
    public DateAdhocGroup(JSONObject jSONObject) throws Exception {
        this.parseJSON(jSONObject);
    }

    protected void parse2Step(Object object) throws JSONException {
        if (object instanceof JSONObject) {
            this.setStep(new DateStep(((JSONObject)object).getBoolean("year"), ((JSONObject)object).getBoolean("season"), ((JSONObject)object).getBoolean("month"), ((JSONObject)object).getBoolean("day"), ((JSONObject)object).getInt("days")));
        }
    }

    public CustomGrouper parseGroup(String string) {
        Object object;
        CustomGrouper customGrouper = new CustomGrouper();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Date date = (Date)this.getStartValue();
        Date date2 = (Date)this.getEndValue();
        DateStep dateStep = (DateStep)this.getStep();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while (date.getTime() < date2.getTime()) {
            DateCategory dateCategory = new DateCategory(date);
            StringBuffer conditionGroupArray2 = new StringBuffer();
            object = new StringBuffer().append("(1 == 1)");
            if (dateStep.isYear()) {
                conditionGroupArray2.append(dateCategory.getYear()).append("\u5e74");
                ((StringBuffer)object).append(" && (year(").append(string).append(")=").append(dateCategory.getYear()).append(")");
            }
            if (dateStep.isSeason()) {
                conditionGroupArray2.append("\u7b2c").append(dateCategory.getSeason()).append("\u5b63\u5ea6");
                ((StringBuffer)object).append(" && (ROUNDUP(month(").append(string).append(")/3)=").append(dateCategory.getSeason()).append(")");
            }
            if (dateStep.isMonth()) {
                conditionGroupArray2.append(dateCategory.getMonth()).append("\u6708\u4efd");
                ((StringBuffer)object).append(" && (month(").append(string).append(")=").append(dateCategory.getMonth()).append(")");
            }
            if (dateStep.day) {
                conditionGroupArray2.append(dateStep.getKeyList(dateCategory.getDay(), (StringBuffer)object, string)).append("\u65e5");
            }
            hashMap.put(conditionGroupArray2.toString(), ((StringBuffer)object).toString());
            date = DateUtils.datePlusInteger(date, 1);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            object = new ConditionGroup();
            ((ConditionGroup)object).setDisplay((String)entry.getKey());
            ((ConditionGroup)object).setCondition(new FormulaCondition((String)entry.getValue()));
            arrayList.add(object);
        }
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                if (!(object instanceof ConditionGroup) || !(object2 instanceof ConditionGroup)) {
                    return 0;
                }
                String string = ((ConditionGroup)object).getDisplay();
                String string2 = ((ConditionGroup)object2).getDisplay();
                if (string.length() != string2.length()) {
                    return string.length() > string2.length() ? 1 : -1;
                }
                return ComparatorUtils.compare(string, string2);
            }
        });
        ConditionGroup[] conditionGroupArray = new ConditionGroup[arrayList.size()];
        object = arrayList.iterator();
        int n2 = 0;
        while (object.hasNext()) {
            conditionGroupArray[n2] = (ConditionGroup)object.next();
            ++n2;
        }
        customGrouper.setConditionGroups(conditionGroupArray);
        customGrouper.setForce(true);
        customGrouper.setOther(0);
        return customGrouper;
    }

    private StringBuffer getDoubleDigit(int n2) {
        return new StringBuffer().append(n2 < 10 ? "0" : "").append(n2);
    }

    protected int getType() {
        return 1;
    }

    private class DateCategory {
        private int year;
        private int month;
        private int season;
        private int day;

        public DateCategory(Date date) {
            this.setYear(date.getYear() + 1900);
            this.setMonth(date.getMonth());
            this.setDay(date.getDate());
        }

        public int getYear() {
            return this.year;
        }

        public void setYear(int n2) {
            this.year = n2;
        }

        public int getMonth() {
            return this.month;
        }

        public void setMonth(int n2) {
            this.month = n2 + 1;
            this.season = n2 / 3 + 1;
        }

        public int getDay() {
            return this.day;
        }

        public void setDay(int n2) {
            this.day = n2;
        }

        public int getSeason() {
            return this.season;
        }
    }

    private class DateStep
    extends StepAdhocGroup.Step {
        private boolean year;
        private boolean season;
        private boolean month;
        private boolean day;

        public DateStep(boolean bl, boolean bl2, boolean bl3, boolean bl4, int n2) {
            super(DateAdhocGroup.this, new Integer(n2));
            this.setYear(bl);
            this.setSeason(bl2);
            this.setMonth(bl3);
            this.setDay(bl4);
        }

        private boolean isYear() {
            return this.year;
        }

        private void setYear(boolean bl) {
            this.year = bl;
        }

        private boolean isSeason() {
            return this.season;
        }

        private void setSeason(boolean bl) {
            this.season = bl;
        }

        private boolean isMonth() {
            return this.month;
        }

        private void setMonth(boolean bl) {
            this.month = bl;
        }

        private boolean isDay() {
            return this.day;
        }

        private void setDay(boolean bl) {
            this.day = bl;
        }

        protected Object createJSON() throws JSONException {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("year", this.isYear());
            jSONObject.put("season", this.isSeason());
            jSONObject.put("month", this.isMonth());
            jSONObject.put("day", this.isDay());
            jSONObject.put("days", this.getStep());
            return jSONObject;
        }

        private String getKeyList(int n2, StringBuffer stringBuffer, String string) {
            String string2 = null;
            int n3 = 31;
            int n4 = this.getStep().intValue();
            for (int i2 = 1; i2 <= n3; i2 += n4) {
                if (n2 < i2 || n2 >= i2 + n4) continue;
                int n5 = i2 + n4 - 1;
                n5 = Math.min(n3, n5);
                string2 = DateAdhocGroup.this.getDoubleDigit(i2) + "~" + DateAdhocGroup.this.getDoubleDigit(n5);
                stringBuffer.append(" && (day(").append(string).append(") >=").append(i2).append(")");
                stringBuffer.append(" && (day(").append(string).append(") ").append("<=").append(n5).append(")");
                break;
            }
            return string2;
        }
    }
}

