/*
 * Decompiled with CFR 0.152.
 */
package com.fr.adhoc.report.core;

import com.fr.adhoc.report.core.SimpleADHOCColumn;
import com.fr.base.BrowserI18N;
import com.fr.data.util.function.AverageFunction;
import com.fr.data.util.function.CountFunction;
import com.fr.data.util.function.DataFunction;
import com.fr.data.util.function.MaxFunction;
import com.fr.data.util.function.MinFunction;
import com.fr.data.util.function.SumFunction;
import com.fr.json.JSONObject;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import com.fr.web.core.A.l;
import java.util.HashMap;
import java.util.Map;

public class ADHOCSummaryColumn
extends SimpleADHOCColumn {
    private String weeklySummaryColumn;
    private String monthlySummaryColumn;
    private String yearlySummaryColumn;
    private String function;
    private Map funMap = new HashMap();
    private static Map funNameMap = new HashMap();

    public void initMap() {
        if (this.funMap.size() < 1) {
            this.funMap.put("sum", new SumFunction());
            this.funMap.put("ave", new AverageFunction());
            this.funMap.put("max", new MaxFunction());
            this.funMap.put("min", new MinFunction());
            this.funMap.put("count", new CountFunction());
            this.funMap.put("weeksummary", new SumFunction());
            this.funMap.put("monthsummary", new SumFunction());
            this.funMap.put("yearsummary", new SumFunction());
        }
    }

    private void initNameMap() {
        if (funNameMap.size() < 1) {
            funNameMap.put("sum", BrowserI18N.getLocText("DataFunction-Sum", l.a));
            funNameMap.put("ave", BrowserI18N.getLocText("DataFunction-Average", l.a));
            funNameMap.put("max", BrowserI18N.getLocText("DataFunction-Max", l.a));
            funNameMap.put("min", BrowserI18N.getLocText("DataFunction-Min", l.a));
            funNameMap.put("count", BrowserI18N.getLocText("DataFunction-Count", l.a));
        }
    }

    public DataFunction getFunction() {
        if (this.funMap.size() < 1) {
            this.initMap();
        }
        return (DataFunction)this.funMap.get(this.getFunctionString());
    }

    public String getFunctionName() {
        if (funNameMap.size() < 1) {
            this.initNameMap();
        }
        return (String)funNameMap.get(this.getFunctionString());
    }

    public void setWeeklySummaryColumn(String string) {
        this.weeklySummaryColumn = string;
    }

    public void setMonthlySummaryColumn(String string) {
        this.monthlySummaryColumn = string;
    }

    public void setYearlySummaryColumn(String string) {
        this.yearlySummaryColumn = string;
    }

    public String getFunctionString() {
        return this.function;
    }

    public void setFunction(String string) {
        this.function = string;
    }

    public JSONObject createJSON() throws Exception {
        JSONObject jSONObject = super.createJSON();
        if (this.weeklySummaryColumn != null) {
            jSONObject.put("weeksummary", this.weeklySummaryColumn);
        } else if (this.monthlySummaryColumn != null) {
            jSONObject.put("monthsummary", this.monthlySummaryColumn);
        } else if (this.yearlySummaryColumn != null) {
            jSONObject.put("yearsummary", this.yearlySummaryColumn);
        } else if (this.function != null) {
            jSONObject.put("funname", this.function);
        }
        return jSONObject;
    }

    public void parseJSON(JSONObject jSONObject) throws Exception {
        super.parseJSON(jSONObject);
        this.setFunction(jSONObject.getString("funname"));
        if (jSONObject.has("weeksummary")) {
            this.setWeeklySummaryColumn(jSONObject.getString("weeksummary"));
        }
        if (jSONObject.has("monthsummary")) {
            this.setMonthlySummaryColumn(jSONObject.getString("monthsummary"));
        }
        if (jSONObject.has("yearsummary")) {
            this.setYearlySummaryColumn(jSONObject.getString("yearsummary"));
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ADHOCSummaryColumn aDHOCSummaryColumn = (ADHOCSummaryColumn)super.clone();
        aDHOCSummaryColumn.funMap = new HashMap();
        return aDHOCSummaryColumn;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("WSC".equals(string)) {
                this.weeklySummaryColumn = xMLableReader.getElementValue();
            } else if ("MSC".equals(string)) {
                this.monthlySummaryColumn = xMLableReader.getElementValue();
            } else if ("YSC".equals(string)) {
                this.yearlySummaryColumn = xMLableReader.getElementValue();
            } else if ("FUNC".equals(string)) {
                this.function = xMLableReader.getElementValue();
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (this.weeklySummaryColumn != null) {
            xMLPrintWriter.startTAG("WSC").textNode(this.weeklySummaryColumn).end();
        }
        if (this.monthlySummaryColumn != null) {
            xMLPrintWriter.startTAG("MSC").textNode(this.monthlySummaryColumn).end();
        }
        if (this.yearlySummaryColumn != null) {
            xMLPrintWriter.startTAG("YSC").textNode(this.yearlySummaryColumn).end();
        }
        if (this.function != null) {
            xMLPrintWriter.startTAG("FUNC").textNode(this.function).end();
        }
    }
}

