/*
 * Decompiled with CFR 0.152.
 */
package com.fr.adhoc.report.core;

import com.fr.adhoc.report.core.ADHOCGroupAndResultColumn;
import com.fr.adhoc.report.core.SimpleADHOCColumn;
import com.fr.json.JSONObject;
import com.fr.report.cell.ADHOCCellElement;
import com.fr.report.cell.ADHOCFilterAndGroupCellElement;
import com.fr.report.cell.cellattr.core.group.FunctionGrouper;
import com.fr.report.cell.cellattr.core.group.RecordGrouper;
import com.fr.stable.ColumnRow;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;

public class ADHOCColumn
extends SimpleADHOCColumn
implements ADHOCGroupAndResultColumn {
    public int groupStyle = 0;

    int getGroupType() {
        return this.groupStyle;
    }

    private void setGroupType(int n2) {
        this.groupStyle = n2;
    }

    public JSONObject createJSON() throws Exception {
        JSONObject jSONObject = super.createJSON();
        jSONObject.put("groupStyle", this.groupStyle);
        return jSONObject;
    }

    public void parseJSON(JSONObject jSONObject) throws Exception {
        super.parseJSON(jSONObject);
        this.setGroupType(jSONObject.getInt("groupStyle"));
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && "groupStyle".equals(xMLableReader.getTagName())) {
            this.groupStyle = Integer.parseInt(xMLableReader.getElementValue());
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (this.groupStyle != 0) {
            xMLPrintWriter.startTAG("groupStyle").textNode("" + this.groupStyle).end();
        }
    }

    public ADHOCCellElement getADHOCCellElement(ColumnRow columnRow) {
        return new ADHOCFilterAndGroupCellElement(columnRow.getColumn(), columnRow.getRow(), this.getColumnName());
    }

    public RecordGrouper getGrouper() {
        return this.getGrouper(this.getGroupType());
    }

    private RecordGrouper getGrouper(int n2) {
        switch (n2) {
            case 1: {
                return this.getGrouper(0);
            }
            case 2: {
                FunctionGrouper functionGrouper = new FunctionGrouper();
                functionGrouper.setDivideMode(1);
                functionGrouper.setCustom(false);
                return functionGrouper;
            }
        }
        FunctionGrouper functionGrouper = new FunctionGrouper();
        functionGrouper.setDivideMode(0);
        functionGrouper.setCustom(false);
        return functionGrouper;
    }
}

